<?php
/**
 * Kalium WordPress Theme //WPMonster.co
 *
 * Product registration page.
 *
 * @var $licensed_domain
 * @var $licensee
 * @var $license_key
 * @var $registration_date
 * @var $theme_backups
 * @var $remove_registration_link
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="about-kalium__heading">
    <h2>لایسنس قالب فعال شده است</h2>
    <p>تبریک! لایسنس شما با موفقیت فعال شده است. جهت خرید لایسنس های بعدی شما میتوانید تا سقف 90% تخفیف دریافت نمایید.</p>
</div>

<div class="about-kalium__register-theme-information">
    <!-- Theme status -->
    <div class="about-kalium__register-theme-information-entry">
        <div class="about-kalium__register-theme-information-entry-column type-name">وضعیت قالب</div>
        <div class="about-kalium__register-theme-information-entry-column type-value">
            <span class="about-kalium__support-info-badge">فعال شده</span>
        </div>
        <div class="about-kalium__register-theme-information-entry-column type-remove-registration">
			<span class="remove-registration-tooltip tooltipster" title="جهت غیرفعال سازی لایسنس خود از روی دامنه فعلی با پشتیبانی راست چین در ارتباط باشید.">
				<i class="dashicons dashicons-info"></i>
			</span>
            
        </div>
    </div>


    <!-- Registration date -->
    <div class="about-kalium__register-theme-information-entry">
        <div class="about-kalium__register-theme-information-entry-column type-name">تاریخ فعالسازی</div>
        <div class="about-kalium__register-theme-information-entry-column type-value">
			<?php echo esc_html( $registration_date ); ?>
        </div>
    </div>
</div>

<div class="row align-items-center">
    <div class="col col-9">
        <div class="about-kalium__heading">
            <h2>بک آپ گیری از قالب</h2>
            <p>لیست بک آپ های گرفته شده از قالب با لینک دانلودشان. شما میتوانید هر زمان که نیاز داشتید از میان آن ها انتخاب کنید.</p>
        </div>
    </div>
    <div class="col text-align-right">
        <div class="about-kalium__register-theme-backups-toggle">
            <a href="<?php echo add_query_arg( [ 'theme_backups' => 1 ] ); ?>" class="button first <?php echo true === kalium()->theme_license->get_backups_status() ? ' button-primary' : ''; ?>">فعال</a>
            <a href="<?php echo add_query_arg( [ 'theme_backups' => 0 ] ); ?>" class="button last <?php echo false === kalium()->theme_license->get_backups_status() ? ' button-primary' : ''; ?>">غیرفعال</a>
        </div>
    </div>
</div>

<ul class="about-kalium__changelog-previous">
	<?php
	if ( ! empty( $theme_backups ) ) :
		foreach ( $theme_backups as $theme_backup ) :
			$relative_backup_file = str_replace( ABSPATH, '', $theme_backup );

			?>
            <li class="about-kalium__changelog-previous-entry">
                <div class="about-kalium__changelog-previous-entry-title"><?php echo esc_html( $theme_backup['base_name'] ); ?></div>
                <div class="about-kalium__changelog-previous-entry-date"><?php echo esc_html( wp_date( 'F d, Y', $theme_backup['time'] ) ); ?></div>
                <div class="about-kalium__changelog-previous-entry-size"><?php echo esc_html( $theme_backup['size'] ); ?></div>
                <div class="about-kalium__changelog-previous-entry-link">
                    <a href="<?php echo esc_url( $theme_backup['url'] ); ?>" target="_blank" rel="noreferrer noopener">دانلود</a>
                </div>
            </li>
		<?php
		endforeach;
	else :

		?>
        <li class="about-kalium__changelog-previous-entry justify-content-center">
           در حال حاظر بک آپ ذخیره شده ای از قالب وجود ندارد.
        </li>
	<?php

	endif; ?>
</ul>
