<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class XforWC_Product_Filters_Settings {

	public static $settings = null;
	public static $presets  = null;

	public static $plugin = array();

	public static function init() {

		self::$plugin = array(
			'name'    => esc_html__( 'Product Filter for WooCommerce', '^xwc' ),
			'xforwc'  => esc_html__( 'Product Filters', '^xwc' ),
			'slug'    => 'product-filters',
			'label'   => 'product_filter',
			'image'   => Prdctfltr()->plugin_url() . '/includes/images/product-filter-for-woocommerce-elements.png',
			'path'    => 'prdctfltr/prdctfltr',
			'version' => XforWC_Product_Filters::$version,
		);

		if ( SevenVXGet()->plugin_page_check( self::$plugin['label'] ) ) {
			add_filter( 'svx_plugins_settings', array( 'XforWC_Product_Filters_Settings', 'get_settings' ), 50 );
			add_action( 'admin_enqueue_scripts', __CLASS__ . '::scripts', 9 );
		}

		if ( SevenVXGet()->xforwoo_page_check() ) {
			add_action( 'admin_enqueue_scripts', __CLASS__ . '::scripts', 9 );
		}

		if ( function_exists( 'XforWC' ) ) {
			add_filter( 'xforwc_settings', array( 'XforWC_Product_Filters_Settings', 'xforwc' ), 9999999101 );
			add_filter( 'xforwc_svx_get_product_filters', array( 'XforWC_Product_Filters_Settings', '_get_settings_xforwc' ) );
		}

		add_filter( 'svx_plugins', array( 'XforWC_Product_Filters_Settings', 'add_plugin' ), 0 );

		add_action( 'wp_ajax_prdctfltr_analytics_reset', __CLASS__ . '::analytics_reset' );
	}

	public static function xforwc( $settings ) {
		$settings['plugins'][] = self::$plugin;

		return $settings;
	}

	public static function add_plugin( $plugins ) {
		$plugins[ self::$plugin['label'] ] = array(
			'slug' => self::$plugin['label'],
			'name' => self::$plugin['xforwc'],
		);

		return $plugins;
	}

	public static function _get_settings_xforwc() {
		$settings = self::get_settings( array() );
		return $settings[ self::$plugin['label'] ];
	}

	public static function scripts() {
		wp_register_script( 'google-api', ( is_ssl() ? 'https://' : 'http://' ) . 'www.google.com/jsapi', array(), false, true );
		wp_enqueue_script( 'google-api' );

		wp_register_script( 'product-filter', Prdctfltr()->plugin_url() . '/includes/js/svx-admin.js', array( 'jquery' ), Prdctfltr()->version(), true );
		wp_enqueue_script( 'product-filter' );
	}

	public static function get_taxonomy_option() {
		return array(
			'name'    => esc_html__( 'Select Taxonomy', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select taxonomy for this filter', '^xwc' ),
			'id'      => 'taxonomy',
			'options' => 'ajax:product_taxonomies:has_none',
			'default' => '',
			'class'   => 'svx-update-list-title svx-selectize',
		);
	}

	public static function get_title_option() {
		return array(
			'name'    => esc_html__( 'Title', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Use alternative title', '^xwc' ),
			'id'      => 'name',
			'default' => '',
		);
	}

	public static function get_desc_option() {
		return array(
			'name'    => esc_html__( 'Description', '^xwc' ),
			'type'    => 'textarea',
			'desc'    => esc_html__( 'Enter filter description', '^xwc' ),
			'id'      => 'desc',
			'default' => '',
		);
	}

	public static function get_include_option() {
		return array(
			'name'    => esc_html__( 'Include/Exclude', '^xwc' ),
			'type'    => 'include',
			'desc'    => esc_html__( 'Select terms to include/exclude', '^xwc' ),
			'id'      => 'include',
			'default' => false,
		);
	}

	public static function get_orderby_option() {
		return array(
			'name'    => esc_html__( 'Order By', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select term order', '^xwc' ),
			'id'      => 'orderby',
			'default' => '',
			'options' => array(
				''       => esc_html__( 'None (Custom Menu Order)', '^xwc' ),
				'id'     => esc_html__( 'ID', '^xwc' ),
				'name'   => esc_html__( 'Name', '^xwc' ),
				'number' => esc_html__( 'Number', '^xwc' ),
				'slug'   => esc_html__( 'Slug', '^xwc' ),
				'count'  => esc_html__( 'Count', '^xwc' ),
			),
		);
	}

	public static function get_order_option() {
		return array(
			'name'    => esc_html__( 'Order', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select ascending/descending', '^xwc' ),
			'id'      => 'order',
			'default' => 'ASC',
			'options' => array(
				'ASC'  => esc_html__( 'ASC', '^xwc' ),
				'DESC' => esc_html__( 'DESC', '^xwc' ),
			),
		);
	}

	public static function get_limit_option() {
		return array(
			'name'    => esc_html__( 'Show more', '^xwc' ),
			'type'    => 'number',
			'desc'    => esc_html__( 'Show more button on term', '^xwc' ),
			'id'      => 'limit',
			'default' => '',
		);
	}

	public static function get_hierarchy_option() {
		return array(
			'name'    => esc_html__( 'Hierarchy', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Use hierarchy.', '^xwc' ),
			'id'      => 'hierarchy',
			'default' => 'no',
		);
	}

	public static function get_hierarchy_mode_option() {
		return array(
			'name'    => esc_html__( 'Hierarchy Mode', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select hierarchy mode', '^xwc' ),
			'id'      => 'hierarchy_mode',
			'default' => 'showall',
			'options' => array(
				'showall'     => esc_html__( 'Show all terms', '^xwc' ),
				'drill'       => esc_html__( 'Show current level terms (Drill filter)', '^xwc' ),
				'drillback'   => esc_html__( 'Show current level terms with parent term support (Drill filter)', '^xwc' ),
				'subonly'     => esc_html__( 'Show lower level hierarchy terms', '^xwc' ),
				'subonlyback' => esc_html__( 'Show lower level hierarchy terms with parent term support', '^xwc' ),
			),
		);
	}

	public static function get_hierarchy_expand_option() {
		return array(
			'name'    => esc_html__( 'Hierarchy Expand', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Expand hierarchy tree on load', '^xwc' ),
			'id'      => 'hierarchy_expand',
			'default' => 'no',
		);
	}

	public static function get_multiselect_option() {
		return array(
			'name'    => esc_html__( 'Multiselect', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Use multiselect', '^xwc' ),
			'id'      => 'multiselect',
			'default' => 'no',
		);
	}

	public static function get_multiselect_relation_option() {
		return array(
			'name'    => esc_html__( 'Multiselect Relation', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select multiselect relation', '^xwc' ),
			'id'      => 'multiselect_relation',
			'default' => 'IN',
			'options' => array(
				'IN'  => 'IN',
				'AND' => 'AND',
			),
		);
	}

	public static function get_selection_reset_option() {
		return array(
			'name'    => esc_html__( 'Selection Reset', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Reset filters on select', '^xwc' ),
			'id'      => 'selection_reset',
			'default' => 'no',
		);
	}

	public static function get_adoptive_option() {
		return array(
			'name'      => esc_html__( 'Adoptive', '^xwc' ),
			'type'      => 'select',
			'desc'      => esc_html__( 'Select adoptive filtering', '^xwc' ),
			'id'        => 'adoptive',
			'default'   => 'no',
			'options'   => array(
				'no'               => esc_html__( 'Not active on this filter', '^xwc' ),
				'pf_adptv_default' => esc_html__( 'Terms will be hidden', '^xwc' ),
				'pf_adptv_unclick' => esc_html__( 'Terms will be shown, but unclickable', '^xwc' ),
				'pf_adptv_click'   => esc_html__( 'Terms will be shown and clickable', '^xwc' ),
			),
			'condition' => 'a_enable:yes',
		);
	}

	public static function get_adoptive_for_range_option() {
		return array(
			'name'      => esc_html__( 'Adoptive', '^xwc' ),
			'type'      => 'select',
			'desc'      => esc_html__( 'Select adoptive filtering', '^xwc' ),
			'id'        => 'adoptive',
			'default'   => 'no',
			'options'   => array(
				'no'               => esc_html__( 'Not active on this filter', '^xwc' ),
				'pf_adptv_default' => esc_html__( 'Terms will be hidden', '^xwc' ),
			),
			'condition' => 'a_enable:yes',
		);
	}

	public static function get_term_count_option() {
		return array(
			'name'    => esc_html__( 'Term Count', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Show term count', '^xwc' ),
			'id'      => 'term_count',
			'default' => 'no',
		);
	}

	public static function get_term_search_option() {
		return array(
			'name'    => esc_html__( 'Term Search', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Show term search input', '^xwc' ),
			'id'      => 'term_search',
			'default' => 'no',
		);
	}

	public static function get_term_display_option() {
		return array(
			'name'    => esc_html__( 'Term Display', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select terms display style', '^xwc' ),
			'id'      => 'term_display',
			'default' => 'none',
			'options' => array(
				'none'      => esc_html__( 'Default', '^xwc' ),
				'inline'    => esc_html__( 'Inline', '^xwc' ),
				'2_columns' => esc_html__( 'Split into two columns', '^xwc' ),
				'3_columns' => esc_html__( 'Split into three columns', '^xwc' ),
			),
		);
	}

	public static function get_none_text() {
		return array(
			'name'    => esc_html__( 'None Text', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Change none text', '^xwc' ),
			'id'      => 'none_text',
			'default' => '',
		);
	}

	public static function get_hide_elements_option() {
		return array(
			'name'    => esc_html__( 'Hide Elements', '^xwc' ),
			'type'    => 'multiselect',
			'desc'    => esc_html__( 'Select elements to hide', '^xwc' ),
			'id'      => 'hide_elements',
			'default' => '',
			'options' => array(
				'title' => esc_html__( 'Title', 'prdctflr' ),
				'none'  => esc_html__( 'None', '^xwc' ),
			),
			'class'   => 'svx-selectize',
		);
	}

	public static function get_hide_elements_for_range_option() {
		return array(
			'name'    => esc_html__( 'Hide Elements', '^xwc' ),
			'type'    => 'multiselect',
			'desc'    => esc_html__( 'Select elements to hide', '^xwc' ),
			'id'      => 'hide_elements',
			'default' => '',
			'options' => array(
				'title' => esc_html__( 'Title', 'prdctflr' ),
			),
			'class'   => 'svx-selectize',
		);
	}

	public static function get_range_style_option() {
		return array(
			'name'    => esc_html__( 'Style', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Style', '^xwc' ),
			'id'      => 'design',
			'default' => 'thin',
			'options' => array(
				'flat'   => esc_html__( 'Flat', '^xwc' ),
				'modern' => esc_html__( 'Modern', '^xwc' ),
				'html5'  => esc_html__( 'HTML5', '^xwc' ),
				'white'  => esc_html__( 'White', '^xwc' ),
				'thin'   => esc_html__( 'Thin', '^xwc' ),
				'knob'   => esc_html__( 'Knob', '^xwc' ),
				'metal'  => esc_html__( 'Metal', '^xwc' ),
			),
		);
	}

	public static function get_range_grid_option() {
		return array(
			'name'    => esc_html__( 'Grid', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Show grid', '^xwc' ),
			'id'      => 'grid',
			'default' => '',
		);
	}

	public static function get_range_start_option() {
		return array(
			'name'    => esc_html__( 'Start', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Range start', '^xwc' ),
			'id'      => 'start',
			'default' => '',
		);
	}

	public static function get_range_end_option() {
		return array(
			'name'    => esc_html__( 'End', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Range end', '^xwc' ),
			'id'      => 'end',
			'default' => '',
		);
	}

	public static function get_range_prefix_option() {
		return array(
			'name'    => esc_html__( 'Prefix', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Terms prefix', '^xwc' ),
			'id'      => 'prefix',
			'default' => '',
		);
	}

	public static function get_range_postfix_option() {
		return array(
			'name'    => esc_html__( 'Postfix', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Terms postfix', '^xwc' ),
			'id'      => 'postfix',
			'default' => '',
		);
	}

	public static function get_range_step_option() {
		return array(
			'name'    => esc_html__( 'Step', '^xwc' ),
			'type'    => 'number',
			'desc'    => esc_html__( 'Step value', '^xwc' ),
			'id'      => 'step',
			'default' => '',
		);
	}

	public static function get_range_grid_num_option() {
		return array(
			'name'    => esc_html__( 'Grid density', '^xwc' ),
			'type'    => 'number',
			'desc'    => esc_html__( 'Grid density value', '^xwc' ),
			'id'      => 'grid_num',
			'default' => '',
		);
	}

	public static function get_meta_key_option() {
		return array(
			'name'    => esc_html__( 'Meta key', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Enter meta key', '^xwc' ),
			'id'      => 'meta_key',
			'default' => '',
		);
	}

	public static function get_meta_compare_option() {
		return array(
			'name'    => esc_html__( 'Meta compare', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select meta compare', '^xwc' ),
			'id'      => 'meta_compare',
			'default' => '=',
			'options' => array(
				'='           => '=',
				'!='          => '!=',
				'>'           => '>',
				'<'           => '<',
				'>='          => '>=',
				'<='          => '<=',
				'LIKE'        => 'LIKE',
				'NOT LIKE'    => 'NOT LIKE',
				'IN'          => 'IN',
				'NOT IN'      => 'NOT IN',
				'EXISTS'      => 'EXISTS',
				'NOT EXISTS'  => 'NOT EXISTS',
				'BETWEEN'     => 'BETWEEN',
				'NOT BETWEEN' => 'NOT BETWEEN',
			),
		);
	}

	public static function get_meta_numeric() {
		return array(
			'name'    => esc_html__( 'Numeric', '^xwc' ),
			'type'    => 'checkbox',
			'desc'    => esc_html__( 'Meta values are numeric', '^xwc' ),
			'id'      => 'meta_numeric',
			'default' => '',
		);
	}

	public static function get_meta_type_option() {
		return array(
			'name'    => esc_html__( 'Meta type', '^xwc' ),
			'type'    => 'select',
			'desc'    => esc_html__( 'Select meta type', '^xwc' ),
			'id'      => 'meta_type',
			'default' => 'CHAR',
			'options' => array(
				'NUMERIC'  => 'NUMERIC',
				'BINARY'   => 'BINARY',
				'CHAR'     => 'CHAR',
				'DATE'     => 'DATE',
				'DATETIME' => 'DATETIME',
				'DECIMAL'  => 'DECIMAL',
				'SIGNED'   => 'SIGNED',
				'TIME'     => 'TIME',
				'UNSIGNED' => 'UNSIGNED',
			),
		);
	}

	public static function get_placeholder_option() {
		return array(
			'name'    => esc_html__( 'Placeholder', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Placeholder text', '^xwc' ),
			'id'      => 'placeholder',
			'default' => '',
		);
	}

	public static function get_label_option() {
		return array(
			'name'    => esc_html__( 'Label', '^xwc' ),
			'type'    => 'text',
			'desc'    => esc_html__( 'Label text', '^xwc' ),
			'id'      => 'label',
			'default' => '',
		);
	}

	public static function build_filters() {

		$array = array();

		$array['taxonomy'] = array(
			'taxonomy'             => self::get_taxonomy_option(),
			'name'                 => self::get_title_option(),
			'desc'                 => self::get_desc_option(),
			'include'              => self::get_include_option(),
			'orderby'              => self::get_orderby_option(),
			'order'                => self::get_order_option(),
			'limit'                => self::get_limit_option(),
			'hierarchy'            => self::get_hierarchy_option(),
			'hierarchy_mode'       => self::get_hierarchy_mode_option(),
			'hierarchy_expand'     => self::get_hierarchy_expand_option(),
			'multiselect'          => self::get_multiselect_option(),
			'multiselect_relation' => self::get_multiselect_relation_option(),
			'selection_reset'      => self::get_selection_reset_option(),
			'adoptive'             => self::get_adoptive_option(),
			'term_count'           => self::get_term_count_option(),
			'term_search'          => self::get_term_search_option(),
			'term_display'         => self::get_term_display_option(),
			'none_text'            => self::get_none_text(),
			'hide_elements'        => self::get_hide_elements_option(),
		);

		$array['range'] = array(
			'taxonomy'      => self::get_taxonomy_option(),
			'name'          => self::get_title_option(),
			'desc'          => self::get_desc_option(),
			'include'       => self::get_include_option(),
			'orderby'       => self::get_orderby_option(),
			'order'         => self::get_order_option(),
			'design'        => self::get_range_style_option(),
			'start'         => self::get_range_start_option(),
			'end'           => self::get_range_end_option(),
			'prefix'        => self::get_range_prefix_option(),
			'postfix'       => self::get_range_postfix_option(),
			'step'          => self::get_range_step_option(),
			'grid'          => self::get_range_grid_option(),
			'grid_num'      => self::get_range_grid_num_option(),
			'adoptive'      => self::get_adoptive_for_range_option(),
			'hide_elements' => self::get_hide_elements_for_range_option(),
		);

		$array['meta'] = array(
			'name'                 => self::get_title_option(),
			'desc'                 => self::get_desc_option(),
			'meta_key'             => self::get_meta_key_option(),
			'meta_compare'         => self::get_meta_compare_option(),
			'meta_type'            => self::get_meta_type_option(),
			'limit'                => self::get_limit_option(),
			'multiselect'          => self::get_multiselect_option(),
			'multiselect_relation' => self::get_multiselect_relation_option(),
			'selection_reset'      => self::get_selection_reset_option(),
			'term_search'          => self::get_term_search_option(),
			'term_display'         => self::get_term_display_option(),
			'none_text'            => self::get_none_text(),
			'hide_elements'        => self::get_hide_elements_option(),
		);

		$array['meta_range'] = array(
			'name'          => self::get_title_option(),
			'desc'          => self::get_desc_option(),
			'meta_key'      => self::get_meta_key_option(),
			'meta_numeric'  => self::get_meta_numeric(),
			'design'        => self::get_range_style_option(),
			'start'         => self::get_range_start_option(),
			'end'           => self::get_range_end_option(),
			'prefix'        => self::get_range_prefix_option(),
			'postfix'       => self::get_range_postfix_option(),
			'step'          => self::get_range_step_option(),
			'grid'          => self::get_range_grid_option(),
			'grid_num'      => self::get_range_grid_num_option(),
			'hide_elements' => self::get_hide_elements_for_range_option(),
		);

		$array['vendor'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'include'         => self::get_include_option(),
			'limit'           => self::get_limit_option(),
			'multiselect'     => self::get_multiselect_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_search'     => self::get_term_search_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array['rating_filter'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'include'         => self::get_include_option(),
			'limit'           => self::get_limit_option(),
			'multiselect'     => self::get_multiselect_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_search'     => self::get_term_search_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array['orderby'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'include'         => self::get_include_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array['search'] = array(
			'name'          => self::get_title_option(),
			'desc'          => self::get_desc_option(),
			'placeholder'   => self::get_placeholder_option(),
			'none_text'     => self::get_none_text(),
			'hide_elements' => self::get_hide_elements_option(),
		);

		$array['instock'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'include'         => self::get_include_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array['price'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array['price_range'] = array(
			'name'          => self::get_title_option(),
			'desc'          => self::get_desc_option(),
			'design'        => self::get_range_style_option(),
			'grid'          => self::get_range_grid_option(),
			'start'         => self::get_range_start_option(),
			'end'           => self::get_range_end_option(),
			'prefix'        => self::get_range_prefix_option(),
			'postfix'       => self::get_range_postfix_option(),
			'step'          => self::get_range_step_option(),
			'grid_num'      => self::get_range_grid_num_option(),
			'hide_elements' => self::get_hide_elements_for_range_option(),
		);

		$array['per_page'] = array(
			'name'            => self::get_title_option(),
			'desc'            => self::get_desc_option(),
			'selection_reset' => self::get_selection_reset_option(),
			'term_display'    => self::get_term_display_option(),
			'none_text'       => self::get_none_text(),
			'hide_elements'   => self::get_hide_elements_option(),
		);

		$array = apply_filters( 'prdctflr_supported_filters', $array );

		return $array;

	}

	public static function get_key() {
		return get_option( 'xforwc_key_product_filter' ) === false ? 'false' : 'true';
	}

	public static function get_settings( $plugins ) {

		self::$settings['options'] = Prdctfltr()->get_default_options();

		self::$settings['preset'] = Prdctfltr()->get_preset( 'default' );

		$saved = isset( self::$settings['options']['presets'] ) && is_array( self::$settings['options']['presets'] ) ? self::$settings['options']['presets'] : array();
		foreach ( $saved as $preset ) {
			self::$presets[ $preset['slug'] ] = $preset['name'];
		}

		if ( empty( self::$presets ) ) {
			self::$presets = false;
		}

		$attributes = get_object_taxonomies( 'product' );
		foreach ( $attributes as $k ) {
			if ( ! in_array( $k, array(), true ) ) {
				if ( substr( $k, 0, 3 ) === 'pa_' ) {
					$ready_attributes[ $k ] = wc_attribute_label( $k );
				} else {
					$taxonomy               = get_taxonomy( $k );
					$ready_attributes[ $k ] = $taxonomy->label;
				}
			}
		}

		if ( empty( $ready_attributes ) ) {
			$ready_attributes = false;
		}

		include_once 'class-themes.php';
		$ajax = XforWC_Product_Filters_Themes::get_theme();

		$plugins[ self::$plugin['label'] ] = array(
			'slug'     => self::$plugin['label'],
			'name'     => esc_html( function_exists( 'XforWC' ) ? self::$plugin['xforwc'] : self::$plugin['name'] ),
			'desc'     => esc_html( function_exists( 'XforWC' ) ? self::$plugin['name'] . ' v' . self::$plugin['version'] : esc_html__( 'Settings page for', '^xwc' ) . ' ' . self::$plugin['name'] ),
			'link'     => esc_url( 'https://xforwoocommerce.com/store/product-filters/' ),
			'imgs'     => esc_url( Prdctfltr()->plugin_url() ),
			'ref'      => array(
				'name' => esc_html__( 'Visit XforWooCommerce.com', '^xwc' ),
				'url'  => 'https://xforwoocommerce.com',
			),
			'doc'      => array(
				'name' => esc_html__( 'Get help', '^xwc' ),
				'url'  => 'https://help.xforwoocommerce.com',
			),
			'sections' => array(
				'dashboard'   => array(
					'name' => esc_html__( 'Dashboard', '^xwc' ),
					'desc' => esc_html__( 'Dashboard Overview', '^xwc' ),
				),
				'presets'     => array(
					'name' => esc_html__( 'Filter Presets', '^xwc' ),
					'desc' => esc_html__( 'Filter Presets Options', '^xwc' ),
				),
				'manager'     => array(
					'name' => esc_html__( 'Presets Manager', '^xwc' ),
					'desc' => esc_html__( 'Presets Manager Options', '^xwc' ),
				),
				'integration' => array(
					'name' => esc_html__( 'Shop Integration', '^xwc' ),
					'desc' => esc_html__( 'Shop Integration Options', '^xwc' ),
				),
				'ajax'        => array(
					'name' => esc_html__( 'AJAX', '^xwc' ),
					'desc' => esc_html__( 'AJAX Options', '^xwc' ),
				),
				'general'     => array(
					'name' => esc_html__( 'Advanced', '^xwc' ),
					'desc' => esc_html__( 'Advanced Options', '^xwc' ),
				),
				'analytics'   => array(
					'name' => esc_html__( 'Analytics', '^xwc' ),
					'desc' => esc_html__( 'Filtering Analytics', '^xwc' ),
				),
			),
			'extras'   => array(
				'product_attributes' => $ready_attributes,
				'more_titles'        => array(
					'orderby'       => esc_html__( 'Order by', '^xwc' ),
					'per_page'      => esc_html__( 'Per page', '^xwc' ),
					'vendor'        => esc_html__( 'Vendor', '^xwc' ),
					'search'        => esc_html__( 'Search', '^xwc' ),
					'instock'       => esc_html__( 'Availability', '^xwc' ),
					'price'         => esc_html__( 'Price', '^xwc' ),
					'price_range'   => esc_html__( 'Price range', '^xwc' ),
					'meta'          => esc_html__( 'Meta filter', '^xwc' ),
					'rating_filter' => esc_html__( 'Rating', '^xwc' ),
				),
				'options'            => self::$settings['options'],
				'presets'            => array(
					'loaded'          => 'default',
					'loaded_settings' => self::$settings['preset'],
					'set'             => self::$presets,
				),
				'terms'              => array(
					'orderby' => array(
						array(
							'id'           => 'menu_order',
							'slug'         => 'menu_order',
							'default_name' => 'Default',
						),
						array(
							'id'           => 'comment_count',
							'slug'         => 'comment_count',
							'default_name' => 'Review Count',
						),
						array(
							'id'           => 'popularity',
							'slug'         => 'popularity',
							'default_name' => 'Popularity',
						),
						array(
							'id'           => 'rating',
							'slug'         => 'rating',
							'default_name' => 'Average rating',
						),
						array(
							'id'           => 'date',
							'slug'         => 'date',
							'default_name' => 'Newness',
						),
						array(
							'id'           => 'price',
							'slug'         => 'price',
							'default_name' => 'Price: low to high',
						),
						array(
							'id'           => 'price-desc',
							'slug'         => 'price-desc',
							'default_name' => 'Price: high to low',
						),
						array(
							'id'           => 'rand',
							'slug'         => 'rand',
							'default_name' => 'Random Products',
						),
						array(
							'id'           => 'title',
							'slug'         => 'title',
							'default_name' => 'Product Name',
						),
					),
					'instock' => array(
						array(
							'id'           => 'out',
							'slug'         => 'out',
							'default_name' => 'Out of stock',
						),
						array(
							'id'           => 'in',
							'slug'         => 'in',
							'default_name' => 'In stock',
						),
						array(
							'id'           => 'both',
							'slug'         => 'both',
							'default_name' => 'All products',
						),
					),
					'rating'  => array(
						array(
							'id'           => '1',
							'slug'         => '1',
							'default_name' => '1 Star',
						),
						array(
							'id'           => '2',
							'slug'         => '2',
							'default_name' => '2 Stars',
						),
						array(
							'id'           => '3',
							'slug'         => '3',
							'default_name' => '3 Stars',
						),
						array(
							'id'           => '4',
							'slug'         => '4',
							'default_name' => '4 Stars',
						),
						array(
							'id'           => '5',
							'slug'         => '5',
							'default_name' => '5 Stars',
						),
					),
				),
			),
			'settings' => array(),
		);

		$plugins['product_filter']['settings']['wcmn_dashboard'] = array(
			'type'    => 'html',
			'id'      => 'wcmn_dashboard',
			'desc'    => '
				<h3><span class="dashicons dashicons-store"></span> XforWooCommerce</h3>
				<p>' . esc_html__( 'Visit XforWooCommerce.com store, demos and knowledge base.', '^xwc' ) . '</p>
				<p><a href="https://xforwoocommerce.com" class="xforwc-button-primary x-color" target="_blank">XforWooCommerce.com</a></p>

				<br /><hr />

				<h3><span class="dashicons dashicons-admin-tools"></span> ' . esc_html__( 'Help Center', '^xwc' ) . '</h3>
				<p>' . esc_html__( 'Need support? Visit the Help Center.', '^xwc' ) . '</p>
				<p><a href="https://help.xforwoocommerce.com" class="xforwc-button-primary red" target="_blank">XforWooCommerce.com HELP</a></p>
				
				<br /><hr />

				<h3><span class="dashicons dashicons-update"></span> ' . esc_html__( 'Automatic Updates', '^xwc' ) . '</h3>
				<p>' . esc_html__( 'Get automatic updates, by downloading and installing the Envato Market plugin.', '^xwc' ) . '</p>
				<p><a href="https://envato.com/market-plugin/" class="svx-button" target="_blank">Envato Market Plugin</a></p>
				
				<br />',
			'section' => 'dashboard',
		);

		$plugins['product_filter']['settings']['wcmn_utility'] = array(
			'name'    => esc_html__( 'Plugin Options', '^xwc' ),
			'type'    => 'utility',
			'id'      => 'wcmn_utility',
			'desc'    => esc_html__( 'Quick export/import, backup and restore, or just reset your optons here', '^xwc' ),
			'section' => 'dashboard',
		);

		$plugins['product_filter']['settings'] = array_merge(
			$plugins['product_filter']['settings'],
			array(

				'_filter_preset_manager' => array(
					'name'    => esc_html__( 'Filter Preset', '^xwc' ),
					'type'    => 'select',
					'id'      => '_filter_preset_manager',
					'desc'    => esc_html__( 'Editing selected filter preset', '^xwc' ),
					'section' => 'presets',
					'options' => 'function:__make_presets',
					'default' => 'default',
					'class'   => '',
					'val'     => 'default',
				),

				'_filter_preset_options' => array(
					'name'    => esc_html__( 'Filter Options', '^xwc' ),
					'type'    => 'select',
					'id'      => '_filter_preset_options',
					'desc'    => esc_html__( 'Select options group for the current preset', '^xwc' ),
					'section' => 'presets',
					'options' => array(
						'filters'    => esc_html__( 'Filters', '^xwc' ),
						'general'    => esc_html__( 'General', '^xwc' ),
						'style'      => esc_html__( 'Style', '^xwc' ),
						'adoptive'   => esc_html__( 'Adoptive', '^xwc' ),
						'responsive' => esc_html__( 'Responsive', '^xwc' ),
					),
					'default' => 'filters',
					'class'   => 'svx-make-group svx-refresh-active-tab',
					'val'     => 'filters',
				),

				'g_instant'              => array(
					'name'      => esc_html__( 'Filter on Click', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to filter on click', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_instant',
					'default'   => 'no',
					'condition' => '_filter_preset_options:general',
				),

				'g_step_selection'       => array(
					'name'      => esc_html__( 'Stepped Selection', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to use stepped selection', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_step_selection',
					'default'   => 'no',
					'condition' => '_filter_preset_options:general',
				),

				'g_collectors'           => array(
					'name'      => esc_html__( 'Show Selected Terms In', '^xwc' ),
					'type'      => 'multiselect',
					'desc'      => esc_html__( 'Select areas where to show the selected terms', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_collectors',
					'options'   => array(
						'topbar'     => esc_html__( 'Top bar', '^xwc' ),
						'collector'  => esc_html__( 'Collector', '^xwc' ),
						'intitle'    => esc_html__( 'Filter title', '^xwc' ),
						'aftertitle' => esc_html__( 'After filter title', '^xwc' ),
					),
					'default'   => array( 'collector' ),
					'condition' => '_filter_preset_options:general',
					'class'     => 'svx-selectize',
				),

				'g_collector_style'      => array(
					'name'      => esc_html__( 'Selected Terms Style', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select selected terms style', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_collector_style',
					'options'   => array(
						'flat'   => esc_html__( 'Flat', '^xwc' ),
						'border' => esc_html__( 'Border', '^xwc' ),
					),
					'default'   => 'flat',
					'condition' => '_filter_preset_options:general',
				),

				'g_reorder_selected'     => array(
					'name'      => esc_html__( 'Reorder Selected', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to bring selected terms to the top', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_reorder_selected',
					'default'   => 'no',
					'condition' => '_filter_preset_options:general',
				),

				'g_form_action'          => array(
					'name'      => esc_html__( 'Filter Form Action', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter custom filter form action="" parameter', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'g_form_action',
					'default'   => '',
					'condition' => '_filter_preset_options:general',
				),

				's_style'                => array(
					'name'      => esc_html__( 'Select Design', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select filter design style', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_style',
					'options'   => array(
						'pf_default'           => esc_html__( 'Default', '^xwc' ),
						'pf_arrow'             => esc_html__( 'Pop up', '^xwc' ),
						'pf_sidebar'           => esc_html__( 'Left fixed sidebar', '^xwc' ),
						'pf_sidebar_right'     => esc_html__( 'Right fixed sidebar', '^xwc' ),
						'pf_sidebar_css'       => esc_html__( 'Left fixed sidebar with overlay', '^xwc' ),
						'pf_sidebar_css_right' => esc_html__( 'Right fixed sidebar with overlay', '^xwc' ),
						'pf_fullscreen'        => esc_html__( 'Full screen filters', '^xwc' ),
						'pf_select'            => esc_html__( 'Filters inside select boxes', '^xwc' ),
					),
					'default'   => 'pf_sidebar_css',
					'condition' => '_filter_preset_options:style',
				),

				's_always_visible'       => array(
					'name'      => esc_html__( 'Always Visible', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Disable slide in/out animation', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_always_visible',
					'default'   => 'yes',
					'condition' => '_filter_preset_options:style',
				),

				's_hide_elements'        => array(
					'name'      => esc_html__( 'Hide Elements', '^xwc' ),
					'type'      => 'multiselect',
					'desc'      => esc_html__( 'Select elements to hide', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_hide_elements',
					'options'   => array(
						'hide_icon'           => esc_html__( 'Filter icon', '^xwc' ),
						'hide_top_bar'        => esc_html__( 'The whole top bar', '^xwc' ),
						'hide_showing'        => esc_html__( 'Showing text in top bar', '^xwc' ),
						'hide_sale_button'    => esc_html__( 'Sale button', '^xwc' ),
						'hide_instock_button' => esc_html__( 'Instock button', '^xwc' ),
						'hide_reset_button'   => esc_html__( 'Reset button', '^xwc' ),
					),
					'default'   => '',
					'condition' => '_filter_preset_options:style',
					'class'     => 'svx-selectize',
				),

				's_mode'                 => array(
					'name'      => esc_html__( 'Row Display', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select row display mode', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_mode',
					'options'   => array(
						'pf_mod_row'      => esc_html__( 'One row', '^xwc' ),
						'pf_mod_multirow' => esc_html__( 'Multiple rows', '^xwc' ),
						'pf_mod_masonry'  => esc_html__( 'Masonry Filters', '^xwc' ),
					),
					'default'   => 'pf_mod_multirow',
					'condition' => '_filter_preset_options:style',
				),

				's_columns'              => array(
					'name'      => esc_html__( 'Max Columns', '^xwc' ),
					'type'      => 'number',
					'desc'      => esc_html__( 'Set max filter columns', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_columns',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_max_height'           => array(
					'name'      => esc_html__( 'Max Height', '^xwc' ),
					'type'      => 'number',
					'desc'      => esc_html__( 'Set max filter height', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_max_height',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_js_scroll'            => array(
					'name'      => esc_html__( 'Scroll Bar Style', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Enable enhanced scroll bars display', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_js_scroll',
					'default'   => 'no',
					'condition' => '_filter_preset_options:style',
				),

				's_checkbox_style'       => array(
					'name'      => esc_html__( 'Checkbox Style', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select term checkbox style', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_checkbox_style',
					'options'   => array(
						'prdctfltr_bold'     => esc_html__( 'Hide', '^xwc' ),
						'prdctfltr_round'    => esc_html__( 'Round', '^xwc' ),
						'prdctfltr_square'   => esc_html__( 'Square', '^xwc' ),
						'prdctfltr_checkbox' => esc_html__( 'Checkbox', '^xwc' ),
						'prdctfltr_system'   => esc_html__( 'System Checkboxes', '^xwc' ),
					),
					'default'   => 'prdctfltr_round',
					'condition' => '_filter_preset_options:style',
				),

				's_hierarchy_style'      => array(
					'name'      => esc_html__( 'Hierarchy Style', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select hierarchy style', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_hierarchy_style',
					'options'   => array(
						'prdctfltr_hierarchy_hide'   => esc_html__( 'Hide', '^xwc' ),
						'prdctfltr_hierarchy_circle' => esc_html__( 'Circle', '^xwc' ),
						'prdctfltr_hierarchy_filled' => esc_html__( 'Circle Solid', '^xwc' ),
						'prdctfltr_hierarchy_lined'  => esc_html__( 'Lined', '^xwc' ),
						'prdctfltr_hierarchy_arrow'  => esc_html__( 'Arrows', '^xwc' ),
					),
					'default'   => 'prdctfltr_hierarchy_lined',
					'condition' => '_filter_preset_options:style',
				),

				's_filter_icon'          => array(
					'name'      => esc_html__( 'Filter Icon', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter icon class. Use icon class e.g. prdctfltr-bars or FontAwesome fa fa-shopping-cart or any other you have on the website', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_filter_icon',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_filter_title'         => array(
					'name'      => esc_html__( 'Filter Title Text', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter title text', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_filter_title',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_filter_button'        => array(
					'name'      => esc_html__( 'Filter Button Text', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter filter button text', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_filter_button',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_button_position'      => array(
					'name'      => esc_html__( 'Button Position', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select button position', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_button_position',
					'options'   => array(
						'bottom' => esc_html__( 'Bottom', '^xwc' ),
						'top'    => esc_html__( 'Top', '^xwc' ),
						'both'   => esc_html__( 'Both', '^xwc' ),
					),
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_content_align'        => array(
					'name'      => esc_html__( 'Content Align', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Set content align', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_content_align',
					'options'   => array(
						'left'   => esc_html__( 'Left', '^xwc' ),
						'center' => esc_html__( 'Center', '^xwc' ),
						'right'  => esc_html__( 'Right', '^xwc' ),
					),
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's_loading_animation'    => array(
					'name'      => esc_html__( 'Loader Animation', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select loader animation', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's_loading_animation',
					'options'   => array(
						'css-spinner-full'    => 'Overlay 1',
						'css-spinner-full-01' => 'Overlay 2',
						'css-spinner-full-02' => 'Overlay 3',
						'css-spinner-full-03' => 'Overlay 4',
						'css-spinner-full-04' => 'Overlay 5',
						'css-spinner-full-05' => 'Overlay 6',
						'css-spinner'         => 'Title 1',
						'css-spinner-01'      => 'Title 2',
						'css-spinner-02'      => 'Title 3',
						'css-spinner-03'      => 'Title 4',
						'css-spinner-04'      => 'Title 5',
						'css-spinner-05'      => 'Title 6',
						'none'                => esc_html__( 'None', '^xwc' ),
					),
					'default'   => 'css-spinner-full',
					'condition' => '_filter_preset_options:style',
				),

				's__tx_sale'             => array(
					'name'      => esc_html__( 'Sale Text', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter sale button text', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's__tx_sale',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's__tx_instock'          => array(
					'name'      => esc_html__( 'Instock Text', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter instock button text', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's__tx_instock',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				's__tx_clearall'         => array(
					'name'      => esc_html__( 'Clear All Text', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter clear all button text', '^xwc' ),
					'section'   => 'presets',
					'id'        => 's__tx_clearall',
					'default'   => '',
					'condition' => '_filter_preset_options:style',
				),

				'a_enable'               => array(
					'name'      => esc_html__( 'Enable', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to use adoptive filtering in current preset', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'a_enable',
					'default'   => 'no',
					'condition' => '_filter_preset_options:adoptive',
				),

				'a_active_on'            => array(
					'name'      => esc_html__( 'Active On', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select when to activate adoptive filtering', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'a_active_on',
					'options'   => array(
						'always'    => esc_html__( 'Always active', '^xwc' ),
						'permalink' => esc_html__( 'Active on permalinks and filters', '^xwc' ),
						'filter'    => esc_html__( 'Active on filters', '^xwc' ),
					),
					'default'   => 'no',
					'condition' => '_filter_preset_options:adoptive',
				),

				'a_depend_on'            => array(
					'name'      => esc_html__( 'Depend On', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select taxonomy terms can depend on', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'a_depend_on',
					'options'   => 'ajax:product_taxonomies:has_none',
					'default'   => '',
					'condition' => '_filter_preset_options:adoptive',
				),

				'a_term_counts'          => array(
					'name'      => esc_html__( 'Product Count', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select adoptive product count display', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'a_term_counts',
					'options'   => array(
						'default' => esc_html__( 'Filtered count / Total', '^xwc' ),
						'count'   => esc_html__( 'Filtered count', '^xwc' ),
						'total'   => esc_html__( 'Total', '^xwc' ),
					),
					'default'   => 'default',
					'condition' => '_filter_preset_options:adoptive',
				),

				'a_reorder_selected'     => array(
					'name'      => esc_html__( 'Reorder Terms', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Reorder remaining terms to the top', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'a_reorder_selected',
					'default'   => 'no',
					'condition' => '_filter_preset_options:adoptive',
				),

				'r_behaviour'            => array(
					'name'      => esc_html__( 'Responsive Behaviour', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Set filter preset behaviour on defined resolution', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'r_behaviour',
					'options'   => array(
						'none'   => esc_html__( 'Do not do a thing', '^xwc' ),
						'switch' => esc_html__( 'Switch with filter preset', '^xwc' ),
						'hide'   => esc_html__( 'Show on screen resolution smaller than', '^xwc' ),
						'show'   => esc_html__( 'Show on screen resolution larger than', '^xwc' ),
					),
					'default'   => 'none',
					'condition' => '_filter_preset_options:responsive',
					'class'     => 'svx-refresh-active-tab',
				),

				'r_resolution'           => array(
					'name'      => esc_html__( 'Responsive Resolution', '^xwc' ),
					'type'      => 'number',
					'desc'      => esc_html__( 'Set screen resolution in pixels that will trigger the responsive behaviour', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'r_resolution',
					'default'   => '768',
					'condition' => '_filter_preset_options:responsive',
				),

				'r_preset'               => array(
					'name'      => esc_html__( 'Preset', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Set filter preset', '^xwc' ),
					'section'   => 'presets',
					'id'        => 'r_preset',
					'options'   => 'function:__make_presets',
					'default'   => '',
					'condition' => '_filter_preset_options:responsive&&r_behaviour:switch',
				),

				'filters'                => array(
					'name'      => esc_html__( 'Filters', '^xwc' ),
					'type'      => 'list-select',
					'id'        => 'filters',
					'desc'      => esc_html__( 'Add more filters to the current preset', '^xwc' ),
					'section'   => 'presets',
					'title'     => esc_html__( 'Filter', '^xwc' ),
					'supports'  => array( 'customizer' ),
					'options'   => 'list',
					'selects'   => array(
						'taxonomy'      => esc_html__( 'Taxonomy', '^xwc' ),
						'range'         => esc_html__( 'Taxonomy Range', '^xwc' ),
						'meta'          => esc_html__( 'Meta', '^xwc' ),
						'meta_range'    => esc_html__( 'Meta Range', '^xwc' ),
						'vendor'        => esc_html__( 'Vendor', '^xwc' ),
						'orderby'       => esc_html__( 'Order by', '^xwc' ),
						'search'        => esc_html__( 'Search', '^xwc' ),
						'instock'       => esc_html__( 'Availability', '^xwc' ),
						'price'         => esc_html__( 'Price', '^xwc' ),
						'price_range'   => esc_html__( 'Price Range', '^xwc' ),
						'per_page'      => esc_html__( 'Per page', '^xwc' ),
						'rating_filter' => esc_html__( 'Rating', '^xwc' ),
					),
					'settings'  => self::build_filters(),
					'condition' => '_filter_preset_options:filters',
					'val'       => '',
				),

			)
		);

		$plugins['product_filter']['settings'] = array_merge( $plugins['product_filter']['settings'], self::build_overrides() );

		$plugins['product_filter']['settings']['supported_overrides'] = array(
			'name'    => esc_html__( 'Select Taxonomies', '^xwc' ),
			'type'    => 'multiselect',
			'desc'    => esc_html__( 'Select supported taxonomies for Presets Manager', '^xwc' ),
			'section' => 'manager',
			'id'      => 'supported_overrides',
			'options' => 'ajax:product_taxonomies',
			'default' => '',
			'class'   => '',
		);

		$plugins['product_filter']['settings'] = array_merge(
			$plugins['product_filter']['settings'],
			array(

				'variable_images'        => array(
					'name'    => esc_html__( 'Switch Variable Images', '^xwc' ),
					'type'    => 'checkbox',
					'desc'    => esc_html__( 'Check this option to switch variable images when filtering attributes', '^xwc' ),
					'section' => 'general',
					'id'      => 'variable_images',
					'default' => 'no',
				),

				'clear_all'              => array(
					'name'    => esc_html__( 'Clear All', '^xwc' ),
					'type'    => 'multiselect',
					'desc'    => esc_html__( 'Select taxonomies which Clear All button cannot clear', '^xwc' ),
					'section' => 'general',
					'id'      => 'clear_all',
					'options' => 'ajax:product_taxonomies',
					'default' => '',
				),

				'register_taxonomy'      => array(
					'name'     => esc_html__( 'Register Taxonomy', '^xwc' ),
					'type'     => 'list',
					'id'       => 'register_taxonomy',
					'desc'     => esc_html__( 'Register custom product taxonomies', '^xwc' ),
					'section'  => 'general',
					'title'    => esc_html__( 'Name', '^xwc' ),
					'options'  => 'list',
					'default'  => '',
					'settings' => array(
						'name'        => array(
							'name'    => esc_html__( 'Plural name', '^xwc' ),
							'type'    => 'text',
							'id'      => 'name',
							'desc'    => esc_html__( 'Enter plural taxonomy name', '^xwc' ),
							'default' => '',
						),
						'single_name' => array(
							'name'    => esc_html__( 'Singular name', '^xwc' ),
							'type'    => 'text',
							'id'      => 'single_name',
							'desc'    => esc_html__( 'Enter singular taxonomy name', '^xwc' ),
							'default' => '',
						),
						'hierarchy'   => array(
							'name'    => esc_html__( 'Use hierarchy', '^xwc' ),
							'type'    => 'checkbox',
							'id'      => 'hierarchy',
							'desc'    => esc_html__( 'Enable hierarchy for this taxonomy', '^xwc' ),
							'default' => 'no',
						),
					),
				),

				'hide_empty'             => array(
					'name'    => esc_html__( 'Hide Empty Terms', '^xwc' ),
					'type'    => 'checkbox',
					'desc'    => esc_html__( 'Hide empty terms in settings', '^xwc' ),
					'section' => 'general',
					'id'      => 'hide_empty',
					'default' => 'no',
				),

				'enable'                 => array(
					'name'    => esc_html__( 'Use AJAX', '^xwc' ),
					'type'    => 'checkbox',
					'desc'    => esc_html__( 'Check this option to use AJAX in Shop', '^xwc' ),
					'section' => 'ajax',
					'id'      => 'enable',
					'default' => 'no',
					'class'   => 'svx-refresh-active-tab',
				),

				'automatic'              => array(
					'name'      => esc_html__( 'Automatic AJAX', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to use automatic AJAX installation.', '^xwc' ) . ' <strong>' . ( isset( $ajax['recognized'] ) ? esc_html__( 'Theme supported! AJAX is set for', '^xwc' ) . ' ' . esc_html( $ajax['name'] ) : esc_html__( 'Theme not found in database. Using default settings.', '^xwc' ) ) . '</strong>',
					'section'   => 'ajax',
					'id'        => 'automatic',
					'default'   => 'yes',
					'class'     => 'svx-refresh-active-tab',
					'condition' => 'enable:yes',
				),

				'wrapper'                => array(
					'name'      => esc_html__( 'Product Wrapper', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter product wrapper jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['wrapper'] ) ? esc_html( $ajax['wrapper'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'wrapper',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'category'               => array(
					'name'      => esc_html__( 'Product Category', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter product category jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['category'] ) ? esc_html( $ajax['category'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'category',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'product'                => array(
					'name'      => esc_html__( 'Product', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter product jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['product'] ) ? esc_html( $ajax['product'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'product',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'columns'                => array(
					'name'      => esc_html__( 'Columns', '^xwc' ),
					'type'      => 'number',
					'desc'      => esc_html__( 'Fix columns problems', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'columns',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'rows'                   => array(
					'name'      => esc_html__( 'Rows', '^xwc' ),
					'type'      => 'number',
					'desc'      => esc_html__( 'Fix rows problems', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'rows',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'result_count'           => array(
					'name'      => esc_html__( 'Result Count', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter result count jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['result_count'] ) ? esc_html( $ajax['result_count'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'result_count',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'order_by'               => array(
					'name'      => esc_html__( 'Order By', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter order by jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['order_by'] ) ? esc_html( $ajax['order_by'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'order_by',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'pagination'             => array(
					'name'      => esc_html__( 'Pagination', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter pagination jQuery selector.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['pagination'] ) ? esc_html( $ajax['pagination'] ) : '' ),
					'section'   => 'ajax',
					'id'        => 'pagination',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'pagination_function'    => array(
					'name'      => esc_html__( 'Pagination Function', '^xwc' ),
					'type'      => 'text',
					'desc'      => esc_html__( 'Enter pagination function.', '^xwc' ) . ' ' . esc_html( 'Currently set to', '^xwc' ) . ': ' . ( isset( $ajax['pagination_function'] ) ? esc_html( $ajax['pagination_function'] ) : 'woocommerce_pagination' ),
					'section'   => 'ajax',
					'id'        => 'pagination_function',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'pagination_type'        => array(
					'name'      => esc_html__( 'Pagination Type', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select pagination type', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'pagination_type',
					'options'   => array(
						'default'                        => esc_html__( 'Default (Theme)', '^xwc' ),
						'prdctfltr-pagination-default'   => esc_html__( 'Custom pagination (Product Filter)', '^xwc' ),
						'prdctfltr-pagination-load-more' => esc_html__( 'Load more (Product Filter)', '^xwc' ),
						'prdctfltr-pagination-infinite-load' => esc_html__( 'Infinite load (Product Filter)', '^xwc' ),
					),
					'default'   => 'default',
					'condition' => 'enable:yes',
				),

				'failsafe'               => array(
					'name'      => esc_html__( 'Failsafe', '^xwc' ),
					'type'      => 'multiselect',
					'desc'      => esc_html__( 'Select which missing element will not trigger AJAX and will reload the page', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'failsafe',
					'options'   => array(
						'wrapper'    => esc_html__( 'Products wrapper', '^xwc' ),
						'product'    => esc_html__( 'Products', '^xwc' ),
						'pagination' => esc_html__( 'Pagination', '^xwc' ),
					),
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'js'                     => array(
					'name'      => esc_html__( 'After AJAX JS', '^xwc' ),
					'type'      => 'textarea',
					'desc'      => esc_html__( 'Enter JavaScript or jQuery code to execute after AJAX', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'js',
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'animation'              => array(
					'name'      => esc_html__( 'Product Animation', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select product animation after AJAX', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'animation',
					'options'   => array(
						'none'    => esc_html__( 'No animation', '^xwc' ),
						'default' => esc_html__( 'Fade in products', '^xwc' ),
						'random'  => esc_html__( 'Fade in random products', '^xwc' ),
					),
					'default'   => '',
					'condition' => 'enable:yes',
				),

				'scroll_to'              => array(
					'name'      => esc_html__( 'Scroll To', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select scroll to after AJAX', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'scroll_to',
					'options'   => array(
						'none'     => esc_html__( 'Disable scroll', '^xwc' ),
						'filter'   => esc_html__( 'Filter', '^xwc' ),
						'products' => esc_html__( 'Products', '^xwc' ),
						'top'      => esc_html__( 'Page top', '^xwc' ),
					),
					'default'   => '',
					'condition' => 'enable:yes',
				),

				'permalinks'             => array(
					'name'      => esc_html__( 'Browser URL/Permalinks', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Select how to display browser URLs or permalinks on AJAX', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'permalinks',
					'options'   => array(
						'no'    => esc_html__( 'Use Product Filter redirects', '^xwc' ),
						'query' => esc_html__( 'Only add query parameters', '^xwc' ),
						'yes'   => esc_html__( 'Disable URL changes', '^xwc' ),
					),
					'default'   => '',
					'condition' => 'enable:yes',
				),

				'dont_load'              => array(
					'name'      => esc_html__( 'Disable Elements', '^xwc' ),
					'type'      => 'multiselect',
					'desc'      => esc_html__( 'Select which elements will not be used with AJAX', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'dont_load',
					'options'   => array(
						'breadcrumbs' => esc_html__( 'Breadcrumbs', '^xwc' ),
						'title'       => esc_html__( 'Shop title', '^xwc' ),
						'desc'        => esc_html__( 'Shop description', '^xwc' ),
						'result'      => esc_html__( 'Result count', '^xwc' ),
						'orderby'     => esc_html__( 'Order By', '^xwc' ),
					),
					'default'   => '',
					'condition' => 'enable:yes&&automatic:no',
				),

				'force_product'          => array(
					'name'      => esc_html__( 'Post Type', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to add the ?post_type=product parameter when filtering', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'force_product',
					'default'   => 'no',
					'condition' => 'enable:no',
				),

				'force_action'           => array(
					'name'      => esc_html__( 'Stay on Permalink ', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to force filtering on same permalink (URL)', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'force_action',
					'default'   => 'no',
					'condition' => 'enable:no',
				),

				'force_redirects'        => array(
					'name'      => esc_html__( 'Permalink Structure', '^xwc' ),
					'type'      => 'select',
					'desc'      => esc_html__( 'Set permalinks structure', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'force_redirects',
					'options'   => array(
						'no'  => esc_html__( 'Use Product Filter redirects', '^xwc' ),
						'yes' => esc_html__( 'Use .htaccess and native WordPress redirects', '^xwc' ),
					),
					'default'   => 'no',
					'condition' => 'enable:no',
				),

				'remove_single_redirect' => array(
					'name'      => esc_html__( 'Single Product', '^xwc' ),
					'type'      => 'checkbox',
					'desc'      => esc_html__( 'Check this option to remove redirect when only one product is found', '^xwc' ),
					'section'   => 'ajax',
					'id'        => 'remove_single_redirect',
					'default'   => 'no',
					'condition' => 'enable:no',
				),

				'actions'                => array(
					'name'     => esc_html__( 'Integration Hooks', '^xwc' ),
					'type'     => 'list',
					'id'       => 'actions',
					'desc'     => esc_html__( 'Add filter presets to hooks', '^xwc' ),
					'section'  => 'integration',
					'title'    => esc_html__( 'Name', '^xwc' ),
					'options'  => 'list',
					'default'  => '',
					'settings' => array(
						'name'              => array(
							'name'    => esc_html__( 'Name', '^xwc' ),
							'type'    => 'text',
							'id'      => 'name',
							'desc'    => esc_html__( 'Enter name', '^xwc' ),
							'default' => '',
						),
						'hook'              => array(
							'name'    => esc_html__( 'Common Hooks', '^xwc' ),
							'type'    => 'select',
							'id'      => 'hook',
							'desc'    => esc_html__( 'Select a common hook', '^xwc' ),
							'options' => array(
								'' => esc_html__( 'Use custom hook', '^xwc' ),
								'woocommerce_before_main_content' => 'woocommerce_before_main_content',
								'woocommerce_archive_description' => 'woocommerce_archive_description',
								'woocommerce_before_shop_loop' => 'woocommerce_before_shop_loop',
								'woocommerce_after_shop_loop' => 'woocommerce_after_shop_loop',
								'woocommerce_after_main_content' => 'woocommerce_after_main_content',
							),
							'default' => '',
						),
						'action'            => array(
							'name'    => esc_html__( 'Custom Hook', '^xwc' ),
							'type'    => 'text',
							'id'      => 'action',
							'desc'    => esc_html__( 'If you use custom hook, rather than common hooks, please enter it here', '^xwc' ),
							'default' => '',
						),
						'priority'          => array(
							'name'    => esc_html__( 'Priority', '^xwc' ),
							'type'    => 'number',
							'id'      => 'priority',
							'desc'    => esc_html__( 'Set hook priority', '^xwc' ),
							'default' => '',
						),
						'preset'            => array(
							'name'    => esc_html__( 'Preset', '^xwc' ),
							'type'    => 'select',
							'id'      => 'preset',
							'desc'    => esc_html__( 'Set filter preset', '^xwc' ),
							'options' => 'function:__make_presets',
							'default' => '',
							'class'   => 'svx-selectize',
						),
						'disable_overrides' => array(
							'name'    => esc_html__( 'Presets Manager', '^xwc' ),
							'type'    => 'checkbox',
							'id'      => 'disable_overrides',
							'desc'    => esc_html__( 'Disable presets manager settings', '^xwc' ),
							'default' => '',
						),
						'id'                => array(
							'name'    => esc_html__( 'ID', '^xwc' ),
							'type'    => 'text',
							'id'      => 'id',
							'desc'    => esc_html__( 'Enter filter element ID attribute', '^xwc' ),
							'default' => '',
						),
						'class'             => array(
							'name'    => esc_html__( 'Class', '^xwc' ),
							'type'    => 'text',
							'id'      => 'class',
							'desc'    => esc_html__( 'Enter filter element class attribute', '^xwc' ),
							'default' => '',
						),
					),
				),

				'el_result_count'        => array(
					'name'    => esc_html__( 'Result Count Integration', '^xwc' ),
					'type'    => 'select',
					'desc'    => esc_html__( 'Replace WooCommerce result count element with a product filter', '^xwc' ),
					'section' => 'integration',
					'id'      => 'el_result_count',
					'options' => 'function:__make_presets:template',
					'default' => '_do_not',
				),

				'el_orderby'             => array(
					'name'    => esc_html__( 'Order By Integration', '^xwc' ),
					'type'    => 'select',
					'desc'    => esc_html__( 'Replace WooCommerce order by element with a product filter', '^xwc' ),
					'section' => 'integration',
					'id'      => 'el_orderby',
					'options' => 'function:__make_presets:template',
					'default' => '_do_not',
				),

				'widget_notice'          => array(
					'name'    => esc_html__( 'Widget Integration', '^xwc' ),
					'type'    => 'html',
					'desc'    => '
					<div class="svx-option-header"><h3>' . esc_html__( 'Widget Integration', '^xwc' ) . '</h3></div><div class="svx-option-wrapper"><div class="svx-notice svx-info">' . esc_html__( 'Looking for widget integration options? Product Filter widgets are added to sidebars in the WordPress Widgets screen.', '^xwc' ) . ' <a href="' . admin_url( 'widgets.php' ) . '">' . esc_html__( 'Click here to navigate to WordPress Widgets', '^xwc' ) . '</a><br /><br />' . esc_html__( 'If theme that you are using has limited sidebar options, try plugins such as', '^xwc' ) . ' ' . '<a href="https://wordpress.org/plugins/woosidebars/">WooSidebars</a>, <a href="https://wordpress.org/plugins/custom-sidebars/">Custom Sidebars</a></div></div>',
					'section' => 'integration',
					'id'      => 'widget_notice',
				),

				'analytics'              => array(
					'name'    => esc_html__( 'Use Analytics', '^xwc' ),
					'type'    => 'checkbox',
					'desc'    => esc_html__( 'Check this option to use filtering analytics', '^xwc' ),
					'section' => 'analytics',
					'id'      => 'analytics',
					'default' => 'no',
				),

				'analytics_ui'           => array(
					'name'    => esc_html__( 'Filtering Analytics', '^xwc' ),
					'type'    => 'html',
					'desc'    => '
					<div class="svx-option-header"><h3>' . esc_html__( 'Filtering Analytics', '^xwc' ) . '</h3></div><div class="svx-option-wrapper">' . self::filtering_ananlytics() . '</div>',
					'section' => 'analytics',
					'id'      => 'analytics_ui',
				),

			)
		);

		return SevenVX()->_do_options( $plugins, self::$plugin['label'] );
	}

	public static function build_overrides() {
		if ( empty( self::$settings['options']['general']['supported_overrides'] ) ) {
			return array();
		}

		$array = array();

		foreach ( self::$settings['options']['general']['supported_overrides'] as $taxonomy ) {

			if ( taxonomy_exists( $taxonomy ) ) {

				$taxonomy = get_taxonomy( $taxonomy );

				$array[ '_pf_manager_' . $taxonomy->name ] = array(
					'name'     => $taxonomy->label . ' ' . esc_html__( 'Presets', '^xwc' ),
					'type'     => 'list',
					'id'       => '_pf_manager_' . $taxonomy->name,
					'desc'     => esc_html__( 'Add filter presets for', '^xwc' ) . ' ' . $taxonomy->label,
					'section'  => 'manager',
					'title'    => esc_html__( 'Name', '^xwc' ),
					'options'  => 'list',
					'default'  => '',
					'settings' => array(
						'name'   => array(
							'name'    => esc_html__( 'Name', '^xwc' ),
							'type'    => 'text',
							'id'      => 'name',
							'desc'    => esc_html__( 'Enter name', '^xwc' ),
							'default' => '',
						),
						'term'   => array(
							'name'    => esc_html__( 'Term', '^xwc' ),
							'type'    => 'select',
							'id'      => 'term',
							'desc'    => esc_html__( 'Choose term, that when selected, will show the set filter preset', '^xwc' ),
							'options' => 'ajax:taxonomy:' . $taxonomy->name . ':has_none:no_lang',
							'default' => '',
							'class'   => 'svx-selectize',
						),
						'preset' => array(
							'name'    => esc_html__( 'Preset', '^xwc' ),
							'type'    => 'select',
							'id'      => 'preset',
							'desc'    => esc_html__( 'Set filter preset', '^xwc' ),
							'options' => 'function:__make_presets:has_none',
							'default' => '',
							'class'   => 'svx-selectize',
						),
					),
				);
			}
		}

		return $array;

	}

	public static function filtering_ananlytics() {
		ob_start();

		$stats = get_option( '_prdctfltr_analytics', array() );

		if ( empty( $stats ) ) {
			?>
				<div class="svx-notice svx-info">
			<?php
				esc_html_e( 'Filtering analytics are empty!', '^xwc' );
			?>
				</div>
			<?php
		} else {
			?>
				<div class="pf-analytics-wrapper">
			<?php
			foreach ( $stats as $k => $v ) {
				$show = array();
				?>
					<div class="pf-analytics">
				<?php
					$mode = 'default';
				if ( taxonomy_exists( $k ) ) {
					$mode = 'taxonomy';
					if ( 'pa_' === substr( $k, 0, 3 ) ) {
						$label = wc_attribute_label( $k );
					} else {
						if ( 'product_cat' === $k ) {
							$label = esc_html__( 'Categories', '^xwc' );
						} elseif ( 'product_tag' === $k ) {
							$label = esc_html__( 'Tags', '^xwc' );
						} elseif ( 'characteristics' === $k ) {
							$label = esc_html__( 'Characteristics', '^xwc' );
						} else {
							$curr_term = get_taxonomy( $k );
							$label     = $curr_term->name;
						}
					}
				}

				if ( 'taxonomy' === $mode ) {
					if ( ! empty( $v ) && is_array( $v ) ) {
						foreach ( $v as $vk => $vv ) {
							$term = get_term_by( 'slug', $vk, $k );

							if ( isset( $term->name ) ) {
								$term_name = ucfirst( $term->name ) . ' ( ' . $v[ $vk ] . ' )';
							} else {
									$term_name = 'Unknown';
							}

								$show[ $term_name ] = $v[ $vk ];
						}
							$title = ucfirst( $label );
					}
				} else {
					$title = ucfirst( $k );
				}

				?>
					<div class="pf-analytics-info">
						<strong><?php echo esc_html( $title ); ?></strong>
					</div>
					<div id="<?php echo uniqid( 'pf-analytics-chart-' ); ?>" class="pf-analytics-chart" data-chart="<?php echo esc_attr( wp_json_encode( $show ) ); ?>"></div>
				</div>
				<?php
			}
			?>
			</div>
			<div class="pf-analytics-settings">
				<div class="svx-notice svx-info">
				<?php esc_html_e( 'Click the button to reset filtering analytics.', '^xwc' ); ?><br /><br />
					<span id ="pf-analytics-reset" class="svx-button"><?php esc_html_e( 'Reset analytics', '^xwc' ); ?></span>
				</div>
			</div>
			<?php
		}
		return ob_get_clean();
	}

	public static function analytics_reset() {
		delete_option( '_prdctfltr_analytics' );

		wp_die( 1 );
		exit;
	}

	public static function stripslashes_deep( $value ) {
		$value = is_array( $value ) ? array_map( 'stripslashes_deep', $value ) : stripslashes( $value );
		return $value;
	}

}

XforWC_Product_Filters_Settings::init();
