<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class XforWC_Product_Filters_Frontend {

	public static $version;

	public static $dir;
	public static $path;
	public static $url_path;

	public static $settings;
	public static $options;

	public static $filter;
	public static $theme;
	public static $opt;

	public static function init() {
		$class = __CLASS__;
		new $class();
	}

	function __construct() {

		self::$version = XforWC_Product_Filters::$version;

		self::$dir      = trailingslashit( Prdctfltr()->plugin_path() );
		self::$path     = trailingslashit( Prdctfltr()->plugin_path() );
		self::$url_path = trailingslashit( Prdctfltr()->plugin_url() );

		self::$options = Prdctfltr()->get_default_options();

		self::_install_filter();

		add_filter( 'body_class', array( $this, 'add_body_class' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'prdctfltr_scripts' ), 999999 );
		add_action( 'wp_footer', array( $this, 'localize_scripts' ), 0 );

		add_action( 'woocommerce_product_query', array( $this, 'prdctfltr_wc_query' ), 999998, 2 );
		add_action( 'woocommerce_product_query', array( $this, 'prdctfltr_wc_tax' ), 999999, 2 );

		add_action( 'prdctfltr_output_css', array( $this, 'prdctfltr_add_css' ) );

		add_filter( 'woocommerce_product_is_visible', array( $this, 'outofstock_show' ), 2, 999999 );

		if ( ! is_admin() && '' !== get_option( 'permalink_structure' ) && 'yes' !== self::$options['general']['force_redirects'] ) {
			add_action( 'template_redirect', array( $this, 'prdctfltr_redirect' ), 0 );
		}

		if ( 'yes' === self::$options['general']['remove_single_redirect'] ) {
			add_filter( 'woocommerce_redirect_single_search_result', array( $this, 'return_false' ), 999 );
		}
		if ( 'yes' === self::$options['general']['analytics'] ) {
			add_action( 'wp_ajax_nopriv_prdctfltr_analytics', array( $this, 'prdctfltr_analytics' ) );
			add_action( 'wp_ajax_prdctfltr_analytics', array( $this, 'prdctfltr_analytics' ) );
		}

		add_action( 'prdctfltr_output', array( $this, 'prdctfltr_get_filter' ), 10 );

		if ( 'yes' === self::$options['general']['variable_images'] ) {
			add_action( 'woocommerce_product_get_image', array( $this, 'prdctfltr_switch_thumbnails_350' ), 999, 5 );
		}

		add_action( 'prdctfltr_filter_before', array( $this, 'make_filterjs' ) );
		add_action( 'prdctfltr_filter_after', array( $this, 'do_after' ) );
		add_action( 'prdctfltr_filter_form_after', array( $this, 'get_added_inputs' ) );
		add_action( 'prdctfltr_filter_wrapper_before', array( $this, 'get_added_inputs' ) );
		add_action( 'prdctfltr_filter_wrapper_before', array( $this, 'make_adoptive' ), 10 );
		add_action( 'prdctfltr_filter_wrapper_before', array( $this, 'get_top_bar' ), 20 );

		add_action( 'woocommerce_after_shop_loop', array( $this, 'cleanup' ), 999 );

		add_action( 'prdctfltr_before_ajax_json_send', array( $this, 'add_variations_data' ), 999 );

		add_filter( 'wcml_multi_currency_ajax_actions', array( $this, 'wcml_currency' ), 50, 1 );
		add_filter( 'xforwc__add_meta_information_used', array( $this, 'prdctfltr_info' ) );

		add_action( 'init', array( $this, 'check_wpml' ) );
		add_filter( 'prdctfltr_show_filter', array( $this, 'check_filter' ) );
		add_action( 'prdctfltr_template_init', array( $this, 'admin_message' ) );
	}

	function check_wpml() {
		if ( class_exists( 'woocommerce_wpml' ) && function_exists( 'icl_object_id' ) ) {
			$default = apply_filters( 'wpml_default_language', null );
			if ( ! empty( $default ) ) {
				self::$settings['wpml']['default'] = $default;
			}
			$lang = '_' . apply_filters( 'wpml_current_language', null );
			if ( ! empty( $lang ) ) {
				self::$settings['wpml']['lang'] = $lang;
			}
		} else {
			self::$settings['wpml'] = false;
		}
	}

	function check_filter() {
		if ( empty( get_option( 'xforwc_key_' . ( function_exists( 'XforWC' ) ? 'xforwoocommerce' : 'product_filter' ) ) ) ) {
			return false;
		}
	}

	function admin_message() {
		if ( empty( get_option( 'xforwc_key_' . ( function_exists( 'XforWC' ) ? 'xforwoocommerce' : 'product_filter' ) ) ) ) {
			?>
		<div class="xwc--pf-notice-disabled">
			<p><?php esc_html_e( 'XWC Product Filter plugin is disabled because it is not activated. Visit the plugin settings page to register and activate the plugin.', '^xwc' ); ?></p>
			<p>
				<a href="<?php echo esc_url( admin_url( function_exists( 'XforWC' ) ? 'admin.php?page=xforwoocommerce' : 'admin.php?page=wc-settings&tab=product_filter' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Activate plugin now', '^xwc' ); ?></a>
			</p>
		</div>
			<?php
		}
	}

	function _install_filter() {

		include_once 'class-themes.php';
		$auto = XforWC_Product_Filters_Themes::get_theme();

		if ( 'yes' === self::$options['install']['ajax']['automatic'] ) {
			if ( false !== $auto ) {
				self::$options['install']['ajax'] = array_merge( self::$options['install']['ajax'], $auto );
			} else {
				self::$options['install']['ajax']['enable'] = 'no';
			}
		}

		if ( 'no' === self::$options['install']['ajax']['automatic'] && false !== $auto ) {
			foreach ( $auto as $k => $v ) {
				if ( ! isset( self::$options['install']['ajax'][ $k ] ) || '' === self::$options['install']['ajax'][ $k ] ) {
					self::$options['install']['ajax'][ $k ] = $v;
				}
			}
		}

		if ( ! empty( self::$options['install']['actions'] ) ) {
			foreach ( self::$options['install']['actions'] as $action ) {
				include_once 'class-filter.php';
				$filter = new XforWC_Product_Filters_Hooks( $action );
			}
		}

		add_filter( 'woocommerce_locate_template', array( $this, 'prdctrfltr_add_filter' ), 0, 3 );
		add_filter( 'wc_get_template_part', array( $this, 'prdctrfltr_add_filter' ), 0, 3 );
	}

	function prdctfltr_info( $val ) {
		return array_merge( $val, array( 'Product Filter for WooCommerce' ) );
	}

	function true( $var ) {
		return true;
	}

	function do_after() {
		global $prdctfltr_global;

		$prdctfltr_global['init'] = true;

		if ( ! isset( $prdctfltr_global['mobile'] ) && 'switch' === self::$settings['instance']['responsive']['behaviour'] ) {
			$prdctfltr_global['mobile'] = true;

			$prdctfltr_global['unique_id'] = null;
			$prdctfltr_global['preset']    = self::$settings['instance']['responsive']['preset'];

			include self::$dir . 'templates/product-filter.php';

		}

		if ( ! isset( $prdctfltr_global['sc_init'] ) ) {
			unset( $prdctfltr_global['unique_id'] );
		}
		unset( $prdctfltr_global['mobile'] );
		unset( $prdctfltr_global['preset'] );
		unset( $prdctfltr_global['sc_query'] );
		unset( self::$options['step_filter'] );
	}

	function make_filterjs() {

		global $prdctfltr_global;

		if ( ! isset( $prdctfltr_global['sc_init'] ) ) {

			if ( ! isset( $prdctfltr_global['mobile'] ) && ! wp_doing_ajax() && is_shop() || is_product_taxonomy() || is_search() || isset( self::$settings['shop_query']['wc_query'] ) && 'product_query' === self::$settings['shop_query']['wc_query'] ) {

				$columns = get_option( 'woocommerce_catalog_columns', 4 );
				if ( function_exists( 'wc_get_default_products_per_row' ) ) {
					$columns = wc_get_default_products_per_row();
				}

				$per_page = get_option( 'posts_per_page' );
				if ( function_exists( 'wc_get_default_product_rows_per_page' ) ) {
					$per_page = $columns * wc_get_default_product_rows_per_page();
				}
				$per_page = apply_filters( 'loop_shop_per_page', $per_page );

				$pf_col = intval( self::$options['install']['ajax']['columns'] );
				$pf_row = intval( self::$options['install']['ajax']['rows'] );

				if ( $pf_col > 0 ) {
					$columns = $pf_col;
				}
				if ( $pf_row > 0 ) {
					$per_page = $columns * $pf_row;
				}

				if ( ! isset( self::$settings['shop_query'] ) ) {

					$ordering_args = array(
						'orderby' => 'menu_order title',
						'order'   => 'ASC',
					);

					$meta_query = WC()->query->get_meta_query();
					$query_args = array(
						'post_type'           => 'product',
						'post_status'         => 'publish',
						'ignore_sticky_posts' => 1,
						'orderby'             => $ordering_args['orderby'],
						'order'               => $ordering_args['order'],
						'posts_per_page'      => $per_page,
						'meta_query'          => $meta_query,
						'tax_query'           => WC()->query->get_tax_query(),
					);

					self::$settings['shop_query'] = $query_args;

				}

				$prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['archive']    = true;
				$prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['query_args'] = array_unique( self::$settings['shop_query'], SORT_REGULAR );

				$prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts'] = array(
					'archive'  => true,
					'columns'  => $columns,
					'per_page' => $per_page,
					'preset'   => isset( $prdctfltr_global['preset'] ) ? $prdctfltr_global['preset'] : null,
				);

				if ( isset( $prdctfltr_global['atts_data'] ) && is_array( $prdctfltr_global['atts_data'] ) ) {
					array_merge( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts'], $prdctfltr_global['atts_data'] );
				}
			}
		}

		$prdctfltr_global['filter_js'][ $prdctfltr_global['unique_id'] ] = array(
			'widget_search'     => isset( $prdctfltr_global['widget_search'] ) ? 'yes' : 'no',
			'widget_options'    => isset( $prdctfltr_global['widget_options'] ) ? $prdctfltr_global['widget_options'] : '',
			'collectors'        => self::$settings['instance']['general']['collectors'],
			'collector_style'   => self::$settings['instance']['general']['collector_style'],
			'button_text'       => self::$settings['instance']['style']['filter_button'],
			'disable_overrides' => ! empty( $prdctfltr_global['disable_overrides'] ) ? $prdctfltr_global['disable_overrides'] : '',

			'_tx_clearall'      => self::$settings['instance']['style']['_tx_clearall'],
		);

	}

	public static function get_filter_appearance() {

		global $prdctfltr_global;

		self::$settings['instance'] = null;
		self::$settings['cnt']      = 1;

		self::make_filter();

		$prdctfltr_global['unique_id'] = isset( $prdctfltr_global['unique_id'] ) ? $prdctfltr_global['unique_id'] : uniqid( 'prdctfltr-' );

	}

	function get_added_inputs() {
		global $prdctfltr_global;

		$pf_activated = isset( $prdctfltr_global['pf_activated'] ) ? $prdctfltr_global['pf_activated'] : array();

		if ( 1 === apply_filters( 'prdctfltr_add_inputs_html', 1 ) ) {

			?>
			<div class="prdctfltr_add_inputs">
			<?php
			if ( ! in_array( 'search', self::$settings['active'], true ) && isset( $pf_activated['s'] ) ) {
				echo '<input type="hidden" name="' . ( isset( $prdctfltr_global['sc_init'] ) ? 'search_products' : 's' ) . '" value="' . esc_attr( $pf_activated['s'] ) . '" />';
			}
			if ( isset( $_GET['page_id'] ) ) {
				echo '<input type="hidden" name="page_id" value="' . esc_attr( $_GET['page_id'] ) . '" />';
			}
			if ( isset( $_GET['lang'] ) ) {
				echo '<input type="hidden" name="lang" value="' . esc_attr( $_GET['lang'] ) . '" />';
			}
			if ( ! in_array( 'orderby', self::$settings['active'], true ) && isset( $pf_activated['orderby'] ) ) {
				echo '<input type="hidden" name="orderby" value="' . esc_attr( $pf_activated['orderby'] ) . '" class="pf_added_orderby" />';
			}

			if ( ! empty( $prdctfltr_global['active_permalinks'] ) ) {
				foreach ( $prdctfltr_global['active_permalinks'] as $pf_k => $pf_v ) {
					if ( ! in_array( $pf_k, self::$settings['active'], true ) ) {
						echo '<input type="hidden" name="' . esc_attr( $pf_k ) . '" value="' . esc_attr( $prdctfltr_global['permalinks_data'][ $pf_k . '_string' ] ) . '" class="pf_added_input" />';
					}
					$prdctfltr_global['filter_js'][ $prdctfltr_global['unique_id'] ]['adds'][ $pf_k ] = $prdctfltr_global['permalinks_data'][ $pf_k . '_string' ];
				}
			}

			$curr_posttype = self::$options['general']['force_product'];
			if ( 'no' === $curr_posttype ) {
				if ( ! isset( $pf_activated['s'] ) && '' === get_option( 'permalink_structure' ) && ( is_shop() || is_product_taxonomy() ) ) {
					echo '<input type="hidden" name="post_type" value="product" />';
				}
			} else {
				echo '<input type="hidden" name="post_type" value="product" />';
			}

			if ( isset( $pf_activated['products_per_page'] ) ) {
				echo '<input type="hidden" name="products_per_page" value="' . absint( $pf_activated['products_per_page'] ) . '"  class="pf_added_input" />';
			}

			do_action( 'prdctfltr_add_inputs' );
			?>
			</div>
			<?php
		}

	}

	function prdctfltr_scripts() {
		wp_enqueue_style( 'prdctfltr', self::$url_path . 'includes/css/styles' . ( is_rtl() ? '-rtl' : '' ) . '.css', false, self::$version );

		wp_register_script( 'prdctfltr-main-js', self::$url_path . 'includes/js/prdctfltr.js', array( 'jquery', 'hoverIntent' ), self::$version, true );
		wp_enqueue_script( 'prdctfltr-main-js' );
	}

	function localize_scripts() {

		global $prdctfltr_global;

		if ( ! isset( $prdctfltr_global['init'] ) ) {
			wp_dequeue_script( 'prdctfltr-main-js' );
		} elseif ( wp_script_is( 'prdctfltr-main-js', 'enqueued' ) ) {

			global $wp_rewrite;

			$curr_args = apply_filters(
				'prdctfltr_localize_javascript',
				array(
					'ajax'                  => admin_url( 'admin-ajax.php' ),
					'wc_ajax'               => WC()->ajax_url(),
					'url'                   => self::$url_path,
					'rtl'                   => is_rtl(),
					'page_rewrite'          => $wp_rewrite->pagination_base,
					'js'                    => stripslashes( self::$options['install']['ajax']['js'] ),
					'use_ajax'              => self::$options['install']['ajax']['enable'],
					'ajax_class'            => self::$options['install']['ajax']['wrapper'],
					'ajax_category_class'   => self::$options['install']['ajax']['category'],
					'ajax_product_class'    => self::$options['install']['ajax']['product'],
					'ajax_pagination_class' => self::$options['install']['ajax']['pagination'],
					'ajax_count_class'      => self::$options['install']['ajax']['result_count'],
					'ajax_orderby_class'    => self::$options['install']['ajax']['order_by'],
					'ajax_pagination_type'  => self::$options['install']['ajax']['pagination_type'],
					'ajax_animation'        => self::$options['install']['ajax']['animation'],
					'ajax_scroll'           => self::$options['install']['ajax']['scroll_to'],
					'analytics'             => self::$options['general']['analytics'],
					'clearall'              => isset( self::$options['general']['clear_all'] ) ? self::$options['general']['clear_all'] : false,
					'permalinks'            => self::$options['install']['ajax']['permalinks'],
					'ajax_failsafe'         => self::$options['install']['ajax']['failsafe'],
					'localization'          => array(
						'close_filter' => esc_html__( 'Close', '^xwc' ),
						'filter_terms' => esc_html__( 'Filter terms', '^xwc' ),
						'ajax_error'   => esc_html__( 'AJAX Error!', '^xwc' ),
						'show_more'    => esc_html__( 'Show more', '^xwc' ),
						'show_less'    => esc_html__( 'Show less', '^xwc' ),
						'noproducts'   => esc_html__( 'No products found!', '^xwc' ),
						'clearall'     => esc_html__( 'Clear filters', '^xwc' ),
						'getproducts'  => esc_html__( 'Show products', '^xwc' ),
						'outofstock'   => esc_html__( 'Out of stock', '^xwc' ),
						'backorder'    => esc_html__( 'On backorder', '^xwc' ),
					),
					'js_filters'            => ( isset( $prdctfltr_global['filter_js'] ) ? $prdctfltr_global['filter_js'] : array() ),
					'pagefilters'           => ( isset( $prdctfltr_global['pagefilters'] ) ? $prdctfltr_global['pagefilters'] : array() ),
					'rangefilters'          => ( isset( $prdctfltr_global['ranges'] ) ? $prdctfltr_global['ranges'] : array() ),
					'orderby'               => ( isset( $prdctfltr_global['default_order']['orderby'] ) ? $prdctfltr_global['default_order']['orderby'] : '' ),
					'order'                 => ( isset( $prdctfltr_global['default_order']['order'] ) ? $prdctfltr_global['default_order']['order'] : '' ),
					'active_sc'             => ( isset( XforWC_Product_Filters_Shortcodes::$settings['sc'] ) ? XforWC_Product_Filters_Shortcodes::$settings['sc'] : '' ),
					'animation'             => array(
						'delay'    => 100,
						'duration' => 300,
					),
					'active_filtering'      => array(
						'active'   => empty( $prdctfltr_global['active_filters'] ) ? false : $prdctfltr_global['active_filters'],
						'variable' => $this->get_variable_products_helper(),
					),
				)
			);

			wp_localize_script( 'prdctfltr-main-js', 'prdctfltr', $curr_args );

		}

	}

	public static function make_global( $set, $query = array() ) {

		global $prdctfltr_global;

		if ( isset( $prdctfltr_global['mobile'] ) ) {
			return true;
		}

		if ( 1 === apply_filters( 'prdctfltr_make_global', 1 ) ) :

			$stop = false;

			if ( false === $stop ) {

				$taxonomies                = array();
				$taxonomies_data           = array();
				$permalink_taxonomies      = array();
				$permalink_taxonomies_data = array();
				$misc                      = array();
				$rng_terms                 = array();
				$mta_terms                 = array();
				$rng_for_activated         = array();
				$mtarn_for_activated       = array();
				$mtar_for_activated        = array();
				$mta_for_activated         = array();
				$mta_for_array             = array();

				$product_taxonomies = get_object_taxonomies( 'product' );
				$product_type       = array_search( 'product_type', $product_taxonomies, true );

				if ( false !== $product_type ) {
					unset( $product_taxonomies[ $product_type ] );
				}

				$sc_args = array();

				$prdctfltr_global['taxonomies'] = $product_taxonomies;

				if ( isset( $prdctfltr_global['sc_query'] ) && is_array( $prdctfltr_global['sc_query'] ) ) {
					foreach ( $prdctfltr_global['sc_query'] as $sck => $scv ) {
						if ( in_array( $sck, $product_taxonomies, true ) ) {
							continue;
						}
						$sc_args[ $sck ] = $scv;
					}
				}

				$set = array_merge( $sc_args, $set );

				if ( isset( $set ) && ! empty( $set ) ) {

					$get = $set;

					if ( isset( $get['search_products'] ) && ! empty( $get['search_products'] ) && ! isset( $get['s'] ) ) {
						$get['s'] = $get['search_products'];
					}

					$allowed = array( 'orderby', 'product_order', 'order', 'product_sort', 'min_price', 'max_price', 'instock_products', 'sale_products', 'products_per_page', 'product_count', 's', 'vendor', 'rating_filter' );

					foreach ( $get as $k => $v ) {
						if ( '' === $v ) {
							continue;
						}

						if ( in_array( $k, $allowed, true ) ) {
							if ( 'order' === $k || 'product_sort' === $k ) {
								$misc['order'] = ( strtoupper( $v ) === 'DESC' ? 'DESC' : 'ASC' );
							} elseif ( 'orderby' === $k || 'product_order' === $k ) {
								$misc['orderby'] = strtolower( $v );
							} elseif ( in_array( $k, array( 'products_per_page', 'product_count' ), true ) ) {
								$misc['products_per_page'] = intval( $v );
							} elseif ( in_array( $k, array( 'min_price', 'max_price' ), true ) ) {
								$misc[ $k ] = '' === $v ? '' : floatval( $v );
							} else {
								$misc[ $k ] = $v;
							}
						} elseif ( taxonomy_exists( $k ) || 'filter_' === substr( $k, 0, 7 ) ) {

							if ( strpos( $v, ',' ) ) {
								$selected                            = explode( ',', $v );
								$taxonomies_data[ $k . '_relation' ] = 'IN';
							} elseif ( strpos( $v, '+' ) ) {
								$selected                            = explode( '+', $v );
								$taxonomies_data[ $k . '_relation' ] = 'AND';
							} elseif ( strpos( $v, ' ' ) ) {
								$selected                            = explode( ' ', $v );
								$taxonomies_data[ $k . '_relation' ] = 'AND';
							} else {
								$selected = array( $v );
							}

							if ( 'pa_' === substr( $k, 0, 3 ) ) {
								$f_attrs[] = 'attribute_' . $k;

								foreach ( $selected as $val ) {
									if ( term_exists( $val, $k ) !== null ) {
										$taxonomies[ $k ][] = $val;
										$f_terms[]          = self::prdctfltr_utf8_decode( $val );
									}
								}
							} elseif ( 'filter_' === substr( $k, 0, 7 ) ) {
								$k         = 'pa_' . substr( $k, 7 );
								$f_attrs[] = 'attribute_' . $k;

								foreach ( $selected as $val ) {
									if ( term_exists( $val, $k ) !== null ) {
										$taxonomies[ $k ][] = $val;
										$f_terms[]          = self::prdctfltr_utf8_decode( $val );
									}
								}
							} else {
								foreach ( $selected as $val ) {
									if ( term_exists( $val, $k ) !== null ) {
										$taxonomies[ $k ][] = $val;
									}
								}
							}

							if ( ! empty( $taxonomies[ $k ] ) ) {
								if ( isset( $taxonomies_data[ $k . '_relation' ] ) && 'AND' === $taxonomies_data[ $k . '_relation' ] ) {
									$taxonomies_data[ $k . '_string' ] = implode( '+', $taxonomies[ $k ] );
								} else {
									$taxonomies_data[ $k . '_string' ] = implode( ',', $taxonomies[ $k ] );
								}
							}
						} elseif ( 'rng_' === substr( $k, 0, 4 ) ) {

							if ( 'rng_min_' === substr( $k, 0, 8 ) ) {
								$rng_for_activated[ $k ]                               = ( 'rng_min_price' === $k ? floatval( $v ) : $v );
								$rng_terms[ str_replace( 'rng_min_', '', $k ) ]['min'] = $v;
							} elseif ( 'rng_max_' === substr( $k, 0, 8 ) ) {
								$rng_for_activated[ $k ]                               = ( 'rng_max_price' === $k ? floatval( $v ) : $v );
								$rng_terms[ str_replace( 'rng_max_', '', $k ) ]['max'] = $v;
							} elseif ( 'rng_orderby_' === substr( $k, 0, 12 ) ) {
								$rng_terms[ str_replace( 'rng_orderby_', '', $k ) ]['orderby'] = $v;
							} elseif ( 'rng_order_' === substr( $k, 0, 10 ) ) {
								$rng_terms[ str_replace( 'rng_order_', '', $k ) ]['order'] = ( 'DESC' === strtoupper( $v ) ? 'DESC' : 'ASC' );
							}
						} elseif ( 1 === preg_match( '#^' . apply_filters( 'prdctfltr_meta_range_numeric_key_prefix', 'mtarn_' ) . '#i', $k ) ) {
							$mtarn_for_activated[ $k ] = explode( ',', $v );

							$mta_key     = esc_attr( substr( $k, strlen( apply_filters( 'prdctfltr_meta_range_numeric_key_prefix', 'mtarn_' ) ) ) );
							$mta_type    = 'DECIMAL';
							$mta_compare = 'BETWEEN';

							$mta_terms[] = array(
								'key'     => $mta_key,
								'type'    => $mta_type,
								'compare' => $mta_compare,
								'value'   => $mtarn_for_activated[ $k ],
							);
						} elseif ( 1 === preg_match( '#^' . apply_filters( 'prdctfltr_meta_range_key_prefix', 'mtar_' ) . '#i', $k ) ) {
							$mtar_for_activated[ $k ] = explode( ',', $v );

							$mta_key     = esc_attr( substr( $k, strlen( apply_filters( 'prdctfltr_meta_range_numeric_key_prefix', 'mtar_' ) ) ) );
							$mta_type    = 'CHAR';
							$mta_compare = 'IN';

							$mta_terms[] = array(
								'key'     => $mta_key,
								'type'    => $mta_type,
								'compare' => $mta_compare,
								'value'   => $mtar_for_activated[ $k ],
							);
						} elseif ( 1 === preg_match( '#^' . apply_filters( 'prdctfltr_meta_key_prefix', 'mta_' ) . '#i', $k ) ) {

							$mta_key     = esc_attr( substr( $k, strlen( apply_filters( 'prdctfltr_meta_key_prefix', 'mta_' ) ), -5 ) );
							$mta_type    = self::get_meta_type( substr( $k, -4, 1 ) );
							$mta_compare = self::get_meta_compare( substr( $k, -2, 2 ) );

							if ( strpos( $v, ',' ) ) {
								$mta_selected = array_map( 'esc_attr', explode( ',', $v ) );
								$mta_relation = 'OR';
							} elseif ( strpos( $v, '+' ) ) {
								$mta_selected = array_map( 'esc_attr', explode( '+', $v ) );
								$mta_relation = 'AND';
							} else {
								$mta_selected = esc_attr( $v );
							}

							$mta_for_activated[ $k ] = $v;
							$mta_for_array[ $k ]     = is_array( $mta_selected ) ? $mta_selected : array( $mta_selected );
							if ( is_array( $mta_selected ) ) {
								$mta_terms['relation'] = $mta_relation;
								foreach ( $mta_selected as $mta_sngl ) {
									if ( strpos( $mta_compare, 'BETWEEN' ) > -1 && strpos( $mta_sngl, '-' ) ) {
										$mta_sngl = explode( '-', $mta_sngl );
									}
									$mta_terms[] = array(
										'key'     => $mta_key,
										'type'    => $mta_type,
										'compare' => $mta_compare,
										'value'   => $mta_sngl,
									);
								}
							} else {
								if ( strpos( $mta_compare, 'BETWEEN' ) > -1 && strpos( $mta_selected, apply_filters( 'prdctfltr_meta_key_between_separator', '-' ) ) ) {
									$mta_selected = explode( apply_filters( 'prdctfltr_meta_key_between_separator', '-' ), $mta_selected );
								}
								$mta_terms[] = array(
									'key'     => $mta_key,
									'type'    => $mta_type,
									'compare' => $mta_compare,
									'value'   => $mta_selected,
								);
							}
						}
					}

					if ( ! empty( $rng_terms ) ) {

						foreach ( $rng_terms as $rng_name => $rng_inside ) {

							if ( ! in_array( $rng_name, array( 'price' ), true ) ) {

								if ( false === ( isset( $rng_inside['min'] ) && isset( $rng_inside['max'] ) ) || ! taxonomy_exists( $rng_name ) ) {
									unset( $rng_terms[ $rng_name ] );
									unset( $rng_for_activated[ 'rng_min_' . $rng_name ] );
									unset( $rng_for_activated[ 'rng_max_' . $rng_name ] );
									continue;
								}

								if ( isset( $rng_terms[ $rng_name ]['orderby'] ) && 'number' === $rng_terms[ $rng_name ]['orderby'] ) {
									$curr_term_args = array(
										'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
										'orderby'    => 'slug',
									);
									$pf_terms       = self::prdctfltr_get_terms( $rng_name, $curr_term_args );
									$pf_sort_args   = array(
										'order' => isset( $rng_terms[ $rng_name ]['order'] ) ? $rng_terms[ $rng_name ]['order'] : '',
									);
									$pf_terms       = self::prdctfltr_sort_terms_naturally( $pf_terms, $pf_sort_args );
								} else {
									$curr_term_args = array(
										'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
										'orderby'    => isset( $rng_terms[ $rng_name ]['orderby'] ) ? $rng_terms[ $rng_name ]['orderby'] : '',
										'order'      => isset( $rng_terms[ $rng_name ]['order'] ) ? $rng_terms[ $rng_name ]['order'] : '',
									);
									$pf_terms       = self::prdctfltr_get_terms( $rng_name, $curr_term_args );
								}

								if ( empty( $pf_terms ) ) {
									continue;
								}

								$rng_found = false;

								$curr_ranges = array();

								foreach ( $pf_terms as $c => $s ) {
									if ( true === $rng_found ) {
										$curr_ranges[] = $s->slug;
										if ( $s->slug === $rng_inside['max'] ) {
											$rng_found = false;
											continue;
										}
									}
									if ( $s->slug === $rng_inside['min'] && false === $rng_found ) {
										$rng_found     = true;
										$curr_ranges[] = $s->slug;
									}
								}

								$taxonomies[ $rng_name ]                    = $curr_ranges;
								$taxonomies_data[ $rng_name . '_string' ]   = implode( ',', $curr_ranges );
								$taxonomies_data[ $rng_name . '_relation' ] = 'IN';

								if ( 'pa_' === substr( $rng_name, 0, 3 ) ) {
									$f_attrs[] = 'attribute_' . $rng_name;

									foreach ( $curr_ranges as $cr ) {
										$f_terms[] = $cr;
									}
								}
							} else {
								if ( ! isset( $rng_inside['min'] ) || ! isset( $rng_inside['max'] ) || false === ( $rng_inside['min'] < $rng_inside['max'] ) ) {
									unset( $rng_terms[ $rng_name ] );
									unset( $rng_for_activated[ 'rng_min_' . $rng_name ] );
									unset( $rng_for_activated[ 'rng_max_' . $rng_name ] );
								}
							}
						}
					}
				}

				if ( is_product_taxonomy() || isset( $prdctfltr_global['sc_query'] ) && ! empty( $prdctfltr_global['sc_query'] ) ) {

					$check_links = apply_filters( 'prdctfltr_check_permalinks', $product_taxonomies );

					foreach ( $check_links as $check_link ) {

						$curr_link      = false;
						$pf_helper      = array();
						$pf_helper_real = array();
						$is_attribute   = substr( $check_link, 0, 3 ) === 'pa_' ? true : false;

						$curr_var = get_query_var( $check_link );
						if ( ! isset( $set[ $check_link ] ) && '' !== $curr_var ) {
							$curr_link = $curr_var;
						} elseif ( isset( $prdctfltr_global['sc_query'][ $check_link ] ) && '' !== $prdctfltr_global['sc_query'][ $check_link ] ) {
							$curr_link = $prdctfltr_global['sc_query'][ $check_link ];
						} else {
							$curr_link = false;
						}

						if ( $curr_link ) {

							if ( ! is_array( $curr_link ) ) {
								if ( strpos( $curr_link, ',' ) ) {
									$pf_helper = explode( ',', $curr_link );
									$permalink_taxonomies_data[ $check_link . '_relation' ] = 'IN';
								} elseif ( strpos( $curr_link, '+' ) ) {
									$pf_helper = explode( '+', $curr_link );
									$permalink_taxonomies_data[ $check_link . '_relation' ] = 'AND';
								} elseif ( strpos( $curr_link, ' ' ) ) {
									$pf_helper = explode( ' ', $curr_link );
									$permalink_taxonomies_data[ $check_link . '_relation' ] = 'AND';
								} else {
									$pf_helper = array( $curr_link );
								}
							} else {
								$pf_helper = $curr_link;
							}

							foreach ( $pf_helper as $val ) {
								if ( null !== term_exists( $val, $check_link ) ) {
									$pf_helper_real[] = $val;
									if ( $is_attribute ) {
										$f_terms[] = self::prdctfltr_utf8_decode( $val );
									}
								}
							}

							if ( ! empty( $pf_helper_real ) ) {
								$permalink_taxonomies[ $check_link ] = $pf_helper_real;

								if ( $is_attribute ) {
									$f_attrs[] = 'attribute_' . $check_link;
								}
								if ( isset( $permalink_taxonomies_data[ $check_link . '_relation' ] ) && 'AND' === $permalink_taxonomies_data[ $check_link . '_relation' ] ) {
									$permalink_taxonomies_data[ $check_link . '_string' ] = implode( '+', $pf_helper_real );
								} else {
									$permalink_taxonomies_data[ $check_link . '_string' ] = implode( ',', $pf_helper_real );
								}
							}
						}
					}
				}

				if ( isset( $misc['order'] ) && ! isset( $misc['orderby'] ) ) {
					unset( $misc['order'] );
				}

				$prdctfltr_global['done_filters']      = true;
				$prdctfltr_global['taxonomies_data']   = $taxonomies_data;
				$prdctfltr_global['active_taxonomies'] = $taxonomies;
				$prdctfltr_global['active_misc']       = $misc;
				$prdctfltr_global['range_filters']     = $rng_terms;
				$prdctfltr_global['meta_filters']      = $mta_terms;
				$prdctfltr_global['meta_data']         = $mta_for_activated;
				$prdctfltr_global['active_filters']    = array_merge( $prdctfltr_global['active_taxonomies'], $prdctfltr_global['active_misc'], $rng_for_activated, $mta_for_array, $mtarn_for_activated, $mtar_for_activated );

				$prdctfltr_global['active_permalinks'] = array_merge( $permalink_taxonomies, $prdctfltr_global['active_taxonomies'] );
				$prdctfltr_global['permalinks_data']   = array_merge( $permalink_taxonomies_data, $prdctfltr_global['taxonomies_data'] );

				if ( ! empty( $prdctfltr_global['active_permalinks'] ) && ( is_shop() || is_product_taxonomy() ) ) {
					$prdctfltr_global['sc_query'] = $prdctfltr_global['active_permalinks'];
				}

				if ( ! empty( $misc ) || ! empty( $rng_for_activated ) || ! empty( $mta_for_array ) || 1 === count( $taxonomies ) && ! isset( $taxonomies['product_cat'] ) || count( $taxonomies ) > 1 ) {
					add_filter( 'woocommerce_is_filtered', 'XforWC_Product_Filters_Frontend::return_true' );
				}

				$prdctfltr_global['active_in_filter'] = $prdctfltr_global['active_filters'];
				if ( isset( $prdctfltr_global['sc_query'] ) && ! is_array( $prdctfltr_global['sc_query'] ) ) {
					foreach ( $check_links as $check_link ) {
						if ( isset( $prdctfltr_global['sc_query'][ $check_link ] ) && isset( $prdctfltr_global['active_in_filter'][ $check_link ] ) && $prdctfltr_global['sc_query'][ $check_link ] === $prdctfltr_global['active_in_filter'][ $check_link ] ) {
							unset( $prdctfltr_global['active_in_filter'][ $check_link ] );
						}
					}
				}

				$prdctfltr_global['pf_activated'] = array_merge( $prdctfltr_global['active_in_filter'], $prdctfltr_global['active_permalinks'] );
				self::$options['activated']       = $prdctfltr_global['pf_activated'];

				if ( isset( $f_attrs ) ) {
					$prdctfltr_global['f_attrs'] = $f_attrs;
				}

				if ( isset( $f_terms ) ) {
					$prdctfltr_global['f_terms'] = $f_terms;
				}

				$pf_activated = $prdctfltr_global['active_taxonomies'];
				$pf_tax_query = array();

				if ( ! empty( $pf_activated ) || ! empty( $prdctfltr_global['active_permalinks'] ) ) {

					foreach ( $pf_activated as $k => $v ) {
						$relation = isset( $prdctfltr_global['taxonomies_data'][ $k . '_relation' ] ) && 'AND' === $prdctfltr_global['taxonomies_data'][ $k . '_relation' ] ? 'AND' : 'IN';
						if ( count( $v ) > 1 ) {
							if ( 'AND' === $relation ) {
								$precompile = array();
								foreach ( $v as $k12 => $v12 ) {

									$asked_term  = get_term_by( 'slug', $v12, $k );
									$child_terms = get_term_children( $asked_term->term_id, $k );

									if ( ! empty( $child_terms ) ) {
										$precompile[] = array(
											'taxonomy' => $k,
											'field'    => 'term_id',
											'terms'    => array_merge( $child_terms, array( $asked_term->term_id ) ),
											'include_children' => false,
											'operator' => 'IN',
										);
									} else {
										$precompile[] = array(
											'taxonomy' => $k,
											'field'    => 'slug',
											'terms'    => $v12,
											'include_children' => false,
											'operator' => 'IN',
										);
									}
								}

								$precompile['relation'] = 'AND';

								$pf_tax_query[] = $precompile;
							} else {
								$pf_tax_query[] = array(
									'taxonomy'         => $k,
									'field'            => 'slug',
									'terms'            => $v,
									'include_children' => true,
									'operator'         => 'IN',
								);
							}
						} else {
							$pf_tax_query[] = array(
								'taxonomy'         => $k,
								'field'            => 'slug',
								'terms'            => $v,
								'include_children' => true,
								'operator'         => 'IN',
							);
						}
					}

					$pf_permalinks = $prdctfltr_global['active_permalinks'];

					foreach ( $pf_permalinks as $k => $v ) {
						$relation = isset( $prdctfltr_global['permalinks_data'][ $k . '_relation' ] ) && 'AND' === $prdctfltr_global['permalinks_data'][ $k . '_relation' ] ? 'AND' : 'IN';
						if ( count( $v ) > 1 ) {
							if ( 'AND' === $relation ) {
								$precompile = array();
								foreach ( $v as $k12 => $v12 ) {

									$asked_term  = get_term_by( 'slug', $v12, $k );
									$child_terms = get_term_children( $asked_term->term_id, $k );

									if ( ! empty( $child_terms ) ) {
										$precompile[] = array(
											'taxonomy' => $k,
											'field'    => 'term_id',
											'terms'    => array_merge( $child_terms, array( $asked_term->term_id ) ),
											'include_children' => false,
											'operator' => 'IN',
										);
									} else {
										$precompile[] = array(
											'taxonomy' => $k,
											'field'    => 'slug',
											'terms'    => $v12,
											'include_children' => false,
											'operator' => 'IN',
										);
									}
								}

								$precompile['relation'] = 'AND';

								$pf_tax_query[] = $precompile;
							} else {
								$pf_tax_query[] = array(
									'taxonomy'         => $k,
									'field'            => 'slug',
									'terms'            => $v,
									'include_children' => true,
									'operator'         => 'IN',
								);
							}
						} else {
							$pf_tax_query[] = array(
								'taxonomy'         => $k,
								'field'            => 'slug',
								'terms'            => $v,
								'include_children' => true,
								'operator'         => 'IN',
							);
						}
					}
				}

				$active = $prdctfltr_global['active_filters'];

				if ( ! isset( $active['instock_products'] ) && isset( XforWC_Product_Filters_Shortcodes::$settings['sc_instock'] ) && in_array( XforWC_Product_Filters_Shortcodes::$settings['sc_instock'], array( 'in', 'out', 'both' ), true ) ) {
					$active['instock_products'] = XforWC_Product_Filters_Shortcodes::$settings['sc_instock'];
				}

				if ( ( false !== ( ( isset( $active['instock_products'] ) && '' !== $active['instock_products'] && ( 'in' === $active['instock_products'] || 'out' === $active['instock_products'] ) ) || 'yes' === get_option( 'woocommerce_hide_out_of_stock_items', 'no' ) ) ) && ( ! isset( $active['instock_products'] ) || 'both' !== $active['instock_products'] ) ) {
					$operator = isset( $active['instock_products'] ) && 'out' === $active['instock_products'] ? 'IN' : 'NOT IN';
				}

				if ( isset( $operator ) ) {
					$pf_tax_query[] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'slug',
						'terms'    => array( 'outofstock' ),
						'operator' => $operator,
					);
				}
				$pf_tax_query[] = array(
					'taxonomy' => 'product_visibility',
					'field'    => 'slug',
					'terms'    => array( 'exclude-from-' . ( isset( $active['s'] ) ? 'search' : 'catalog' ) ),
					'operator' => 'NOT IN',
				);

				if ( isset( $active['rating_filter'] ) && in_array( $active['rating_filter'], array( '1', '2', '3', '4', '5'), true ) ) {
					$pf_tax_query[] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'slug',
						'terms'    => array( sprintf( 'rated-%s', intval( $active['rating_filter'] ) ) ),
						'operator' => 'IN',
					);
				}

				if ( ! empty( $pf_tax_query ) ) {
					self::$settings['tax_query']   = $pf_tax_query;
					$prdctfltr_global['tax_query'] = $pf_tax_query;
				}
			}

			endif;

	}

	public static function outofstock_show( $visible, $id ) {
		global $prdctfltr_global;
		if ( isset( $prdctfltr_global['active_filters']['instock_products'] ) && in_array( $prdctfltr_global['active_filters']['instock_products'], array( 'both', 'out', 'in' ), true ) ) {
			return true;
		}
		return $visible;
	}

	public static function get_min_max_price_meta_query( $args ) {

		$min = isset( $args['min_price'] ) ? floatval( $args['min_price'] ) : 0;
		$max = isset( $args['max_price'] ) ? floatval( $args['max_price'] ) : 9999999999;

		if ( wc_tax_enabled() && 'incl' === get_option( 'woocommerce_tax_display_shop' ) && ! wc_prices_include_tax() ) {
			$tax_classes = array_merge( array( '' ), WC_Tax::get_tax_classes() );
			$class_min   = $min;

			foreach ( $tax_classes as $tax_class ) {
				$tax_rates = WC_Tax::get_rates( $tax_class );
				if ( $tax_rates ) {
					$class_min = $min - WC_Tax::get_tax_total( WC_Tax::calc_exclusive_tax( $min, $tax_rates ) );
				}
			}

			$min = $class_min;
		}

		return array(
			'key'     => '_price',
			'value'   => array( $min, $max ),
			'compare' => 'BETWEEN',
			'type'    => 'DECIMAL(10,' . wc_get_price_decimals() . ')',
		);
	}

	public static function sc_wc_query( $query ) {
		if ( isset( $query->query_vars['prdctfltr_active'] ) ) {
			call_user_func( 'XforWC_Product_Filters_Frontend::prdctfltr_wc_query', $query, array() );
		}
	}
	public static function sc_wc_tax( $query ) {
		if ( isset( $query->query_vars['prdctfltr_active'] ) ) {
			call_user_func( 'XforWC_Product_Filters_Frontend::prdctfltr_wc_tax', $query, array() );
		}
	}

	public static function prdctfltr_wc_query( $query, $that ) {
		if ( empty( get_option( 'xforwc_key_' . ( function_exists( 'XforWC' ) ? 'xforwoocommerce' : 'product_filter' ) ) ) ) {
			return;
		}

		if ( ! wp_doing_ajax() && 'woocommerce_product_query' === current_filter() ) {
			self::get_vars( $query, array() );
			self::make_global( $_REQUEST, $query );
		}

		global $prdctfltr_global;

		$stop = true;

		$curr_args = array();
		$f_attrs   = array();
		$f_terms   = array();
		$rng_terms = array();

		if ( isset( $prdctfltr_global['active_filters'] ) ) {

			$pf_activated = $prdctfltr_global['active_filters'];

			if ( isset( $prdctfltr_global['range_filters'] ) ) {
				$rng_terms = $prdctfltr_global['range_filters'];
			}

			if ( isset( $prdctfltr_global['f_attrs'] ) ) {

				$f_attrs = $prdctfltr_global['f_attrs'];

				if ( isset( $prdctfltr_global['f_terms'] ) ) {
					$f_terms = $prdctfltr_global['f_terms'];
				}
			}
		}

		if ( wp_doing_ajax() && ! isset( $prdctfltr_global['sc_init'] ) || isset( $prdctfltr_global['sc_init'] ) && isset( $pf_activated['orderby'] ) && '' !== $pf_activated['orderby'] ) {

			$orderby = '';
			$order   = '';

			$default_order                                = apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
			$default_explode                              = explode( '-', $default_order );
			$dflt_order_by                                = esc_attr( $default_explode[0] );
			$dflt_order                                   = ( isset( $default_explode[1] ) && ! empty( $default_explode[1] ) ? $default_explode[1] : '' );
			$prdctfltr_global['default_order']['orderby'] = isset( $dflt_order_by ) ? $dflt_order_by : '';
			$prdctfltr_global['default_order']['order']   = isset( $dflt_order ) ? $dflt_order : '';

			$orderby_value = isset( $pf_activated['orderby'] ) ? wc_clean( (string) $pf_activated['orderby'] ) : $default_order;
			$orderby_value = explode( '-', $orderby_value );
			$orderby       = esc_attr( $orderby_value[0] );
			$order         = isset( $pf_activated['order'] ) && ! empty( $pf_activated['order'] ) ? ( 'DESC' === $pf_activated['order'] ? 'DESC' : 'ASC' ) : ( isset( $orderby_value[1] ) && ! empty( $orderby_value[1] ) ? $orderby_value[1] : '' );

			$orderby = strtolower( $orderby );
			$order   = strtoupper( $order );

			switch ( $orderby ) {

				case 'rand':
					$curr_args['orderby'] = 'rand';
					break;
				case 'date':
				case 'date ID':
					$curr_args['orderby'] = 'date';
					$curr_args['order']   = 'ASC' === $order ? 'ASC' : 'DESC';
					break;
				case 'price':
					if ( 'DESC' === $order ) {
						add_filter( 'posts_clauses', array( WC()->query, 'order_by_price_desc_post_clauses' ) );
					} else {
						add_filter( 'posts_clauses', array( WC()->query, 'order_by_price_asc_post_clauses' ) );
					}
					break;
				case 'popularity':
					$curr_args['meta_key'] = 'total_sales';
					add_filter( 'posts_clauses', array( WC()->query, 'order_by_popularity_post_clauses' ) );
					break;
				case 'rating':
					$curr_args['orderby']  = array(
						'meta_value_num' => 'DESC',
						'ID'             => 'ASC',
					);
					$curr_args['order']    = 'ASC';
					$curr_args['meta_key'] = '_wc_average_rating';
					break;
				case 'title':
					$curr_args['orderby'] = 'title';
					$curr_args['order']   = 'DESC' === $order ? 'DESC' : 'ASC';
					break;
				case 'menu_order':
				case 'menu_order title':
				case '':
					$curr_args['orderby'] = 'menu_order title';
					$curr_args['order']   = 'DESC' === $order ? 'DESC' : 'ASC';
					break;
				case 'comment_count':
					$curr_args['orderby'] = 'comment_count';
					$curr_args['order']   = 'ASC' === $order ? 'ASC' : 'DESC';
					break;
				default:
					$curr_args['orderby'] = $orderby;
					$curr_args['order']   = 'ASC' === $order ? 'ASC' : 'DESC';
					break;

			}
		}

		if ( ! empty( $pf_activated ) && false === has_filter( 'post_clauses', array( 'WC_Query', 'price_filter_post_clauses' ) ) ) {
			add_filter( 'posts_clauses', 'XforWC_Product_Filters_Frontend::price_filter_post_clauses', 10, 2 );
		}

		if ( ( isset( $pf_activated['sale_products'] ) || false !== isset( $query->query_vars['sale_products'] ) ) ) {
			$curr_args['post__in'] = isset( $curr_args['post__in'] ) ? array_merge( $curr_args['post__in'], wc_get_product_ids_on_sale() ) : wc_get_product_ids_on_sale();
		}

		if ( isset( $pf_activated['products_per_page'] ) && '' !== $pf_activated['products_per_page'] ) {
			$curr_args = array_merge(
				$curr_args,
				array(
					'posts_per_page' => floatval( $pf_activated['products_per_page'] ),
				)
			);
		}

		if ( isset( $pf_activated['s'] ) && '' !== $pf_activated['s'] ) {
			$curr_args = array_merge(
				$curr_args,
				array(
					's' => $pf_activated['s'],
				)
			);
		}

		if ( isset( $pf_activated['vendor'] ) && '' !== $pf_activated['vendor'] ) {
			$curr_args = array_merge(
				$curr_args,
				array(
					'author' => $pf_activated['vendor'],
				)
			);
		}

		if ( isset( $prdctfltr_global['meta_filters'] ) ) {
			$product_metas = self::unconvert_price_filter_limits( apply_filters( 'prdctfltr_meta_query', $prdctfltr_global['meta_filters'] ) );

			if ( ! empty( $product_metas ) ) {
				$curr_args['meta_query']['relation'] = 'AND';
				$curr_args['meta_query'][]           = $product_metas;
				$check_meta                          = isset( $query->query_vars['meta_query'] ) ? $query->query_vars['meta_query'] : array();
				if ( ! empty( $check_meta ) ) {
					foreach ( $check_meta as $mk => $mv ) {
						if ( 'price_filter' === $mk || is_array( $mv ) && 'price_filter' === key( $mv ) ) {
							unset( $check_meta[ $mk ] );
						}
					}
				}
				$curr_args['meta_query'][] = $check_meta;
			}
		}

		if ( ! isset( $pf_activated['instock_products'] ) && isset( $query->query_vars['instock_products'] ) && in_array( $query->query_vars['instock_products'], array( 'in', 'out', 'both' ), true ) ) {
			$pf_activated['instock_products'] = $query->query_vars['instock_products'];
		}

		if ( ( false !== ( ( isset( $pf_activated['instock_products'] ) && '' !== $pf_activated['instock_products'] && ( 'in' === $pf_activated['instock_products'] || 'out' === $pf_activated['instock_products'] ) ) || 'yes' === get_option( 'woocommerce_hide_out_of_stock_items', 'no' ) ) ) && ( ! isset( $pf_activated['instock_products'] ) || 'both' !== $pf_activated['instock_products'] ) ) {

			$cfa = count( $f_attrs );

			if ( $cfa > 0 ) {

				$variable_stock_out = array();
				for ( $i = 1; $i <= $cfa; $i++ ) {
					$variable_stock_out = array_merge( $variable_stock_out, self::get_variable_product_outofstock( $f_attrs, $f_terms, $i ) );
				}

				if ( ! empty( $variable_stock_out ) ) {
					$variable_stock_out_fil = array();

					foreach ( $variable_stock_out as $k => $p ) {
						if ( ! in_array( $p[0], $variable_stock_out_fil, true ) ) {
							$variable_stock_out_fil[] = $p[0];
						}
					}

					self::$settings['variable_outofstock'] = $variable_stock_out_fil;

					if ( isset( $pf_activated['instock_products'] ) && 'out' === $pf_activated['instock_products'] ) {
						add_filter( 'posts_where', array( 'XforWC_Product_Filters_Frontend', 'prdctfltr_add_variable_outofstock' ), 99998 );
					} else {
						$curr_args = array_merge( $curr_args, array( 'post__not_in' => $variable_stock_out_fil ) );
					}
				}
			}
		}

		foreach ( $curr_args as $k => $v ) {
			switch ( $k ) {
				case 'post__in':
					$v       = array_unique( $v );
					$post_in = isset( $query->query_vars[ $k ] ) && ! empty( $query->query_vars[ $k ] ) ? $query->query_vars[ $k ] : array();
					$ins     = ( empty( $post_in ) ? $v : array_intersect( $post_in, $v ) );

					if ( isset( $variable_stock_out_fil ) ) {
						$ins = array_diff( $ins, $variable_stock_out_fil );
					}

					$query->set( $k, $ins );
					break;
				default:
					$query->set( $k, $v );
					break;
			}
		}

	}

	public static function generate_wpdb_prepare_placeholders_from_array( $array ) {
		$placeholders = array_map(
			function ( $item ) {
				return is_string( $item ) ? '%s' : ( is_float( $item ) ? '%f' : ( is_int( $item ) ? '%d' : '' ) );
			},
			$array
		);
		return implode( ',', $placeholders );
	}

	public static function get_variable_product_outofstock( $f_attrs, $f_terms, $int ) {

		global $wpdb;

		$outofstock = get_term_by( 'slug', 'outofstock', 'product_visibility' );

		$attr_placeholder_str = implode( ',', array_fill( 0, count( $f_attrs ), '%s' ) );
		$term_placeholder_str = self::generate_wpdb_prepare_placeholders_from_array( $f_terms );

		$prepared_values = array_merge(
			$f_attrs,
			$f_terms,
			array( $outofstock->term_id ),
			array( $wpdb->esc_like( 'attribute_pa_' ) . '%' ),
			array( $int ),
			array( $int )
		);

		$query = array(
			"
			SELECT DISTINCT p.post_parent AS ID
			FROM {$wpdb->posts} p
			INNER JOIN {$wpdb->postmeta} pm1 ON p.ID = pm1.post_id
			INNER JOIN {$wpdb->term_relationships} tr ON p.ID = tr.object_id
			WHERE p.post_type = 'product_variation'
			AND pm1.meta_key IN ($attr_placeholder_str)
			AND (pm1.meta_value IN ($term_placeholder_str) OR pm1.meta_value = '')
			AND p.ID IN (
				SELECT tr2.object_id
				FROM {$wpdb->term_relationships} tr2
				WHERE tr2.term_taxonomy_id = %d
			)
			AND p.ID IN (
				SELECT pm2.post_id
				FROM {$wpdb->postmeta} pm2
				WHERE pm2.meta_key LIKE %s
				GROUP BY pm2.post_id
				HAVING COUNT(DISTINCT pm2.meta_key) = %d
			)
			GROUP BY pm1.post_id
			HAVING COUNT(DISTINCT pm1.meta_key) = %d
			LIMIT 29999
			",
		);

		$prepare_query = call_user_func_array( array( $wpdb, 'prepare' ), array_merge( $query, $prepared_values ) );

		return $wpdb->get_results( $prepare_query, ARRAY_N ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

	}

	public static function append_product_sorting_table_join( $sql ) {
		global $wpdb;

		if ( ! strstr( $sql, 'wc_product_meta_lookup' ) ) {
			$sql .= " LEFT JOIN {$wpdb->wc_product_meta_lookup} wc_product_meta_lookup ON $wpdb->posts.ID = wc_product_meta_lookup.product_id ";
		}

		return $sql;
	}

	public static function price_filter_post_clauses( $args, $wp_query ) {

		$prices = self::get_prices( $wp_query->query_vars );

		if ( empty( $prices['max_price'] ) && empty( $prices['min_price'] ) ) {
			return $args;
		}

		$current_min_price = isset( $prices['min_price'] ) ? self::unconvert_pice( floatval( wp_unslash( $prices['min_price'] ) ) ) : 0;
		$current_max_price = isset( $prices['max_price'] ) ? self::unconvert_pice( floatval( wp_unslash( $prices['max_price'] ) ) ) : PHP_INT_MAX;

		if ( wc_tax_enabled() && 'incl' === get_option( 'woocommerce_tax_display_shop' ) && ! wc_prices_include_tax() ) {
			$tax_class = apply_filters( 'woocommerce_price_filter_widget_tax_class', '' );
			$tax_rates = WC_Tax::get_rates( $tax_class );

			if ( $tax_rates ) {
				$current_min_price -= WC_Tax::get_tax_total( WC_Tax::calc_inclusive_tax( $current_min_price, $tax_rates ) );
				$current_max_price -= WC_Tax::get_tax_total( WC_Tax::calc_inclusive_tax( $current_max_price, $tax_rates ) );
			}
		}

		global $wpdb;

		$args['join']   = self::append_product_sorting_table_join( $args['join'] );
		$args['where'] .= $wpdb->prepare(
			' AND wc_product_meta_lookup.min_price >= %f AND wc_product_meta_lookup.max_price <= %f ',
			$current_min_price,
			$current_max_price
		);

		return $args;
	}

	public static function get_vars( $query, $that ) {
		if ( $query->is_main_query() ) {

			$ordering_args = array(
				'orderby' => 'menu_order title',
				'order'   => 'ASC',
			);

			$meta_query = WC()->query->get_meta_query();
			$query_args = array(
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'orderby'             => $ordering_args['orderby'],
				'order'               => $ordering_args['order'],
				'meta_query'          => $meta_query,
				'tax_query'           => WC()->query->get_tax_query(),
			);

			self::$settings['shop_query'] = $query_args;
		}
	}

	public static function prdctfltr_wc_tax( $query, $that ) {
		if ( empty( get_option( 'xforwc_key_' . ( function_exists( 'XforWC' ) ? 'xforwoocommerce' : 'product_filter' ) ) ) ) {
			return;
		}

		global $prdctfltr_global;

		$stop      = true;
		$curr_args = array();

		$pf_tax_query = apply_filters( 'prdctfltr_tax_query', ( isset( self::$settings['tax_query'] ) ? self::$settings['tax_query'] : array() ) );

		$pf_activated = isset( $prdctfltr_global['active_taxonomies'] ) ? $prdctfltr_global['active_taxonomies'] : array();

		if ( ! empty( $pf_tax_query ) ) {

			$pf_tax_query['relation'] = 'AND';

			$now = ! empty( $query->tax_query->queries ) ? $query->tax_query->queries : array();

			if ( ! empty( $now ) ) {
				foreach ( $now as $k => $v ) {
					if ( isset( $v['taxonomy'] ) && 'product_visibility' === $v['taxonomy'] && isset( $v['terms'] ) && is_array( $v['terms'] ) && empty( array_intersect( array( 'exclude-from-catalog', 'exclude-from-search', 'outofstock' ), $v['terms'] ) ) ) {
						unset( $now[ $k ] );
					}
				}
				$query->query_vars['tax_query'] = array_unique( array_merge( $pf_tax_query, $now ), SORT_REGULAR );
				$query->tax_query->queries      = $query->query_vars['tax_query'];
			} else {
				$query->query_vars['tax_query'] = array_unique( $pf_tax_query, SORT_REGULAR );
				$query->tax_query->queries      = $query->query_vars['tax_query'];
			}

			if ( wp_doing_ajax() && empty( $query->tax_query->queried_terms ) && ! empty( $pf_activated ) ) {

				$add_terms = array();

				foreach ( $pf_activated as $k => $v ) {
					$add_terms[ $k ] = array(
						'terms' => $v,
						'field' => 'slug',
					);
				}
				$query->is_tax                   = true;
				$query->tax_query->queried_terms = $add_terms;

			}
		}

	}

	public static function prdctfltr_add_variable_outofstock( $where ) {

		if ( ! empty( self::$settings['variable_outofstock'] ) ) {
			global $wpdb;
			$where .= " OR $wpdb->posts.ID IN ('" . implode( "','", array_map( 'esc_sql', self::$settings['variable_outofstock'] ) ) . "') ";
			remove_filter( 'posts_where', 'prdctfltr_add_variable_outofstock' );
		}
		return $where;
	}

	public static function get_prices( $query ) {
		global $prdctfltr_global;

		$pf_activated = $prdctfltr_global['active_filters'];

		$_min_price = null;

		if ( isset( $query['min_price'] ) ) {
			$_min_price = $query['min_price'];
		}
		if ( isset( $pf_activated['rng_min_price'] ) ) {
			$_min_price = $pf_activated['rng_min_price'];
		}
		if ( isset( $pf_activated['min_price'] ) ) {
			$_min_price = $pf_activated['min_price'];
		}

		$_max_price = null;

		if ( isset( $query['max_price'] ) ) {
			$_max_price = $query['max_price'];
		}
		if ( isset( $pf_activated['rng_max_price'] ) ) {
			$_max_price = $pf_activated['rng_max_price'];
		}
		if ( isset( $pf_activated['max_price'] ) ) {
			$_max_price = $pf_activated['max_price'];
		}

		if ( isset( $_min_price ) && ! isset( $_max_price ) ) {
			$_max_price = PHP_INT_MAX;
		}

		if ( isset( $_max_price ) && ! isset( $_min_price ) ) {
			$_min_price = 0;
		}

		if ( isset( $_min_price ) ) {
			$_min_price = floatval( $_min_price ) - apply_filters( 'prdctfltr_min_price_margin', 0.01 );
		}

		if ( isset( $_max_price ) ) {
			$_max_price = floatval( $_max_price ) + apply_filters( 'prdctfltr_max_price_margin', 0.01 );
		}

		return array(
			'min_price' => $_min_price,
			'max_price' => $_max_price,
		);

	}

	function prdctrfltr_add_filter( $template, $slug, $name ) {

		if ( in_array( $slug, array( 'loop/orderby.php', 'loop/result-count.php', 'loop/pagination.php' ), true ) ) {

			$do = false;

			switch ( $slug ) {
				case 'loop/pagination.php':
					global $prdctfltr_global;
					if ( ! isset( $prdctfltr_global['sc_init'] ) && 'default' !== self::$options['install']['ajax']['pagination_type'] && 'yes' === self::$options['install']['ajax']['enable'] && is_woocommerce() ) {
						$do = true;
					}
					break;
				case 'loop/orderby.php':
					if ( isset( self::$options['install']['templates']['orderby'] ) && '_do_not' !== self::$options['install']['templates']['orderby'] ) {
						$do = true;
					}
					break;
				case 'loop/result-count.php':
					if ( isset( self::$options['install']['templates']['result_count'] ) && '_do_not' !== self::$options['install']['templates']['result_count'] ) {
						$do = true;
					}
					break;
				default:
					break;
			}

			if ( $do ) {
				self::$settings['template'] = $slug;
				return self::$path . 'templates/getright.php';
			}
		}

		return $template;

	}

	function prdctfltr_redirect() {

		if ( ! empty( $_REQUEST ) ) {

			if ( is_shop() || is_product_taxonomy() ) {

				$request = array();
				foreach ( $_REQUEST as $k3 => $v3 ) {
					if ( taxonomy_exists( $k3 ) ) {
						if ( strpos( $v3, ' ' ) > -1 ) {
							$v3 = str_replace( ' ', '+', $v3 );
						}
					} elseif ( 's' === $k3 ) {
						$v3 = str_replace( ' ', '%20', $v3 );
					}
					$request[ $k3 ] = $v3;
				}

				global $wp_rewrite;

				$current = $GLOBALS['wp_the_query']->get_queried_object();
				if ( ! isset( $current->taxonomy ) || ! $current->taxonomy ) {
					if ( isset( $request['product_cat'] ) && '' !== $request['product_cat'] ) {
						$current           = new stdClass();
						$current->taxonomy = 'product_cat';
						$current->slug     = $request['product_cat'];
					}
				}

				if ( isset( $current->taxonomy ) ) {

					if ( isset( $request[ $current->taxonomy ] ) ) {

						if ( strpos( $request[ $current->taxonomy ], ',' ) || strpos( $request[ $current->taxonomy ], '+' ) || strpos( $request[ $current->taxonomy ], ' ' ) ) {
							$rewrite = $wp_rewrite->get_extra_permastruct( $current->taxonomy );
							if ( false !== $rewrite ) {
								if ( strpos( $request[ $current->taxonomy ], ',' ) ) {
									$terms = explode( ',', $request[ $current->taxonomy ] );
								} elseif ( strpos( $request[ $current->taxonomy ], '+' ) ) {
									$terms = explode( '+', $request[ $current->taxonomy ] );
								} elseif ( strpos( $request[ $current->taxonomy ], ' ' ) ) {
									$terms = explode( ' ', $request[ $current->taxonomy ] );
								}

								foreach ( $terms as $term ) {
									if ( ! term_exists( $term, $current->taxonomy ) ) {
										continue;
									}
									$checked = get_term_by( 'slug', $term, $current->taxonomy );
									if ( ! empty( $checked ) ) {
										$parents[] = $checked->parent;
									}
								}

								$parent_slug = '';
								if ( isset( $parents ) ) {
									$parents_unique = array_unique( array_filter( $parents ) );
									if ( 1 === count( $parents_unique ) && 0 !== $parents_unique[0] ) {
										$not_found    = false;
										$parent_check = $parents_unique[0];
										while ( false === $not_found ) {
											if ( 0 !== $parent_check ) {
												$checked = get_term_by( 'id', $parent_check, $current->taxonomy );
												if ( ! is_wp_error( $checked ) ) {
													$get_parent  = $checked->slug;
													$parent_slug = $get_parent . '/' . $parent_slug;
													if ( 0 !== $checked->parent ) {
														$parent_check = $checked->parent;
													} else {
														$not_found = true;
													}
												} else {
													$not_found = true;
												}
											} else {
												$not_found = true;
											}
										}
									}
								}

								$redirect = preg_replace( '/\?.*/', '', get_bloginfo( 'url' ) ) . '/' . str_replace( '%' . $current->taxonomy . '%', $parent_slug . $request[ $current->taxonomy ], $rewrite );
							}
						} else {
							$link = get_term_link( $request[ $current->taxonomy ], $current->taxonomy );
							if ( ! is_wp_error( $link ) ) {
								$redirect = preg_replace( '/\?.*/', '', $link );
							}
						}

						if ( isset( $redirect ) ) {

							$redirect = untrailingslashit( $redirect );

							unset( $request[ $current->taxonomy ] );

							if ( ! empty( $request ) ) {

								$req = '';

								foreach ( $request as $k => $v ) {
									if ( '' === $v || in_array( $k, apply_filters( 'prdctfltr_block_request', array( 'woocs_order_emails_is_sending' ) ), true ) ) {
										unset( $request[ $k ] );
										continue;
									}

									$req .= $k . '=' . $v . '&';
								}

								$redirect = $redirect . '/?' . $req;

								if ( '&' === substr( $redirect, -1 ) ) {
									$redirect = substr( $redirect, 0, -1 );
								}

								if ( '?' === substr( $redirect, -1 ) ) {
									$redirect = substr( $redirect, 0, -1 );
								}
							}

							if ( isset( $redirect ) ) {

								wp_safe_redirect( $redirect );
								exit;

							}
						}
					}
				}
			}
		} else {
			$uri   = $_SERVER['REQUEST_URI'];
			$q_pos = strpos( $uri, '?' );
			$r_pos = strlen( $uri ) - 1;

			if ( $q_pos === $r_pos ) {
				wp_safe_redirect( substr( $uri, 0, $q_pos ) );
				exit;
			}
		}

	}

	public static function prdctrfltr_search_array( $array, $attrs ) {
		$results = array();
		$found   = 0;

		foreach ( $array as $subarray ) {
			if ( isset( $subarray['attributes'] ) ) {
				foreach ( $attrs as $k => $v ) {
					if ( in_array( $v, $subarray['attributes'], true ) ) {
						$found++;
					}
				}
			}
			if ( count( $attrs ) === $found ) {
				$results[] = $subarray;
			}

			if ( ! empty( $results ) ) {
				return $results;
			}

			$found = 0;
		}

		return $results;
	}

	public static function prdctfltr_sort_terms_hierarchicaly( array &$cats, array &$into, $parent_id = 0 ) {
		foreach ( $cats as $i => $cat ) {
			if ( $parent_id === $cat->parent ) {
				$into[ $cat->term_id ] = $cat;
				unset( $cats[ $i ] );
			}
		}
		foreach ( $into as $top_cat ) {
			$top_cat->children = array();
			self::prdctfltr_sort_terms_hierarchicaly( $cats, $top_cat->children, $top_cat->term_id );
		}
	}

	public static function tofloat( $num ) {
		$num = '.' === substr( $num, -1 ) ? substr( $num, 0, -1 ) : $num;

		$dot_pos   = strrpos( $num, '.' );
		$comma_pos = strrpos( $num, ',' );
		$sep       = ( ( $dot_pos > $comma_pos ) && $dot_pos ) ? $dot_pos : ( ( ( $comma_pos > $dot_pos ) && $comma_pos ) ? $comma_pos : false );

		if ( ! $sep ) {
			return floatval( preg_replace( '/[^0-9]/', '', $num ) );
		}

		return floatval(
			preg_replace( '/[^0-9]/', '', substr( $num, 0, $sep ) ) . '.' .
			preg_replace( '/[^0-9]/', '', substr( $num, $sep + 1, strlen( $num ) ) )
		);
	}

	public static function prdctfltr_sort_terms_naturally( $terms, $args ) {

		$sort_terms = array();

		foreach ( $terms as $term ) {
			$id                = (string) self::tofloat( $term->name );
			$sort_terms[ $id ] = $term;
		}

		ksort( $sort_terms );

		if ( 'DESC' === strtoupper( $args['order'] ) ) {
			$sort_terms = array_reverse( $sort_terms );
		}

		return $sort_terms;

	}

	public static function prdctfltr_get_filter() {
		if ( ! isset( self::$settings['get_filter'] ) ) {
			self::$settings['get_filter'] = current_filter();
			include self::$dir . 'templates/product-filter.php';
		}
	}

	public static function prdctfltr_get_between( $content, $start, $end ) {
		$r = explode( $start, $content );
		if ( isset( $r[1] ) ) {
			$r = explode( $end, $r[1] );
			return $r[0];
		}
		return '';
	}

	public static function prdctfltr_utf8_decode( $str ) {
		$str = preg_replace( '/%u([0-9a-f]{3,4})/i', "&#x\\1;", urldecode( $str ) );
		return html_entity_decode( $str, ENT_QUOTES | ENT_SUBSTITUTE | ENT_HTML401, 'UTF-8' );
	}

	public static function prdctfltr_wpml_get_id( $id ) {
		if ( function_exists( 'icl_object_id' ) ) {
			return icl_object_id( $id, 'page', true );
		} else {
			return $id;
		}
	}

	public static function prdctfltr_get_styles() {

		global $prdctfltr_global;

		$styles = array(
			( in_array( self::$settings['instance']['style']['style'], array( 'pf_arrow', 'pf_arrow_inline', 'pf_default', 'pf_default_inline', 'pf_select', 'pf_default_select', 'pf_sidebar', 'pf_sidebar_right', 'pf_sidebar_css', 'pf_sidebar_css_right', 'pf_fullscreen' ), true ) ? self::$settings['instance']['style']['style'] : 'pf_default' ),
			( 'no' === self::$settings['instance']['style']['always_visible'] && ! in_array( 'hide_top_bar', self::$settings['instance']['style']['hide_elements'], true ) || in_array( self::$settings['instance']['style']['style'], array( 'pf_sidebar', 'pf_sidebar_right', 'pf_sidebar_css', 'pf_sidebar_css_right', 'pf_fullscreen', 'pf_arrow', 'pf_arrow_inline' ), true ) ? 'prdctfltr_slide' : 'prdctfltr_always_visible' ),
			( 'no' === self::$settings['instance']['general']['instant'] ? 'prdctfltr_click' : 'prdctfltr_click_filter' ),
			( ! in_array( 'hide_top_bar', self::$settings['instance']['style']['hide_elements'], true ) || in_array( self::$settings['instance']['style']['style'], array( 'pf_sidebar', 'pf_sidebar_right', 'pf_sidebar_css', 'pf_sidebar_css_right' ), true ) ? '' : 'prdctfltr_disable_bar' ),
			self::$settings['instance']['style']['checkbox_style'],
			( 1 === 'no' ? '' : 'prdctfltr_search_fields' ),
			self::$settings['instance']['style']['hierarchy_style'],
			( 'yes' === self::$settings['instance']['general']['step_selection'] ? 'prdctfltr_tabbed_selection' : '' ),
			( 'no' !== self::$settings['instance']['adoptive']['enable'] && 'yes' === self::$settings['instance']['adoptive']['reorder_selected'] ? 'prdctfltr_adoptive_reorder' : '' ),
			( 'yes' === self::$settings['instance']['general']['reorder_selected'] ? 'prdctfltr_selected_reorder' : '' ),
			( isset( self::$settings['instance']['style']['content_align'] ) && in_array( self::$settings['instance']['style']['content_align'], array( 'right', 'center' ), true ) ? 'pf_content_' . self::$settings['instance']['style']['content_align'] : '' ),
		);

		if ( isset( self::$options['step_filter'] ) ) {
			$styles[] = 'prdctfltr_step_filter';
		}

		if ( in_array( 'hide_reset_button', self::$settings['instance']['style']['hide_elements'], true ) ) {
			$styles[] = 'pf_remove_clearall';
		}

		if ( in_array( self::$settings['instance']['style']['style'], array( 'pf_arrow', 'pf_arrow_inline', 'pf_sidebar', 'pf_sidebar_right', 'pf_sidebar_css', 'pf_sidebar_css_right', 'pf_fullscreen' ), true ) ) {
			self::$settings['instance']['style']['always_visible'] = 'no';

			$key = array_search( 'hide_top_bar', self::$settings['instance']['style']['hide_elements'], true );
			if ( false !== $key ) {
				unset( self::$settings['instance']['style']['hide_elements'][ $key ] );
			}
		}

		if ( isset( $prdctfltr_global['mobile'] ) ) {
			$styles[] = 'prdctfltr_mobile';
		}

		if ( in_array( self::$settings['instance']['responsive']['behaviour'], array( 'show', 'hide' ), true ) ) {
			$styles[] = 'prdctfltr_mobile_' . self::$settings['instance']['responsive']['behaviour'];
		}

		$styles[] = self::$settings['instance']['style']['mode'];
		if ( 'pf_mod_masonry' === self::$settings['instance']['style']['mode'] ) {
			self::$options['scripts']['isotope'] = true;
		}

		if ( 'yes' === self::$settings['instance']['style']['js_scroll'] ) {
			$styles[] = 'prdctfltr_scroll_default';
			$styles[] = 'prdctfltr_custom_scroll';
		} else {
			$styles[] = 'prdctfltr_scroll_default';
		}

		return $styles;

	}

	public static function _search_array( $array, $field, $value ) {
		foreach ( $array as $key => $object ) {
			if ( intval( $object[ $field ] ) === $value ) {
				return $key;
			}
		}

		return false;
	}

	public static function prdctfltr_get_settings() {

		global $prdctfltr_global;

		$preset = 'default';

		$pf_activated = isset( $prdctfltr_global['active_filters'] ) && is_array( $prdctfltr_global['active_filters'] ) ? $prdctfltr_global['active_filters'] : array();

		if ( isset( $prdctfltr_global['active_permalinks'] ) && is_array( $prdctfltr_global['active_permalinks'] ) ) {
			$pf_activated = array_merge( $prdctfltr_global['active_permalinks'], $pf_activated );
		}

		if ( ! empty( self::$opt ) ) {
			$preset = self::$opt;
		}

		if ( isset( $prdctfltr_global['preset'] ) && '' !== $prdctfltr_global['preset'] ) {
			$preset = $prdctfltr_global['preset'];
		}

		if ( ! isset( $prdctfltr_global['mobile'] ) ) {
			if ( ! isset( $prdctfltr_global['disable_overrides'] ) || ( isset( $prdctfltr_global['disable_overrides'] ) && 'yes' !== $prdctfltr_global['disable_overrides'] ) ) {

				if ( empty( self::$options['manager'] ) && class_exists( 'XforWC_Product_Filters_Compatible_Settings' ) ) {
					self::$options['manager'] = XforWC_Product_Filters_Compatible_Settings::_fix_overrides();
				}

				if ( ! empty( self::$options['manager'] ) ) {

					$manager_support = self::$options['general']['supported_overrides'];

					foreach ( $manager_support as $taxonomy ) {
						if ( isset( self::$options['manager'][ $taxonomy ] ) ) {

							$term = isset( $pf_activated[ $taxonomy ][0] ) && term_exists( $pf_activated[ $taxonomy ][0], $taxonomy ) ? get_term_by( 'slug', $pf_activated[ $taxonomy ][0], $taxonomy ) : '';

							if ( ! empty( $term ) ) {
								$check_wpml = self::get_true_object_id( $term->term_id );

								if ( $check_wpml !== $term->term_id ) {
									$term = get_term_by( 'id', $check_wpml, $taxonomy );
								}
							}

							if ( ! empty( $term ) ) {

								$key = self::_search_array( self::$options['manager'][ $taxonomy ], 'term', $term->term_id );

								if ( false === $key && 0 !== $term->parent && is_taxonomy_hierarchical( $taxonomy ) ) {

									$parents = get_ancestors( $term->term_id, $taxonomy );

									foreach ( $parents as $parent_id ) {

										$parent = get_term_by( 'id', $parent_id, $taxonomy );

										$key = self::_search_array( self::$options['manager'][ $taxonomy ], 'term', $parent_id );

										if ( false !== $key ) {
											$preset = self::$options['manager'][ $taxonomy ][ $key ]['preset'];
										}

										if ( array_key_exists( $parent->slug, self::$options['manager'][ $taxonomy ] ) ) {
											$preset = self::$options['manager'][ $taxonomy ][ $parent->slug ];
											break;
										}
									}
								}

								if ( false !== $key ) {
									$preset = self::$options['manager'][ $taxonomy ][ $key ]['preset'];
									break;
								}
							}
						}
					}
				}
			}
		}

		$preset = sanitize_title( $preset );

		if ( isset( $preset ) && '' !== $preset ) {
			$prdctfltr_global['preset'] = $preset;
		}

		$option = Prdctfltr()->get_preset( $preset );

		self::$settings['instance'] = isset( self::$settings['instance'] ) && is_array( self::$settings['instance'] ) ? array_merge( self::$settings['instance'], $option ) : $option;

	}

	public static function fix_up_preset() {

		if ( empty( self::$settings['instance']['style']['hide_elements'] ) ) {
			self::$settings['instance']['style']['hide_elements'] = array();
		}

		if ( empty( self::$settings['instance']['general']['collectors'] ) || 'false' === self::$settings['instance']['general']['collectors'] ) {
			self::$settings['instance']['general']['collectors'] = array();
		}

		if ( isset( self::$settings['widget'] ) && 'pf_select' === self::$settings['instance']['style']['style'] ) {
			self::$settings['instance']['style']['style'] = 'pf_default_select';
		}

		/*if ( ! isset( self::$settings['widget'] ) ) {
			if ( isset( self::$settings['instance']['style']['mode'] ) ) {
				if ( in_array( self::$settings['instance']['style']['style'], array( 'pf_sidebar', 'pf_sidebar_right', 'pf_sidebar_css', 'pf_sidebar_css_right' ), true ) ) {
					self::$settings['instance']['style']['mode'] = 'pf_mod_multirow';
				}
			} else {
				self::$settings['instance']['style']['mode'] = 'pf_mod_multirow';
			}
		} else {
			if ( in_array( self::$settings['widget']['style'], array( 'pf_default', 'pf_default_inline', 'pf_default_select' ), true ) ) {
				self::$settings['instance']['style']['style'] = self::$settings['widget']['style'];
			}
			if ( 'pf_select' === self::$settings['instance']['style']['style'] ) {
				self::$settings['instance']['style']['style'] = 'pf_default_select';
			}

			//self::$settings['instance']['style']['mode'] = 'pf_mod_multirow';
		}*/
	}

	public static function check_preset_buttons() {

		if ( 'none' !== self::$settings['instance']['style']['loading_animation'] && 'css-' !== substr( self::$settings['instance']['style']['loading_animation'], 0, 4 ) ) {
			self::$settings['instance']['style']['loading_animation'] = 'css-spinner-full';
		}

		if ( 'top' === self::$settings['instance']['style']['button_position'] ) {
			add_action( 'prdctfltr_filter_form_before', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons', 10 );
			remove_action( 'prdctfltr_filter_form_after', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons' );
		} elseif ( 'both' === self::$settings['instance']['style']['button_position'] ) {
			add_action( 'prdctfltr_filter_form_after', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons', 10 );
			add_action( 'prdctfltr_filter_form_before', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons', 10 );
		} else {
			add_action( 'prdctfltr_filter_form_after', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons', 10 );
			remove_action( 'prdctfltr_filter_form_before', 'XforWC_Product_Filters_Frontend::prdctfltr_filter_buttons' );
		}

	}

	public static function prdctfltr_get_terms( $taxonomy, $args ) {

		if ( ! taxonomy_exists( $taxonomy ) ) {
			return array();
		}

		$args['hide_empty'] = 'yes' === self::$options['general']['hide_empty'] ? 1 : 0;

		$orderby = isset( $args['orderby'] ) ? $args['orderby'] : wc_attribute_orderby( $taxonomy );

		$get_terms_args = array();

		switch ( $orderby ) {
			case 'name':
				$get_terms_args['orderby']    = 'name';
				$get_terms_args['menu_order'] = false;
				break;
			case 'id':
				$get_terms_args['orderby']    = 'id';
				$get_terms_args['order']      = 'ASC';
				$get_terms_args['menu_order'] = false;
				break;
			case '':
			case 'menu_order':
				unset( $args['orderby'] );
				unset( $args['order'] );
				$get_terms_args['menu_order'] = 'ASC';
				break;
		}

		$args             = array_merge( $args, $get_terms_args );
		$args['taxonomy'] = $taxonomy;

		if ( ! empty( self::$filter['include']['selected'] ) && 'false' !== self::$filter['include']['selected'] ) {
			$relation = isset( self::$filter['include']['relation'] ) && 'OUT' === self::$filter['include']['relation'] ? 'OUT' : 'IN';
			if ( 'IN' === $relation ) {
				$args['include'] = self::$filter['include']['selected'];
			} else {
				$args['exclude'] = self::$filter['include']['selected'];
			}
		}

		if ( 'product_cat' === $taxonomy ) {
			if ( ! isset( $args['exclude'] ) ) {
				$args['exclude'] = array();
			}
			$args['exclude'][] = get_option( 'default_product_cat' );
		}

		$key = self::build_cache_key( $args );

		if ( isset( self::$options['cache'][ $key ] ) ) {
			return self::$options['cache'][ $key ];
		}

		$terms = get_terms( apply_filters( 'prdctfltr_get_terms_args', $args ) );

		self::$options['cache'][ $key ] = $terms;

		return $terms;

	}

	public static function fix_custom_terms( $terms ) {
		$return = array();

		if ( ! is_array( $terms ) ) {
			return $return;
		}

		foreach ( $terms as $k => $v ) {

			$key = self::find_customized_term( $v->term_id, self::$filter['style']['terms'] );
			if ( false !== $key && ! empty( self::$filter['style']['terms'][ $key ] ) ) {
				$return[ $key ] = $v;
			} else {
				$return[] = $v;
			}
		}

		ksort( $return, SORT_REGULAR );

		return $return;
	}

	public static function prdctfltr_in_array( $needle, $haystack ) {
		return in_array( strtolower( $needle ), array_map( 'strtolower', $haystack ), true );
	}

	public static function prdctfltr_filter_buttons() {

		global $prdctfltr_global;

		$pf_activated = ( isset( $prdctfltr_global['active_in_filter'] ) ? $prdctfltr_global['active_in_filter'] : array() );

		?>
			<div class="prdctfltr_buttons">
		<?php
		if ( 'no' === self::$settings['instance']['general']['instant'] ) {
			?>
				<a class="button prdctfltr_woocommerce_filter_submit" href="#">
			<?php
			if ( '' !== self::$settings['instance']['style']['filter_button'] ) {
				echo esc_html( self::$settings['instance']['style']['filter_button'] );
			} else {
				esc_html_e( 'Filter selected', '^xwc' );
			}
			?>
				</a>
			<?php
		}
		if ( ! in_array( 'hide_sale_button', self::$settings['instance']['style']['hide_elements'], true ) ) {
			?>
				<span class="prdctfltr_sale">
			<?php
			printf(
				'<label%2$s><input name="sale_products" type="checkbox"%3$s/><span>%1$s</span></label>',
				'' !== self::$settings['instance']['style']['_tx_sale'] ? esc_html( self::$settings['instance']['style']['_tx_sale'] ) : esc_html__( 'Show only products on sale', '^xwc' ),
				isset( $pf_activated['sale_products'] ) ? ' class="prdctfltr_active"' : '',
				isset( $pf_activated['sale_products'] ) ? ' checked' : ''
			);
			?>
				</span>
			<?php
		}
		if ( ! in_array( 'hide_instock_button', self::$settings['instance']['style']['hide_elements'], true ) && ! in_array( 'instock', self::$settings['active'], true ) ) {
			?>
				<span class="prdctfltr_instock">
			<?php
			if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items', 'no' ) ) {
				printf(
					'<label%2$s><input name="instock_products" type="checkbox" value="both"%3$s/><span>%1$s</span></label>',
					esc_html__( 'Show out of stock products', '^xwc' ),
					isset( $pf_activated['instock_products'] ) ? ' class="prdctfltr_active"' : '',
					isset( $pf_activated['instock_products'] ) ? ' checked' : ''
				);
			} else {
				printf(
					'<label%2$s><input name="instock_products" type="checkbox" value="in"%3$s/><span>%1$s</span></label>',
					'' !== self::$settings['instance']['style']['_tx_instock'] ? esc_html( self::$settings['instance']['style']['_tx_instock'] ) : esc_html__( 'In stock only', '^xwc' ),
					isset( $pf_activated['instock_products'] ) ? ' class="prdctfltr_active"' : '',
					isset( $pf_activated['instock_products'] ) ? ' checked' : ''
				);
			}
			?>
				</span>
			<?php
		}
		?>
			</div>
		<?php

	}

	public static function find_customized_term( $id, $terms ) {
		$id = self::get_true_object_id( $id );

		foreach ( $terms as $key => $term ) {
			if ( isset( $term['id'] ) && intval( $term['id'] ) === $id ) {
				return $key;
			}
			if ( isset( $term['value'] ) && $term['value'] === $id ) {
				return $key;
			}
		}

		return false;
	}

	public static function get_true_object_id( $id ) {
		if ( self::$settings['wpml'] ) {
			$id = icl_object_id( $id, self::$filter['taxonomy'], true, self::$settings['wpml']['default'] );
		}

		return $id;
	}

	public static function get_customized_term_none( $style ) {
		switch ( $style ) {
			case 'color':
				return 'transparent';
			break;
			case 'image':
				return self::$url_path . '/includes/images/pf-transparent.gif';
			break;
			default:
				return self::get_none_string();
			break;
		}
		return '';
	}

	public static function get_customized_term_700( $term_id, $term_slug, $term_name, $cnt, $checked = '', $sublevel = '' ) {

		if ( ! empty( $term_id ) ) {
			$data = array(
				'tooltip' => '',
				'data'    => '',
			);

			if ( ! empty( self::$filter['style']['terms'] ) ) {

				$key = self::find_customized_term( $term_id, self::$filter['style']['terms'] );

				if ( false !== $key ) {
					$data = array_merge(
						array(
							'tooltip' => '',
							'data'    => '',
						),
						self::$filter['style']['terms'][ $key ]
					);
				}
			}
		} else {
			$data = array(
				'value'   => '',
				'title'   => self::get_none_string(),
				'tooltip' => self::get_none_tooltip_string(),
				'data'    => self::get_customized_term_none( self::$filter['style']['style']['type'] ),
			);
		}

		if ( ! empty( $data['title'] ) ) {
			$term_name = $data['title'];
		}

		$tip = empty( $data['tooltip'] ) ? false : $data['tooltip'];

		switch ( self::$filter['style']['style']['type'] ) {

			case 'text':
				return '<span class="prdctfltr_customize_' . esc_attr( self::$filter['style']['style']['css'] ) . ' prdctfltr_customize"><span class="prdctfltr_customize_name">' . esc_html( $term_name ) . '</span>' . ( false !== $cnt ? ' <span class="prdctfltr_customize_count">' . $cnt . '</span>' : '' ) . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' ) . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . wp_kses_post( $sublevel ) . '</span>';
			break;

			case 'color':
				$size = ! empty( self::$filter['style']['size'] ) ? self::$filter['style']['size'] : 42;

				if ( ! empty( self::$filter['style']['label'] ) && 'side' === self::$filter['style']['label'] ) {
					return '<span class="prdctfltr_customize_block prdctfltr_customize" style="line-height:' . absint( $size ) . 'px;"><span class="prdctfltr_customize_color_text"><span style="background-color:' . SevenVXGet()->esc_color( $data['data'] ) . ';width:' . absint( $size ) . 'px;height:' . absint( $size ) . 'px;"></span></span>' . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' ) . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . '<span class="prdctfltr_customization_search">' . esc_html( $term_name ) . '</span><span class="prdctfltr_customize_color_text_tip">' . esc_html( $term_name ) . '</span>' . ( false !== $cnt ? ' <span class="prdctfltr_count">' . $cnt . '</span>' : '' ) . wp_kses_post( $sublevel ) . '</span>';
				} else {
					return '<span class="prdctfltr_customize_block prdctfltr_customize"><span class="prdctfltr_customize_color" style="background-color:' . SevenVXGet()->esc_color( $data['data'] ) . ';width:' . absint( $size ) . 'px;height:' . absint( $size ) . 'px;"></span>' . ( false !== $cnt ? ' <span class="prdctfltr_customize_count">' . $cnt . '</span>' : '' ) . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' ) . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . '<span class="prdctfltr_customization_search">' . esc_html( $term_name ) . '</span>' . wp_kses_post( $sublevel ) . '</span>';
				}
				break;

			case 'image':
				$size = ! empty( self::$filter['style']['size'] ) ? self::$filter['style']['size'] : 42;

				if ( ! empty( self::$filter['style']['label'] ) && 'side' === self::$filter['style']['label'] ) {
					return '<span class="prdctfltr_customize_block prdctfltr_customize" style="line-height:' . absint( $size ) . 'px;"><span class="prdctfltr_customize_image_text"><img src="' . ( empty( $data['data'] ) ? self::$url_path . '/includes/images/pf-placeholder.gif' : esc_url( $data['data'] ) ) . '" style="height: ' . absint( $size ) . 'px" /></span>' . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' ) . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . '<span class="prdctfltr_customization_search">' . esc_html( $term_name ) . '</span><span class="prdctfltr_customize_image_text_tip">' . esc_html( $term_name ) . '</span>' . ( false !== $cnt ? ' <span class="prdctfltr_count">' . $cnt . '</span>' : '' ) . wp_kses_post( $sublevel ) . '</span>';
				} else {
					return '<span class="prdctfltr_customize_block prdctfltr_customize"><span class="prdctfltr_customize_image"><img src="' . ( empty( $data['data'] ) ? self::$url_path . '/includes/images/pf-placeholder.gif' : esc_url( $data['data'] ) ) . '"  style="height: ' . absint( $size ) . 'px" /></span>' . ( false !== $cnt ? ' <span class="prdctfltr_customize_count">' . $cnt . '</span>' : '' ) . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' ) . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . '<span class="prdctfltr_customization_search">' . esc_html( $term_name ) . '</span>' . wp_kses_post( $sublevel ) . '</span>';
				}
				break;

			case 'select':
				return '<span class="prdctfltr_customize_select prdctfltr_customize">' . ( '' !== $checked ? '<input type="checkbox" value="' . esc_attr( $term_slug ) . '"' . esc_html( $checked ) . '/>' : '' ) . '<span class="prdctfltr_customize_name">' . esc_html( $term_name ) . '</span>' . ( false !== $cnt ? ' <span class="prdctfltr_customize_count">' . $cnt . '</span>' : '' ) . wp_kses_post( $sublevel ) . '</span>' . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span></span>' : '' );
			break;

			case 'html':
				if ( ! empty( $data['data'] ) ) {
					return wp_kses_post( stripslashes( $data['data'] ) ) . '<span class="prdctfltr_customization_search">' . esc_html( $term_name ) . '</span>' . ( false !== $tip ? '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $tip ) . '</span>' . wp_kses_post( $sublevel ) . '</span>' : '' );
				} else {
					return esc_html( $term_name );
				}
				break;

			default:
				return '';
			break;
		}

	}

	public static function add_customized_terms_css() {

		if ( empty( self::$filter['style']['style']['css'] ) ) {
			return false;
		}

		self::$filter['style']['key'] = isset( self::$filter['style']['key'] ) ? self::$filter['style']['key'] : 'pf_style_' . uniqid();

		if ( 'border' === self::$filter['style']['style']['css'] ) {
			$css_entry = sprintf( '%1$s .prdctfltr_customize {border-color:%2$s;color:%2$s;}%1$s label.prdctfltr_active .prdctfltr_customize {border-color:%3$s;color:%3$s;}%1$s label.pf_adoptive_hide .prdctfltr_customize {border-color:%4$s;color:%4$s;}', '.' . esc_attr( self::$filter['style']['key'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['normal'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['active'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['disabled'] ) );
		} elseif ( 'background' === self::$filter['style']['style']['css'] ) {
			$css_entry = sprintf( '%1$s .prdctfltr_customize {background-color:%2$s;}%1$s label.prdctfltr_active .prdctfltr_customize {background-color:%3$s;}%1$s label.pf_adoptive_hide .prdctfltr_customize {background-color:%4$s;}', '.' . esc_attr( self::$filter['style']['key'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['normal'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['active'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['disabled'] ) );
		} elseif ( 'round' === self::$filter['style']['style']['css'] ) {
			$css_entry = sprintf( '%1$s .prdctfltr_customize {background-color:%2$s;border-radius:50%%;}%1$s label.prdctfltr_active .prdctfltr_customize {background-color:%3$s;}%1$s label.pf_adoptive_hide .prdctfltr_customize {background-color:%4$s;}', '.' . esc_attr( self::$filter['style']['key'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['normal'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['active'] ), SevenVXGet()->esc_color( self::$filter['style']['style']['disabled'] ) );
		} else {
			$css_entry = '';
		}

		if ( ! isset( self::$options['css'] ) ) {
			self::$options['css'] = $css_entry;
		} else {
			self::$options['css'] .= $css_entry;
		}

	}

	public static function prdctfltr_add_css() {
		if ( isset( self::$options['css'] ) ) {
			?>
				<style type="text/css">
				<?php echo self::$options['css']; ?>
				</style>
			<?php
		}
	}

	function prdctfltr_analytics() {

		check_ajax_referer( 'prdctfltr_analytics', 'pf_nonce' );

		$data = isset( $_POST['filters'] ) ? $_POST['filters'] : '';

		if ( empty( $data ) ) {
			wp_die( 1 );
			exit;
		}

		if ( isset( $data['min_price'] ) && isset( $data['max_price'] ) ) {
			$data['price'] = $data['min_price'] . ' - ' . $data['max_price'];
			unset( $data['max_price'] );
		}

		$stats = get_option( '_prdctfltr_analytics', array() );

		foreach ( $data as $k => $v ) {
			if ( strpos( $v, ',' ) ) {
				$selected = explode( ',', $v );
			} elseif ( strpos( $v, '+' ) ) {
				$selected = explode( '+', $v );
			} else {
				$selected = array( $v );
			}

			foreach ( $selected as $k2 => $v2 ) {
				if ( isset( $stats[ $k ] ) ) {
					if ( isset( $stats[ $k ][ $v2 ] ) ) {
						$stats[ $k ][ $v2 ] = intval( $stats[ $k ][ $v2 ] ) + 1;
					} else {
						$stats[ $k ][ $v2 ] = 1;
					}
				} else {
					$stats[ $k ][ $v2 ] = 1;
				}
			}
		}

		update_option( '_prdctfltr_analytics', $stats );

		wp_die( 1 );
		exit;
	}

	public static function get_term_count_800( $term ) {
		if ( empty( self::$settings['adoptive'] ) ) {
			return '<span class="pf-recount">' . self::_get_term_count( $term ) . '</span>';
		}

		if ( isset( self::$settings['instance']['adoptive']['term_counts'] ) ) {
			switch ( self::$settings['instance']['adoptive']['term_counts'] ) {
				case 'default':
					$of  = self::_get_term_count( $term );
					$has = isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ][ $term->slug ] ) ? self::$settings['adoptive'][ self::$filter['taxonomy'] ][ $term->slug ] : 0;

					return $has < $of ? '<span class="pf-recount">' . $has . '</span>' . apply_filters( 'prdctfltr_count_separator', '/' ) . $of : '<span class="pf-recount">' . $of . '</span>';
				break;
				case 'total':
					$of = self::_get_term_count( $term );

					return '<span class="pf-recount">' . $of . '</span>';
				break;
				case 'count':
				default:
					$has = isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ][ $term->slug ] ) ? self::$settings['adoptive'][ self::$filter['taxonomy'] ][ $term->slug ] : 0;

					return '<span class="pf-recount">' . $has . '</span>';
				break;
			}
		}
	}

	public static function nice_number( $n ) {
		$n = ( 0 + str_replace( ',', '', $n ) );

		if ( ! is_numeric( $n ) ) {
			return false;
		}

		if ( $n > 1000000000000 ) {
			return round( ( $n / 1000000000000 ), 1 ) . ' ' . esc_html__( 'trillion', '^xwc' );
		} elseif ( $n > 1000000000 ) {
			return round( ( $n / 1000000000 ), 1 ) . ' ' . esc_html__( 'billion', '^xwc' );
		} elseif ( $n > 1000000 ) {
			return round( ( $n / 1000000 ), 1 ) . ' ' . esc_html__( 'million', '^xwc' );
		} elseif ( $n > 1000 ) {
			return round( ( $n / 1000 ), 1 ) . ' ' . esc_html__( 'thousand', '^xwc' );
		}

		return number_format( $n );
	}

	public static function tofloatprice( $num ) {
		$num      = '.' === substr( $num, -1 ) ? substr( $num, 0, -1 ) : $num;
		$num_deci = intval( apply_filters( 'wc_get_price_decimals', get_option( 'woocommerce_price_num_decimals', 2 ) ) );

		if ( 0 === $num_deci ) {
			return floatval( preg_replace( '/[^0-9]/', '', $num ) );
		}

		return floatval(
			preg_replace( '/[^0-9]/', '', substr( $num, 0, -$num_deci ) ) . '.' .
			preg_replace( '/[^0-9]/', '', substr( $num, -$num_deci + 1 ) )
		);
	}


	public static function price_to_float( $pt_string ) {

		$pt_string = str_replace( get_woocommerce_currency_symbol(), '', $pt_string );

		$pt_string = str_replace( '&nbsp;', '', $pt_string );

		return self::tofloatprice( $pt_string );

	}

	public static function get_filtered_price() {

		global $prdctfltr_global;

		$tax_query = isset( $prdctfltr_global['tax_query'] ) ? $prdctfltr_global['tax_query'] : array();

		if ( empty( $tax_query ) ) {
			global $wp_query;
			$tax_query = isset( $wp_query->query_vars['tax_query'] ) && ! empty( $wp_query->query_vars['tax_query'] ) ? $wp_query->query_vars['tax_query'] : array();
		}

		global $wpdb;

		$tax_query     = new WP_Tax_Query( $tax_query );
		$tax_query_sql = $tax_query->get_sql( $wpdb->posts, 'ID' );

		$sql = "
			SELECT min( min_price ) as min_price, MAX( max_price ) as max_price
			FROM {$wpdb->wc_product_meta_lookup}
			WHERE product_id IN (
				SELECT ID FROM {$wpdb->posts}
				" . $tax_query_sql['join'] . "
				WHERE {$wpdb->posts}.post_type IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_post_type', array( 'product' ) ) ) ) . "')
				AND {$wpdb->posts}.post_status = 'publish'
				" . $tax_query_sql['where'] . '
			)';

		$prices = $wpdb->get_row( $sql, ARRAY_A ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

		return $prices;

	}

	function add_body_class( $classes ) {
		if ( is_shop() || is_product_taxonomy() ) {
			if ( 'yes' === self::$options['install']['ajax']['enable'] ) {
				$classes[] = 'prdctfltr-ajax';
			}
			$classes[] = 'prdctfltr-shop';
		}

		return $classes;
	}

	function debug() {
		global $prdctfltr_global;
		?>
			<div class="prdctfltr_debug"><?php var_dump( $prdctfltr_global ); ?></div>
		<?php
	}

	public static function return_true() {
		return true;
	}

	function return_false() {
		return false;
	}

	public static function get_catalog_ordering_args() {

		$orderby_value = apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );

		return $orderby_value;

	}

	public static function build_term_cache_key( $term ) {
		return '_' . $term->term_id . '_' . self::$filter['filter'];
	}

	public static function _get_term_count( $term ) {

		if ( isset( self::$filter['terms_recount'] ) ) {
			$key = self::build_term_cache_key( $term );

			if ( isset( self::$options['cache'][ $key ] ) ) {
				return self::$options['cache'][ $key ];
			}

			global $wpdb;

			$pf_childs = get_term_children( $term->term_id, self::$filter['taxonomy'] );

			if ( empty( $pf_childs ) ) {
				$get             = array(
					"
					SELECT SUM({$wpdb->term_taxonomy}.count) as count FROM {$wpdb->term_taxonomy}
					WHERE {$wpdb->term_taxonomy}.term_id = %d OR {$wpdb->term_taxonomy}.parent = %d
				",
				);
				$prepared_values = array( $term->term_id, $term->term_id );
			} else {
				$get             = array(
					"
					SELECT SUM({$wpdb->term_taxonomy}.count) as count FROM {$wpdb->term_taxonomy}
					WHERE {$wpdb->term_taxonomy}.term_id = %d OR {$wpdb->term_taxonomy}.parent IN (" . self::generate_wpdb_prepare_placeholders_from_array( $pf_childs ) . ')
				',
				);
				$prepared_values = array_merge( array( $term->term_id ), $pf_childs );
			}

			$prepare_query = call_user_func_array( array( $wpdb, 'prepare' ), array_merge( $get, $prepared_values ) );

			$term_count = $wpdb->get_var( $prepare_query ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

			self::$options['cache'][ $key ] = $term_count;

			return ! empty( $term_count ) ? $term_count : $term->count;
		} else {
			return $term->count;
		}

	}

	public static function _hierarchy_parent_check() {
		if ( isset( self::$filter['style']['style'] ) ) {
			if ( isset( self::$filter['style']['style']['type'] ) && 'system' === self::$filter['style']['style']['type'] || isset( self::$filter['style']['style']['type'] ) && 'selectize' === self::$filter['style']['style']['type'] ) {
				return false;
			}
		}

		return true;
	}

	public static function get_taxonomy_terms( $terms, $parent = false ) {

		foreach ( $terms as $term ) {
			if ( ! empty( self::$filter['style']['style']['type'] ) && ! in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ) {

				if ( 'no' === self::$filter['term_count'] ) {
					$term_count = false;
				} else {
					if ( self::_check_adoptive() ) {
						$term_count = self::get_term_count_800( $term );
					} else {
						$term_count = '<span class="pf-recount">' . self::_get_term_count( $term ) . '</span>';
					}
				}

				$sublevel = ( 'yes' === self::$filter['hierarchy'] && ! empty( $term->children ) ? '<i class="prdctfltr-plus"></i>' : '' );
				$insert   = self::get_customized_term_700( $term->term_id, $term->slug, $term->name, $term_count, '', $sublevel );

			} else {

				if ( 'no' === self::$filter['term_count'] ) {
					$term_count = '';
				} else {
					if ( self::_check_adoptive() ) {
						$term_count = ' <span class="prdctfltr_count">' . self::get_term_count_800( $term ) . '</span>';
					} else {
						$term_count = ' <span class="prdctfltr_count"><span class="pf-recount">' . self::_get_term_count( $term ) . '</span></span>';
					}
				}

				$title = $term->name;
				$tip   = '';

				if ( ! empty( self::$filter['style']['terms'] ) ) {

					$key = self::find_customized_term( $term->term_id, self::$filter['style']['terms'] );

					if ( false !== $key && ! empty( self::$filter['style']['terms'][ $key ] ) ) {
						if ( ! empty( self::$filter['style']['terms'][ $key ]['title'] ) ) {
							$title = self::$filter['style']['terms'][ $key ]['title'];
						}
						if ( ! empty( self::$filter['style']['terms'][ $key ]['tooltip'] ) ) {
							$tip = empty( self::$filter['style']['terms'][ $key ]['tooltip'] ) ? false : '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( self::$filter['style']['terms'][ $key ]['tooltip'] ) . '</span></span>';
						}
					}
				}

				$insert = '<span>' . esc_html( $title ) . $term_count . $tip . ( self::_hierarchy_parent_check() && ! empty( $term->children ) ? '<i class="prdctfltr-plus"></i>' : '' ) . '</span>';

			}

			$pf_adoptive_class = '';

			if ( self::_check_adoptive() && ! empty( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) && ! array_key_exists( $term->slug, self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) ) {
				$pf_adoptive_class = ' pf_adoptive_hide';
			}

			if ( false === $parent && ! empty( $term->parent ) ) {
				$term_parent = get_term_by( 'id', intval( $term->parent ), self::$filter['taxonomy'] );

				if ( ! empty( $term_parent ) ) {
					$parent = $term_parent->slug;
				}
			}

			$in_array         = in_array( $term->slug, self::$filter['selected'], true );
			$hierarchy_parent = self::_hierarchy_parent_check();

			printf( '<label class="%6$s%4$s%7$s%8$s%10$s"><input type="checkbox" value="%1$s"%3$s%9$s />%2$s%5$s</label>', esc_attr( $term->slug ), wp_kses_post( $insert ), ( $in_array ? ' checked' : '' ), ( $in_array ? ' prdctfltr_active' : '' ), '', esc_attr( $pf_adoptive_class ), ( ! empty( $term->children ) && $in_array ? ' prdctfltr_clicked' : '' ), ' prdctfltr_ft_' . esc_attr( sanitize_title( $term->slug ) ), ( $hierarchy_parent && false !== $parent ? ' data-parent="' . esc_attr( $parent ) . '"' : '' ), ( $hierarchy_parent && ! empty( $term->children ) ? ' pfw--has-childeren' : '' ) );

			if ( 'yes' === self::$filter['hierarchy'] && ! empty( $term->children ) ) {

				printf( '<div class="prdctfltr_sub"%1$s>', $hierarchy_parent ? ' data-sub="' . esc_attr( $term->slug ) . '"' : '' );

				self::get_taxonomy_terms( $term->children, $term->slug );

				printf( '</div>' );

			}
		}

	}

	function wcml_currency( $actions ) {
		$actions[] = 'prdctfltr_respond_550';

		return $actions;
	}

	public static function get_dynamic_filter_title_700() {

		if ( self::check_for_hidden( 'title' ) ) {
			return false;
		}

		$title_class = isset( self::$settings['widget'] ) && isset( self::$settings['widget']['use_widget_titles'] ) && 'yes' === self::$settings['widget']['use_widget_titles'] ? 'prdctfltr_widget_title' : 'prdctfltr_regular_title';

		$args = apply_filters(
			'prdctfltr_filter_title_args',
			array(
				'filter' => 'rng_' . self::$filter['taxonomy'],
				'title'  => self::$filter['title'],
				'before' => '<span class="' . esc_attr( $title_class ) . '">',
				'after'  => '</span>',
			)
		);

		echo wp_kses_post( $args['before'] );

		if ( '' !== self::$filter['title'] ) {
			echo esc_html( self::$filter['title'] );
		} else {
			if ( 'price' !== self::$filter['taxonomy'] && taxonomy_exists( self::$filter['taxonomy'] ) ) {
				$taxonomy = get_taxonomy( self::$filter['taxonomy'] );
				echo esc_html( $taxonomy->labels->name );
			} else {
				esc_html_e( 'Price', '^xwc' );
			}
		}
		?>
			<i class="prdctfltr-down"></i>
		<?php

		echo wp_kses_post( $args['after'] );
	}

	public static function get_filter_taxonomy_title() {

		if ( self::check_for_hidden( 'title' ) ) {
			return '';
		}

		$title_class = isset( self::$settings['widget'] ) && isset( self::$settings['widget']['use_widget_titles'] ) && 'yes' === self::$settings['widget']['use_widget_titles'] ? 'prdctfltr_widget_title' : 'prdctfltr_regular_title';

		$args = apply_filters(
			'prdctfltr_filter_title_args',
			array(
				'before' => '<span class="' . esc_attr( $title_class ) . '">',
				'after'  => '</span>',
			)
		);

		echo wp_kses_post( $args['before'] );

		if ( '' !== self::$filter['title'] ) {
			echo esc_html( self::$filter['title'] );
		} else {
			if ( 'pa_' === substr( self::$filter['taxonomy'], 0, 3 ) ) {
				echo wc_attribute_label( self::$filter['taxonomy'] );
			} else {
				if ( 'product_cat' === self::$filter['taxonomy'] ) {
					esc_html_e( 'Categories', '^xwc' );
				} elseif ( 'product_tag' === self::$filter['taxonomy'] ) {
					esc_html_e( 'Tags', '^xwc' );
				} elseif ( 'characteristics' === self::$filter['taxonomy'] ) {
					esc_html_e( 'Characteristics', '^xwc' );
				} else {
					$term = get_taxonomy( self::$filter['taxonomy'] );
					echo esc_html( $term->label );
				}
			}
		}
		?>
			<i class="prdctfltr-down"></i>
		<?php

		echo wp_kses_post( $args['after'] );
	}

	public static function get_filter_title( $filter, $title, $terms = array() ) {

		if ( self::check_for_hidden( 'title' ) ) {
			return '';
		}

		$title_class = isset( self::$settings['widget'] ) && isset( self::$settings['widget']['use_widget_titles'] ) && 'yes' === self::$settings['widget']['use_widget_titles'] ? 'prdctfltr_widget_title' : 'prdctfltr_regular_title';

		$args = apply_filters(
			'prdctfltr_filter_title_args',
			array(
				'filter' => $filter,
				'title'  => $title,
				'before' => '<span class="' . esc_attr( $title_class ) . '">',
				'after'  => '</span>',
			)
		);

		echo wp_kses_post( $args['before'] );

		echo esc_html( $title );

		?>
			<i class="prdctfltr-down"></i>
		<?php

		echo wp_kses_post( $args['after'] );
	}

	public static function check_term_include( $term ) {
		$relation = isset( self::$filter['include']['relation'] ) && 'IN' === self::$filter['include']['relation'] ? 'IN' : 'OUT';
		if ( ! empty( self::$filter['include']['selected'] ) && is_array( self::$filter['include']['selected'] ) ) {
			if ( ! in_array( $term, self::$filter['include']['selected'], true ) ) {
				return 'IN' === $relation ? true : false;
			}
		}
		return 'IN' === $relation ? false : true;
	}

	public static function catalog_instock( $get = '' ) {

		$array = array();
		if ( ! self::check_for_hidden( 'none' ) ) {
			$array[] = self::get_none_array();
		}

		$instock = array(
			'both' => esc_html__( 'All Products', '^xwc' ),
			'in'   => esc_html__( 'In Stock', '^xwc' ),
			'out'  => esc_html__( 'Out Of Stock', '^xwc' ),
		);

		if ( ! empty( self::$filter['style']['terms'] ) ) {

			foreach ( self::$filter['style']['terms'] as $k => $v ) {
				if ( self::check_term_include( $v['id'] ) ) {
					continue;
				}
				if ( empty( $v['title'] ) ) {
					$v['title'] = $instock[ $v['id'] ];
				}
				/* Bad fix */
				if ( empty( $v['value'] ) ) {
					$v['value'] = $v['id'];
				}
				$array[] = $v;
			}
		} else {
			foreach ( $instock as $k => $v ) {
				if ( self::check_term_include( $k ) ) {
					continue;
				}
				$array[] = array(
					'value'   => $k,
					'title'   => $v,
					'tooltip' => $v,
					'data'    => $k,
				);
			}
		}

		$array = apply_filters( 'prdctfltr_catalog_instock', $array );

		return $array;

	}

	public static function catalog_ordering() {

		$array = array();
		if ( ! self::check_for_hidden( 'none' ) ) {
			$array[] = self::get_none_array();
		}

		$orderby = array(
			'menu_order'    => esc_html__( 'Default', '^xwc' ),
			'comment_count' => esc_html__( 'Review Count', '^xwc' ),
			'popularity'    => esc_html__( 'Popularity', '^xwc' ),
			'rating'        => esc_html__( 'Average rating', '^xwc' ),
			'date'          => esc_html__( 'Newness', '^xwc' ),
			'price'         => esc_html__( 'Price: low to high', '^xwc' ),
			'price-desc'    => esc_html__( 'Price: high to low', '^xwc' ),
			'rand'          => esc_html__( 'Random Products', '^xwc' ),
			'title'         => esc_html__( 'Product Name', '^xwc' ),
		);

		if ( ! empty( self::$filter['style']['terms'] ) ) {

			foreach ( self::$filter['style']['terms'] as $k => $v ) {
				if ( self::check_term_include( $v['id'] ) ) {
					continue;
				}
				if ( empty( $v['title'] ) ) {
					$v['title'] = $orderby[ $v['id'] ];
				}
				/* Bad fix */
				if ( empty( $v['value'] ) ) {
					$v['value'] = $v['id'];
				}
				$array[] = $v;
			}
		} else {
			foreach ( $orderby as $k => $v ) {
				if ( self::check_term_include( $k ) ) {
					continue;
				}
				$array[] = array(
					'value'   => $k,
					'title'   => $v,
					'tooltip' => $v,
					'data'    => $k,
				);
			}
		}

		$array = apply_filters( 'prdctfltr_catalog_orderby', $array );

		return $array;

	}

	public static function make_filter() {

		global $wp_query;

		if ( isset( self::$options['sc_instance'] ) ) {
			$pf_paged    = self::$options['sc_instance']['paged'];
			$pf_per_page = self::$options['sc_instance']['per_page'];
			$pf_total    = self::$options['sc_instance']['total'];
			$pf_first    = self::$options['sc_instance']['first'];
			$pf_last     = self::$options['sc_instance']['last'];
			$pf_request  = self::$options['sc_instance']['request'];
		} elseif ( is_shop() || is_product_taxonomy() || is_search() || isset( $wp_query->query_vars['wc_query'] ) && 'product_query' === $wp_query->query_vars['wc_query'] ) {
			$pf_paged    = max( 1, $wp_query->get( 'paged' ) );
			$pf_per_page = $wp_query->get( 'posts_per_page' );
			$pf_total    = $wp_query->found_posts;
			$pf_first    = ( $pf_per_page * $pf_paged ) - $pf_per_page + 1;
			$pf_last     = $wp_query->get( 'offset' ) > 0 ? min( $pf_total, $wp_query->get( 'offset' ) + $wp_query->get( 'posts_per_page' ) ) : min( $pf_total, $wp_query->get( 'posts_per_page' ) * $pf_paged );
			$pf_request  = $wp_query->request;
		} else {
			$args = array(
				'paginate' => true,
				'limit'    => 2999,
			);

			$query = wc_get_products( $args );

			$pf_paged    = 1;
			$pf_per_page = 10;
			$pf_total    = $query->total;
			$pf_first    = 1;
			$pf_last     = 1;
			$pf_request  = '';
		}

		self::$settings['instance'] = array(
			'paged'     => intval( $pf_paged ),
			'per_page'  => intval( $pf_per_page ),
			'total'     => intval( $pf_total ),
			'first'     => intval( $pf_first ),
			'last'      => intval( $pf_last ),
			'request'   => $pf_request,
			'activated' => array(),
		);

		self::prdctfltr_get_settings();
		self::fix_up_preset();
		self::check_preset_buttons();
		self::check_action();
		self::make_max_columns();
		self::make_active_filters();

	}

	public static function make_active_filters() {
		if ( empty( self::$settings['instance']['filters'] ) ) {
			self::$settings['instance']['filters'] = array();
		}

		$filters = array();

		foreach ( self::$settings['instance']['filters'] as $filter ) {
			$filters[] = isset( $filter['taxonomy'] ) ? $filter['taxonomy'] : $filter['filter'];
		}

		self::$settings['active'] = $filters;
	}

	public static function get_top_bar_showing() {
		if ( false === self::$settings['instance']['total'] ) {
			return false;
		}

		$pf_step_filter = isset( self::$options['step_filter'] ) ? 'yes' : '';
		?>
			<span class="prdctfltr_showing">
		<?php
		if ( 0 === self::$settings['instance']['total'] ) {
			esc_html_e( 'No products found', '^xwc' );
		} elseif ( 1 === self::$settings['instance']['total'] ) {
			if ( '' !== $pf_step_filter ) {
				esc_html_e( 'Found a single result', '^xwc' );
			} else {
				esc_html_e( 'Showing the single result', '^xwc' );
			}
		} elseif ( self::$settings['instance']['first'] === self::$settings['instance']['last'] ) {
			if ( '' !== $pf_step_filter ) {
				echo esc_html__( 'Found', '^xwc' ) . ' ' . absint( self::$settings['instance']['total'] ) . ' ' . esc_html__( 'results', '^xwc' );
			} else {
				echo esc_html__( 'Showing all', '^xwc' ) . ' ' . absint( self::$settings['instance']['total'] ) . ' ' . esc_html__( 'results', '^xwc' );
			}
		} else {
			if ( '' !== $pf_step_filter ) {
				echo esc_html__( 'Found', '^xwc' ) . ' ' . absint( self::$settings['instance']['total'] ) . ' ' . esc_html__( 'results', '^xwc' );
			} else {
				echo esc_html__( 'Showing', '^xwc' ) . ' ' . absint( self::$settings['instance']['first'] ) . ' - ' . absint( self::$settings['instance']['last'] ) . ' ' . esc_html__( 'of', '^xwc' ) . ' ' . absint( self::$settings['instance']['total'] ) . ' ' . esc_html__( 'results', '^xwc' );
			}
		}
		?>
			</span>
		<?php

	}

	function get_top_bar() {
		if ( in_array( 'hide_top_bar', self::$settings['instance']['style']['hide_elements'], true ) ) {
			return false;
		}

		$icon = self::$settings['instance']['style']['filter_icon'];
		?>
			<span class="prdctfltr_filter_title">
		<?php
			$hide = '';
		if ( in_array( 'hide_icon', self::$settings['instance']['style']['hide_elements'], true ) ) {
				$hide = ' pfw-hidden-element';
		}
		?>
				<a class="prdctfltr_woocommerce_filter<?php echo esc_attr( $hide ) . ' pf_ajax_' . ( '' !== self::$settings['instance']['style']['loading_animation'] ? esc_attr( self::$settings['instance']['style']['loading_animation'] ) : 'css-spinner-full-01' ); ?>" href="#"><i class="<?php echo ( '' === $icon ? 'prdctfltr-filter' : esc_attr( $icon ) ); ?><?php echo ( 'css-' === substr( self::$settings['instance']['style']['loading_animation'], 0, 4 ) ? ' ' . esc_attr( self::$settings['instance']['style']['loading_animation'] ) : '' ); ?>"></i></a>
				<span class="prdctfltr_woocommerce_filter_title">
			<?php
			if ( '' !== self::$settings['instance']['style']['filter_title'] ) {
				echo esc_html( self::$settings['instance']['style']['filter_title'] );
			} else {
				esc_html_e( 'Filter products', '^xwc' );
			}
			?>
				</span>
			<?php
			if ( ! in_array( 'hide_showing', self::$settings['instance']['style']['hide_elements'], true ) ) {
				self::get_top_bar_showing();
			}
			?>
			</span>
		<?php

		wc_set_loop_prop( 'total', self::$settings['instance']['total'] );
		wc_set_loop_prop( 'per_page', self::$settings['instance']['per_page'] );
	}

	public static function get_action_tag() {
		$action = isset( self::$settings['instance']['action'] ) ? self::$settings['instance']['action'] : '';

		return apply_filters( 'prdctfltr_filter_action', $action );
	}

	public static function check_action() {
		global $prdctfltr_global;

		$action = '';

		if ( ! empty( self::$settings['instance']['general']['form_action'] ) ) {
			$action = ( '/' === self::$settings['instance']['general']['form_action'] ? '/' : self::$settings['instance']['general']['form_action'] );
		}

		if ( isset( $prdctfltr_global['action'] ) && '' !== $prdctfltr_global['action'] ) {
			$action = ( '/' === $prdctfltr_global['action'] ? '/' : $prdctfltr_global['action'] );
		}

		if ( '' === $action ) {
			if ( is_woocommerce() || is_cart() || is_checkout() || is_account_page() || is_home() ) {
				if ( 'yes' === self::$options['general']['force_action'] ) {
					if ( is_product_taxonomy() ) {
						$action = '';
					} else {
						$action = get_the_permalink( self::prdctfltr_wpml_get_id( wc_get_page_id( 'shop' ) ) );
					}
				} else {
					$action = get_the_permalink( self::prdctfltr_wpml_get_id( wc_get_page_id( 'shop' ) ) );
				}
			} elseif ( is_page() ) {
				global $wp;
				if ( '' === get_option( 'permalink_structure' ) ) {
					$action = remove_query_arg( array( 'page', 'paged' ), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
				} else {
					$action = preg_replace( '%\/page/[0-9]+%', '', home_url( $wp->request ) );
				}
			} else {
				$action = get_the_permalink( self::prdctfltr_wpml_get_id( wc_get_page_id( 'shop' ) ) );
			}
		}

		self::$settings['instance']['action'] = $action;
	}

	public static function get_meta_compare( $compare ) {

		switch ( $compare ) {

			case 11:
			case '!=':
				return '!=' !== $compare ? '!=' : 11;
			break;

			case 12:
			case '>':
				return '>' !== $compare ? '>' : 12;
			break;

			case 13:
			case '<':
				return '<' !== $compare ? '<' : 13;
			break;

			case 14:
			case '>=':
				return '>=' !== $compare ? '>=' : 14;
			break;

			case 15:
			case '<=':
				return '<=' !== $compare ? '<=' : 15;
			break;

			case 16:
			case 'LIKE':
				return 'LIKE' !== $compare ? 'LIKE' : 16;
			break;

			case 17:
			case 'NOT LIKE':
				return 'NOT LIKE' !== $compare ? 'NOT LIKE' : 17;
			break;

			case 18:
			case 'IN':
				return 'IN' !== $compare ? 'IN' : 18;
			break;

			case 19:
			case 'NOT IN':
				return 'NOT IN' !== $compare ? 'NOT IN' : 19;
			break;

			case 20:
			case 'EXISTS':
				return 'EXISTS' !== $compare ? 'EXISTS' : 20;
			break;

			case 21:
			case 'NOT EXISTS':
				return 'NOT EXISTS' !== $compare ? 'NOT EXISTS' : 21;
			break;

			case 22:
			case 'NOT EXISTS':
				return 'NOT EXISTS' !== $compare ? 'NOT EXISTS' : 22;
			break;

			case 23:
			case 'BETWEEN':
				return 'BETWEEN' !== $compare ? 'BETWEEN' : 23;
			break;

			case 24:
			case 'NOT BETWEEN':
				return 'NOT BETWEEN' !== $compare ? 'NOT BETWEEN' : 24;
			break;

			case 10:
			case '=':
				return '=' !== $compare ? '=' : 10;
			break;

			default:
				return '';
			break;
		}

	}

	public static function get_meta_type( $type ) {

		switch ( $type ) {

			case 1:
			case 'BINARY':
				return 'BINARY' !== $type ? 'BINARY' : 1;
			break;

			case 2:
			case 'CHAR':
				return 'CHAR' !== $type ? 'CHAR' : 2;
			break;

			case 3:
			case 'DATE':
				return 'DATE' !== $type ? 'DATE' : 3;
			break;

			case 4:
			case 'DATETIME':
				return 'DATETIME' !== $type ? 'DATETIME' : 4;
			break;

			case 5:
			case 'DECIMAL':
				return 'DECIMAL' !== $type ? 'DECIMAL' : 5;
			break;

			case 6:
			case 'SIGNED':
				return 'SIGNED' !== $type ? 'SIGNED' : 6;
			break;

			case 7:
			case 'UNSIGNED':
				return 'UNSIGNED' !== $type ? 'UNSIGNED' : 7;
			break;

			case 8:
			case 'TIME':
				return 'TIME' !== $type ? 'TIME' : 8;
			break;

			case 0:
			case 'NUMERIC':
				return 'NUMERIC' !== $type ? 'NUMERIC' : 0;
			break;

			default:
				return '';
			break;

		}

	}

	public static function build_meta_key( $key, $compare, $type ) {
		return apply_filters( 'prdctfltr_meta_key_prefix', 'mta_' ) . $key . '_' . self::get_meta_type( $type ) . '_' . self::get_meta_compare( $compare );
	}

	public static function build_meta_range_key( $key, $numeric ) {
		return ! empty( $numeric ) && 'yes' === $numeric ? apply_filters( 'prdctfltr_meta_range_numeric_key_prefix', 'mtarn_' ) . $key : apply_filters( 'prdctfltr_meta_range_key_prefix', 'mtar_' ) . $key;
	}

	public static function get_max_columns() {
		return absint( self::$settings['instance']['style']['columns'] );
	}

	public static function make_max_columns() {
		if ( isset( self::$settings['widget'] ) && isset( self::$settings['widget']['keep_one_column'] ) && 'yes' === self::$settings['widget']['keep_one_column'] ) {
			self::$settings['instance']['style']['columns'] = 1;
			self::$settings['instance']['style']['mode']    = 'pf_mod_multirow';

			return;
		}

		if ( strpos( self::$settings['instance']['style']['style'], 'pf_sidebar' ) > -1 ) {
			self::$settings['instance']['style']['columns'] = 1;
			self::$settings['instance']['style']['mode']    = 'pf_mod_multirow';
		} else {
			$fc = ! empty( self::$settings['instance']['filters'] ) ? count( self::$settings['instance']['filters'] ) : 3;

			$columns                                        = empty( self::$settings['instance']['style']['columns'] ) ? 3 : self::$settings['instance']['style']['columns'];
			self::$settings['instance']['style']['columns'] = $fc < $columns ? $fc : intval( $columns );
		}
	}

	public static function get_wrapper_tag_parameters() {
		echo 'class="prdctfltr_filter_wrapper prdctfltr_columns_' . esc_attr( self::get_max_columns() ) . ( 1 === count( self::$settings['instance']['filters'] ) ? ' prdctfltr_single_filter' : '' ) . '" data-columns="' . absint( self::get_max_columns() ) . '"';
	}

	public static function check_wcml_active() {
		if ( class_exists( 'woocommerce_wpml' ) && defined( 'ICL_LANGUAGE_CODE' ) ) {
			$default  = '_' . apply_filters( 'wpml_default_language', null );
			$language = '_' . apply_filters( 'wpml_current_language', null );
			if ( $default !== $language ) {
				return substr( $language, 1 );
			}
		}
		return '';
	}

	public static function get_filter_tag_parameters() {

		$styles = self::prdctfltr_get_styles();

		echo 'class="prdctfltr_wc prdctfltr_woocommerce ' . ( isset( self::$settings['widget'] ) ? 'prdctfltr_wc_widget' : 'prdctfltr_wc_regular' ) . ' ' . esc_attr( implode( ' ', $styles ) ) . '"';
		echo 'yes' === self::$options['install']['ajax']['enable'] ? ' data-page="' . absint( self::$settings['instance']['paged'] ) . '"' : '';
		echo ' data-loader="' . esc_attr( self::$settings['instance']['style']['loading_animation'] ) . '"';
		echo ( false !== Prdctfltr()->get_language() ? ' data-lang="' . esc_attr( substr( Prdctfltr()->get_language(), 1 ) ) . '"' : '' );
		echo 'yes' === self::$options['general']['analytics'] ? ' data-nonce="' . wp_create_nonce( 'prdctfltr_analytics' ) . '"' : '';

		global $prdctfltr_global;
		if ( ! isset( $prdctfltr_global['mobile'] ) ) {
			if ( in_array( self::$settings['instance']['responsive']['behaviour'], array( 'show', 'hide', 'switch' ), true ) ) {
				echo ' data-mobile="' . absint( self::$settings['instance']['responsive']['resolution'] ) . '"';
			}
		}
		echo ' data-id="' . esc_attr( $prdctfltr_global['unique_id'] ) . '"';

	}

	public static function prdctfltr_switch_thumbnails_350( $image, $product, $size, $attr, $placeholder ) {

		global $prdctfltr_global;

		if ( ! empty( $prdctfltr_global['f_attrs'] ) || ! empty( $prdctfltr_global['unique_id'] ) && ! empty( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['attribute'] ) ) {

			global $product;

			if ( is_object( $product ) && method_exists( $product, 'is_type' ) && $product->is_type( 'variable' ) ) {

				if ( empty( self::$settings['v_attr'] ) ) {
					$pf_activated  = isset( $prdctfltr_global['active_filters'] ) ? $prdctfltr_global['active_filters'] : array();
					$pf_permalinks = isset( $prdctfltr_global['active_permalinks'] ) ? $prdctfltr_global['active_permalinks'] : array();

					if ( isset( $prdctfltr_global['unique_id'] ) && isset( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['attribute'] ) && isset( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['filter'] ) ) {
						$atts = $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts'];

						if ( ! empty( $atts ) ) {
							$pf_permalinks[ strstr( $atts['attribute'], 'pa_' ) ? sanitize_title( $atts['attribute'] ) : 'pa_' . sanitize_title( $atts['attribute'] ) ] = array_map( 'sanitize_title', explode( ',', $atts['filter'] ) );
						}
					}

					$pf_activated = array_merge( $pf_activated, $pf_permalinks );

					if ( ! empty( $pf_activated ) ) {
						$attrs = array();
						foreach ( $pf_activated as $k => $v ) {
							if ( 'pa_' === substr( $k, 0, 3 ) ) {
								$attrs = $attrs + array(
									$k => $v[0],
								);
							}
						}
						self::$settings['v_attr'] = $attrs;
					}
				}

				if ( ! empty( self::$settings['v_attr'] ) ) {

					$variables     = $product->get_variation_attributes();
					$var_intersect = array_intersect_key( self::$settings['v_attr'], $variables );

					if ( ! empty( $var_intersect ) ) {

						foreach ( $product->get_children() as $child_id ) {

							$variation = wc_get_product( $child_id );

							$curr_var_set[ $child_id ]['attributes']   = $variation->get_variation_attributes();
							$curr_var_set[ $child_id ]['variation_id'] = $variation->get_id();
						}

						$found = self::prdctrfltr_search_array( $curr_var_set, self::$settings['v_attr'] );
					}
				}
			}

			if ( ! empty( $found ) && has_post_thumbnail( $found[0]['variation_id'] ) ) {
				return str_replace( preg_replace( '/.[^.]*$/', '', wp_get_attachment_image_src( get_post_thumbnail_id( $product->get_id() ), 'full', false ) ), preg_replace( '/.[^.]*$/', '', wp_get_attachment_image_src( get_post_thumbnail_id( $found[0]['variation_id'] ), 'full', false ) ), $image );
			}
		}

		return $image;
	}

	public static function prdctfltr_switch_thumbnails( $html, $post_ID, $post_thumbnail_id, $size, $attr ) {

		global $prdctfltr_global;

		if ( ! empty( $prdctfltr_global['f_attrs'] ) || isset( $prdctfltr_global['unique_id'] ) && isset( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['attribute'] ) ) {

			global $product;

			if ( method_exists( $product, 'is_type' ) && $product->is_type( 'variable' ) ) {

				if ( empty( self::$settings['v_attr'] ) ) {
					$pf_activated  = isset( $prdctfltr_global['active_filters'] ) ? $prdctfltr_global['active_filters'] : array();
					$pf_permalinks = isset( $prdctfltr_global['active_permalinks'] ) ? $prdctfltr_global['active_permalinks'] : array();

					if ( isset( $prdctfltr_global['unique_id'] ) && isset( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['attribute'] ) && isset( $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts']['filter'] ) ) {
						$atts = $prdctfltr_global['pagefilters'][ $prdctfltr_global['unique_id'] ]['atts'];

						if ( ! empty( $atts ) ) {
							$pf_permalinks[ strstr( $atts['attribute'], 'pa_' ) ? sanitize_title( $atts['attribute'] ) : 'pa_' . sanitize_title( $atts['attribute'] ) ] = array_map( 'sanitize_title', explode( ',', $atts['filter'] ) );
						}
					}

					$pf_activated = array_merge( $pf_activated, $pf_permalinks );

					if ( ! empty( $pf_activated ) ) {
						$attrs = array();
						foreach ( $pf_activated as $k => $v ) {
							if ( 'pa_' === substr( $k, 0, 3 ) ) {
								$attrs = $attrs + array(
									$k => $v[0],
								);
							}
						}
						self::$settings['v_attr'] = $attrs;
					}
				}

				if ( ! empty( self::$settings['v_attr'] ) ) {

					$variables     = $product->get_variation_attributes();
					$var_intersect = array_intersect_key( self::$settings['v_attr'], $variables );

					if ( ! empty( $var_intersect ) ) {

						foreach ( $product->get_children() as $child_id ) {

							$variation = wc_get_product( $child_id );

							$curr_var_set[ $child_id ]['attributes']   = $variation->get_variation_attributes();
							$curr_var_set[ $child_id ]['variation_id'] = $variation->get_id();
						}

						$found = self::prdctrfltr_search_array( $curr_var_set, self::$settings['v_attr'] );
					}
				}
			}
		}

		if ( ! empty( $found ) && has_post_thumbnail( $found[0]['variation_id'] ) ) {
			return str_replace( preg_replace( '/.[^.]*$/', '', wp_get_attachment_image_src( $post_thumbnail_id, 'full', false ) ), preg_replace( '/.[^.]*$/', '', wp_get_attachment_image_src( get_post_thumbnail_id( $found[0]['variation_id'] ), 'full', false ) ), $html );
		}

		return $html;

	}

	public static function unconvert_price_filter_limits( $meta_query ) {

		if ( ! isset( $meta_query['price_filter'] ) ) {
			return $meta_query;
		}

		if ( isset( $meta_query['price_filter'] ) && isset( $meta_query['price_filter']['key'] ) && in_array( $meta_query['price_filter']['key'], array( '_price', '_sale_price' ), true ) ) {

			$currency = apply_filters( 'wcml_get_client_currency', null );

			if ( null !== $currency ) {
				if ( get_option( 'woocommerce_currency' ) !== $currency ) {
					global $woocommerce_wpml;
					$meta_query['price_filter']['value'][0] = $woocommerce_wpml->multi_currency->prices->unconvert_price_amount( $meta_query['price_filter']['value'][0] );
					$meta_query['price_filter']['value'][1] = $woocommerce_wpml->multi_currency->prices->unconvert_price_amount( $meta_query['price_filter']['value'][1] );
				}
			} else {
				$meta_query['price_filter']['value'][0] = apply_filters( 'woocs_back_convert_price', $meta_query['price_filter']['value'][0] );
				$meta_query['price_filter']['value'][1] = apply_filters( 'woocs_back_convert_price', $meta_query['price_filter']['value'][1] ) + 1;
			}
		}

		return $meta_query;

	}

	public static function unconvert_pice( $price ) {
		$currency = apply_filters( 'wcml_get_client_currency', null );

		if ( null !== $currency ) {
			if ( get_option( 'woocommerce_currency' ) !== $currency ) {
				global $woocommerce_wpml;
				$price = $woocommerce_wpml->multi_currency->prices->unconvert_price_amount( $price );
			}
		} else {
			$price = apply_filters( 'woocs_back_convert_price', $price );
		}

		return $price;
	}

	public static function get_filter_search() {

		global $prdctfltr_global;

		$pf_srch = ( isset( $prdctfltr_global['sc_init'] ) && true === $prdctfltr_global['sc_init'] ? 'search_products' : 's' );

		$pf_placeholder = '' !== self::$filter['placeholder'] ? self::$filter['placeholder'] : esc_html__( 'Product keywords', '^xwc' );

		printf( '<label%3$s>%1$s <a href="#" class="pf_search_trigger"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="prdctfltr_feather_search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg></a><span>%2$s</span></label>', '<input class="pf_search" name="' . esc_attr( $pf_srch ) . '" type="text"' . ( isset( self::$options['activated']['s'] ) ? ' value="' . esc_attr( self::$options['activated']['s'] ) . '"' : '' ) . ' placeholder="' . esc_attr( $pf_placeholder ) . '">', '' === get_search_query() ? ( isset( self::$options['activated']['s'] ) ? esc_html( self::$options['activated']['s'] ) : '' ) : esc_html( get_search_query() ), isset( self::$options['activated']['s'] ) ? ' class="prdctfltr_active"' : '' );

	}

	public static function check_for_hidden( $object ) {
		if ( isset( self::$filter['hide_elements'] ) && is_array( self::$filter['hide_elements'] ) && in_array( $object, self::$filter['hide_elements'], true ) ) {
			return true;
		}
		return false;
	}

	public static function _get_filter_meta_range_terms() {

		if ( empty( self::$filter['style']['terms'] ) ) {
			esc_html_e( 'Error! No terms!', '^xwc' );
		} else {

			global $prdctfltr_global;

			$rng_id = self::_get_range_id();

			$prdctfltr_global['ranges'][ $rng_id ]                 = array();
			$prdctfltr_global['ranges'][ $rng_id ]['type']         = 'double';
			$prdctfltr_global['ranges'][ $rng_id ]['min_interval'] = 1;
			$prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] = array();

			$c = 0;

			$set_min = isset( self::$options['activated'][ self::$filter['name'] ][0] ) ? self::$options['activated'][ self::$filter['name'] ][0] : '';
			$set_max = isset( self::$options['activated'][ self::$filter['name'] ] ) ? self::$options['activated'][ self::$filter['name'] ][ count( self::$options['activated'][ self::$filter['name'] ] ) - 1 ] : '';

			foreach ( self::$filter['style']['terms'] as $meta ) {

				if ( $set_min === $meta['value'] ) {
					$prdctfltr_global['ranges'][ $rng_id ]['from'] = $c;
				}

				if ( $set_max === $meta['value'] ) {
					$prdctfltr_global['ranges'][ $rng_id ]['to'] = $c;
				}

				$prdctfltr_global['ranges'][ $rng_id ]['prettyValues'][] = '<span class=\'pf_range_val\'>' . esc_html( $meta['value'] ) . '</span>' . esc_html( $meta['title'] );

				$c++;

			}

			if ( ! empty( $prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] ) ) {
				$prdctfltr_global['ranges'][ $rng_id ]['min'] = 0;
				$prdctfltr_global['ranges'][ $rng_id ]['max'] = count( $prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] ) - 1;
			}

			$prdctfltr_global['ranges'][ $rng_id ]['decorate_both']    = false;
			$prdctfltr_global['ranges'][ $rng_id ]['values_separator'] = ' &rarr; ';
			$prdctfltr_global['ranges'][ $rng_id ]['force_edges']      = true;

			foreach ( self::build_range_options() as $k24 => $v23 ) {
				if ( '' === $v23 ) {
					continue;
				}
				switch ( $k24 ) {
					case 'prefix':
						$outv23 = $v23 . ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' );
						break;
					case 'postfix':
						$outv23 = ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' ) . $v23;
						break;
					default:
						$outv23 = $v23;
						break;
				}
				$prdctfltr_global['ranges'][ $rng_id ][ $k24 ] = $outv23;
			}

			printf( '<input id="%1$s" class="pf_rng_%2$s" data-filter="%2$s" />', esc_attr( $rng_id ), esc_attr( self::$filter['name'] ) );

		}

	}

	public static $rng_id = 0;

	public static function _get_range_id() {
		return 'prdctfltr_rng_' . self::$rng_id++;
	}

	public static function _get_filter_meta_range_numeric_terms() {

		global $prdctfltr_global;

		$rng_id = self::_get_range_id();

		$prdctfltr_global['ranges'][ $rng_id ]                     = array();
		$prdctfltr_global['ranges'][ $rng_id ]['type']             = 'double';
		$prdctfltr_global['ranges'][ $rng_id ]['decorate_both']    = false;
		$prdctfltr_global['ranges'][ $rng_id ]['values_separator'] = ' &rarr; ';
		$prdctfltr_global['ranges'][ $rng_id ]['force_edges']      = true;

		if ( ! empty( self::$filter['start'] ) ) {
			$min = self::$filter['start'];
		} else {
			$min = 0;
		}

		if ( ! empty( self::$filter['end'] ) ) {
			$max = self::$filter['end'];
		} else {
			$max = 100;
		}

		$prdctfltr_global['ranges'][ $rng_id ]['min'] = $min;
		$prdctfltr_global['ranges'][ $rng_id ]['max'] = $max;

		if ( isset( self::$options['activated'][ self::$filter['name'] ][0] ) ) {
			$prdctfltr_global['ranges'][ $rng_id ]['from'] = self::$options['activated'][ self::$filter['name'] ][0];
		}

		if ( isset( self::$options['activated'][ self::$filter['name'] ][1] ) ) {
			$prdctfltr_global['ranges'][ $rng_id ]['to'] = self::$options['activated'][ self::$filter['name'] ][1];
		}

		if ( 'yes' === self::$filter['grid'] ) {
			$prdctfltr_global['ranges'][ $rng_id ]['grid'] = true;
		}

		foreach ( self::build_range_options() as $k24 => $v23 ) {
			if ( '' === $v23 ) {
				continue;
			}
			switch ( $k24 ) {
				case 'prefix':
					$outv23 = $v23 . ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' );
					break;
				case 'postfix':
					$outv23 = ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' ) . $v23;
					break;
				default:
					$outv23 = $v23;
					break;
			}
			$prdctfltr_global['ranges'][ $rng_id ][ $k24 ] = $outv23;
		}

		printf( '<input id="%1$s" class="pf_%2$s" data-filter="%2$s" />', esc_attr( $rng_id ), esc_attr( self::$filter['name'] ) );

	}

	public static function get_filter_meta_range_terms() {
		if ( ! empty( self::$filter['numeric'] ) && 'yes' === self::$filter['numeric'] ) {
			self::_get_filter_meta_range_numeric_terms();
		} else {
			self::_get_filter_meta_range_terms();
		}
	}

	public static function get_filter_meta_terms() {

		if ( ! self::check_for_hidden( 'none' ) ) {
			printf( '<label class="prdctfltr_ft_none"><input type="checkbox" value="" />%1$s</label>', wp_kses_post( ( ! empty( self::$filter['style']['style']['type'] ) && ! in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ? self::get_customized_term_700( '', 'none', self::get_none_string(), false ) : '<span>' . self::get_none_string() . '</span>' ) ) );
		}

		if ( empty( self::$filter['style']['terms'] ) ) {
			esc_html_e( 'Error! No terms!', '^xwc' );
		} else {
			foreach ( self::$filter['style']['terms'] as $meta ) {

				$checked = ( isset( self::$options['activated'][ self::$filter['name'] ] ) && in_array( $meta['value'], self::$options['activated'][ self::$filter['name'] ], true ) ? ' checked' : ' ' );

				printf( '<label%1$s>%2$s</label>', ( isset( self::$options['activated'][ self::$filter['name'] ] ) && in_array( $meta['value'], self::$options['activated'][ self::$filter['name'] ], true ) ? ' class="prdctfltr_active prdctfltr_ft_' . esc_attr( sanitize_title( $meta['value'] ) ) . '"' : ' class="prdctfltr_ft_' . esc_attr( sanitize_title( $meta['value'] ) ) . '"' ), ! empty( self::$filter['style']['style']['type'] ) && ! in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ? self::get_customized_term_700( $meta['value'], sanitize_title( $meta['title'] ), $meta['title'], false, $checked ) : sprintf( '<input type="checkbox" value="%1$s"%2$s/><span>%3$s</span>', esc_attr( $meta['value'] ), esc_attr( $checked ), esc_html( $meta['title'] ) ) );
			}
		}

	}

	public static function get_filter( $filter_element ) {

		self::get_true_filter( $filter_element );

		if ( empty( self::$filter['taxonomy'] ) && in_array( $filter_element['filter'], array( 'taxonomy', 'range' ), true ) ) {
			return false;
		}

		if ( false === self::check_adoptive() ) {
			return false;
		}

		self::get_filter_wrapper_start();

		self::get_filter_input_fields();

		switch ( self::$filter['filter'] ) {
			case 'range':
				self::get_dynamic_filter_title_700();
				break;
			case 'taxonomy':
				self::get_filter_taxonomy_title();
				break;
			default:
				self::get_filter_title( self::$filter['filter'], self::$filter['title'] );
				break;
		}

		self::get_filter_description();

		self::add_customized_terms_css();

		self::get_filter_checkboxes_wrapper_start();

		switch ( self::$filter['filter'] ) {
			case 'meta':
				self::get_filter_meta_terms();
				break;
			case 'search':
				self::get_filter_search();
				break;
			case 'range':
				self::get_filter_range_terms();
				break;
			case 'taxonomy':
				self::get_filter_taxonomy_terms();
				break;
			case 'meta_range':
				self::get_filter_meta_range_terms();
				break;
			default:
				self::get_filter_terms();
				break;
		}

		self::get_filter_checkboxes_wrapper_end();

		self::get_filter_wrapper_end();

	}

	public static function get_true_filter_description( $name ) {
		return self::$filter['desc'];
	}

	public static function get_true_filter_customization( $name ) {
		return self::$filter['style'];
	}

	public static function get_true_filter( $filter ) {

		switch ( $filter['filter'] ) {

			case 'search':
				self::$filter = array_merge(
					array(
						'filter'      => $filter['filter'],
						'title'       => esc_html__( 'Search Products', '^xwc' ),
						'desc'        => '',
						'placeholder' => '',
						'style'       => '',
						'class'       => 'search',
						'name'        => 'search',
					),
					array_filter( $filter )
				);

				break;

			case 'per_page':
				self::$filter = array_merge(
					array(
						'filter' => $filter['filter'],
						'title'  => esc_html__( 'Per Page', '^xwc' ),
						'desc'   => '',
						'style'  => '',
						'class'  => 'perpage',
						'name'   => 'products_per_page',
					),
					array_filter( $filter )
				);

				break;

			case 'instock':
				self::$filter = array_merge(
					array(
						'filter'        => $filter['filter'],
						'title'         => esc_html__( 'Availability', '^xwc' ),
						'desc'          => '',
						'include'       => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'hide_elements' => array(),
						'style'         => '',
						'class'         => 'instock',
						'name'          => 'instock_products',
					),
					array_filter( $filter )
				);

				break;

			case 'orderby':
			case 'sort':
				self::$filter = array_merge(
					array(
						'filter'        => $filter['filter'],
						'title'         => esc_html__( 'Order By', '^xwc' ),
						'desc'          => '',
						'include'       => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'hide_elements' => array(),
						'style'         => '',
						'class'         => 'orderby',
						'name'          => 'orderby',
					),
					array_filter( $filter )
				);

				break;

			case 'vendor':
				self::$filter = array_merge(
					array(
						'filter'        => $filter['filter'],
						'title'         => esc_html__( 'Vendor', '^xwc' ),
						'desc'          => '',
						'include'       => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'hide_elements' => array(),
						'style'         => '',
						'class'         => 'vendor',
						'name'          => 'vendor',
					),
					array_filter( $filter )
				);

				break;

			case 'rating_filter':
				self::$filter = array_merge(
					array(
						'filter'        => $filter['filter'],
						'title'         => esc_html__( 'Rating', '^xwc' ),
						'desc'          => '',
						'include'       => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'hide_elements' => array(),
						'style'         => '',
						'class'         => 'rating_filter',
						'name'          => 'rating_filter',
					),
					array_filter( $filter )
				);

				break;

			case 'price':
				self::$filter = array_merge(
					array(
						'filter'        => $filter['filter'],
						'title'         => esc_html__( 'Price', '^xwc' ),
						'desc'          => '',
						'include'       => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'hide_elements' => array(),
						'style'         => '',
						'class'         => 'byprice',
						'name'          => 'price',
					),
					array_filter( $filter )
				);

				break;

			case 'meta':
				$key = self::build_meta_key( $filter['key'], $filter['compare'], $filter['type'] );

				self::$filter = array_merge(
					array(
						'filter'               => 'meta',
						'title'                => esc_html__( 'Meta', '^xwc' ),
						'desc'                 => '',

						'key'                  => '',
						'compare'              => '=',
						'type'                 => 'CHAR',
						'limit'                => '',
						'multiselect'          => 'no',
						'multiselect_relation' => 'IN',
						'hide_elements'        => array(),

						'style'                => '',

						'name'                 => $key,
						'class'                => 'meta',
					),
					array_filter( $filter )
				);

				self::$filter['class'] .= ( 'yes' === self::$filter['multiselect'] ? ' prdctfltr_multi' : ' prdctfltr_single' ) . ( 'AND' === self::$filter['multiselect_relation'] ? ' prdctfltr_merge_terms' : '' );

				break;

			case 'meta_range':
				$key = self::build_meta_range_key( $filter['key'], $filter['numeric'] );

				self::$filter = array_merge(
					array(
						'filter'   => 'range',
						'title'    => '',
						'desc'     => '',

						'key'      => '',
						'numeric'  => '',

						'style'    => '',
						'grid'     => 'no',
						'start'    => '',
						'end'      => '',
						'prefix'   => '',
						'postfix'  => '',
						'step'     => '',
						'grid_num' => '',

						'name'     => $key,
						'class'    => 'meta_range',
					),
					$filter
				);

				self::$filter['class'] .= ' prdctfltr_' . $filter['filter'] . ' pf_rngstyle_' . self::$filter['design'];

				break;

			case 'range':
				self::$filter = array_merge(
					array(
						'filter'   => 'range',
						'title'    => '',
						'desc'     => '',
						'include'  => array(
							'relation' => 'IN',
							'selected' => array(),
						),
						'orderby'  => 'name',
						'order'    => 'ASC',
						'adoptive' => 'no',

						'style'    => '',
						'grid'     => 'no',
						'start'    => '',
						'end'      => '',
						'prefix'   => '',
						'postfix'  => '',
						'step'     => '',
						'grid_num' => '',

						'name'     => 'rng_' . $filter['taxonomy'],
						'class'    => 'rng_' . $filter['taxonomy'],
					),
					$filter
				);

				self::$filter['class'] .= ' prdctfltr_' . $filter['filter'] . ' pf_rngstyle_' . self::$filter['design'];

				break;

			case 'taxonomy':
			default:
				self::make_up_filter_700( $filter );
				break;
		}

	}

	public static function make_up_filter_700( $filter ) {

		if ( ! taxonomy_exists( $filter['taxonomy'] ) ) {
			return false;
		}

		self::$filter = array_merge(
			array(
				'filter'               => 'taxonomy',
				'class'                => '',
				'title'                => '',
				'desc'                 => '',
				'include'              => array(
					'relation' => 'IN',
					'selected' => array(),
				),
				'orderby'              => 'name',
				'order'                => 'ASC',
				'multiselect'          => 'no',
				'multiselect_relation' => 'IN',
				'adoptive'             => 'no',
				'selection_reset'      => 'no',
				'hide_elements'        => array(),
				'hierarchy'            => 'no',
				'hierarchy_mode'       => 'no',
				'hierarchy_expand'     => 'showall',
				'limit'                => 0,
				'term_count'           => 'yes',
				'term_search'          => 'yes',
				'style'                => '',
			),
			$filter
		);

		self::$filter['name'] = self::$filter['taxonomy'];

		self::$filter['class'] .= self::$filter['name'] . ' prdctfltr_attributes' . ( 'yes' === self::$filter['multiselect'] ? ' prdctfltr_multi' : ' prdctfltr_single' ) . ( self::_check_adoptive() ? ' ' . self::$filter['adoptive'] . ' prdctfltr_adoptive' : '' ) . ( 'AND' === self::$filter['multiselect_relation'] ? ' prdctfltr_merge_terms' : '' ) . ( 'yes' === self::$filter['hierarchy_expand'] ? ' prdctfltr_expand_parents' : '' ) . ( 'yes' === self::$filter['hierarchy'] ? ' prdctfltr_hierarchy' : '' ) . ( in_array( self::$filter['hierarchy_mode'], array( 'drill', 'drillback', 'subonly', 'subonlyback' ), true ) ? ' prdctfltr_' . self::$filter['hierarchy_mode'] : '' );

		$pf_terms = array();

		if ( 'number' === self::$filter['orderby'] ) {
			$curr_term_args = array(
				'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
				'orderby'    => 'slug',
			);
			$pf_terms       = self::prdctfltr_get_terms( self::$filter['taxonomy'], $curr_term_args );
			$pf_sort_args   = array(
				'order' => ( isset( self::$filter['order'] ) ? self::$filter['order'] : '' ),
			);
			$pf_terms       = self::prdctfltr_sort_terms_naturally( $pf_terms, $pf_sort_args );
		} else {
			$curr_term_args = array(
				'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
				'orderby'    => ( '' !== self::$filter['orderby'] ? self::$filter['orderby'] : wc_attribute_orderby( self::$filter['taxonomy'] ) ),
				'order'      => ( '' !== self::$filter['order'] ? self::$filter['order'] : '' ),
			);

			$pf_terms = self::prdctfltr_get_terms( self::$filter['taxonomy'], $curr_term_args );
		}

		self::$filter['terms_recount'] = 'yes' === self::$filter['term_count'] && wp_doing_ajax() && is_taxonomy_hierarchical( self::$filter['taxonomy'] );

		if ( isset( self::$filter['hierarchy'] ) && 'yes' === self::$filter['hierarchy'] ) {

			$pf_terms_sorted = array();
			self::prdctfltr_sort_terms_hierarchicaly( $pf_terms, $pf_terms_sorted );
			self::$filter['terms'] = $pf_terms_sorted;

		} else {
			self::$filter['terms'] = $pf_terms;
		}

		if ( ! empty( self::$filter['custom_order'] ) && ! empty( self::$filter['style']['terms'] ) ) {
			self::$filter['terms'] = self::fix_custom_terms( self::$filter['terms'] );
		}

	}

	public static function get_max_height_value() {
		return isset( self::$settings['instance']['style']['max_height'] ) && absint( self::$settings['instance']['style']['max_height'] ) > 0 ? absint( self::$settings['instance']['style']['max_height'] ) . 'px' : false;
	}

	public static function get_max_height() {
		if ( in_array( self::$filter['filter'], array( 'range', 'search' ), true ) ) {
			return false;
		}

		if ( isset( self::$filter['style']['style']['type'] ) && in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ) {
			return false;
		}

		$max_height = self::get_max_height_value();

		if ( empty( $max_height ) ) {
			return false;
		}

		if ( isset( self::$filter['style']['style']['type'] ) && in_array( self::$filter['style']['style']['type'], array( 'pf_select', 'select' ), true ) ) {
			return ' style="height:' . esc_attr( $max_height ) . ';"';
		}

		return ' style="max-height:' . esc_attr( $max_height ) . ';"';
	}

	public static function get_filter_class() {
		$classes = array(
			'prdctfltr_filter',
			'prdctfltr_' . self::$filter['class'],
		);

		if ( ! empty( self::$filter['selection_reset'] ) && 'yes' === self::$filter['selection_reset'] ) {
			$classes[] = 'prdctfltr_selection';
		}

		if ( ! empty( self::$filter['style'] ) ) {
			if ( ! empty( self::$filter['style']['label'] ) && 'side' === self::$filter['style']['label'] ) {
				$classes[] = 'prdctfltr_side_lables';
			}
			if ( ! empty( self::$filter['style']['swatchDesign'] ) && 'round' === self::$filter['style']['swatchDesign'] ) {
				$classes[] = 'prdctfltr_round_swatches';
			}
		}

		if ( ! in_array( self::$filter['filter'], array( 'range', 'search' ), true ) ) {

			if ( ! empty( self::$filter['term_display'] ) && in_array( self::$filter['term_display'], array( 'inline', '2_columns', '3_columns' ), true ) ) {
				$classes[] = 'prdctfltr_' . self::$filter['term_display'];
			}

			if ( ! empty( self::$filter['style']['style']['type'] ) ) {
				if ( 'pf_select' === self::$settings['instance']['style']['style'] && in_array( self::$filter['style']['style']['type'], array( 'selectbox', 'system', 'selectize' ), true ) ) {
					unset( self::$filter['style']['style']['type'] );
				} else {
					self::$filter['style']['key'] = isset( self::$filter['style']['key'] ) ? self::$filter['style']['key'] : 'pf_style_' . uniqid();

					$classes[] = self::$filter['style']['key'];

					$classes[] = 'prdctfltr_terms_customized';
					$classes[] = 'prdctfltr_terms_customized_' . self::$filter['style']['style']['type'];
				}
			} else {
				$classes[] = 'prdctfltr_text';
			}

			if ( ! empty( self::$filter['term_search'] ) && 'yes' === self::$filter['term_search'] ) {
				$classes[] = 'prdctfltr_add_search';
			}
		}

		echo implode( ' ', $classes );
	}

	public static function get_filter_wrapper_start() {

		if ( ( 'pf_mod_multirow' === self::$settings['instance']['style']['mode'] || 'pf_select' === self::$settings['instance']['style']['style'] ) && 1 !== self::get_max_columns() && ! isset( self::$settings['widget'] ) && self::get_max_columns() === self::$settings['cnt'] ) {
			self::$settings['cnt']  = 0;
			self::$filter['class'] .= ' prdctfltr_clearnext';
		}

		?>
				<div class="<?php esc_attr( self::get_filter_class() ); ?>" data-filter="<?php echo esc_attr( self::$filter['name'] ); ?>"<?php echo isset( self::$filter['limit'] ) && intval( self::$filter['limit'] ) > 0 ? ' data-limit="' . absint( self::$filter['limit'] ) . '"' : ''; ?>>
			<?php
	}

	public static function get_filter_checkboxes_wrapper_start() {
		$max_height = self::get_max_height();
		?>
			<div <?php echo empty( $max_height ) ? 'class="prdctfltr_add_scroll"' : 'class="prdctfltr_add_scroll prdctfltr_max_height" ' . $max_height; ?>>
				<div class="prdctfltr_checkboxes">
		<?php
	}

	public static function get_filter_input_taxonomy() {

		global $prdctfltr_global;

		$curr_cat_selected = array();

		if ( isset( self::$options['activated'][ self::$filter['taxonomy'] ] ) ) {
			$curr_cat_selected = is_array( self::$options['activated'][ self::$filter['taxonomy'] ] ) ? self::$options['activated'][ self::$filter['taxonomy'] ] : array( self::$options['activated'][ self::$filter['taxonomy'] ] );
		}

		if ( empty( $curr_cat_selected ) && ! isset( $prdctfltr_global['sc_init'] ) && isset( $prdctfltr_global['active_permalinks'][ self::$filter['taxonomy'] ] ) ) {
			$curr_cat_selected = is_array( $prdctfltr_global['active_permalinks'][ self::$filter['taxonomy'] ] ) ? $prdctfltr_global['active_permalinks'][ self::$filter['taxonomy'] ] : array( $prdctfltr_global['active_permalinks'][ self::$filter['taxonomy'] ] );
		}

		if ( ! empty( $curr_cat_selected ) ) {
			$curr_cat_selected = array_map( 'sanitize_title', $curr_cat_selected );
		}

		if ( isset( self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) ) {
			$curr_cat_selected = array();
		}

		if ( ! empty( $curr_cat_selected ) ) {
			$tax_val = isset( $prdctfltr_global['taxonomies_data'][ self::$filter['taxonomy'] . '_string' ] ) ? esc_attr( $prdctfltr_global['taxonomies_data'][ self::$filter['taxonomy'] . '_string' ] ) : '';
			if ( '' === $tax_val && ! empty( $curr_cat_selected ) ) {
				$tax_val = isset( $prdctfltr_global['permalinks_data'][ self::$filter['taxonomy'] . '_string' ] ) ? esc_attr( $prdctfltr_global['permalinks_data'][ self::$filter['taxonomy'] . '_string' ] ) : '';
			}
			self::$filter['selected'] = $curr_cat_selected;
		} else {
			self::$filter['selected'] = array();
		}

		$term_add_parent = '';
		if ( ! empty( $curr_cat_selected ) ) {

			foreach ( $curr_cat_selected as $tax_val_term ) {

				if ( null !== term_exists( $tax_val_term, self::$filter['taxonomy'] ) ) {
					$curr_term        = get_term_by( 'slug', $tax_val_term, self::$filter['taxonomy'] );
					$pf_term_parent[] = $curr_term->parent;
				}
			}

			$do_not_term = null;
			if ( ! empty( $pf_term_parent ) ) {
				$first_value_term = current( $pf_term_parent );
				foreach ( $pf_term_parent as $val_term ) {
					if ( $first_value_term !== $val_term ) {
						$do_not_term = true;
					}
				}
				if ( ! isset( $do_not_term ) && 0 !== $pf_term_parent[0] ) {
					$curr_parent     = get_term_by( 'id', $pf_term_parent[0], self::$filter['taxonomy'] );
					$term_add_parent = $curr_parent->slug;
				}
			}
		}
		self::$settings['instance']['activated'][] = self::$filter['taxonomy'];
		?>
			<input name="<?php echo esc_attr( self::$filter['taxonomy'] ); ?>" type="hidden"<?php echo ( ! empty( $tax_val ) ? ' value="' . esc_attr( $tax_val ) . '"' : '' ) . ( self::_hierarchy_parent_check() && ! empty( $term_add_parent ) ? ' data-parent="' . esc_attr( $term_add_parent ) . '"' : '' ); ?> />
		<?php

	}

	public static function get_filter_input_meta() {
		global $prdctfltr_global;
		self::$settings['instance']['activated'][] = self::$filter['name'];
		?>
				<input name="<?php echo esc_attr( self::$filter['name'] ); ?>" type="hidden"<?php echo ( isset( $prdctfltr_global['meta_data'][ self::$filter['name'] ] ) ? ' value="' . esc_attr( $prdctfltr_global['meta_data'][ self::$filter['name'] ] ) . '"' : '' ); ?>>
			<?php
	}

	public static function get_filter_input_range() {
		?>
				<input name="rng_min_<?php echo esc_attr( self::$filter['taxonomy'] ); ?>" type="hidden"<?php echo ( isset( self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) ? ' value="' . esc_attr( self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) . '"' : '' ); ?>>
				<input name="rng_max_<?php echo esc_attr( self::$filter['taxonomy'] ); ?>" type="hidden"<?php echo ( isset( self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ] ) ? ' value="' . esc_attr( self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ] ) . '"' : '' ); ?>>
			<?php
			self::$settings['instance']['activated'][] = self::$filter['taxonomy'];
			self::$settings['instance']['activated'][] = 'rng_min_' . self::$filter['taxonomy'];
			self::$settings['instance']['activated'][] = 'rng_max_' . self::$filter['taxonomy'];

			if ( 'price' !== self::$filter['taxonomy'] ) {
				?>
					<input name="rng_orderby_<?php echo esc_attr( self::$filter['taxonomy'] ); ?>" type="hidden" value="<?php echo ! empty( self::$filter['custom_order'] ) && ! empty( self::$filter['style']['terms'] ) ? 'custom_order' : esc_attr( self::$filter['orderby'] ); ?>">
					<input name="rng_order_<?php echo esc_attr( self::$filter['taxonomy'] ); ?>" type="hidden" value="<?php echo ! empty( self::$filter['order'] ) ? esc_attr( self::$filter['order'] ) : ''; ?>">
				<?php
			}
	}

	public static function get_filter_input_price() {
		self::$settings['instance']['activated'][] = 'min_price';
		self::$settings['instance']['activated'][] = 'max_price';
		?>
				<input name="min_price" type="hidden"<?php echo ( isset( self::$options['activated']['min_price'] ) ? ' value="' . esc_attr( self::$options['activated']['min_price'] ) . '"' : '' ); ?>>
				<input name="max_price" type="hidden"<?php echo ( isset( self::$options['activated']['max_price'] ) ? ' value="' . esc_attr( self::$options['activated']['max_price'] ) . '"' : '' ); ?>>
			<?php
	}

	public static function get_filter_input_default_value() {
		echo isset( self::$options['activated'][ self::$filter['name'] ] ) ? ' value="' . esc_attr( ( is_array( self::$options['activated'][ self::$filter['name'] ] ) ? implode( ',', self::$options['activated'][ self::$filter['name'] ] ) : self::$options['activated'][ self::$filter['name'] ] ) ) . '"' : '';
	}

	public static function get_filter_input_default() {
		if ( 'search' === self::$filter['filter'] ) {
			return false;
		}
		?>
				<input name="<?php echo esc_attr( self::$filter['name'] ); ?>" type="hidden"<?php self::get_filter_input_default_value(); ?>>
		<?php

		self::$settings['instance']['activated'][] = self::$filter['name'];
	}

	public static function get_filter_input_fields() {

		switch ( self::$filter['filter'] ) {
			case 'price':
				self::get_filter_input_price();
				break;

			case 'meta':
				self::get_filter_input_meta();
				break;

			case 'range':
				self::get_filter_input_range();
				break;

			case 'taxonomy':
				self::get_filter_input_taxonomy();
				break;

			default:
				self::get_filter_input_default();
				break;
		}

	}

	public static function get_filter_description() {

		$desc = isset( self::$filter['desc'] ) && ! empty( self::$filter['desc'] ) ? self::$filter['desc'] : '';
		if ( '' !== $desc ) {
			printf( '<div class="prdctfltr_description">%1$s</div>', do_shortcode( wp_kses_post( $desc ) ) );
		}

	}

	public static function get_filter_checkboxes_wrapper_end() {
		?>
						</div>
					</div>
		<?php
	}

	public static function get_filter_wrapper_end() {
		?>
				</div>
		<?php

		self::$settings['cnt']++;

	}

	public static function _check_adoptive() {
		if ( isset( self::$settings['instance']['adoptive']['enable'] ) && 'yes' === self::$settings['instance']['adoptive']['enable'] && in_array( self::$filter['adoptive'], array( 'pf_adptv_default', 'pf_adptv_unclick', 'pf_adptv_click' ), true ) ) {
			return true;
		}
		return false;
	}

	public static function get_filter_range_terms() {
		
		global $prdctfltr_global;

		$rng_id = self::_get_range_id();

		$prdctfltr_global['ranges'][ $rng_id ]                 = array();
		$prdctfltr_global['ranges'][ $rng_id ]['type']         = 'double';
		$prdctfltr_global['ranges'][ $rng_id ]['min_interval'] = 1;

		if ( ! in_array( self::$filter['taxonomy'], array( 'price' ), true ) ) {

			if ( isset( self::$filter['orderby'] ) && 'number' === self::$filter['orderby'] ) {
				$curr_term_args = array(
					'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
					'orderby'    => 'slug',
				);
				$pf_terms       = self::prdctfltr_get_terms( self::$filter['taxonomy'], $curr_term_args );
				$pf_sort_args   = array(
					'order' => ( isset( self::$filter['order'] ) ? self::$filter['order'] : '' ),
				);
				$pf_terms       = self::prdctfltr_sort_terms_naturally( $pf_terms, $pf_sort_args );
			} else {
				$curr_term_args = array(
					'hide_empty' => 'yes' === self::$options['general']['hide_empty'] ? 1 : 0,
					'orderby'    => ( '' !== self::$filter['orderby'] ? self::$filter['orderby'] : wc_attribute_orderby( self::$filter['taxonomy'] ) ),
					'order'      => ( '' !== self::$filter['order'] ? self::$filter['order'] : '' ),
				);
				$pf_terms       = self::prdctfltr_get_terms( self::$filter['taxonomy'], $curr_term_args );
			}

			if ( ! empty( self::$filter['custom_order'] ) && ! empty( self::$filter['style']['terms'] ) ) {
				$pf_terms = self::fix_custom_terms( $pf_terms );
			}

			$prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] = array();

			$c = 0;

			foreach ( $pf_terms as $attribute ) {

				if ( self::_check_adoptive() && isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) && 1 !== count( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) ) {
					if ( ! isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ][ $attribute->slug ] ) ) {
						continue;
					}
				}

				if ( isset( self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) && $attribute->slug === self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) {
					$prdctfltr_global['ranges'][ $rng_id ]['from'] = $c;
				}

				if ( isset( self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ] ) && $attribute->slug === self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ] ) {
					$prdctfltr_global['ranges'][ $rng_id ]['to'] = $c;
				}

				$title = $attribute->name;

				if ( ! empty( self::$filter['style']['terms'] ) ) {

					$key = self::find_customized_term( $attribute->term_id, self::$filter['style']['terms'] );

					if ( false !== $key && ! empty( self::$filter['style']['terms'][ $key ] ) && ! empty( self::$filter['style']['terms'][ $key ]['title'] ) ) {
						$title = self::$filter['style']['terms'][ $key ]['title'];
					}
				}

				$prdctfltr_global['ranges'][ $rng_id ]['prettyValues'][] = '<span class=\'pf_range_val\'>' . esc_html( $attribute->slug ) . '</span>' . esc_html( $title );

				$c++;
			}

			if ( ! empty( $prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] ) ) {
				$prdctfltr_global['ranges'][ $rng_id ]['min'] = 0;
				$prdctfltr_global['ranges'][ $rng_id ]['max'] = count( $prdctfltr_global['ranges'][ $rng_id ]['prettyValues'] ) - 1;
			}

			$prdctfltr_global['ranges'][ $rng_id ]['decorate_both']    = false;
			$prdctfltr_global['ranges'][ $rng_id ]['values_separator'] = ' &rarr; ';
			$prdctfltr_global['ranges'][ $rng_id ]['force_edges']      = true;

		} else {

			if ( ! empty( self::$filter['start'] ) && ! empty( self::$filter['end'] ) ) {
				$min = self::$filter['start'];
				$max = self::$filter['end'];
			} else {
				$prices = self::get_filtered_price();
				
				$min = isset( $prices['min_price'] ) ? $prices['min_price'] : 0;
				$max = isset( $prices['max_price'] ) ? $prices['max_price'] : 0;

				self::$filter['start'] = $min;
				self::$filter['end']   = $max;
			}

			$pf_curr_min = self::price_to_float( wp_strip_all_tags( wc_price( floor( $min ) ) ) );
			$pf_curr_max = self::price_to_float( wp_strip_all_tags( wc_price( ceil( $max ) ) ) );

			$prdctfltr_global['ranges'][ $rng_id ]['min']         = apply_filters( 'wcml_raw_price_amount', $pf_curr_min );
			$prdctfltr_global['ranges'][ $rng_id ]['max']         = apply_filters( 'wcml_raw_price_amount', $pf_curr_max );
			$prdctfltr_global['ranges'][ $rng_id ]['minR']        = $pf_curr_min;
			$prdctfltr_global['ranges'][ $rng_id ]['maxR']        = $pf_curr_max;
			$prdctfltr_global['ranges'][ $rng_id ]['force_edges'] = true;

			$currency_pos = get_option( 'woocommerce_currency_pos', 'left' );
			$currency     = get_woocommerce_currency_symbol();

			switch ( $currency_pos ) {
				case 'right':
					$prdctfltr_global['ranges'][ $rng_id ]['postfix'] = $currency;
					break;
				case 'right_space':
					$prdctfltr_global['ranges'][ $rng_id ]['postfix'] = ' ' . $currency;
					break;
				case 'left_space':
					$prdctfltr_global['ranges'][ $rng_id ]['prefix'] = $currency . ' ';
					break;
				case 'left':
				default:
					$prdctfltr_global['ranges'][ $rng_id ]['prefix'] = $currency;
					break;
			}

			if ( isset( self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ] ) ) {
				$prdctfltr_global['ranges'][ $rng_id ]['from'] = self::$options['activated'][ 'rng_min_' . self::$filter['taxonomy'] ];
			}

			if ( isset( self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ] ) ) {
				$prdctfltr_global['ranges'][ $rng_id ]['to'] = self::$options['activated'][ 'rng_max_' . self::$filter['taxonomy'] ];
			}
		}

		if ( 'yes' === self::$filter['grid'] ) {
			$prdctfltr_global['ranges'][ $rng_id ]['grid'] = true;
		}

		foreach ( self::build_range_options() as $k24 => $v23 ) {
			if ( '' === $v23 ) {
				continue;
			}
			switch ( $k24 ) {
				case 'prefix':
					$outv23 = $v23 . ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' );
					break;
				case 'postfix':
					$outv23 = ( isset( $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] ) ? $prdctfltr_global['ranges'][ $rng_id ][ $k24 ] : '' ) . $v23;
					break;
				default:
					$outv23 = $v23;
					break;
			}
			$prdctfltr_global['ranges'][ $rng_id ][ $k24 ] = $outv23;
		}

		printf( '<input id="%1$s" class="pf_rng_%2$s" data-filter="%2$s" />', esc_attr( $rng_id ), esc_attr( self::$filter['taxonomy'] ) );

	}

	public static function build_range_options() {
		return array(
			'start'    => self::$filter['start'],
			'end'      => self::$filter['end'],
			'prefix'   => self::$filter['prefix'],
			'postfix'  => self::$filter['postfix'],
			'step'     => self::$filter['step'],
			'grid_num' => self::$filter['grid_num'],
		);
	}

	public static function get_filter_taxonomy_terms() {

		if ( ! self::check_for_hidden( 'none' ) ) {
			if ( ! empty( self::$filter['style']['style']['type'] ) && ! in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ) {
				$blank = self::get_customized_term_700( '', 'none', self::get_none_string(), false );
			} else {
				$blank = self::get_none_string();
			}

			printf( '<label class="prdctfltr_ft_none"><input type="checkbox" value="" /><span>%1$s</span></label>', wp_kses_post( $blank ) );
		}

		self::get_taxonomy_terms( self::$filter['terms'] );

	}

	public static function get_filter_terms() {

		self::get_filter_labels( self::check_for_customization_700() );

	}

	public static function get_filter_checked( $id ) {
		switch ( self::$filter['filter'] ) {
			case 'price':
				$price = ( isset( self::$options['activated']['min_price'] ) ? self::$options['activated']['min_price'] . '-' . ( isset( self::$options['activated']['max_price'] ) ? self::$options['activated']['max_price'] : '' ) : '' );
				return ( $price === $id ? true : false );
			break;
			default:
				return ( isset( self::$options['activated'][ self::$filter['name'] ] ) && self::$options['activated'][ self::$filter['name'] ] === $id ? true : false );
			break;
		}
	}

	public static function get_filter_labels( $terms ) {

		if ( false === $terms ) {
			$terms = self::get_false_terms();
		}

		foreach ( $terms as $term ) {

			$checked = '' === $term['value'] ? false : self::get_filter_checked( $term['value'] );

			$class = array();

			if ( $checked ) {
				$class[] = 'prdctfltr_active';
			}

			$class[] = 'prdctfltr_ft_' . ( '' === $term['value'] ? 'none' : sanitize_title( $term['value'] ) );

			printf( '<label class="%1$s">%2$s</label>', esc_attr( implode( ' ', $class ) ), ( ! empty( self::$filter['style']['style']['type'] ) && ! in_array( self::$filter['style']['style']['type'], array( 'system', 'selectize' ), true ) ? self::get_customized_term_700( $term['value'], $term['value'], $term['title'], false, ( true === $checked ? ' checked' : ' ' ) ) : sprintf( '<input type="checkbox" value="%1$s"%2$s/><span>%3$s%4$s</span>', esc_attr( $term['value'] ), ( true === $checked ? ' checked' : ' ' ), esc_html( $term['title'] ), ( empty( $term['tooltip'] ) ? '' : '<span class="prdctfltr_tooltip"><span>' . wp_kses_post( $term['tooltip'] ) . '</span></span>' ) ) ) );
		}

	}

	public static function check_for_customization_700() {
		if ( ! in_array( self::$filter['filter'], array( 'per_page', 'price' ), true ) ) {
			return false;
		}

		if ( empty( self::$filter['style']['terms'] ) ) {
			esc_html_e( 'Error! No terms!', '^xwc' );
			return array();
		}

		$opts = array();

		if ( ! self::check_for_hidden( 'none' ) ) {
			$opts[] = self::get_none_array();
		}

		switch ( self::$filter['filter'] ) {
			case 'price':
				$merge = array();

				foreach ( self::$filter['style']['terms'] as $term ) {

					$range = explode( '-', $term['value'] );

					if ( '' !== $range[0] ) {
						$range[0] = wp_strip_all_tags( wc_price( apply_filters( 'wcml_raw_price_amount', $range[0] ) ) );
					}

					if ( '' !== $range[1] ) {
						$range[1] = wp_strip_all_tags( wc_price( apply_filters( 'wcml_raw_price_amount', $range[1] ) ) );
					} else {
						$range[1] = '&infin;';
					}

					$merge['value'] = self::price_to_float( $range[0] ) . '-' . ( empty( $range[1] ) ? '' : self::price_to_float( $range[1] ) );

					if ( '' === $term['title'] ) {
						$merge['title'] = $range[0] . ' &mdash; ' . $range[1];
					}

					$opts[] = array_merge( $term, $merge );
				}

				return $opts;

			break;

			case 'per_page':
				foreach ( self::$filter['style']['terms'] as $term ) {
					$opts[] = array(
						'value' => $term['value'],
						'title' => $term['title'],
					);
				}

				return $opts;

			break;

			default:
				break;
		}

		return false;
	}

	public static function get_false_terms() {
		return call_user_func( 'XforWC_Product_Filters_Frontend::get_false_terms_' . self::$filter['filter'] );
	}

	public static function get_false_terms_() {
		return array();
	}

	public static function get_false_terms_price() {
		return array();
	}

	public static function get_none_array() {
		return array(
			'value'   => '',
			'title'   => self::get_none_string(),
			'tooltip' => self::get_none_tooltip_string(),
			'data'    => false,
		);
	}

	public static function get_none_string() {
		return isset( self::$filter['none_text'] ) && ! empty( self::$filter['none_text'] ) ? esc_html( self::$filter['none_text'] ) : apply_filters( 'prdctfltr_none_text', esc_html__( 'None', '^xwc' ) );
	}

	public static function get_none_tooltip_string() {
		return '';
	}

	public static function get_false_terms_rating_filter() {
		$array = array();

		if ( ! self::check_for_hidden( 'none' ) ) {
			$array[] = self::get_none_array();
		}

		$rated = array(
			'1' => esc_html__( '1 Star', '^xwc' ),
			'2' => esc_html__( '2 Stars', '^xwc' ),
			'3' => esc_html__( '3 Stars', '^xwc' ),
			'4' => esc_html__( '4 Stars', '^xwc' ),
			'5' => esc_html__( '5 Stars', '^xwc' ),
		);

		if ( ! empty( self::$filter['style']['terms'] ) ) {

			foreach ( self::$filter['style']['terms'] as $k => $v ) {
				if ( self::check_term_include( $v['id'] ) ) {
					continue;
				}
				if ( empty( $v['title'] ) ) {
					$v['title'] = $rated[ $v['id'] ];
				}
				/* Bad fix */
				if ( empty( $v['value'] ) ) {
					$v['value'] = $v['id'];
				}
				$array[] = $v;
			}
		} else {
			foreach ( $rated as $k => $v ) {
				if ( self::check_term_include( $k ) ) {
					continue;
				}
				$array[] = array(
					'value'   => $k,
					'title'   => $v,
					'tooltip' => $v,
					'data'    => $k,
				);
			}
		}

		return $array;
	}

	public static function get_false_terms_vendor() {

		$array = array();

		if ( ! self::check_for_hidden( 'none' ) ) {
			$array[] = self::get_none_array();
		}

		$args = array(
			'orderby' => 'nicename',
		);

		if ( ! empty( self::$filter['include']['selected'] ) && 'false' !== self::$filter['include']['selected'] ) {
			$relation = isset( self::$filter['include']['relation'] ) && 'OUT' === self::$filter['include']['relation'] ? 'OUT' : 'IN';
			if ( 'IN' === $relation ) {
				$args['include'] = self::$filter['include']['selected'];
			} else {
				$args['exclude'] = self::$filter['include']['selected'];
			}
		}

		$key = self::build_cache_key( $args );

		if ( ! empty( self::$options['cache'][ $key ] ) ) {
			return self::$options['cache'][ $key ];
		}

		$users = get_users( $args );

		foreach ( $users as $user ) {
			$array[] = array(
				'value'   => intval( $user->ID ),
				'title'   => $user->display_name,
				'tooltip' => $user->display_name,
				'data'    => false,
			);
		}

		self::$options['cache'][ $key ] = $array;

		return $array;

	}

	public static function build_cache_key( $args ) {
		if ( empty( $args ) ) {
			return false;
		}
		return '_' . md5( wp_json_encode( $args ) ) . '_' . self::$filter['filter'];
	}

	public static function get_false_terms_orderby() {
		return self::catalog_ordering();
	}

	public static function get_false_terms_instock() {
		return self::catalog_instock();
	}

	public static function get_false_terms_per_page() {
		return array();
	}

	function make_adoptive() {

		global $prdctfltr_global;

		$pf_adoptive_active = false;

		if ( ! empty( self::$settings['instance']['adoptive']['active_on'] ) ) {
			switch ( self::$settings['instance']['adoptive']['active_on'] ) {
				case 'always':
					$pf_adoptive_active = true;
					break;
				case 'permalink':
					if ( ! empty( $prdctfltr_global['active_filters'] ) || ! empty( $prdctfltr_global['active_permalinks'] ) ) {
						$pf_adoptive_active = true;
					}
					break;
				case 'filter':
					if ( ! empty( $prdctfltr_global['active_filters'] ) ) {
						$pf_adoptive_active = true;
					}
					break;
				default:
					$pf_adoptive_active = false;
					break;
			}
		}

		self::$settings['products_loop'] = false;

		if ( true === $pf_adoptive_active && 'yes' === self::$settings['instance']['adoptive']['enable'] ) {

			$adpt_taxes = ! empty( self::$settings['instance']['adoptive']['depend_on'] ) && is_string( self::$settings['instance']['adoptive']['depend_on'] ) ? array( self::$settings['instance']['adoptive']['depend_on'] ) : array();

			if ( ! empty( $adpt_taxes ) ) {

				if ( 0 === self::$settings['instance']['total'] ) {
					$adpt_taxes = array( 'product_cat' );
				}

				$pf_products = array();

				$adpt_go = false;
				foreach ( $adpt_taxes as $adpt_key => $adpt_tax ) {
					if ( ! empty( $prdctfltr_global['active_filters'] ) && array_key_exists( $adpt_tax, $prdctfltr_global['active_filters'] ) ) {
						$adpt_go = true;
					}
					if ( ! empty( $prdctfltr_global['active_permalinks'] ) && array_key_exists( $adpt_tax, $prdctfltr_global['active_permalinks'] ) ) {
						$adpt_go = true;
					}
					if ( apply_filters( 'prdctfltr_adoptive_go', false ) ) {
						$adpt_go = true;
					}
				}

				if ( true === $adpt_go ) {

					$adoptive_args = array(
						'post_type'      => 'product',
						'post_status'    => 'publish',
						'fields'         => 'ids',
						'posts_per_page' => apply_filters( 'prdctfltr_adoptive_precision', 999 ),
					);

					$tax_query        = array();
					$adpt_taxes_count = count( $adpt_taxes );

					for ( $i = 0; $i < $adpt_taxes_count; $i++ ) {

						if ( isset( $prdctfltr_global['active_filters'][ $adpt_taxes[ $i ] ] ) && taxonomy_exists( $adpt_taxes[ $i ] ) ) {
							$tax_query[] = array(
								'taxonomy' => $adpt_taxes[ $i ],
								'field'    => 'slug',
								'terms'    => $prdctfltr_global['active_filters'][ $adpt_taxes[ $i ] ],
							);
						}

						if ( isset( $prdctfltr_global['active_permalinks'][ $adpt_taxes[ $i ] ] ) && taxonomy_exists( $adpt_taxes[ $i ] ) ) {
							$tax_query[] = array(
								'taxonomy' => $adpt_taxes[ $i ],
								'field'    => 'slug',
								'terms'    => $prdctfltr_global['active_permalinks'][ $adpt_taxes[ $i ] ],
							);
						}
					}

					if ( ! empty( $tax_query ) ) {
						$tax_query['relation']      = 'AND';
						$adoptive_args['tax_query'] = $tax_query;
					}

					$pf_help_products = new WP_Query( $adoptive_args );

					$prepared = $pf_help_products->request;

					global $wpdb;
					$pf_products = $wpdb->get_results( $prepared ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

				}
			} else {

				$request = self::$settings['instance']['request'];

				if ( ! empty( $request ) && is_string( $request ) ) {

					$t_str = $request;

					$t_pos = strpos( $request, 'SQL_CALC_FOUND_ROWS' );
					if ( false !== $t_pos ) {
						$t_str = str_replace( 'SQL_CALC_FOUND_ROWS', '', $request );
					}

					$t_pos = strpos( $request, 'LIMIT' );
					if ( false !== $t_pos ) {
						$t_str = substr( $request, 0, $t_pos );
					}

					$t_str .= ' LIMIT 0,' . apply_filters( 'prdctfltr_adoptive_precision', 999 ) . ' ';

					global $wpdb;
					$pf_products = $wpdb->get_results( $t_str ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

				}
			}

			if ( ! empty( $pf_products ) ) {

				$curr_in = array();
				foreach ( $pf_products as $p ) {
					if ( ! isset( $p->ID ) ) {
						continue;
					}
					if ( ! in_array( $p->ID, $curr_in, true ) ) {
						$curr_in[] = $p->ID;
					}
				}

				if ( ! empty( $curr_in ) && is_array( $curr_in ) ) {

					$adoptive_taxes = array();
					$output_terms   = array();

					if ( ! empty( self::$settings['active'] ) ) {
						foreach ( self::$settings['active'] as $k24 => $v54 ) {
							if ( taxonomy_exists( $v54 ) ) {
								$adoptive_taxes[] = $v54;
							}
						}

						$curr_in_placeholders        = self::generate_wpdb_prepare_placeholders_from_array( $curr_in );
						$adoptive_taxes_placeholders = self::generate_wpdb_prepare_placeholders_from_array( $adoptive_taxes );

						$query           = "
							SELECT t.slug, tt.parent, tt.taxonomy, COUNT(DISTINCT tr.object_id) as count
							FROM {$wpdb->term_relationships} tr
							INNER JOIN {$wpdb->term_taxonomy} tt ON (tr.term_taxonomy_id = tt.term_taxonomy_id) AND tt.taxonomy IN ($adoptive_taxes_placeholders)
							INNER JOIN {$wpdb->terms} t ON (tt.term_id = t.term_id)
							WHERE tr.object_id IN ($curr_in_placeholders)
							GROUP BY t.slug, tt.taxonomy
						";
						$prepared_values = array_merge( $adoptive_taxes, $curr_in );
					} else {
						$curr_in_placeholders = self::generate_wpdb_prepare_placeholders_from_array( $curr_in );

						$query           = "
							SELECT t.slug, tt.parent, tt.taxonomy, COUNT(DISTINCT tr.object_id) as count
							FROM {$wpdb->term_relationships} tr
							INNER JOIN {$wpdb->term_taxonomy} tt ON (tr.term_taxonomy_id = tt.term_taxonomy_id)
							INNER JOIN {$wpdb->terms} t ON (tt.term_id = t.term_id)
							WHERE tr.object_id IN ($curr_in_placeholders)
							GROUP BY t.slug, tt.taxonomy
						";
						$prepared_values = $curr_in;
					}

					$prepare_query = call_user_func_array( array( $wpdb, 'prepare' ), array_merge( array( $query ), $prepared_values ) );

					$pf_product_terms = $wpdb->get_results( $prepare_query ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared

					foreach ( $pf_product_terms as $p ) {

						if ( ! isset( $output_terms[ $p->taxonomy ] ) ) {
							$output_terms[ $p->taxonomy ] = array();
						}

						if ( ! array_key_exists( $p->slug, $output_terms[ $p->taxonomy ] ) ) {
							$output_terms[ $p->taxonomy ][ $p->slug ] = $p->count;
						} else {
							$output_terms[ $p->taxonomy ][ $p->slug ] = $p->count + ( isset( $output_terms[ $p->taxonomy ][ $p->slug ] ) ? $output_terms[ $p->taxonomy ][ $p->slug ] : 0 );
						}

						$adpt_prnt = intval( $p->parent );
						if ( $adpt_prnt > 0 ) {
							while ( 0 !== $adpt_prnt ) {
								$adpt_prnt_term                                        = get_term_by( 'id', $adpt_prnt, $p->taxonomy );
								$output_terms[ $p->taxonomy ][ $adpt_prnt_term->slug ] = $p->count + ( isset( $output_terms[ $p->taxonomy ][ $adpt_prnt_term->slug ] ) ? $output_terms[ $p->taxonomy ][ $adpt_prnt_term->slug ] : 0 );
								$adpt_prnt_val = intval( $adpt_prnt_term->parent );
								$adpt_prnt     = $adpt_prnt_val > 0 ? $adpt_prnt_val : 0;
							}
						}
					}

					self::$settings['products_loop'] = $curr_in;
				}
			}
		}

		if ( isset( $output_terms ) ) {
			self::$settings['adoptive'] = $output_terms;
		}
	}

	public static function check_adoptive() {

		if ( ! in_array( self::$filter['filter'], array( 'range', 'taxonomy' ), true ) ) {
			return true;
		}

		switch ( self::$filter['filter'] ) {
			case 'range':
				if ( 'price' !== self::$filter['taxonomy'] && self::_check_adoptive() && ( isset( self::$settings['adoptive'] ) && true === ( ! isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) || isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) && empty( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) ) ) ) {
					return false;
				}
				break;
			default:
				if ( self::_check_adoptive() && ( isset( self::$settings['adoptive'] ) && true === ( ! isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) || isset( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) && empty( self::$settings['adoptive'][ self::$filter['taxonomy'] ] ) ) ) ) {
					return false;
				}

				break;
		}

		return true;

	}

	/*public function get_option( $o, $d = false ) {
		$p = self::$options;
		for ( $i = 0; $i <= count( $o ); $i++ ) {
			if ( ! isset( $p[ $i ] ) ) {
				return $d;
			}
			$p = $p[ $i ];
		}
		return $p;
	}*/

	function maybe_skip_variable() {
		$__maybe_skip = array();

		if ( ! empty( $_POST['pf_active_variations'] ) && is_array( $_POST['pf_active_variations'] ) ) {
			$__maybe_skip = array_flip( array_filter( $_POST['pf_active_variations'], 'absint' ) );
		}

		return $__maybe_skip;
	}

	function get_variable_products_helper() {
		global $prdctfltr_global;

		if ( ! isset( $prdctfltr_global['f_terms'] ) ) {
			return false;
		}

		if ( empty( self::$settings['products_loop'] ) ) {
			return false;
		}

		$__maybe_skip = $this->maybe_skip_variable();

		$products = array();

		foreach ( self::$settings['products_loop'] as $n => $id ) {
			if ( ! empty( $__maybe_skip ) && array_key_exists( $id, $__maybe_skip ) ) {
				continue;
			}

			$opt  = array();
			$type = WC()->product_factory->get_product_type( $id );

			if ( 'variable' === $type ) {
				$opt     = array( '_id' => $id );
				$product = wc_get_product( $id );

				foreach ( $product->get_children() as $child_id ) {
					$variation = wc_get_product( $child_id );

					$opt['_v'][] = array(
						$variation->get_variation_attributes(),
						$variation->is_in_stock(),
						$variation->backorders_require_notification(),
					);
				}
			}

			if ( ! empty( $opt['_v'] ) ) {
				$products[ $n ] = $opt;
			}
		}

		if ( empty( $products ) ) {
			return false;
		}

		return $products;
	}

	function add_variations_data( $data ) {
		$data['active_filtering']['variable'] = $this->get_variable_products_helper();

		return $data;
	}

	function cleanup() {
		remove_filter( 'woocommerce_is_filtered', 'XforWC_Product_Filters_Frontend::return_true' );
	}

}

	add_action( 'woocommerce_init', array( 'XforWC_Product_Filters_Frontend', 'init' ) );

if ( ! function_exists( 'xforwc__add_meta_information' ) ) {
	function xforwc__add_meta_information_action() {
		echo '<meta name="generator" content="XforWooCommerce.com - ' . esc_attr( implode( ' - ', apply_filters( 'xforwc__add_meta_information_used', array() ) ) ) . '"/>';
	}
	function xforwc__add_meta_information() {
		add_action( 'wp_head', 'xforwc__add_meta_information_action', 99 );
	}
	xforwc__add_meta_information();
}
