<?php
/**
 * Theme Options. //WPMonster.co
 *
 * Laborator.co
 * www.laborator.co
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme options, the options array.
 */
if ( ! function_exists( 'of_options' ) ) {

	function of_options( $force = false ) {
		global $of_options, $pagenow;

		// Do not execute on frontend, save some execution time
		if ( ! is_admin() && ! $force ) {
			return;
		}

		/*
			Advanced Folding Instructions

			'afolds' => 1 (element container)


			'afold' => "option_name:value1,value2,value3" (match any)
			'afold' => 'option_name:checked'
			'afold' => 'option_name:notChecked'
			'afold' => 'option_name:hasMedia'
			'afold' => 'option_name:hasNotMedia'
		*/

		/*-----------------------------------------------------------------------------------*/
		/* The Options Array */
		/*-----------------------------------------------------------------------------------*/
		$of_options = [];

		// Other vars
		$note_str = '<strong>توجه</strong>:';

		$show_sidebar_options = [
			'hide'  => 'پنهان کردن سایدبار',
            'right' => 'نمایش سایدبار از راست',
            'left' => 'نمایش سایدبار از چپ'
		];

		$endless_pagination_style = [
            '_1' => 'بارگذار چرخان',
            '_2' => 'بارگذار تپنده'
		];

		$menu_type_skins = [
            'menu-skin-main' => 'پیش فرض (رنگ اصلی قالب)',
            'menu-skin-dark' => 'سیاه (تیره)',
            'menu-skin-light' => 'سفید (روشن)',
		];

		$thumbnail_sizes_info = 'اندازه پیش فرض تصاویر بندانگشتی: کامل، بزرگ، متوسط، بندانگشتی.';

		$lab_social_networks_shortcode = "<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks]</code> – استاندارد <br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks rounded]</code> – آیکون های گرد <br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks colored]</code> – نوشته رنگی <br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks colored=\"hover\"]</code> – متن رنگی هنگام hover <br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks rounded colored=\"hover\"]</code> – آیکون های گرد و نوشته رنگی هنگام hover<br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks colored-bg]</code> – پس زمینه رنگی <br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks colored-bg=\"hover\"]</code> – پس زمینه رنگی هنگام hover<br>
<code style='font-size: 10px; display: inline-block; margin-top: 10px;'>[lab_social_networks colored-bg=\"hover\" rounded]</code> – پس زمینه گرد و رنگی هنگام hover";


		// Logo
		$of_options[] = [
			'name' => 'Branding',
			'type' => 'heading',
			'icon' => 'icon-branding'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'branding-tabs',
			'tabs' => [
				'branding-main'  => 'تنظیمات لوگو و برندینگ',
				'branding-other' => 'دیگر تنظیمات',
			]
		];

		$of_options[] = [
			'name' => 'برند سایت',
			'desc' => 'متنی که به عنوان لوگو نمایش داده خواهد شد را وارد کنید',
			'id'   => 'logo_text',
			'std'  => get_bloginfo( 'title' ),
			'type' => 'text',

			'tab_id' => 'branding-main'
		];

		$of_options[] = [
			'desc'  => 'لوگو<br><small>' . $note_str . ' از لوگوی خودتان استفاده کنید.</small>',
			'id'    => 'use_uploaded_logo',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'branding-main',
		];

		$of_options[] = [
			'name'   => 'لوگو',
            'desc' => "لوگوی خودتان را آپلود کنید<br><small>{$note_str}  برای آپلود تصویر SVG باید، <a href=\"https://wordpress.org/plugins/svg-support/\" target=\"_blank\">SVG Support plugin</a> را نصب کنید.</small>",
			'id'     => 'custom_logo_image',
			'std'    => "",
			'type'   => 'media',
			'mod'    => 'min',
			'fold'   => 'use_uploaded_logo',
			'afolds' => true,

			'tab_id' => 'branding-main'
		];

		$of_options[] = [
			'desc'    => 'حداکثر عرض را برای آپلود لوگو تنظیم کنید (اختیاری)<br><small>' . $note_str . ' اگر خالی باشد، عرض لوگو اصلی اعمال خواهد شد.</small>',
			'id'      => 'custom_logo_max_width',
			'std'     => "",
			'plc'     => 'عرض لوگو',
			'type'    => 'text',
			'numeric' => true,
			'fold'    => 'use_uploaded_logo',
			'afold'   => 'custom_logo_image:hasMedia',
			'postfix' => 'px',

			'tab_id' => 'branding-main'
		];

		$of_options[] = [
			'desc'    => 'حداکثر عرض را برای لوگو آپلود شده در موبایل تنظیم کنید (اختیاری)<br><small>' . $note_str . ' اگر خالی باشد، حداکثر ارتفاع  لوگو از فیلد بالایی به ارث برده میشود.</small>',
			'id'      => 'custom_logo_mobile_max_width',
			'std'     => "",
			'plc'     => 'عرض لوگو موبایل',
			'type'    => 'text',
			'numeric' => true,
			'fold'    => 'use_uploaded_logo',
			'afold'   => 'custom_logo_image:hasMedia',
			'postfix' => 'px',

			'tab_id' => 'branding-main'
		];

		if ( has_site_icon() ) {
			$icon_32 = get_site_icon_url( 32 );

			$of_options[] = [
				'name' => 'تنظیم فاوآیکون',
				'desc' => "",
				'id'   => 'favicon_set',
				'std'  => "
						<p>
								آیکون سایت ازقبل روی <strong>سفارشی سازی</strong> &gt; <strong>هویت سایت</strong> &gt; <strong>نمادک سایت</strong> تنظیم شده است. آیکون سایت:
						</p>
						
						<a href=" . admin_url( "customize.php" ) . " class=\"tc-site-icon\"><img src='{$icon_32}'></a>
						<a href=" . admin_url( 'customize.php' ) . " class=\"tc-link\"><span class='dashicons dashicons-admin-customizer'></span> سفارشی سازی</a>
						",
				'icon' => true,
				'type' => 'info',

				'tab_id' => 'branding-other'
			];
		}

		$of_options[] = [
			'name' => 'فاوآیکون',
			'desc' => 'فاویکونی 64x64 با فرمت PNG انتخاب کنید',
			'id'   => 'favicon_image',
			'std'  => "",
			'type' => 'media',
			'mod'  => 'min',

			'tab_id' => 'branding-other'
		];

		$of_options[] = [
			'name' => 'آیکون Apple Touch',
			'desc' => 'اندازه تصویر مورد نیاز 114x114 (فرمت PNG)',
			'id'   => 'apple_touch_icon',
			'std'  => "",
			'type' => 'media',
			'mod'  => 'min',

			'tab_id' => 'branding-other'
		];

		$of_options[] = [
			'name' => 'رنگ قالب گوگل',
			'desc' => "فقط در دستگاه های تلفن همراه کاربرد دارد، برای کسب اطلاعات بیشتر <a href=\"http://updates.html5rocks.com/2014/11/Support-for-theme-color-in-Chrome-39-for-Android\" target=\"_blank\">اینجا کلیک کنید</a>",
			'id'   => 'google_theme_color',
			'std'  => '',
			'type' => 'color',

			'tab_id' => 'branding-other'
		];
		/***** END OF: LOGO ****/

		$of_options[] = [
			'name' => 'Header and Menu',
			'type' => 'heading',
			'icon' => 'icon-header'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'header-and-menu-tabs',
			'tabs' => [
				'header-settings-menu'          => 'تنظیمات سربرگ',
				'header-settings-top-bar'       => 'نوار بالا',
				'header-settings-sticky-header' => 'سربرگ چسبنده',
				'header-settings-position'      => 'تنظیمات سربرگ',
				'header-settings-mobile'        => 'فهرست موبایل',
				'header-settings-other'         => 'دیگر تنظیمات',
			]
		];

		$of_options[] = [
			'name'    => 'موقعیت سربرگ',
			'desc'    => 'موقعیت سربرگ (لوگو و جعبه فهرست)',
			'id'      => 'header_position',
			'std'     => 'static',
			'options' => [
				'static'   => 'زیر محتوا (ساکن)',
				'absolute' => 'روی محتوا (مطلق)',
			],
			'type'    => 'select',

			'afolds' => true,

			'tab_id' => 'header-settings-position'
		];

		$of_options[] = [
			'desc'    => "فاصله سربرگ<br><small>{$note_str} اگر جایگاه سربرگ برای مطلق تنظیم شده باشد، این گزینه اثر می کند.</small>",
			'id'      => 'header_spacing',
			'std'     => "",
			'plc'     => 'مقدار پیشفرض: 0',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'afold' => 'header_position:absolute',

			'tab_id' => 'header-settings-position'
		];

		$of_options[] = [
			'name'    => 'فاصله عمودی سربرگ',
			'desc'    => "تنظیم فاصله سفارشی از بالا برای سربرگ (اختیاری)",
			'id'      => 'header_vpadding_top',
			'std'     => "",
			'plc'     => 'مقدار پیشفرض: 50',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'tab_id' => 'header-settings-position'
		];

		$of_options[] = [
			'desc'    => "تنظیم فاصله سفارشی از پایین برای سربرگ (اختیاری)",
			'id'      => 'header_vpadding_bottom',
			'std'     => "",
			'plc'     => 'مقدار پیشفرض: 50',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'tab_id' => 'header-settings-position'
		];

		$of_options[] = [
			'name'  => 'سربرگ تمام عرض',
			'desc'  => "گسترش جعبه سربرگ تا لبه مرورگر",
			'id'    => 'header_fullwidth',
			'std'   => 0,
			'type'  => 'checkbox',
			'afold' => '',

			'tab_id' => 'header-settings-position',
		];

		$of_options[] = [
			'name'   => 'Header Styling',
			'desc'   => "Background Color<br><small>{$note_str} Optionally you can add background color for header container.</small>",
			'id'     => 'header_background_color',
			'std'    => '',
			'type'   => 'color',
			'tab_id' => 'header-settings-position',
		];

		$of_options[] = [
			'desc'   => "Bottom Border<br><small>{$note_str} Optionally you can add bottom border for header container.</small>",
			'id'     => 'header_bottom_border',
			'std'    => '',
			'type'   => 'color',
			'tab_id' => 'header-settings-position',
		];

		$of_options[] = [
			'desc'    => "Bottom Spacing<br><small>{$note_str} Add your preferred bottom margin from content wrapper.</small>",
			'id'      => 'header_bottom_spacing',
			'std'     => "",
			'plc'     => 'Default is: 40',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'tab_id' => 'header-settings-position'
		];

		$of_options[] = [
			'name'  => 'برچسب سفارشی فهرست',
			'desc'  => "به جای استفاده از سه نوار افقی برای فهرست، شما میتوانید این آیکون را با متن یا هردو جایگزین کنید.",
			'id'    => 'menu_hamburger_custom_label',
			'std'   => 0,
			'on'    => 'فعال',
			'off'   => 'غیرفعال',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'header-settings-other',
		];

		$of_options[] = [
			'desc' => "متن نمایش<br><small>{$note_str} این متن به عنوان شاخص &quot;نمایش فهرست&quot; استفاده میشود.</small>",
			'id'   => 'menu_hamburger_custom_label_text',
			'std'  => 'فهرست',
			'type' => 'text',
			'fold' => 'menu_hamburger_custom_label',

			'tab_id' => 'header-settings-other'
		];

		$of_options[] = [
			'desc' => "متن بستن<br><small>{$note_str} این متن به عنوان شاخص &quot;پنهان کردن فهرست&quot; استفاده میشود.</small>",
			'id'   => 'menu_hamburger_custom_label_close_text',
			'std'  => 'بستن',
			'type' => 'text',
			'fold' => 'menu_hamburger_custom_label',

			'tab_id' => 'header-settings-other'
		];

		$of_options[] = [
			'desc'    => 'پدیداری آیکون فهرست',
			'id'      => 'menu_hamburger_custom_icon_position',
			'std'     => 'hide',
			'type'    => 'select',
			'options' => [
				'hide'  => 'پنهان کردن آیکون',
				'left'  => 'چپ',
				'right' => 'راست',
			],
			'fold'    => 'menu_hamburger_custom_label',

			'tab_id' => 'header-settings-other'
		];

		$of_options[] = [
			'name' => 'فیلد جستجو',
			'desc' => 'نمایان یا پنهان کردن فیلد جستجو در فهرست سربرگ اصلی',
			'id'   => 'header_search_field',
			'std'  => 0,
			'on'   => 'نمایان',
			'off'  => 'پنهان',
			'type' => 'switch',

			'folds' => true,

			'tab_id' => 'header-settings-other'
		];

		$of_options[] = [
			'desc' => 'نوع انیمیشن آیکون فیلد جستجو',
			'id'   => 'header_search_field_icon_animation',
			'std'  => 'scale',
			'type' => 'select',

			'options' => [
				'shift' => 'تغییر مکان حلقه جستجو به سمت چپ',
				'scale' => 'تغییر اندازه به حلقه جستجوی کوچکتر',
				'none'  => 'هیچکدام',

			],

			'fold' => 'header_search_field',

			'tab_id' => 'header-settings-other'
		];

		if ( kalium()->is->wpml_active() ) {
			$of_options[] = [
				'name' => 'تعویض کننده زبان WPML',
				'desc' => 'نمایش یا پنهان کردن تعویض کننده زبان در کنار دکمه های نوار فهرست',
				'id'   => 'header_wpml_language_switcher',
				'std'  => 0,
				'on'   => 'نمایان',
				'off'  => 'پنهان',
				'type' => 'switch',

				'folds' => true,

				'tab_id' => 'header-settings-other'
			];

			$of_options[] = [
				'desc' => 'ماشه تعویض کننده زبان',
				'id'   => 'header_wpml_language_trigger',
				'std'  => 'hover',
				'type' => 'select',

				'options' => [
					'hover' => 'نمایش هنگام hover',
					'click' => 'نمایش هنگام کلیک',

				],

				'fold' => 'header_wpml_language_switcher',

				'tab_id' => 'header-settings-other'
			];

			$of_options[] = [
				'desc' => 'موقعیت پرچم در تعویض کننده زبان',
				'id'   => 'header_wpml_language_flag_position',
				'std'  => 'left',
				'type' => 'select',

				'options' => [
					'left'  => 'چپ',
					'right' => 'راست',
					'hide'  => 'پنهان',

				],

				'fold' => 'header_wpml_language_switcher',

				'tab_id' => 'header-settings-other'
			];

			$of_options[] = [
				'desc' => 'نوع نمایش متن',
				'id'   => 'header_wpml_language_switcher_text_display_type',
				'std'  => 'flag-name',
				'type' => 'select',

				'options' => [
					'name'            => 'نام بومی',
					'translated'      => 'نام ترجمه شده',
					'initials'        => 'بدوی',
					'name-translated' => 'نام بومی + (نام ترجمه شده(',
					'translated-name' => 'نام ترجمه شده + (نام بومی(',
					'hide'            => 'پنهان کردن متن',
				],

				'fold' => 'header_wpml_language_switcher',

				'tab_id' => 'header-settings-other'
			];
		}

		$of_options[] = [
			'name' => 'نوع فهرست موبایل',
			'desc' => 'نوع فهرست موبایل را فقط برای دستگاه های تلفن همراه انتخاب کنید',
			'id'   => 'menu_mobile_type',
			'std'  => 1,
			'on'   => 'سایدبار از چپ',
			'off'  => 'تمام صفحه',
			'type' => 'switch',

			'tab_id' => 'header-settings-mobile'
		];

		$of_options[] = [
			'name' => 'فیلد جستجو در فهرست موبایل',
			'desc' => 'فیلد جستجو در فهرست موبایل را نمایان یا پنهان کنید',
			'id'   => 'menu_mobile_search_field',
			'std'  => 1,
			'on'   => 'نمایان',
			'off'  => 'پنهان',
			'type' => 'switch',

			'tab_id' => 'header-settings-mobile'
		];

		/*
$of_options[] = array( 	'name' 		=> 'WPML Language Switcher',
						'desc' 		=> 'Show or hide WPML language switcher on mobile menu<br><small>' . $note_str . ' Language switcher will be shown only if WPML plugin is installed and active.</small>',
						'id' 		=> 'menu_mobile_wpml_switcher',
						'std' 		=> 1,
						'on' 		=> 'Show',
						'off' 		=> 'Hide',
						'type' 		=> 'switch',

						'tab_id'	=> 'header-settings-mobile'
				);
*/

		$of_options[] = [
			'name'    => 'نقطه توقف فهرست موبایل',
			'desc'    => "حداکثر عرض زمانی که فهرست موبایل فعال است",
			'id'      => 'menu_mobile_breakpoint',
			'plc'     => 'برای استفاده از نقطه توقف پیش فرض خالی بگذارید',
			'std'     => '',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'tab_id' => 'header-settings-mobile',
		];

		$of_options[] = [
			'name'    => 'نوع فهرست اصلی',
			'desc'    => 'سبک فهرست پیش فرض مورد نظرتان را به عنوان فهرست اصلی سایت تنظیم کنید.',
			'id'      => 'main_menu_type',
			'std'     => 'full-bg-menu',
			'options' => [
				'custom-header' => kalium()->assets_url( 'admin/images/theme-options/menu-custom.gif' ),
				'full-bg-menu'  => kalium()->assets_url( 'admin/images/theme-options/menu-full-bg.jpg' ),
				'standard-menu' => kalium()->assets_url( 'admin/images/theme-options/menu-standard.jpg' ),
				'top-menu'      => kalium()->assets_url( 'admin/images/theme-options/menu-top.jpg' ),
				'sidebar-menu'  => kalium()->assets_url( 'admin/images/theme-options/menu-sidebar.jpg' ),
			],
			'type'    => 'images',
			'descrs'  => [
				'custom-header' => 'فهرست خودتان را بسازید',
				'full-bg-menu'  => 'فهرست تمام صفحه',
				'standard-menu' => 'فهرست استاندارد',
				'top-menu'      => 'فهرست بالا',
				'sidebar-menu'  => 'فهرست سایدبار',
			],
			'afolds'  => true,

			'tab_id' => 'header-settings-menu'
		];

		$of_options[] = [
			'name'  => 'تنظیمات فهرست تمام صفحه',
			'desc'  => 'فیلد جستجو بعد از آخرین مورد فهرست',
			'id'    => 'menu_full_bg_search_field',
			'std'   => 1,
			'type'  => 'checkbox',
			'afold' => 'main_menu_type:full-bg-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'  => 'نمایش کپی رایت و شبکه های اجتماعی (پایین)',
			'id'    => 'menu_full_bg_footer_block',
			'std'   => 1,
			'type'  => 'checkbox',
			'afold' => 'main_menu_type:full-bg-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'  => 'پس زمینه نیمه شفاف فهرست (اعمال شفافیت)',
			'id'    => 'menu_full_bg_opacity',
			'std'   => 1,
			'type'  => 'checkbox',
			'afold' => 'main_menu_type:full-bg-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'هماهنگی فهرست (هنگام تغییر)',
			'id'      => 'menu_full_bg_alignment',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				'left'                => 'چپ',
				'centered'            => 'وسط',
				'centered-horizontal' => 'وسط (افقی)',
			],

			'afold' => 'main_menu_type:full-bg-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'پالت رنگ برای این نوع فهرست را انتخاب کنید',
			'id'      => 'menu_full_bg_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,
			'afold'   => 'main_menu_type:full-bg-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'name'  => 'تنظیمات فهرست استاندارد',
			'desc' 	=> "نمایش لینک های فهرست فقط وقتی روی <strong>نوار فهرست</strong> کلیک شود.",
			'id'    => 'menu_standard_menu_bar_visible',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,
			'afold' => 'main_menu_type:standard-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => "افکت افشای <strong>نوار فهرست</strong> هنگام کلیک",
			'id'      => 'menu_standard_menu_bar_effect',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				'reveal-from-top'    => 'اسلاید از بالا',
				'reveal-from-right'  => 'اسلاید از راست',
				'reveal-from-left'   => 'اسلاید از چپ',
				'reveal-from-bottom' => 'اسلاید از پایین',
				'reveal-fade'        => 'فقط محو شود',
			],
			'fold'    => 'menu_standard_menu_bar_visible',
			'afold'   => 'main_menu_type:standard-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'پالت رنگ برای این نوع فهرست را انتخاب کنید',
			'id'      => 'menu_standard_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,
			'afold'   => 'main_menu_type:standard-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'name'    => 'نوع سربرگ',
			'desc'    => 'نوع سربرگ را برای استفاده انتخاب کنید', //' or selected from predefined templates.',
			'id'      => 'custom_header_type',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				'standard'      => 'سربرگ استاندارد',
				'logo-centered' => 'سربرگ با لوگوی وسط چین',
			],

			'afold' => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// ########## Custom Header Builder ##########
		$woocommerce_not_installed_text = ! kalium()->is->woocommerce_active() ? ' (WooCommerce not installed)' : '';
		$wpml_not_installed_text        = ! kalium()->is->wpml_active() ? ' (WPML not installed)' : '';

		$custom_header_content_types = [
			'none'                   => '- Not set -',
			'open-standard-menu'     => 'Toggle Standard Menu Button',
			'open-fullscreen-menu'   => 'Toggle Fullscreen Menu Button',
			'open-sidebar-menu'      => 'Toggle Sidebar Menu Button',
			'open-top-menu'          => 'Toggle Top Menu Button',
			'search-field'           => 'Search Field',
			'woocommerce-mini-cart'  => 'WooCommerce Mini Cart' . $woocommerce_not_installed_text,
			'wpml-language-switcher' => 'WPML Language Switcher' . $wpml_not_installed_text,
			'social-networks'        => 'Social Networks',
			'raw-text'               => 'Raw Text (or HTML)',

			// Menus
			'Menus'                  => [
				'main-menu' => ':: Main Menu ::',
			],
		];

		// Nav Menus
		$nav_menus = wp_get_nav_menus();

		$nav_menus_value = [
			'main-menu' => ':: Main Menu ::',
		];

		foreach ( $nav_menus as $term ) {
			$custom_header_content_types['Menus']["menu-{$term->term_id}"] = $term->name;
			$nav_menus_value["menu-{$term->term_id}"]                      = $term->name;
		}

		// Skin Color Option
		$sub_option_skin = [
			'type'  => 'select',
			'name'  => 'skin',
			'title' => 'Skin Color',
			'value' => array_merge( [
				'inherit' => '- Inherit -',
			], $menu_type_skins ),
		];

		// Hide on Devices Options
		$sub_option_hide_on = [
			'type'  => 'checkbox',
			'name'  => 'hide_on',
			'title' => 'Hide On Device',
			'value' => [
				'desktop' => 'Desktop',
				'tablet'  => 'Tablet',
				'mobile'  => 'Mobile',
			],
		];

		// Align Option
		$sub_option_align = [
			'type'  => 'select',
			'name'  => 'align',
			'title' => 'Alignment',
			'value' => [
				'left'  => 'Left',
				'right' => 'Right',
			],
		];

		// Sub options
		$custom_header_sub_options = [

			// Raw text
			'raw-text'               => [
				[
					'type'  => 'textarea',
					'name'  => 'text',
					'title' => 'Text',
					'value' => '',
					'focus' => true,
				],
			],

			// Social networks
			'social-networks'        => [

				// Style
				[
					'type'  => 'select',
					'name'  => 'style',
					'title' => 'Style',
					'value' => [
						'standard'              => 'Standard',
						'colored'               => 'Colored text',
						'colored-hover'         => 'Colored text on hover',
						'colored-bg'            => 'Colored background',
						'colored-bg-hover'      => 'Colored background on hover',
						'rounded'               => 'Rounded icons',
						'rounded-colored'       => 'Rounded icons and colored',
						'rounded-colored-hover' => 'Rounded icons and colored on hover',
					],
				],

				// Display structure
				[
					'type'    => 'select',
					'name'    => 'display_structure',
					'title'   => 'Display Structure',
					'value'   => [
						'icon-title' => 'Icon and title',
						'icon'       => 'Icon only',
						'title'      => 'Title only',
					],
					'default' => 'icon',
				],

				// Skin
				$sub_option_skin,
			],

			// Standard Menu Toggle Options
			'open-standard-menu'     => [
				[
					'type'  => 'select',
					'name'  => 'menu_id',
					'title' => 'Menu',
					'value' => $nav_menus_value,
				],
				array_merge(
					$sub_option_align,
					[
						'name'  => 'menu_position',
						'title' => 'Menu Position',
					]
				),
				[
					'type'  => 'select',
					'name'  => 'toggle_effect',
					'title' => 'Toggle Effect',
					'value' => [
						'fade'         => 'Fade',
						'slide-left'   => 'Slide from left',
						'slide-right'  => 'Slide from right',
						'slide-top'    => 'Slide from top',
						'slide-bottom' => 'Slide from bottom',
						'scale'        => 'Scale',
					],
				],
				[
					'type'    => 'select',
					'name'    => 'stagger_direction',
					'title'   => 'Stagger Direction',
					'value'   => [
						'all'   => 'All at once',
						'left'  => 'Stagger from left',
						'right' => 'Stagger from right',
					],
					'default' => 'right',
				],
				[
					'type'    => 'select',
					'name'    => 'submenu_dropdown_caret',
					'title'   => 'Submenu Dropdown Caret',
					'value'   => [
						'yes' => 'Yes',
						'no'  => 'No',
					],
					'default' => 'no',
				],
				array_merge(
					$sub_option_skin,
					[
						'title' => 'Skin Color',
					]
				),
			],

			// Fullscreen Menu Toggle Options
			'open-fullscreen-menu'   => [
				array_merge(
					$sub_option_skin,
					[
						'title' => 'Button Skin Color',
					]
				),
				array_merge(
					$sub_option_skin,
					[
						'name'  => 'toggled_skin',
						'title' => 'Toggled Button Skin Color',
						'value' => array_merge( [
							'inherit' => 'Keep Current Skin',
						], $menu_type_skins ),
					]
				),
			],

			// Sidebar Menu Toggle Options
			'open-sidebar-menu'      => [
				array_merge(
					$sub_option_skin,
					[
						'title' => 'Button Skin Color',
					]
				),
			],

			// Top Menu Toggle Options
			'open-top-menu'          => [
				array_merge(
					$sub_option_skin,
					[
						'title' => 'Button Skin Color',
					]
				),
			],

			// Search field
			'search-field'           => [
				// Alignment
				array_merge(
					$sub_option_align,
					[
						'title' => 'Search Field Alignment',
					]
				),
				// Skin
				$sub_option_skin,
			],

			// Mini cart
			'woocommerce-mini-cart'  => [
				// Alignment
				array_merge(
					$sub_option_align,
					[
						'title' => 'Dropdown Alignment',
						'value' => [
							'left'   => 'Left',
							'center' => 'Center',
							'right'  => 'Right',
						],
					]
				),
				// Skin
				$sub_option_skin,
			],

			// WPML language switcher
			'wpml-language-switcher' => [
				[
					'type'    => 'select',
					'name'    => 'display_text_format',
					'title'   => 'Display Text Format',
					'value'   => [
						'hide'            => 'Hide text',
						'name'            => 'Native name',
						'translated'      => 'Translated name',
						'initials'        => 'Initials',
						'name-translated' => 'Native name + (translated name)',
						'translated-name' => 'Translated name + (native name)',
					],
					'default' => 'name',
				],
				[
					'type'  => 'select',
					'name'  => 'flag_position',
					'title' => 'Flag Position',
					'value' => [
						'left'  => 'Left',
						'right' => 'Right',
						'hide'  => 'Hide',
					],
				],
				[
					'type'  => 'select',
					'name'  => 'show_on',
					'title' => 'Show On',
					'value' => [
						'hover' => 'Show on hover',
						'click' => 'Show on click',
					],
				],
				[
					'type'  => 'checkbox',
					'name'  => 'skip_missing',
					'title' => 'Skip Missing Translations',
					'value' => [
						'yes' => 'Yes',
					],
				],
				$sub_option_skin,
			],

			// Menu Options
			'Menus'                  => [
				[
					'type'    => 'select',
					'name'    => 'submenu_dropdown_caret',
					'title'   => 'Submenu Dropdown Caret',
					'value'   => [
						'yes' => 'Yes',
						'no'  => 'No',
					],
					'default' => 'no',
				],
				$sub_option_skin,
			],
		];

		// Header Builder Info
		$of_options[] = [
			'name'  => 'Header Builder',
			'desc'  => "",
			'id'    => 'custom_header_info',
			'std'   => '<h3>Header Builder</h3>',
			'icon'  => true,
			'type'  => 'info',
			'afold' => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Left Menu Content
		$of_options[] = [
			'desc'    => '',
			'id'      => 'custom_header_content_left',
			'std'     => '',
			'type'    => 'content_builder',
			'options' => $custom_header_content_types,
			'conf'    => [
				'maxEntries' => 6,
				'title'      => 'Left Content Elements',
				'alignField' => true,
				'subOptions' => $custom_header_sub_options,
				'responsive' => $sub_option_hide_on,
			],
			'folds'   => true,
			'afold'   => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Logo Image
		$of_options[] = [
			'id'    => 'custom_header_content_logo_image',
			'type'  => 'logo_image_display',
			'afold' => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Right Menu Content
		$of_options[] = [
			'name'    => '',
			'desc'    => '',
			'id'      => 'custom_header_content_right',
			'std'     => '',
			'type'    => 'content_builder',
			'options' => $custom_header_content_types,
			'conf'    => [
				'title'        => 'Right Content Elements',
				'maxEntries'   => 6,
				'alignField'   => true,
				'defaultAlign' => 'right',
				'subOptions'   => $custom_header_sub_options,
				'responsive'   => $sub_option_hide_on,
			],
			'afold'   => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Bottom Menu Content
		$of_options[] = [
			'name'    => '',
			'desc'    => '',
			'id'      => 'custom_header_content',
			'std'     => '',
			'type'    => 'content_builder',
			'options' => $custom_header_content_types,
			'conf'    => [
				'title'      => 'Bottom Content Elements',
				'maxEntries' => 6,
				'alignField' => true,
				'subOptions' => $custom_header_sub_options,
				'responsive' => $sub_option_hide_on,
			],
			'afold'   => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Header Builder Skin
		$of_options[] = [
			'name'    => 'Content Elements Skin',
			'desc'    => 'Default skin to apply to menu content elements in Header Builder',
			'id'      => 'custom_header_default_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,

			'afold' => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// Header templates
		$of_options[] = [
			'name'    => 'Header Templates',
			'explain' => 'Choose from ready to use header templates (optional)',
			'id'      => 'custom_header_templates',
			'type'    => 'content_builder_templates',
			'options' => [
				[
					'image' => kalium()->assets_url( 'admin/images/theme-options/custom-header-template-1.jpg' ),
					'name'  => 'Standard with bottom menu',
					'data'  => '{"other":{"headerType":"standard"},"data":{"custom_header_content_left":"{\"entries\":[{\"contentType\":\"search-field\",\"options\":{\"align\":\"left\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}","custom_header_content_right":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"right\"}","custom_header_content":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}"}}',
				],
				[
					'image' => kalium()->assets_url( 'admin/images/theme-options/custom-header-template-2.jpg' ),
					'name'  => 'Centered with side menus',
					'data'  => '{"other":{"headerType":"logo-centered"},"data":{"custom_header_content_left":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}","custom_header_content_right":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"right\"}","custom_header_content":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"center\"}"}}',
				],
				[
					'image' => kalium()->assets_url( 'admin/images/theme-options/custom-header-template-3.jpg' ),
					'name'  => 'Centered with side icons',
					'data'  => '{"other":{"headerType":"logo-centered"},"data":{"custom_header_content_left":"{\"entries\":[{\"contentType\":\"search-field\",\"options\":{\"align\":\"right\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}","custom_header_content_right":"{\"entries\":[{\"contentType\":\"open-standard-menu\",\"options\":{\"menu_id\":\"main-menu\",\"menu_position\":\"left\",\"toggle_effect\":\"fade\",\"stagger_direction\":\"right\",\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"right\"}","custom_header_content":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"center\"}"}}',
				],
				[
					'image' => kalium()->assets_url( 'admin/images/theme-options/custom-header-template-4.jpg' ),
					'name'  => 'Standard with combined content',
					'data'  => '{"other":{"headerType":"standard"},"data":{"custom_header_content_left":"{\"entries\":[{\"contentType\":\"search-field\",\"options\":{\"align\":\"left\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}","custom_header_content_right":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}},{\"contentType\":\"search-field\",\"options\":{\"align\":\"left\",\"skin\":\"inherit\",\"hide_on\":[]}},{\"contentType\":\"woocommerce-mini-cart\",\"options\":{\"align\":\"left\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"left\"}","custom_header_content":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}"}}',
				],
				[
					'image' => kalium()->assets_url( 'admin/images/theme-options/custom-header-template-5.jpg' ),
					'name'  => 'Standard with social networks',
					'data'  => '{"other":{"headerType":"standard"},"data":{"custom_header_content_left":"{\"entries\":[{\"contentType\":\"search-field\",\"options\":{\"align\":\"left\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}","custom_header_content_right":"{\"entries\":[{\"contentType\":\"social-networks\",\"options\":{\"style\":\"rounded-colored-hover\",\"display_structure\":\"icon\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"right\"}","custom_header_content":"{\"entries\":[{\"contentType\":\"main-menu\",\"options\":{\"submenu_dropdown_caret\":\"no\",\"skin\":\"inherit\",\"hide_on\":[]}}],\"alignment\":\"\"}"}}',
				],
			],

			'afold' => 'main_menu_type:custom-header',

			'tab_id' => 'header-settings-menu',
		];

		// ########## End of: Custom Header Builder ##########

		$of_options[] = [
			'name'  => 'تنظیمات فهرست بالا',
			'desc'  => "نمایش ابزارک های فهرست بالا (<a href=\"".admin_url('widgets.php')."\">مدیریت ابزارک ها</a>)",
			'id'    => 'menu_top_show_widgets',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,
			'afold' => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'  => 'وسط چین لینک های فهرست (تنها در سطح اول)',
			'id'    => 'menu_top_nav_links_center',
			'std'   => 0,
			'type'  => 'checkbox',
			'folds' => true,
			'afold' => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$menus_list = [
			'default' => '- فهرست اصلی (پیشفرض) -'
		];

		if ( is_admin() ) {
			$nav_menus = wp_get_nav_menus();

			foreach ( $nav_menus as $item ) {
				$menus_list["menu-{$item->term_id}"] = $item->name;
			}
		}

		$of_options[] = [
			'desc'    => 'انتخاب فهرست برای استفاده در فهرست بالا',
			'id'      => 'menu_top_menu_id',
			'std'     => 'default',
			'type'    => 'select',
			'options' => array_merge( $menus_list, [ '-' => '(فهرستی نمایش نده)' ] ),
			'afold'   => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'موارد فهرست در هر ردیف (برای تراز کردن)',
			'id'      => 'menu_top_items_per_row',
			'std'     => 'items-3',
			'type'    => 'select',
			'options' => [
				'items-1' => '1 مورد فهرست در هر ردیف',
				'items-2' => '2 مورد فهرست در هر ردیف',
				'items-3' => '3 مورد فهرست در هر ردیف',
				'items-4' => '4 مورد فهرست در هر ردیف',
				'items-5' => '5 مورد فهرست در هر ردیف',
				'items-6' => '6 مورد فهرست در هر ردیف',
				'items-7' => '7 مورد فهرست در هر ردیف',
				'items-8' => '8 مورد فهرست در هر ردیف',
			],
			'afold'   => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'عرض جعبه ابزارک',
			'id'      => 'menu_top_widgets_container_width',
			'std'     => 'col-6',
			'type'    => 'select',
			'options' => [
				'col-3' => '25٪ از عرض ردیف',
				'col-4' => '33٪ از عرض ردیف',
				'col-5' => '40٪ از عرض ردیف',
				'col-6' => '50٪ از عرض ردیف',
				'col-7' => '60٪ از عرض ردیف',
				'col-8' => '65٪ از عرض ردیف',
			],
			'fold'    => 'menu_top_show_widgets',
			'afold'   => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'تعداد ابزارک ها در هر ردیف را برای فهرست بالا تنظیم کنید',
			'id'      => 'menu_top_widgets_per_row',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				'six'   => '2 ابزارک در هر ردیف',
				'four'  => '3 ابزارک در هر ردیف',
				'three' => '4 ابزارک در هر ردیف',
			],
			'fold'    => 'menu_top_show_widgets',
			'afold'   => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'پالت رنگ برای این نوع فهرست را انتخاب کنید',
			'id'      => 'menu_top_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,
			'afold'   => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'  => "گنجاندن فهرست بالا در سربرگ
						<br>
						<small class=\"nowrap\">
							هنگامی که از فهرست بالا به عنوان فهرست اصلی استفاده نمی کنید، می توانید با فعال کردن این گزینه، آن را در سربرگ بگنجانید
							<br>
							این گزینه را فعال کنید زمانی که میخواهید این نوع فهرست بصورت جداگانه با کلیک کردن بر روی یک عنصر با کلاس <strong>top-menu-toggle.</strong> را نشان دهید.
						</small>",
			'id'    => 'menu_top_force_include',
			'std'   => 0,
			'type'  => 'checkbox',
			'folds' => true,
			'afold' => 'main_menu_type:top-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'name'  => 'تنظیمات فهرست سایدبار',
			'desc'  => "نمایش ابزارک های فهرست سایدبار (<a href=\"" . admin_url('widgets.php') . "\">مدیریت ابزارک ها</a>)",
			'id'    => 'menu_sidebar_show_widgets',
			'std'   => 1,
			'type'  => 'checkbox',
			'afold' => 'main_menu_type:sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'انتخاب فهرست برای استفاده در فهرست سایدبار',
			'id'      => 'menu_sidebar_menu_id',
			'std'     => 'default',
			'type'    => 'select',
			'options' => array_merge( $menus_list, [ '-' => '(فهرستی نمایش نده)' ] ),
			'afold'   => 'main_menu_type:sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'چیدمان سایدبار در نمایشگر مرورگر',
			'id'      => 'menu_sidebar_alignment',
			'std'     => 'right',
			'type'    => 'select',
			'options' => [
				'left'  => 'چپ',
				'right' => 'راست',
			],
			'fold'    => 'menu_top_show_widgets',
			'afold'   => 'main_menu_type:sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'    => 'پالت رنگ برای این نوع فهرست را انتخاب کنید',
			'id'      => 'menu_sidebar_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,
			'afold'   => 'main_menu_type:sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'desc'  => "گنجاندن فهرست سایدبار در سربرگ
										<br>
										<small class=\"nowrap\">
										هنگامی که از فهرست سایدبار به عنوان فهرست اصلی استفاده نمی کنید، می توانید با فعال کردن این گزینه، آن را در سربرگ بگنجانید
											<br>
											این گزینه را فعال کنید زمانی که میخواهید این نوع فهرست بصورت جداگانه با کلیک کردن بر روی یک عنصر با کلاس <strong>sidebar-menu-toggle.</strong> را نشان دهید.
										</small>",
			'id'    => 'menu_sidebar_force_include',
			'std'   => 0,
			'type'  => 'checkbox',
			'folds' => true,
			'afold' => 'main_menu_type:sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		$of_options[] = [
			'name' => 'متفرقه',
			'desc' => "نمایش کرکره کشویی برای مواردی که زیرفهرست دارند",
			'id'   => 'submenu_dropdown_indicator',
			'std'  => 0,
			'type' => 'checkbox',

			'afold' => 'main_menu_type:full-bg-menu,standard-menu,top-menu,sidebar-menu',

			'tab_id' => 'header-settings-menu',
		];

		// TOP HEADER BAR
		$of_options[] = [
			'name'   => 'Top Header Bar',
			'desc'   => 'Enable or disable header top header bar container',
			'id'     => 'top_header_bar',
			'std'    => 0,
			'on'     => 'Enable',
			'off'    => 'Disable',
			'type'   => 'switch',
			'folds'  => true,
			'afolds' => 1,

			'tab_id' => 'header-settings-top-bar',
		];

		// Top header bar content types
		$top_header_bar_content_types = [
			'none'                    => $custom_header_content_types['none'],
			'raw-text'                => $custom_header_content_types['raw-text'],
			'social-networks'         => $custom_header_content_types['social-networks'],
			'wpml-language-switcher'  => $custom_header_content_types['wpml-language-switcher'],
			'woocommerce-cart-totals' => 'WooCommerce Cart Totals' . $woocommerce_not_installed_text,
			'Menus'                   => $custom_header_content_types['Menus'],
		];

		$top_header_bar_sub_options = [];

		// Load sub options
		foreach ( array_keys( $top_header_bar_content_types ) as $widget_id ) {
			if ( isset( $custom_header_sub_options[ $widget_id ] ) ) {
				$top_header_bar_sub_options[ $widget_id ] = $custom_header_sub_options[ $widget_id ];
			}
		}

		// WooCommerce Cart Totals sub options
		$top_header_bar_sub_options['woocommerce-cart-totals'] = [
			[
				'type'  => 'select',
				'name'  => 'total_price',
				'title' => 'Total Price',
				'value' => [
					'cart-total'        => 'Cart total',
					'cart-subtotal'     => 'Cart subtotal',
					'cart-total-ex-tax' => 'Cart total ex. taxes',
				],
			],
			[
				'type'  => 'text',
				'name'  => 'text_before',
				'title' => 'Prepend Text',
			],
			[
				'type'    => 'select',
				'name'    => 'hide_empty',
				'title'   => 'Hide When Cart Is Empty',
				'value'   => [
					'yes' => 'Yes',
					'no'  => 'No',
				],
				'default' => 'no',
			],
			$sub_option_skin,
		];

		// Limit social networks styles for top header bar
		$top_header_bar_sub_options['social-networks'][0]['value'] = [
			'standard'      => 'Standard',
			'colored'       => 'Colored text',
			'colored-hover' => 'Colored text on hover',
		];

		// Left Content
		$of_options[] = [
			'name'    => 'Content Widgets',
			'desc'    => '',
			'id'      => 'top_header_bar_content_left',
			'std'     => '',
			'type'    => 'content_builder',
			'options' => $top_header_bar_content_types,
			'conf'    => [
				'maxEntries'  => 5,
				'title'       => 'Left Content',
				'alignField'  => true,
				'noItemsText' => 'Click to add top header bar content widgets',
				'subOptions'  => $top_header_bar_sub_options,
				'responsive'  => $sub_option_hide_on,
			],
			'fold'    => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];

		// Right Content
		$of_options[] = [
			'name'    => '',
			'desc'    => '',
			'id'      => 'top_header_bar_content_right',
			'std'     => '',
			'type'    => 'content_builder',
			'options' => $top_header_bar_content_types,
			'conf'    => [
				'title'        => 'Right Content',
				'maxEntries'   => 5,
				'alignField'   => true,
				'defaultAlign' => 'right',
				'noItemsText'  => 'Click to add top bar header content widgets',
				'subOptions'   => $top_header_bar_sub_options,
				'responsive'   => $sub_option_hide_on,
			],
			'fold'    => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];

		$of_options[] = [
			'name'    => 'Content Widgets Skin',
			'desc'    => 'Default skin to apply to content widget elements',
			'id'      => 'top_header_bar_default_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => $menu_type_skins,
			'fold'    => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];

		// Skin
		$of_options[] = [
			'name'    => 'Top Header Bar Style',
			'desc'    => "Set top header bar skin<br><small>{$note_str} Setting custom background or border color will overwrite colors from this option.</small>",
			'id'      => 'top_header_bar_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				'none'  => 'None',
				'light' => 'Light',
				'dark'  => 'Dark',
			],
			'fold'    => 'top_header_bar',
			'tab_id'  => 'header-settings-top-bar',
		];

		// Background color
		$of_options[] = [
			'desc'   => 'Set background color for top header bar',
			'id'     => 'top_header_bar_background_color',
			'std'    => '',
			'type'   => 'color',
			'fold'   => 'top_header_bar',
			'tab_id' => 'header-settings-top-bar',
		];

		// Bottom border color
		$of_options[] = [
			'desc'   => 'Set bottom border color for top header bar',
			'id'     => 'top_header_bar_border_color',
			'std'    => '',
			'type'   => 'color',
			'fold'   => 'top_header_bar',
			'tab_id' => 'header-settings-top-bar',
		];

		// Separators
		$of_options[] = [
			'desc'   => 'Set content elements separator color<br><small>' . $note_str . ' Leaving blank will not add content separators.</small>',
			'id'     => 'top_header_bar_separator_color',
			'std'    => '',
			'type'   => 'color',
			'fold'   => 'top_header_bar',
			'tab_id' => 'header-settings-top-bar',
		];

		// Responsive Settings
		$of_options[] = [
			'name' => 'Responsive Settings',
			'desc' => "Top header bar in desktop screens",
			'id'   => 'top_header_bar_support_desktop',
			'std'  => 1,
			'on'   => 'Visible',
			'off'  => 'Hidden',
			'type' => 'switch',
			'fold' => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];

		$of_options[] = [
			'desc' => "Top header bar in tablet screens",
			'id'   => 'top_header_bar_support_tablet',
			'std'  => 0,
			'on'   => 'Visible',
			'off'  => 'Hidden',
			'type' => 'switch',
			'fold' => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];

		$of_options[] = [
			'desc' => "Top header bar in mobile screens",
			'id'   => 'top_header_bar_support_mobile',
			'std'  => 0,
			'on'   => 'Visible',
			'off'  => 'Hidden',
			'type' => 'switch',
			'fold' => 'top_header_bar',

			'tab_id' => 'header-settings-top-bar',
		];
		// END OF: TOP HEADER BAR

		$of_options[] = [
			'name'   => 'Sticky Header',
			'desc'   => 'Enable or disable sticky header entirely',
			'id'     => 'sticky_header',
			'std'    => 0,
			'on'     => 'Enable',
			'off'    => 'Disable',
			'type'   => 'switch',
			'afolds' => 1,

			'tab_id' => 'header-settings-sticky-header',
		];

		// Sticky Header: Styling Options
		$of_options[] = [
			'name'  => 'تنظیمات سبک و طراحی',
			'desc'  => 'اعمال رنگ پس زمینه هنگامی که سربرگ چسبنده فعال است',
			'id'    => 'sticky_header_background_color',
			'std'   => '',
			'type'  => 'color',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => "اعمال فاصله عمودی زمانی که هدر چسبنده فعال است<br /><small><span class=\"note\">{$note_str}</span> فاصله از بالا و پایین سربرگ لوگو/فهرست.</small>",
			'id'      => 'sticky_header_vertical_padding',
			'plc'     => 'اگر نمی خواهید اندازه را تغییر دهید، خالی بگذارید',
			'std'     => '10',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'afold'   => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => 'طرح فهرست را انتخاب کنید زمانی که سربرگ چسبنده فعال است',
			'id'      => 'sticky_header_skin',
			'std'     => '',
			'type'    => 'select',
			'options' => array_merge( [ '' => 'طرح فهرست را عوض نکن' ], $menu_type_skins ),
			'afold'   => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'  => "حاشیه پایین و سایه<br><small>{$note_str} حاشیه پایین و/یا سایه را برای فهرست چسبنده اعمال کنید.</small>",
			'id'    => 'sticky_header_border',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => true,

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$width_in_pixels = [];
		$blur_in_pixels  = [];

		for ( $i = 0; $i <= 30; $i ++ ) {
			$width_in_pixels[] = $i . 'px';
		}

		for ( $i = 0; $i <= 60; $i ++ ) {
			$blur_in_pixels[] = $i . 'px';
		}

		$border_apply_when_options = [
			'always'          => 'همیشه',
			'sticky-active'   => 'فقط زمانی که سربرگ چسبنده فعال است',
			'sticky-inactive' => 'فقط زمانی که سربرگ چسبنده فعال نیست',
		];

		$of_options[] = [
			'name' => 'حاشیه',
			'desc' => 'حاشیه رنگی (اختیاری)',
			'id'   => 'sticky_header_border_color',
			'std'  => '',
			'type' => 'color',
			'fold' => 'sticky_header_border',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => 'عرض حاشیه',
			'id'      => 'sticky_header_border_width',
			'std'     => '1px',
			'type'    => 'select',
			'options' => $width_in_pixels,
			'fold'    => 'sticky_header_border',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'name' => 'سایه',
			'desc' => 'سایه رنگی (اختیاری)',
			'id'   => 'sticky_header_shadow_color',
			'std'  => '',
			'type' => 'color',
			'fold' => 'sticky_header_border',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => 'عرض سایه',
			'id'      => 'sticky_header_shadow_width',
			'std'     => '',
			'type'    => 'select',
			'options' => $width_in_pixels,
			'fold'    => 'sticky_header_border',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => 'شعاع تاری',
			'id'      => 'sticky_header_shadow_blur',
			'type'    => 'select',
			'options' => $blur_in_pixels,
			'fold'    => 'sticky_header_border',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		// ! Sticky Header : Autohide Settings
		$of_options[] = [
			'name'  => 'پنهان شدن خودکار فهرست چسبنده',
			'desc'  => "فعال یا غیرفعال کردن پنهان شدن خودکار فهرست چسبنده<br><small>{$note_str} فقط وقتی که کاربران به سمت بالا می روند، سربرگ چسبنده نمایش داده می شود.</small>",
			'id'    => 'sticky_header_autohide',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => "مدت زمان نمایش/عدم نمایش بر ثانیه",
			'id'      => 'sticky_header_autohide_duration',
			'plc'     => '0.3',
			'std'     => '',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 's',

			'fold'  => 'sticky_header_autohide',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc' => "نوع انیمیشن",
			'id'   => 'sticky_header_autohide_animation_type',
			'std'  => 'slide',
			'type' => 'select',

			'options' => [
				'fade'              => 'فقط محو شود',
				'slide'             => 'اسلاید از بالا',
				'fade-slide-top'    => 'محو شدن و اسلاید از بالا',
				'fade-slide-bottom' => 'محو شدن و اسلاید از پایین',
			],

			'fold'  => 'sticky_header_autohide',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		// ! Sticky Header : Logo Settings
		$of_options[] = [    #'name'		=> 'Upload Logo',
			'name'  => 'تنظیمات لوگو',
			'desc'  => "استفاده از لوگو سفارشی هنگامی که سربرگ چسبنده فعال است",
			'id'    => 'sticky_header_logo',
			'std'   => "",
			'type'  => 'media',
			'mod'   => 'min',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => "عرض لوگو در حالت چسبنده<br><small>{$note_str} عرض لوگو سفارشی زمانی که سربرگ چسبنده فعال است.</small>",
			'id'      => 'sticky_header_logo_width',
			'plc'     => 'عرض پیش فرض لوگو',
			'std'     => '',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		// ! Sticky Header : Other Settings
		$of_options[] = [
			'name'  => 'تنظیمات دیگر',
			'desc'  => "انیمیشن دار کردن سربرگ چسبنده هنگام اسکرول<br><small>{$note_str} اگر فعال باشد، سبک سربرگ چسبنده با چرخ اسکرول به انیمیشن درخواهد آمد.</small>",
			'id'    => 'sticky_header_animate_duration',
			'std'   => 0,
			'on'    => 'خیر',
			'off'   => 'بله',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'sticky_header:checked',

			'reverse' => true, // Reverse switch

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => "مدت زمان انیمیشن در ثانیه<br><small><small>توجه</small>:اعمال شده برای  سربرگ هنگامی که سبک چسبنده به عقب و جلو تعویض میشود.</small>",
			'id'      => 'header_sticky_duration',
			'plc'     => 'برای استفاده از پیشفرض خالی بگذارید',
			'std'     => '',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 's',

			'fold'  => 'sticky_header_animate_duration',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'    => "افست اولیه<br><small>{$note_str} موقعیت اسکرول هنگامی که استایل های سربرگ چسبنده شروع به انجام انیمیشن میکند.</small>",
			'id'      => 'header_sticky_initial_offset',
			'plc'     => '10',
			'std'     => '10',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'afold'   => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc' => "زنجیره انیمیشن<br><small>{$note_str} تنظیم ترتیب انیمیشن ها برای  سربرگ هنگامی که سبک چسبنده به عقب و جلو تعویض میشود.</small>",
			'id'   => 'sticky_header_animation_chaining',
			'std'  => 'all',
			'type' => 'select',

			'options' => [
				'all'             => 'همه باهم',
				'padding-bg_logo' => 'فاصله -> پس زمینه، لوگو',
				'bg_logo-padding' => 'پس زمینه، لوگو -> فاصله',

				'logo_padding-bg' => 'لوگو، فاصله -> پس زمینه',
				'bg-logo_padding' => 'پس زمینه -> لوگو، فاصله',

				'padding-bg-logo' => 'فاصله -> پس زمینه -> لوگو',
				'bg-logo-padding' => 'پس زمینه -> لوگو -> فاصله',
				'logo-bg-padding' => 'لوگو -> پس زمینه -> فاصله',
				'bg-padding-logo' => 'پس زمینه -> فاصله -> لوگو',
			],

			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'  => "Tween changes with scroll (transition smoothly)<br><small>{$note_str} Applied when <strong>Animate sticky header on scroll progress</strong> is set to <strong>Yes</strong>.</small>",
			'id'    => 'sticky_header_tween_changes',
			'std'   => 0,
			'on'    => 'Yes',
			'off'   => 'No',
			'type'  => 'switch',
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		// ! Sticky Header : Responsive Settings
		$of_options[] = [
			'name'  => 'تنظیمات ریسپانسیو (واکنش گرا)',
			'desc'  => "Sticky header in desktop screens",
			'id'    => 'sticky_header_support_desktop',
			'std'   => 1,
			'on'    => 'فعال',
			'off'   => 'غیرفعال',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'  => "سربرگ چسبنده در صفحات تبلت",
			'id'    => 'sticky_header_support_tablet',
			'std'   => 1,
			'on'    => 'فعال',
			'off'   => 'غیرفعال',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		$of_options[] = [
			'desc'  => "سربرگ چسبنده در صفحات موبایل",
			'id'    => 'sticky_header_support_mobile',
			'std'   => 1,
			'on'    => 'فعال',
			'off'   => 'غیرفعال',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'sticky_header:checked',

			'tab_id' => 'header-settings-sticky-header',
		];

		/*$of_options[] = array(	'desc'   	=> "Sticky menu on Mobile Mode<br><small>{$note_str} Enable or disable sticky menu on mobile.</small>",
						'id'   		=> 'header_sticky_mobile',
						'std'   	=> 1,
						'on' 		=> 'Yes',
						'off' 		=> 'No',
						'type'   	=> 'switch',
						'folds'  	=> 1,
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
					);

$of_options[] = array(	'desc'   	=> "Auto-Hide Mode<br><small>{$note_str} Only show sticky menu when users scrolls upside.</small>",
						'id'   		=> 'header_sticky_autohide',
						'std'   	=> 0,
						'on' 		=> 'Yes',
						'off' 		=> 'No',
						'type'   	=> 'switch',
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
					);

$of_options[] = array( 	'name'		=> 'Styling Options',
						'desc' 		=> 'You can apply background color when sticky menu is active',
						'id' 		=> 'header_sticky_bg',
						'std' 		=> '',
						'type' 		=> 'color',
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array(	'desc' 		=> "Vertical padding when sticky is active<br /><small>{$note_str} Padding above and below the header logo/menu.</small>",
						'id' 		=> 'header_sticky_vpadding',
						'plc' 		=> 'Leave empty if you don\'t want to change the size',
						'std'		=> '10',
						'type' 		=> 'text',
						'numeric'	=> true,
						'postfix'	=> 'px',
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'Select menu skin to use when sticky menu is active',
						'id' 		=> 'sticky_header_skin',
						'std' 		=> '',
						'type' 		=> 'select',
						'options'	=> array_merge(array('' => 'Use Default'), $menu_type_skins),
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array(	'desc'   	=> "Bottom Border and Shadow<br><small>{$note_str} Apply bottom border and/or shadow for sticky menu.</small>",
						'id'   		=> 'sticky_header_border',
						'std'   	=> 0,
						'on' 		=> 'Yes',
						'off' 		=> 'No',
						'type'   	=> 'switch',
						'folds'		=> true,

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
					);

$width_in_pixels = array();
$blur_in_pixels = array();

for ( $i = 0; $i <= 30; $i++ ) {
	$width_in_pixels[] = $i . 'px';
}

for ( $i = 0; $i <= 60; $i++ ) {
	$blur_in_pixels[] = $i . 'px';
}

$border_apply_when_options = array(
	'always'           => 'Always',
	'sticky-active'    => 'Only when sticky menu is active',
	'sticky-inactive'  => 'Only when sticky menu is not active',
);

$of_options[] = array( 	'name'		=> 'Border',
						'desc' 		=> 'Border color (optional)',
						'id' 		=> 'sticky_header_border_color',
						'std' 		=> '',
						'type' 		=> 'color',
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'Border width',
						'id' 		=> 'sticky_header_border_width',
						'std' 		=> '1px',
						'type' 		=> 'select',
						'options'	=> $width_in_pixels,
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'When to apply the border',
						'id' 		=> 'sticky_header_border_apply_when',
						'std' 		=> 'sticky-active',
						'type' 		=> 'select',
						'options'	=> $border_apply_when_options,
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'name'		=> 'Shadow',
						'desc' 		=> 'Shadow color (optional)',
						'id' 		=> 'sticky_header_shadow_color',
						'std' 		=> '',
						'type' 		=> 'color',
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'Shadow width',
						'id' 		=> 'sticky_header_shadow_width',
						'std' 		=> '',
						'type' 		=> 'select',
						'options'	=> $width_in_pixels,
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'Blur radius',
						'id' 		=> 'sticky_header_shadow_blur',
						'type' 		=> 'select',
						'options'	=> $blur_in_pixels,
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array( 	'desc' 		=> 'When to apply the border',
						'id' 		=> 'sticky_header_shadow_apply_when',
						'std' 		=> 'sticky-active',
						'type' 		=> 'select',
						'options'	=> $border_apply_when_options,
						'fold' 		=> 'sticky_header_border',

						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);

$of_options[] = array(	'name'		=> 'Custom Logo',
						'desc'   	=> 'Switch to custom logo when sticky menu is active (optional)',
						'id'   		=> 'header_sticky_custom_logo',
						'std'   	=> 0,
						'on'  		=> 'Yes',
						'off'  		=> 'No',
						'type'   	=> 'switch',
						'folds'  	=> 1,
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
					);

$of_options[] = array(	#'name'		=> 'Upload Logo',
						'desc' 		=> "Upload/choose your custom logo image for sticky menu",
						'id' 		=> 'header_sticky_logo_image_id',
						'std' 		=> "",
						'type' 		=> 'media',
						'mod' 		=> 'min',
						'fold' 		=> 'header_sticky_custom_logo',
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
					);

$of_options[] = array( 	'desc' 		=> "Set maximum width for the uploaded logo, mostly used when you use retina (@2x) logo<br /><small>{$note_str} Even if you don't upload custom logo, you may set custom width for the current logo in sticky menu.</small>",
						'id' 		=> 'header_sticky_logo_width',
						'std' 		=> "",
						'plc'		=> 'Custom Logo Width for Sticky Menu',
						'type' 		=> 'text',
						'postfix'	=> 'px',
						'numeric'	=> true,
						//'fold' 		=> 'header_sticky_custom_logo',
						'afold' 	=> 'sticky_header:checked',

						'tab_id'	=> 'header-settings-sticky-header',
				);
	*/

		$of_options[] = [
			'name' => 'Footer',
			'type' => 'heading',
			'icon' => 'icon-footer'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'footer-tabs',
			'tabs' => [
				'footer-general' => 'تنظیمات عمومی',
				'footer-widgets' => 'ابزارک های پاورقی',
			]
		];

		$of_options[] = [
			'name' => 'پدیداری پاورقی',
			'desc' => 'نمایان یا پنهان کردن پاورقی',
			'id'   => 'footer_visibility',
			'std'  => 1,
			'on'   => 'نمایان',
			'off'  => 'پنهان',
			'type' => 'switch',

			'afolds' => true,

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'desc' => 'رنگ پس زمینه را تنظیم کنید. برای پس زمینه شفاف خالی بگذارید',
			'id'   => 'footer_bg',
			'std'  => '#eeeeee',
			'type' => 'color',
			'fold' => 'footer_bg_transparent',

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'name'    => 'تنظیمات پاورقی',
			'desc'    => 'نوع پاورقی<br><small>' . $note_str . ' این تنظیمات پاورقی را به پایین صفحه میچسباند.</small>',
			'id'      => 'footer_fixed',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				''            => 'معمولی',
				'fixed'       => 'چسبیده به پایین (بدون انیمیشن)',
				'fixed-fade'  => 'چسبیده به پایین (انیمیشن محو)',
				'fixed-slide' => 'چسبیده به پایین (انیمیشن اسلاید)',
			],

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'desc'    => 'رنگ نوشته<br><small>' . $note_str . ' رنگ متن پاورقی را انتخاب کنید، رنگ پیش فرض طبق رنگ پوسته قالب است.</small>',
			'id'      => 'footer_style',
			'std'     => '',
			'type'    => 'select',
			'options' => [
				''         => 'پیش فرض (بر اساس پوسته فعلی)',
				'inverted' => 'سفید',
			],

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'desc'  => "پاورقی تمام صفحه<br><small>گسترش جعبه پاورقی تا لبه مرورگر.</small>",
			'id'    => 'footer_fullwidth',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'name'    => 'طرح پاورقی',
			'desc'    => 'انتخاب کنید کدام نوع از پاورقی را میخواهید استفاده کنید',
			'id'      => 'footer_bottom_style',
			'std'     => 'horizontal',
			'type'    => 'images',
			'options' => [
				'horizontal' => kalium()->assets_url( 'admin/images/theme-options/footer-style-horizontal.png' ),
				'vertical'   => kalium()->assets_url( 'admin/images/theme-options/footer-style-vertical.png' ),
			],
			'descrs'  => [
				'horizontal' => 'ستون دار',
				'vertical'   => 'وسط چین',
			],
			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'name'  => 'بخش پایینی پاورقی',
			'desc'  => 'فعال یا غیرفعال کردن قسمت پایین پاورقی شامل متن کپی رایت',
			'id'    => 'footer_bottom_visible',
			'std'   => 1,
			'on'    => 'پنهان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'name' => 'متن پاورقی',
			'desc' => 'پاورقی چپ - متن کپی رایت در پاورقی',
			'id'   => 'footer_text',
			'std'  => "&copy; کپی رایت ".date('Y').'تمام حقوق محفوظ است',
			'type' => 'textarea',
			'fold' => 'footer_bottom_visible',

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'desc' => 'پاورقی راست - محتوا برای بلوک راست در پاورقی<br><small>' . $note_str . ' شما همچنین می توانید شبکه های اجتماعی را در متن پاورقی اضافه کنید
, مثال:<br> ' . $lab_social_networks_shortcode . '</small>',
			'id'   => 'footer_text_right',
			'std'  => "[lab_social_networks]",
			'type' => 'textarea',
			'fold' => 'footer_bottom_visible',

			'afold' => 'footer_visibility:checked',

			'tab_id' => 'footer-general',
		];

		$of_options[] = [
			'name'  => 'ابزارک های پاورقی',
			'desc'  => 'نمایان یا پنهان کردن ابزارک های پاورقی',
			'id'    => 'footer_widgets',
			'std'   => 0,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'footer-widgets',
		];

		$of_options[] = [
			'desc'    => 'تعداد ستون را برای تقسیم ابزارک ها تنظیم کنید',
			'id'      => 'footer_widgets_columns',
			'std'     => 'three',
			'type'    => 'select',
			'options' => [
				'one'   => '1 ابزارک در هر ردیف',// (1/1)",
				'two'   => '2 ابزارک در هر ردیف',// (1/2)",
				'three' => '3 ابزارک در هر ردیف',// (1/3)",
				'four'  => '4 ابزارک در هر ردیف',// (1/4)",
				'five'  => '5 ابزارک در هر ردیف',// (1/5)",
				'six'   => '6 ابزارک در هر ردیف',// (1/6)"
			],
			'fold'    => 'footer_widgets',

			'tab_id' => 'footer-widgets',
		];

		$of_options[] = [
			'desc' =>  "جمع یا بازکردن ابزارک های پاورقی در دستگاه های تلفن همراه<br><small>{$note_str} کاربران هنوز میتوانند ابزارک های پاورقی را ببینند (اگر جمع شده باشد) هنگام کلیک روی لینک <strong>سه نقطه (...)</strong></small>",
			'id'   => 'footer_collapse_mobile',
			'std'  => 0,
			'on'   => 'جمع شده',
			'off'  => 'باز شده',
			'type' => 'switch',
			'fold' => 'footer_widgets',

			'tab_id' => 'footer-widgets',
		];


		// BLOG SETTINGS
		$of_options[] = [
			'name' => 'Blog Settings',
			'type' => 'heading',
			'icon' => 'icon-blog-settings'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'blog-settings-tabs',
			'tabs' => [
				'blog-settings-loop'    => 'صفحه بلاگ',
				'blog-settings-single'  => 'صفحه تک',
				'blog-settings-sharing' => 'تنظیمات اشتراک گذاری',
				'blog-settings-other'   => 'تنظیمات دیگر',
			]
		];

		$of_options[] = [
			'name'  => "عنوان و توضیحات بلاگ",
			'desc'  => 'نمایش سربرگ عنوان و توضیحات در صفحه بلاگ',
			'id'    => 'blog_show_header_title',
			'std'   => 1,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'blog-settings-other',
		];

		$of_options[] = [
			'desc' => 'عنوان سربرگ بلاگ (اختیاری)',
			'id'   => 'blog_title',
			'std'  => 'بلاگ',
			'plc'  => "",
			'type' => 'text',
			'fold' => 'blog_show_header_title',

			'tab_id' => 'blog-settings-other',
		];

		$of_options[] = [
			'desc' => 'توضیحات سربرگ بلاگ (اختیاری)',
			'id'   => 'blog_description',
			'std'  => 'افکار روزمره ما در اینجا ارائه شده است'.PHP_EOL."موسیقی، نمایش ویدئو، عکسبرداری و بیشتر",
			'plc'  => "",
			'type' => 'textarea',
			'type' => 'textarea',
			'fold' => 'blog_show_header_title',

			'tab_id' => 'blog-settings-other',
		];

		$of_options[] = [
			'name'    => 'قالب پیشفرض بلاگ',
			'desc'    => 'قالب بلاگ مورد نظر خود را برای نمایش مطالب بلاگ انتخاب کنید',
			'id'      => 'blog_template',
			'std'     => 'blog-squared',
			'options' => [

				'blog-squared' => kalium()->assets_url( 'admin/images/theme-options/blog-template-squared.png' ),
				'blog-rounded' => kalium()->assets_url( 'admin/images/theme-options/blog-template-rounded.png' ),
				'blog-masonry' => kalium()->assets_url( 'admin/images/theme-options/blog-template-masonry.png' ),
			],
			'descrs'  => [
				'blog-squared' => 'کلاسیک',
				'blog-rounded' => 'گرد',
				'blog-masonry' => 'بنائی',
			],
			'type'    => 'images',
			'afolds'  => true,

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'name'    => 'سایدبار',
			'desc'    => "موقعیت سایدبار بلاگ را تنظیم یا پنهان کنید",
			'id'      => 'blog_sidebar_position',
			'std'     => 'right',
			'type'    => 'select',
			'options' => $show_sidebar_options,

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'name' => 'تنظیمات بلاگ',
			'desc' => 'نمایش تصاویر بندانگشتی مطلب',
			'id'   => 'blog_thumbnails',
			'std'  => 1,
			'type' => 'checkbox',

			'folds' => true,

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'Show thumbnail placeholders<br><small>If there is no featured image, gray image will be shown.</small>',
			'id'   => 'blog_thumbnails_placeholder',
			'std'  => 1,
			'type' => 'checkbox',

			'fold' => 'blog_thumbnails',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش فرمت آیکون مطلب',
			'id'   => 'blog_post_type_icon',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش فرمت محتوای مطلب',
			'id'   => 'blog_post_formats',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش عنوان مطلب',
			'id'   => 'blog_post_title',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش چکیده مطلب',
			'id'   => 'blog_post_excerpt',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش تاریخ مطلب',
			'id'   => 'blog_post_date',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'نمایش دسته بندی مطلب',
			'id'   => 'blog_category',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc' => 'استفاده از ارتفاع نسبی تصاویر بندانگشتی',
			'id'   => 'blog_loop_proportional_thumbnails',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'مطالب در هر ردیف<br><small>' . $note_str . ' اعمال شده فقط برای نوع بنائی بلاگ</small>',
			'id'      => 'blog_columns',
			'std'     => '_3',
			'options' => [
				'_1' => '1 مطلب در هر ردیف',
				'_2' => '2 مطلب در هر ردیف',
				'_3' => '3 مطلب در هر ردیف',
				'_4' => '4 مطلب در هر ردیف'
			],
			'type'    => 'select',

			'afold'  => 'blog_template:blog-masonry',
			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'چیدمان عمودی<br><small>' . $note_str . ' Set alignment of posts between rows.</small>',
			'id'      => 'blog_masonry_layout_mode',
			'std'     => 'packery',
			'options' => [
				'packery'  => 'بنائی',
				'fit-rows' => 'ردیف های فیت',
			],
			'type'    => 'select',

			'afold'  => 'blog_template:blog-masonry',
			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => "Columns gap<br><small>{$note_str} Set custom spacing for post columns.</small>",
			'id'      => 'blog_masonry_columns_gap',
			'std'     => "",
			'plc'     => 'Default gap: 30 pixels',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',

			'afold'  => 'blog_template:blog-masonry',
			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'Thumbnail hover effect',
			'id'      => 'blog_thumbnail_hover_effect',
			'std'     => 'full-cover',
			'options' => [
				'' => 'بدون hover افکت',

				'distanced'            => 'پوشش فاصله دار (نیمه شفاف)',
				'distanced-no-opacity' => 'پوشش فاصله دار',

				'full-cover'            => 'پوشش کامل (نیمه شفاف)',
				'full-cover-no-opacity' => 'پوشش کامل',
			],
			'type'    => 'select',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'آیکون لایه hover تصویر بندانگشتی',
			'id'      => 'blog_post_hover_layer_icon',
			'std'     => kalium_get_theme_option( 'blog_post_hover_animatd_eye' ) ? 'animated-eye' : 'static-eye',
			'type'    => 'select',
			'options' => [
				'none'         => 'هیچکدام',
				'static-eye'   => 'آیکون چشم ثابت',
				'animated-eye' => 'آیکون چشم انیمیشن دار',
				'custom'       => 'آیکون سفارشی'
			],
			'afolds'  => true,

			'tab_id' => 'blog-settings-loop'
		];

		$of_options[] = [
			'name' => 'آیکون لایه hover سفارشی',
			'desc' => 'آیکون لایه hover سفارشی را انتخاب کنید',
			'id'   => 'blog_post_hover_layer_icon_custom',
			'std'  => "",
			'type' => 'media',
			'mod'  => 'min',

			'afold' => 'blog_post_hover_layer_icon:custom',

			'tab_id' => 'blog-settings-loop'
		];

		$of_options[] = [
			'desc'    => "عرض آیکون hover سفارشی",
			'id'      => 'blog_post_hover_layer_icon_custom_width',
			'std'     => "",
			'plc'     => '',
			'type'    => 'text',
			'postfix' => 'px',

			'afold' => 'blog_post_hover_layer_icon:custom',

			'tab_id' => 'blog-settings-loop'
		];

		$of_options[] = [
			'name'    => 'صفحه بندی',
			'desc'    => 'نوع صفحه بندی را انتخاب کنید',
			'id'      => 'blog_pagination_type',
			'std'     => 'center',
			'type'    => 'select',
			'options' => [
				'normal'         => 'صفحه بندی معمولی',
				'endless'        => 'اسکرول بینهایت',
				'endless-reveal' => "اسکرول بینهایت + ظاهرسازی خودکار"
			],

			'afolds' => true,

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'سبک صفحه بندی برای اسکرول بینهایت هنگام بارگذاری',
			'id'      => 'blog_endless_pagination_style',
			'std'     => '_1',
			'type'    => 'select',
			'options' => $endless_pagination_style,

			'afold' => 'blog_pagination_type:endless,endless-reveal',

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'desc'    => 'تنظیم موقعیت صفحه بندی',
			'id'      => 'blog_pagination_position',
			'std'     => 'center',
			'type'    => 'select',
			'options' => [
				'left'      => 'چپ',
				'center'    => 'وسط',
				'right'     => 'راست',
				'stretched' => 'کشیده شده'
			],

			'tab_id' => 'blog-settings-loop',
		];

		$of_options[] = [
			'name' => 'تنظیمات مطلب',
			'desc' => 'نمایش تصویر شاخص',
			'id'   => 'blog_single_thumbnails',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc' => 'نمایش عنوان مطلب',
			'id'   => 'blog_single_title',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'  => 'نمایش اطلاعات نویسنده',
			'id'    => 'blog_author_info',
			'std'   => 0,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc' => 'نمایش تاریخ مطلب',
			'id'   => 'blog_post_date_single',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc' => 'نمایش دسته بندی مطلب',
			'id'   => 'blog_category_single',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc' => 'نمایش برچسب های مطلب',
			'id'   => 'blog_tags',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc' => 'نمایش لینک بعدی-قبلی مطلب',
			'id'   => 'blog_post_prev_next',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => 'سطح تصویر شاخص',
			'id'      => 'blog_featured_image_placement',
			'std'     => 'container',
			'options' => [
				'container'  => 'جعبه ای',
				'full-width' => 'تمام عرض',
			],
			'type'    => 'select',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => 'اندازه تصویر شاخص',
			'id'      => 'blog_featured_image_size_type',
			'std'     => 'default',
			'options' => [
				'default' => 'اندازه پیشفرض تصویر بندانگشتی',
				'full'    => 'اندازه تصویر اصلی',
			],
			'type'    => 'select',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => 'جایگاه اطلاعات نویسنده',
			'id'      => 'blog_author_info_placement',
			'std'     => 'left',
			'options' => [
				'left'   => 'چپ',
				'right'  => 'راست',
				'bottom' => 'زیر مطلب',
			],
			'type'    => 'select',
			'fold'    => 'blog_author_info',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => 'پدیداری نظرات مطلب بلاگ',
			'id'      => 'blog_comments',
			'std'     => 'show',
			'options' => [
				'show' => 'نمایش نظرات',
				'hide' => 'پنهان کردن نظرات',
			],
			'type'    => 'select',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => "عرض تصویر شاخص بندانگشتی (فقط در مطلب تک اعمال میشود). اگر این مقدار را تغییر دهید باید دوباره<a href=\"admin.php؟page=laborator-docs#regenerate-thumbnails\" target=\"_blank\"> تصاویر بندانگشتی را بازسازی کنید </a>",
			'id'      => 'blog_thumbnail_height',
			'std'     => "",
			'plc'     => 'مقدار پیشفرض تنظیم میشود اگر خالی باشد: 490',
			'type'    => 'text',
			'numeric' => true,

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'desc'    => 'مدت تعویض خودکار برای تصاویر گالری<br><small>' . $note_str . ' برای غیرفعال کردن تعویض خودکار خالی بگذارید</small>',
			'id'      => 'blog_gallery_autoswitch',
			'std'     => "",
			'plc'     => 'بدون تعویض خودکار',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 's',

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'name'    => 'سایدبار',
			'desc'    => "تنظیم موقعیت سایدبار در مطلب تک یا پنهان کردن آن<br><small>{$note_str} اطلاعات نویسنده زیر مطلب قرار میگیرد (اگر روی نمایش تنظیم شود)</small>",
			'id'      => 'blog_single_sidebar_position',
			'std'     => 'hide',
			'type'    => 'select',
			'options' => $show_sidebar_options,

			'tab_id' => 'blog-settings-single',
		];

		$of_options[] = [
			'name'  => 'اشتراک گذاری',
			'desc'  => 'فعال یا غیرفعال کردن اشتراک گذاری مطالب بلاگ در شبکه های اجتماعی',
			'id'    => 'blog_share_story',
			'std'   => 0,
			'on'    => 'اجازه به اشتراک گذاشتن',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'blog-settings-sharing'
		];

		$share_story_networks = [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter',
				'lin'     => 'LinkedIn',
				'tlr'     => 'Tumblr',
			],

			'hidden' => [
				'placebo' => 'placebo',
				'pi'      => 'Pinterest',
				'em'      => 'Email',
				'vk'      => 'VKontakte',
				'wa'      => 'WhatsApp',
			],
		];

		$of_options[] = [
			'name' => 'اشتراک گذاری در:',
			'desc' =>  'شبکه های اجتماعی که کاربران میتوانند مطلب بلاگ شما را در آن به اشتراک بگذارند انتخاب کنید',
			'id'   => 'blog_share_story_networks',
			'std'  => $share_story_networks,
			'type' => 'sorter',
			'fold' => 'blog_share_story',

			'tab_id' => 'blog-settings-sharing'
		];

		$of_options[] = [
			'name' => 'تنظیمات لینک های اشتراک گذاری',
			'desc' => 'آیکون های گرد',
			'id'   => 'blog_share_story_rounded_icons',
			'std'  => 0,
			'type' => 'checkbox',
			'fold' => 'blog_share_story',

			'tab_id' => 'blog-settings-sharing'
		];
		// END OF BLOG SETTINGS


		// PORTFOLIO SETTINGS
		$of_options[] = [
			'name' => 'Portfolio Settings',
			'type' => 'heading',
			'icon' => 'icon-portfolio-settings'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'portfolio-settings-tabs',
			'tabs' => [
				'portfolio-settings-layout'   => 'لایه بندی نمونه کارها',
				'portfolio-settings-loop'     => 'صفحه نمونه کارها',
				'portfolio-settings-single'   => 'صفحه تک',
				'portfolio-settings-lightbox' => 'تنظیمات لایت باکس',
				'portfolio-settings-sharing'  => 'تنظیمات اشتراک گذاری',
				'portfolio-settings-other'    => 'دیگر تنظیمات',
			]
		];

		$of_options[] = [
			'name'    => 'نوع لایه بندی نمونه کارها',
			'desc'    => "انتخاب یک نوع پیشفرض برای نمایش نمونه کارها<br /><small>{$note_str} شما می توانید این تنظیم را برای صفحات نمونه کارهای شخصی بازنویسی کنید.</small><br><br>",
			'id'      => 'portfolio_type',
			'std'     => 'type-1',
			'type'    => 'images',
			'options' => [
				'type-1' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-1.png' ),
				'type-2' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-2.png' ),
				'type-3' => kalium()->assets_url( 'admin/images/portfolio/portfolio-type-3.png' ),
			],
			'descrs'  => [
				'type-1' => 'عنوان های قابل مشاهده',
				'type-2' => 'عنوان های داخلی',
				'type-3' => 'عنوان های داخلی + لایه بندی بنائی',
			],
			'afolds'  => 1,

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name'  => 'تنظیمات عنوان های قابل مشاهده',
			'desc'  => 'استفاده از اندازه تصویر نسبی (نه بریده شده)',
			'id'    => 'portfolio_type_1_dynamic_height',
			'std'   => 0,
			'type'  => 'checkbox',
			'afold' => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'تعداد ستون ها برای نوع نمایش فعلی',
			'id'      => 'portfolio_type_1_columns_count',
			'std'     => '4',
			'type'    => 'select',
			'options' => [
				'1'  => '1 مورد در هر ردیف',
				'2'  => '2 مورد در هر ردیف',
				'3'  => '3 مورد در هر ردیف',
				'4'  => '4 مورد در هر ردیف',
				'5'  => '5 مورد در هر ردیف',
				'6'  => '6 مورد در هر ردیف',
			],
			'afold'   => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => "Default item spacing",
			'id'      => 'portfolio_type_1_default_spacing',
			'std'     => "",
			'plc'     => 'Default spacing: 30',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'afold'   => "portfolio_type:type-1",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => "تعداد موارد نمونه کارها بر صفحه برای این نوع<br><small>{$note_str} برای نمایش تمامی نمونه کارها در یک صفحه از مقدار <strong>-1</strong> استفاده کنید.</small>",
			'id'      => 'portfolio_type_1_items_per_page',
			'std'     => "",
			'plc'     => '(برای استفاده از پیش فرض وردپرس خالی بگذارید)',
			'type'    => 'text',
			'numeric' => true,
			'afold'   => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'آیکون لایه hover تصویر بندانگشتی',
			'id'      => 'portfolio_type_1_hover_layer_icon',
			'std'     => kalium_get_theme_option( 'portfolio_type_1_hover_animatd_eye' ) ? 'animated-eye' : 'static-eye',
			'type'    => 'select',
			'options' => [
				'static-eye'   => 'آیکون چشم ثابت',
				'animated-eye' => 'آیکون چشم انیمیشن دار',
				'custom'       => 'آیکون سفارشی'
			],
			'afolds'  => true,
			'afold'   => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name' => 'آیکون لایه hover سفارشی',
			'desc' => 'آیکون لایه hover سفارشی را انتخاب کنید',
			'id'   => 'portfolio_type_1_hover_layer_icon_custom',
			'std'  => "",
			'type' => 'media',
			'mod'  => 'min',

			'afold' => 'portfolio_type_1_hover_layer_icon:custom',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => "عرض آیکون hover سفارشی",
			'id'      => 'portfolio_type_1_hover_layer_icon_custom_width',
			'std'     => "",
			'plc'     => '',
			'type'    => 'text',
			'postfix' => 'px',

			'afold' => 'portfolio_type_1_hover_layer_icon:custom',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name'    => 'تنظیمات تصاویر بندانگشتی',
			'desc'    => 'Hover افکت',
			'id'      => 'portfolio_type_1_hover_effect',
			'std'     => 'full',
			'type'    => 'select',
			'options' => [
				'none'      => 'بدون hover افکت',
				'full'      => 'Hover پس زمینه کامل',
				'distanced' => 'Hover پس زمینه فاصله دار'
			],
			'afold'   => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'شفافیت hover',
			'id'      => 'portfolio_type_1_hover_transparency',
			'std'     => 'opacity',
			'type'    => 'select',
			'options' => [
				'opacity'    => 'اعمال شفافیت',
				'no-opacity' => 'بدون شفافیت',
			],
			'afold'   => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'  => 'رنگ hover پس زمینه برای این نوع',
			'id'    => 'portfolio_type_1_hover_color',
			'std'   => "",
			'type'  => 'color',
			'afold' => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'  => "اندازه تصاویر بندانگشتی برای این نوع<br><small>اگر ابعاد را تغییر دهید باید <a href=\"admin.php?page=kalium&tab=faq#faq-regenerate-thumbnails\" target=\"_blank\">تصاویر بندانگشتی را بازسازی</a> کنید. <br>{$thumbnail_sizes_info}</small>",
			'id'    => 'portfolio_thumbnail_size_1',
			'std'   => "",
			'plc'   => 'برای استفاده از پیش فرض خالی بگذارید: 505x420',
			'type'  => 'text',
			'afold' => 'portfolio_type:type-1',

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name'  => "تنظیمات عنوان های داخلی + لایه بنائی",
			'desc'  => 'نمایش دکمه پسندیدن (لایک) برای موارد نمونه کارها',
			'id'    => 'portfolio_type_2_likes_show',
			'std'   => 1,
			'type'  => 'checkbox',
			'afold' => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'تعداد ستون ها برای نوع نمایش فعلی',
			'id'      => 'portfolio_type_2_columns_count',
			'std'     => '4',
			'type'    => 'select',
			'options' => [
				'1' => '1 مورد در هر ردیف',
				'2' => '2 مورد در هر ردیف',
				'3' => '3 مورد در هر ردیف',
				'4' => '4 مورد در هر ردیف',
				'5' => '5 مورد در هر ردیف',
				'6' => '6 مورد در هر ردیف',
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'فاصله بندی بین موارد نمونه کارها',
			'id'      => 'portfolio_type_2_grid_spacing',
			'std'     => 'four',
			'type'    => 'select',
			'options' => [
				'normal' => 'فاصله پیشفرض',
				'merged' => 'ادغام شده (بدون فاصله)'
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => "فاصله پیشفرض موارد<br><small>{$note_str} اعمال نمیشود وقتی حالت ادغام شده انتخاب شود.</small>",
			'id'      => 'portfolio_type_2_default_spacing',
			'std'     => "",
			'plc'     => 'فاصله پیشفرض: 30',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => "تعداد موارد نمونه کارها بر صفحه برای این نوع<br><small>{$note_str}برای نمایش تمامی نمونه کارها در یک صفحه از مقدار <strong>-1</strong> استفاده کنید.</small>",
			'id'      => 'portfolio_type_2_items_per_page',
			'std'     => "",
			'plc'     => '(برای استفاده از پیش فرض وردپرس خالی بگذارید)',
			'type'    => 'text',
			'numeric' => true,
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name'    => 'تنظیمات تصاویر بندانگشتی',
			'desc'    => 'Hover افکت',
			'id'      => 'portfolio_type_2_hover_effect',
			'std'     => 'full',
			'type'    => 'select',
			'options' => [
				'none'      => 'بدون hover افکت',
				'full'      => 'Hover پس زمینه کامل',
				'distanced' => 'Hover پس زمینه فاصله دار'
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'موقعیت متن hover',
			'id'      => 'portfolio_type_2_hover_text_position',
			'std'     => 'bottom-left',
			'type'    => 'select',
			'options' => [
				'top-left'     => 'بالا چپ',
				'top-right'    => 'بالا راست',
				'center'       => 'وسط',
				'bottom-left'  => 'پایین چپ',
				'bottom-right' => 'پایین راست',
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'شفافیت hover',
			'id'      => 'portfolio_type_2_hover_transparency',
			'std'     => 'opacity',
			'type'    => 'select',
			'options' => [
				'opacity'    => 'اعمال شفافیت',
				'no-opacity' => 'بدون شفافیت',
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'    => 'سبک پس زمینه hover',
			'id'      => 'portfolio_type_2_hover_style',
			'std'     => 'primary',
			'type'    => 'select',
			'options' => [
				'primary' => 'رنگ اصلی قالب',
				'black'   => 'پس زمینه سیاه',
				'white'   => 'پس زمینه سفید'
			],
			'afold'   => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'  => 'رنگ پس زمینه hover برای این نوع',
			'id'    => 'portfolio_type_2_hover_color',
			'std'   => "",
			'type'  => 'color',
			'afold' => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc'  => "اندازه تصاویر بندانگشتی برای این نوع<br><small>اگر ابعاد را تغییر دهید باید <a href=\"admin.php?page=kalium&tab=faq#faq-regenerate-thumbnails\" target=\"_blank\">تصاویر بندانگشتی را بازسازی </a> کنید.<br>{$thumbnail_sizes_info}</small>",
			'id'    => 'portfolio_thumbnail_size_2',
			'std'   => "",
			'plc'   => 'برای استفاده از پیش فرض خالی بگذارید: 505x420',
			'type'  => 'text',
			'afold' => "portfolio_type:type-2,type-3",

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'name' => 'نمونه کارهای تمام عرض',
			'desc' => 'گسترش جعبه نمونه کارها تا لبه مرورگر',
			'id'   => 'portfolio_full_width',
			'std'  => 0,
			'type' => 'checkbox',

			'folds' => true,

			'tab_id' => 'portfolio-settings-layout'
		];

		$of_options[] = [
			'desc' => 'Include title and filter within container',
			'id'   => 'portfolio_full_width_title_filter_container',
			'std'  => 1,
			'type' => 'checkbox',

			'fold' => 'portfolio_full_width',

			'tab_id' => 'portfolio-settings-layout'
		];

		// Portfolio Loop
		$of_options[] = [
			'name'  => 'تنظیمات صفحه نمونه کارها',
			'desc'  => 'ویژگی پسندیدن برای موارد نمونه کارها',
			'id'    => 'portfolio_likes',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'  => 'فیلتر دسته بندی برای موارد نمونه کارها',
			'id'    => 'portfolio_category_filter',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc' => 'فعال کردن فیلتر زیرشاخه های دسته بندی ها',
			'id'   => 'portfolio_filter_enable_subcategories',
			'std'  => 0,
			'type' => 'checkbox',
			'fold' => 'portfolio_category_filter',

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'    => "نوع آیکون پسندیدن<br><small>{$note_str} شکل آیکون \"پسندیدن\" را برای نشان دادن انتخاب کنید.</small>",
			'id'      => 'portfolio_likes_icon',
			'std'     => 'categories',
			'type'    => 'select',
			'options' => [
				'heart' => 'قلب',
				'thumb' => 'لایک',
				'star'  => 'ستاره',
			],

			'fold' => 'portfolio_likes',

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'    => "اطلاعات زیر عنوان نمونه کارها<br><small>{$note_str} نوع محتوایی که میخواهید زیر عنوان نمونه کارها نمایش داده شود را انتخاب کنید.</small>",
			'id'      => 'portfolio_loop_subtitles',
			'std'     => 'categories',
			'type'    => 'select',
			'options' => [
				'categories'        => 'نمایش دسته بندی ها',
				'categories-parent' => 'فقط دسته های والد نمایش داده شود',
				'subtitle'          => 'نمایش زیرعنوان',
				'hide'              => 'پنهان کردن'
			],

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'    => 'افکت ظاهرسازی موارد نمونه کارها',
			'id'      => 'portfolio_reveal_effect',
			'std'     => 'slidenfade',
			'type'    => 'select',
			'options' => [
				'none'           => 'هیچکدام',
				'fade'           => 'محو',
				'slidenfade'     => 'اسلاید و محو',
				'zoom'           => 'بزرگنمایی',
				'fade-one'       => 'محو (دانه به دانه)',
				'slidenfade-one' => 'اسلاید و محو (دانه به دانه)',
				'zoom-one'       => 'بزرگنمایی (دانه به دانه)'
			],

			'tab_id' => 'portfolio-settings-loop'
		];

		$portfolio_categories = get_terms( [
			'taxonomy'   => 'portfolio_category',
			'hide_empty' => true,
		] );

		$portfolio_categories_opts = [
			'default' => 'پیشفرض (All)',
		];

		$filter_terms_by_category = [];

		if ( ! is_wp_error( $portfolio_categories ) ) {
			foreach ( $portfolio_categories as $portfolio_category ) {
				$portfolio_categories_opts[ $portfolio_category->slug ] = $portfolio_category->name;
				$filter_terms_by_category[]                             = $portfolio_category->slug;
			}
		}

		$of_options[] = [
			'desc'    => "Default filter category<br><small>{$note_str} Set default category to filter portfolio items at first page load.</small>",
			'id'      => 'portfolio_default_filter_category',
			'std'     => 'default',
			'type'    => 'select',
			'options' => $portfolio_categories_opts,
			'tab_id'  => 'portfolio-settings-loop',

			'afolds' => true,
		];

		$of_options[] = [
			'desc' => 'Hide "All" filter link from portfolio',
			'id'   => 'portfolio_filter_category_hide_all',
			'std'  => 0,
			'type' => 'checkbox',
			'fold' => 'portfolio_category_filter',

			'afold' => 'portfolio_default_filter_category:' . implode( ',', $filter_terms_by_category ),

			'tab_id' => 'portfolio-settings-loop'
		];

		$portfolio_post_type_obj               = get_post_type_object( 'portfolio' );
		$portfolio_prefix_url_slug_placeholder = '';

		if ( $portfolio_post_type_obj != null ) {
			$portfolio_prefix_url_slug_placeholder = 'Slug فعلی نمونه کارها: ' . $portfolio_post_type_obj->rewrite['slug'];
		}

		if ( $portfolio_prefix_url_slug_placeholder ) {


			$of_options[] = [
				'name'  => 'تنظیمات بازنویسی لینک های نمونه کارها',
				'desc'  => 'پیشوند برای لینک نمونه کارها<br><small>' . $note_str . ' برای نمونه کارها پیشوند اضافه میکند <em>domain.com/<strong>' . $portfolio_post_type_obj->rewrite['slug'] . '/</strong>portfolio-item-slug</em></small>',
				'id'    => 'portfolio_url_add_prefix',
				'std'   => 1,
				'on'    => 'بله',
				'off'   => 'خیر',
				'type'  => 'switch',
				'folds' => 1,

				'tab_id' => 'portfolio-settings-loop'
			];

			$of_options[] = [    #'name'		=> 'URL Rewrite Options',
				'desc' => "پیشوند سفارشی برای لینک نمونه کار<br><small>{$note_str} هنگامی که این تنظیمات را تغییر دهید باید <a href=\"" . admin_url( 'admin.php?page=laborator-docs#flush-rewrite-rules' ) . "\" target=\"_blank\">فلاش کنید قوانین بازنویسی</a> را.</small>",
				'id'   => 'portfolio_prefix_url_slug',
				'std'  => "",
				'plc'  => $portfolio_prefix_url_slug_placeholder,
				'type' => 'text',

				'fold' => 'portfolio_url_add_prefix',

				'tab_id' => 'portfolio-settings-loop',
			];

			// Portfolio Category URL prefix
			$portfolio_category_args = apply_filters( 'portfolioposttype_category_args', [] );

			$portfolio_category_prefix_url_slug_placeholder = '';

			if ( ! empty ( $portfolio_category_args['rewrite']['slug'] ) ) {
				$portfolio_category_prefix_url_slug_placeholder = $portfolio_category_args['rewrite']['slug'];
			}

			$of_options[] = [
				"پیشوند سفارشی برای لینک نمونه کار<br><small>{$note_str} هنگامی که این تنظیمات را تغییر دهید باید <a href=\"" . admin_url( 'admin.php?page=laborator-docs#flush-rewrite-rules' ) . "\" target=\"_blank\">فلاش کنید قوانین بازنویسی</a> را.</small>",
				'id'   => 'portfolio_category_prefix_url_slug',
				'std'  => "",
				'plc'  => 'Slug دسته بندی فعلی: ' . $portfolio_category_prefix_url_slug_placeholder,
				'type' => 'text',

				'tab_id' => 'portfolio-settings-loop',
			];
		}

		$of_options[] = [
			'desc'    => "نوع فیلتر لینک<br><small>{$note_str} لینک های فیلتر نمونه کارها را از بین مطلق یا هشتگ انتخاب و تنظیم کنید. <a href=\"https://documentation.laborator.co/kb/kalium/changing-portfolio-url-prefixes/#category-filter-link-type\" target=\"_blank\">کسب اطلاعات بیشتر</a>.</small>",
			'id'      => 'portfolio_filter_link_type',
			'std'     => 'hash',
			'type'    => 'select',
			'options' => [
				'hash'      => 'هشتگ',
				'pushState' => 'لینک مطلق',
			],

			'fold' => 'portfolio_category_filter',

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'name'    => 'صفحه بندی',
			'desc'    => 'نوع صفحه بندی را انتخاب کنید',
			'id'      => 'portfolio_pagination_type',
			'std'     => 'center',
			'type'    => 'select',
			'options' => [
				'normal'         => 'صفحه بندی معمولی',
				'endless'        => 'اسکرول بینهایت',
				'endless-reveal' => "اسکرول بینهایت + ظاهرسازی خودکار"
			],

			'afolds' => true,

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'    => 'سبک صفحه بندی برای اسکرول بینهایت هنگام بارگذاری',
			'id'      => 'portfolio_endless_pagination_style',
			'std'     => '_1',
			'type'    => 'select',
			'options' => $endless_pagination_style,

			'afold' => 'portfolio_pagination_type:endless,endless-reveal',

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc' => "تعداد موارد برای بارگیری<br><small>{$note_str} مشخص کردن تعداد سفارشی موارد برای بارگیری، زمانی که روی &quot; نمایش بیشتر &quot; کلیک شود. (اختیاری)</small>",
			'id'   => 'portfolio_endless_pagination_fetch_count',
			'plc'  => 'برای به ارث بردن مقدار را خالی بگذارید',
			'type' => 'text',

			'afold' => 'portfolio_pagination_type:endless,endless-reveal',

			'tab_id' => 'portfolio-settings-loop'
		];

		$of_options[] = [
			'desc'    => 'تنظیم موقعیت دسته بندی',
			'id'      => 'portfolio_pagination_position',
			'std'     => 'center',
			'type'    => 'select',
			'options' => [ 'left' => 'چپ', 'center' => 'وسط', 'right' => 'راست' ],

			'tab_id' => 'portfolio-settings-loop'
		];


		// Portfolio: Single
		$of_options[] = [
			'name'  => 'تنظیمات آیتم',
			'desc'  => "لینک های <strong>بعدی-قبلی</strong> در تک آیتم",
			'id'    => 'portfolio_prev_next',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => 1,

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc' => 'لینک بعدی-قبلی در دسته بندی های فعلی',
			'id'   => 'portfolio_prev_next_category',
			'std'  => 1,
			'type' => 'checkbox',
			'fold' => 'portfolio_prev_next',

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc' => "نمایش عنوان های آیتم به صورت لینک های <strong>بعدی/قبلی</strong>",
			'id'   => 'portfolio_prev_next_show_titles',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc' => 'غیرفعال کردن لایت باکس برای تصاویر',
			'id'   => 'portfolio_disable_lightbox',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-single',
		];

		$of_options[] = [
			'desc' => 'لینک بایگانی نمونه کارها به دسته بندی موارد فعلی لینک شود',
			'id'   => 'portfolio_archive_url_category',
			'std'  => 0,
			'type' => 'checkbox',

			'afolds' => true,

			'tab_id' => 'portfolio-settings-single',
		];

		$of_options[] = [
			'desc' => "لینک بایگانی نمونه کارها (اگر خالی باشد از لینک بایگانی نمونه کارهای پیشفرض استفاده میشود)<br><small>{$note_str} این لینک در بعدی-قبلی ناوبری استفاده خواهد شد</small>",
			'id'   => 'portfolio_archive_url',
			'std'  => "",
			'plc'  => get_post_type_archive_link( 'portfolio' ),
			'type' => 'text',
			'fold' => 'portfolio_prev_next',

			'afold' => 'portfolio_archive_url_category:notChecked',

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc'    => 'طراحی لایه بندی پیشفرض بعدی-قبلی را انتخاب کنید',
			'id'      => 'portfolio_prev_next_type',
			'std'     => 'simple',
			'type'    => 'select',
			'options' => [
				'simple' => 'بعدی-قبلی ساده (در آخر صفحه)',
				'fixed'  => 'موقعیت ثابت بعدی-قبلی',
			],
			'fold'    => 'portfolio_prev_next',

			'afolds' => true,

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc'    => "چیدمان بعدی-قبلی در مرورگر.<br /><small>{$note_str} این تنظیمات فقط از نوع موقعیت ثابت بعدی-قبلی پیشتیبانی میکند.</small>",
			'id'      => 'portfolio_prev_next_position',
			'std'     => 'right-side',
			'type'    => 'select',
			'options' => [
				'left-side'  => 'بعدی-قبلی - چپ',
				'centered'   => 'بعدی-قبلی - وسط',
				'right-side' => 'بعدی-قبلی - راست',
			],
			'fold'    => 'portfolio_prev_next',

			'afold' => 'portfolio_prev_next_type:fixed',

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc'    => "طراحی لایه بندی پسندیدن و اشتراک گذاری",
			'id'      => 'portfolio_like_share_layout',
			'std'     => 'default',
			'type'    => 'select',
			'options' => [
				'default' => 'لینک های ساده',
				'rounded' => 'لینک های گرد (دایره ای)',
			],

			'tab_id' => 'portfolio-settings-single'
		];

		$of_options[] = [
			'desc'    => "موقعیت عنوان تصویر گالری",
			'id'      => 'portfolio_gallery_caption_position',
			'std'     => 'hover',
			'type'    => 'select',
			'options' => [
				'hover' => 'نمایش هنگام hover',
				'below' => 'نمایش زیر عکس',
				'hide'  => 'عدم نمایش عنوان',
			],

			'tab_id' => 'portfolio-settings-single'
		];


		// Lightbox: General
		$of_options[] = [
			'name' => 'Lightbox Portfolio Item Type Settings',
			'desc' => "",
			'id'   => 'portfolio_lb',
			'std'  => "<h3 style=\"margin: 0 0 10px;\">اطلاعات</h3>
						<p>تنظیمات زیر فقط روی &quot;لایت باکس&quot; نمونه کارها اعمال میشود</p>",
			'icon' => true,
			'type' => 'info',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'name'    => 'ناوبری لایت باکس',
			'desc'    => "حالت نمایش<br><small>لینک های فیلتر نمونه کارها را از بین مطلق یا هشتگ انتخاب و تنظیم کنید.
توجه: اگر روی \"لینک شده\" تنظیم شود، فلش های قبلی و بعدی لایت باکس از طریق تمام نمونه کارهای نمایش داده شده در لیست ادامه می یابد.</small>",
			'id'      => 'portfolio_lb_navigation_mode',
			'std'     => 'single',
			'type'    => 'select',
			'options' => [
				'single' => 'تک مورد',
				'linked' => 'لینک شده',
			],

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'name' => 'تنظیمات عمومی',
			'desc' => 'فعال کردن حالت تمام صفحه',
			'id'   => 'portfolio_lb_fullscreen',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'فعال کردن عناوین',
			'id'   => 'portfolio_lb_captions',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'فعال کردن دانلود',
			'id'   => 'portfolio_lb_download',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'نمایش شمارنده',
			'id'   => 'portfolio_lb_counter',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'اسلایدها قابل کشیدن باشد',
			'id'   => 'portfolio_lb_draggable',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'فعال کردن لینک هشتگ برای موارد',
			'id'   => 'portfolio_lb_hash',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => "حلقه بینهایت (بعدی/قبلی)",
			'id'   => 'portfolio_lb_loop',
			'std'  => 1,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => 'فعال کردن پیجر',
			'id'   => 'portfolio_lb_pager',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc'    => 'پوسته لایت باکس را انتخاب کنید',
			'id'      => 'portfolio_lb_skin',
			'std'     => 'lg-skin-kalium-default',
			'type'    => 'select',
			'options' => [
				'default'      => 'پیشفرض',
				'kalium-dark'  => 'تیره',
				'kalium-light' => 'روشن'
			],

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc'    => 'نوع انتقال بین تصاویر',
			'id'      => 'portfolio_lb_mode',
			'std'     => 'lg-fade',
			'type'    => 'select',
			'options' => [
				'lg-slide'                    => 'Slide',
				'lg-fade'                     => 'Fade',
				'lg-zoom-in'                  => 'Zoom in',
				'lg-zoom-in-big'              => 'Zoom in big',
				'lg-zoom-out'                 => 'Zoom out',
				'lg-zoom-out-big'             => 'Zoom out big',
				'lg-zoom-out-in'              => 'Zoom out in',
				'lg-zoom-in-out'              => 'Zoom in out',
				'lg-soft-zoom'                => 'Soft zoom',
				'lg-scale-up'                 => 'Scale up',
				'lg-slide-circular'           => 'Slide circular',
				'lg-slide-circular-vertical'  => 'Slide circular vertical',
				'lg-slide-vertical'           => 'Slide vertical',
				'lg-slide-vertical-growth'    => 'Slide vertical growth',
				'lg-slide-skew-only'          => 'Slide skew only',
				'lg-slide-skew-only-rev'      => 'Slide skew only reverse',
				'lg-slide-skew-only-y'        => 'Slide skew only y',
				'lg-slide-skew-only-y-rev'    => 'Slide skew only y reverse',
				'lg-slide-skew'               => 'Slide skew',
				'lg-slide-skew-rev'           => 'Slide skew reverse',
				'lg-slide-skew-cross'         => 'Slide skew cross',
				'lg-slide-skew-cross-rev'     => 'Slide skew cross reverse',
				'lg-slide-skew-ver'           => 'Slide skew vertically',
				'lg-slide-skew-ver-rev'       => 'Slide skew vertically reverse',
				'lg-slide-skew-ver-cross'     => 'Slide skew vertically cross',
				'lg-slide-skew-ver-cross-rev' => 'Slide skew vertically cross reverse',
				'lg-lollipop'                 => 'Lollipop',
				'lg-lollipop-rev'             => 'Lollipop reverse',
				'lg-rotate'                   => 'Rotate',
				'lg-rotate-rev'               => 'Rotate reverse',
				'lg-tube'                     => 'Tube',
			],

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc'    => "مدت زمان انتقال (در ثانیه)<br><small>{$note_str} فقط مقدار عددی وارد کنید.</small>",
			'id'      => 'portfolio_lb_speed',
			'std'     => '',
			'plc'     => 'پیشفرض: 0.6',
			'postfix' => 's',
			'type'    => 'text',
			'numeric' => true,

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc'    => "تأخیر برای پنهان کردن کنترل های گالری در ثانیه<br><small>{$note_str} فقط مقدار عددی وارد کنید.</small>",
			'id'      => 'portfolio_lb_hide_bars_delay',
			'std'     => '',
			'plc'     => 'پیشفرض: 3',
			'postfix' => 's',
			'type'    => 'text',
			'numeric' => true,

			'tab_id' => 'portfolio-settings-lightbox',
		];

		$of_options[] = [
			'desc' => "اندازه تصویر برای آیتم های گالری<br><small>{$note_str} اندازه تصویر تعریف شده را وارد کنید. برای اطلاعات بیشتر <a href=\"https://codex.wordpress.org/Post_Thumbnails\" target=\"_blank\">اینجا</a> کلیک کنید.</small>",
			'id'   => 'portfolio_lb_image_size_large',
			'std'  => '',
			'plc'  => 'پیشفرض: اورجینال',
			'type' => 'text',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => "اندازه تصویر برای بندانگشتی ها<br><small>{$note_str} اندازه تصویر تعریف شده را وارد کنید. برای اطلاعات بیشتر <a href=\"https://codex.wordpress.org/Post_Thumbnails\" target=\"_blank\">اینجا</a>  کلیک کنید.</small>",
			'id'   => 'portfolio_lb_image_size_thumbnail',
			'std'  => '',
			'plc'  => 'پیشفرض: بندانگشتی',
			'type' => 'text',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		// Lightbox: Thumbnails
		$of_options[] = [
			'name'  => 'تصاویر بندانگشتی',
			'desc'  => 'فعال کردن تصاویر بندانگشتی لایت باکس',
			'id'    => 'portfolio_lb_thumbnails',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => 'تصاویر بندانگشتی در یک خط (swipe nav)',
			'id'   => 'portfolio_lb_thumbnails_animated',
			'std'  => 1,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_thumbnails',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => 'کشیدن عنوان زیر تصاویر بندانگشتی',
			'id'   => 'portfolio_lb_thumbnails_pullcaptions_up',
			'std'  => 1,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_thumbnails',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => 'نمایش تصاویر بندانگشتی بطور پیشفرض',
			'id'   => 'portfolio_lb_thumbnails_show',
			'std'  => 0,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_thumbnails',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc'    => "اندازه تصاویر بندانگشتی<br><small>{$note_str} به عنوان مقدار عرض اعمال می شود.</small>",
			'id'      => 'portfolio_lb_thumbnails_width',
			'std'     => '',
			'plc'     => '100',
			'type'    => 'text',
			'postfix' => 'px',
			'numeric' => true,
			'fold'    => 'portfolio_lb_thumbnails',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc'    => "عرض جعبه تصاویر بندانگشتی",
			'id'      => 'portfolio_lb_thumbnails_container_height',
			'std'     => '',
			'plc'     => '100',
			'type'    => 'text',
			'postfix' => 'px',
			'numeric' => true,
			'fold'    => 'portfolio_lb_thumbnails',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		/*//TMP
		$of_options[] = array(
			'desc' 		=> 'Thumbnails pager position',
			'id' 		=> 'portfolio_lb_thumbnails_pager_position',
			'std' 		=> 'middle',
			'type' 		=> 'select',
			'options' 	=> array(
				'left'   => 'Left',
				'middle' => 'Middle',
				'right'  => 'Right'
			),
			'fold'		=> 'portfolio_lb_thumbnails'
		);
		//*/


		// Lightbox: AutoPlay
		$of_options[] = [
			'name'  => 'پخش خودکار',
			'desc'  => 'فعال کردن پخش خودکار گالری',
			'id'    => 'portfolio_lb_autoplay',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => "نمایان/پنهان شدن کنترل های پخش خودکار",
			'id'   => 'portfolio_lb_autoplay_controls',
			'std'  => 1,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_autoplay',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => 'فعال کردن نوار پیشرفت پخش خودکار',
			'id'   => 'portfolio_lb_autoplay_progressbar',
			'std'  => 1,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_autoplay',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc' => 'اجبار پخش خودکار',
			'id'   => 'portfolio_lb_autoplay_force_autoplay',
			'std'  => 0,
			'type' => 'checkbox',
			'fold' => 'portfolio_lb_autoplay',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc'    => "زمان (در ثانیه) بین هر انتقال خودکار<br><small>{$note_str} فقط مقدار عددی وارد کنید.</small>",
			'id'      => 'portfolio_lb_autoplay_pause',
			'std'     => '',
			'plc'     => 'پیشفرض: 5',
			'type'    => 'text',
			'numeric' => true,
			'fold'    => 'portfolio_lb_autoplay',

			'tab_id' => 'portfolio-settings-lightbox'
		];


		// Lightbox: Zoom
		$of_options[] = [
			'name'  => 'بزرگنمایی',
			'desc'  => 'فعال کردن گزینه بزرگنمایی',
			'id'    => 'portfolio_lb_zoom',
			'std'   => 1,
			'type'  => 'checkbox',
			'folds' => true,

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'desc'    => "مقیاس بزرگنمایی<br><small>{$note_str} مقدار بزرگنمایی باید افزایش/کاهش یابد.</small>",
			'id'      => 'portfolio_lb_zoom_scale',
			'std'     => '',
			'plc'     => 'پیشفرض: 1',
			'type'    => 'text',
			'numeric' => true,
			'fold'    => 'portfolio_lb_zoom',

			'tab_id' => 'portfolio-settings-lightbox'
		];

		$of_options[] = [
			'name'  => 'اشتراک گذاری آیتم',
			'desc'  => 'فعال کردن یا غیرفعال سازی به اشتراک گذاری موارد نمونه کارها در شبکه های اجتماعی',
			'id'    => 'portfolio_share_item',
			'std'   => 0,
			'on'    => 'اجازه اشتراک گذاری',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'portfolio-settings-sharing'
		];

		$share_portfolio_networks = [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter',
				'pr'      => 'Print Page',
			],

			'hidden' => [
				'placebo' => 'placebo',
				'pi'      => 'Pinterest',
				'em'      => 'Email',
				'tlr'     => 'Tumblr',
				'lin'     => 'LinkedIn',
				'vk'      => 'VKontakte',
				'wa'      => 'WhatsApp',
			],
		];

		$of_options[] = [
			'name' => 'اشتراک گذاری در:',
			'desc' => 'شبکه های اجتماعی که کاربران میتوانند آیتم نمونه کا  شما را در آن به اشتراک بگذارند انتخاب کنید',
			'id'   => 'portfolio_share_item_networks',
			'std'  => $share_portfolio_networks,
			'type' => 'sorter',
			'fold' => 'portfolio_share_item',

			'tab_id' => 'portfolio-settings-sharing'
		];

		$of_options[] = [
			'name'  => "عنوان و توضیحات صفحه نمونه کارها",
			'desc'  => "نمایش عنوان و توضیحات در صفحه نمونه کارها. <br /><small>{$note_str} این تنظیمات اعمال میشود فقط برای <a href=\"" . get_post_type_archive_link( 'portfolio' ) . "\" target=\"_blank\">صفحه بایگانی نمونه کارها</a>.</small>",
			'id'    => 'portfolio_show_header_title',
			'std'   => 1,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'portfolio-settings-other'
		];

		$of_options[] = [
			'desc' => 'عنوان سربرگ صفحه نمونه کارها (اختیاری)',
			'id'   => 'portfolio_title',
			'std'  => 'Portfolio',
			'plc'  => "",
			'type' => 'text',
			'fold' => 'portfolio_show_header_title',

			'tab_id' => 'portfolio-settings-other'
		];

		$of_options[] = [
			'desc' => 'توضیحات صفحه نمونه کارها در سربرگ (اختیاری)',
			'id'   => 'portfolio_description',
			'std'  => "کارهای روزمره ما در اینجا ارائه شده است، ما آنچه را دوست داریم انجام میدهیم",
			'plc'  => "",
			'type' => 'textarea',
			'fold' => 'portfolio_show_header_title',

			'tab_id' => 'portfolio-settings-other'
		];

		$of_options[] = [
			'name' => 'برچسب های نمونه کار',
			'desc' => "فعال کردن برچسب های نمونه کار<br><small>توجه: برچسب های نمونه کارها برای فیلتر کردن/دسته بندی نمونه کارها فقط در محیط مدیریت در دسترس است.</small>",
			'id'   => 'portfolio_enable_tags',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'portfolio-settings-other'
		];

		$of_options[] = [
			'name'    => 'Preselected Item Type',
			'desc'    => "Set default portfolio item type when creating portfolio items.",
			'id'      => 'portfolio_preselected_item_type',
			'std'     => 'default',
			'type'    => 'select',
			'options' => [
				'default' => 'Default',
				'type-1'  => 'Side Portfolio',
				'type-2'  => 'Columned',
				'type-3'  => 'Carousel',
				'type-4'  => 'Zig Zag',
				'type-5'  => 'Fullscreen',
				'type-6'  => 'Lightbox',
				'type-7'  => 'WPBakery Page Builder',
			],

			'tab_id' => 'portfolio-settings-other',
		];

		// END OF PORTFOLIO SETTINGS


		// SHOP SETTINGS
		$of_options[] = [
			'name' => 'Shop Settings',
			'type' => 'heading',
			'icon' => 'icon-shop-settings'
		];

		if ( false == kalium()->is->woocommerce_active() ) {
			$of_options[] = [
				'name' => '&#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1601;&#1593;&#1575;&#1604; &#1606;&#1740;&#1587;&#1578;',
				'desc' => '',
				'id'   => 'wc_not_activated',
				'std'  => "
						<h3 style=\"margin: 0 0 10px;\">&#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587; &#1606;&#1589;&#1576; &#1740;&#1575; &#1601;&#1593;&#1575;&#1604; &#1606;&#1740;&#1587;&#1578;!</h3>
						&#1576;&#1585;&#1575;&#1740; &#1662;&#1740;&#1705;&#1585;&#1576;&#1606;&#1583;&#1740; <strong>&#1578;&#1606;&#1592;&#1740;&#1605;&#1575;&#1578; &#1601;&#1585;&#1608;&#1588;&#1711;&#1575;&#1607;</strong> &#1575;&#1576;&#1578;&#1583;&#1575; &#1576;&#1575;&#1740;&#1583; &#1575;&#1601;&#1586;&#1608;&#1606;&#1607; <a href=\"".admin_url( 'plugin-install.php?s=woocommerce&tab=search&type=term' )."\">&#1608;&#1608;&#1705;&#1575;&#1605;&#1585;&#1587;</a> &#1585;&#1575; &#1606;&#1589;&#1576; &#1608; &#1601;&#1593;&#1575;&#1604;&#1587;&#1575;&#1586;&#1740; &#1705;&#1606;&#1740;&#1583;.",
				'icon' => true,
				'type' => 'info',
			];
		} else {


			$woocommerce_image_notice          = '';
			$woocommerce_image_customizer_link = '';

			if ( function_exists( 'wc_get_page_permalink' ) ) {

				$woocommerce_image_customizer_link = add_query_arg( [
					'autofocus' => [
						'panel' => 'woocommerce',
					],
					'url'       => wc_get_page_permalink( 'shop' ),
				], admin_url( 'customize.php' ) );

				$woocommerce_image_notice = wp_kses( sprintf( 'Looking for the product display options? They can now be found in the Customizer. <a href="%s">Go see them in action here.</a>', esc_url( $woocommerce_image_customizer_link ) ), [
					'a' => [
						'href'  => [],
						'title' => [],
					],
				] );
			}

			$of_options[] = [
				'type' => 'tabs',
				'id'   => 'shop-settings-tabs',
				'tabs' => [
					'shop-settings-loop'    => 'صفحه کاتالوگ',
					'shop-settings-single'  => 'صفحه تک',
					'shop-settings-sharing' => 'تنظیمات اشتراک گذاری',
					'shop-settings-other'   => 'دیگر تنظیمات',
				]
			];

			$of_options[] = [
				'name'    => 'لایه بندی کاتالوگ فروشگاه',
				'desc'    => "",
				'id'      => 'shop_catalog_layout',
				'std'     => 'default',
				'options' => [
					'default'            => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-1.png' ),
					'full-bg'            => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-2.png' ),
					'distanced-centered' => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-3.png' ),
					'transparent-bg'     => kalium()->assets_url( 'admin/images/theme-options/shop-loop-layout-4.png' ),
				],
				'descrs'  => [
					'default'            => 'پیشفرض',
					'full-bg'            => 'تمام پس زمینه',
					'distanced-centered' => 'پس زمینه فاصله دار - وسط',
					'transparent-bg'     => 'مینیمال',
				],
				'type'    => 'images',

				'afolds' => true,

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'name' => 'تنظیمات کاتالوگ',
				'desc' => 'عنوان سربرگ فروشگاه و تعداد نتایج',
				'id'   => 'shop_title_show',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => 'مرتب سازی محصولات در صفحه کاتالوگ',
				'id'   => 'shop_sorting_show',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => "نمایش نشان <strong>حراج</strong>",
				'id'   => 'shop_sale_ribbon_show',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => "نمایش نشان <strong>در انبار موجود نیست</strong>",
				'id'   => 'shop_oos_ribbon_show',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => "نمایش نشان <strong>ویژه</strong>",
				'id'   => 'shop_featured_ribbon_show',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => 'نمایش دسته بندی آیتم',
				'id'   => 'shop_product_category_listing',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => 'نمایش قیمت آیتم',
				'id'   => 'shop_product_price_listing',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => 'افزودن به سبد خرید محصول',
				'id'   => 'shop_add_to_cart_listing',
				'std'  => 1,
				'type' => 'checkbox',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'    => "Products grid layout",
				'id'      => 'shop_loop_masonry_layout_mode',
				'std'     => 'fitRows',
				'type'    => 'select',
				'options' => [
					'masonry' => 'Fit gaps (Masonry)',
					'fitRows' => 'Fit rows'
				],

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'    => 'Product thumbnail preview type',
				'id'      => 'shop_item_preview_type',
				'std'     => 'fade',
				'type'    => 'select',
				'options' => [
					'fade'    => 'Second Image on Hover',
					'gallery' => 'Product Gallery Slider',
					'none'    => 'None'
				],

				'afold' => 'shop_catalog_layout:default',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'    => "Products to show in mobile devices",
				'id'      => 'shop_product_columns_mobile',
				'std'     => 'one',
				'type'    => 'select',
				'options' => [
					'one' => '1 product per row',
					'two' => '2 products per row',
				],

				'tab_id' => 'shop-settings-loop'
			];

			$shop_columns_count = [
				'one'   => '1 product per row',
				'two'   => '2 products per row',
				'three' => '3 products per row',
				'four'  => '4 products per row',
				'five'  => '5 products per row',
				'six'   => '6 products per row',
			];

			$of_options[] = [
				'name' => 'WooCommerce images',
				'desc' => '',
				'id'   => 'wc_images_notice',
				'std'  => $woocommerce_image_notice,
				'icon' => true,
				'type' => 'info',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'name'    => 'Sidebar',
				'desc'    => "Shop sidebar visibility",
				'id'      => 'shop_sidebar',
				'std'     => 'hide',
				'type'    => 'select',
				'options' => $show_sidebar_options,

				'afolds' => true,

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'  => 'Show sidebar before products on mobile viewport',
				'id'    => 'shop_sidebar_before_products_mobile',
				'std'   => 0,
				'type'  => 'checkbox',
				'afold' => 'shop_sidebar:left,right',

				'tab_id' => 'shop-settings-loop'
			];

			if ( ! function_exists( 'kalium_woocommerce_product_categories_name_replace' ) ) {
				function kalium_woocommerce_product_categories_name_replace( $item ) {
					return str_replace( [ 'product per row', 'products per row' ], [
						'category per row',
						'categories per row'
					], $item );
				}
			}


			$of_options[] = [
				'name'    => 'دسته بندی های محصول',
				'desc'    => 'تعداد ستون ها را برای دسته بندی های محصول انتخاب کنید',
				'id'      => 'shop_category_columns',
				'std'     => 'decide',
				'options' => array_map( 'kalium_woocommerce_product_categories_name_replace', $shop_columns_count ),
				'type'    => 'select',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => "اندازه تصویر دسته بندی<br /><small>اگر ابعاد را تغییر دهید باید <a href=\"admin.php?page=kalium&tab=faq#faq-regenerate-thumbnails\" target=\"_blank\">تصویر بندانگشتی را بازسازی کنید</a>.<br>{$thumbnail_sizes_info}</small>",
				'id'   => 'shop_category_image_size',
				'std'  => "",
				'plc'  => 'پیشفرض: 500x290',
				'type' => 'text',

				'tab_id' => 'shop-settings-loop'
			];


			$of_options[] = [
				'name'    => 'صفحه بندی',
				'desc'    => 'انتخاب نوع صفحه بندی',
				'id'      => 'shop_pagination_type',
				'std'     => 'normal',
				'type'    => 'select',
				'options' => [
					'normal'         => 'صفحه بندی معمولی',
					'endless'        => 'اسکرول بینهایت',
					'endless-reveal' => "اسکرول بینهایت + ظاهرسازی خودکار"
				],

				'afolds' => true,

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'    => 'سبک صفحه بندی برای اسکرول بینهایت هنگام بارگذاری',
				'id'      => 'shop_endless_pagination_style',
				'std'     => '_1',
				'type'    => 'select',
				'options' => $endless_pagination_style,

				'afold' => 'shop_pagination_type:endless,endless-reveal',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc'    => 'موقعیت صفحه بندی را تنظیم کنید',
				'id'      => 'shop_pagination_position',
				'std'     => 'center',
				'type'    => 'select',
				'options' => [ 'left' => 'چپ', 'center' => 'وسط', 'right' => 'راست' ],

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'name'  => 'Catalog mode',
				'desc'  => "Enable catalog mode<br /><small>{$note_str} Will disable <strong>add to cart</strong> functionality. <a href='https://documentation.laborator.co/kb/kalium/shop-layout/#catalog-options' target='_blank'>Read more</a></small>",
				'id'    => 'shop_catalog_mode',
				'std'   => 0,
				'type'  => 'switch',
				'folds' => true,
				'on'    => 'Enable',
				'off'   => 'Disable',

				'tab_id' => 'shop-settings-loop'
			];

			$of_options[] = [
				'desc' => "Hide prices<br /><small>{$note_str} Show/hide product prices if there is a price set.</small>",
				'id'   => 'shop_catalog_mode_hide_prices',
				'std'  => 0,
				'type' => 'switch',
				'fold' => 'shop_catalog_mode',
				'on'   => 'Yes',
				'off'  => 'No',

				'tab_id' => 'shop-settings-loop'
			];

// ! Shop: Single
			$of_options[] = [
				'name'    => 'جزئیات محصول',
				'desc'    => "",
				'id'      => 'shop_single_product_images_layout',
				'std'     => 'default',
				'options' => [
					'default'      => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-default.png' ),
					'plain'        => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-plain.png' ),
					'plain-sticky' => kalium()->assets_url( 'admin/images/theme-options/shop-single-product-image-layout-plain-sticky.png' ),
				],
				'descrs'  => [
					'default'      => 'تصویر اصلی با تصاویر بندانگشتی در زیر',
					'plain'        => 'لیست تصاویر معمولی',
					'plain-sticky' => 'توضیحات چسبنده'
				],
				'type'    => 'images',

				'afolds' => true,

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "اندازه ستون تصاویر محصول<br /><small>{$note_str} اندازه جعبه تصاویر محصول را تنظیم کنید.</small>",
				'id'      => 'shop_single_image_column_size',
				'std'     => 'medium',
				'type'    => 'select',
				'options' => [
					'small'  => "کوچک (4/12)",
					'medium' => "متوسط (5/12)",
					'large'  => "بزرگ (6/12)",
					'xlarge' => "فوق العاده (8/12)",
				],

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "چیدمان تصاویر محصول<br /><small>{$note_str} چیدمان جعبه تصاویر محصول را انتخاب کنید - راست یا چپ.</small>",
				'id'      => 'shop_single_image_alignment',
				'std'     => 'left',
				'type'    => 'select',
				'options' => [
					'left'  => 'چپ',
					'right' => 'راست'
				],

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "کشیدن تصاویر تا لبه مرورگر<br /><small>{$note_str} تنظیم این گزینه به بله، عرض کانتین های تصاویر را تا لبه مرورگر گسترش می دهد.</small>",
				'id'      => 'shop_single_plain_image_stretch',
				'std'     => 'no',
				'type'    => 'select',
				'options' => [
					'yes' => 'بله',
					'no'  => 'خیر'
				],

				'afold' => 'shop_single_product_images_layout:plain,plain-sticky',

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "انتقال اسلایدر<br /><small>{$note_str} نوع انتقال تصویر را انتخاب کنید تا روی تصاویر اصلی محصول اعمال شود.</small>",
				'id'      => 'shop_single_image_carousel_transition_type',
				'std'     => 'slide',
				'type'    => 'select',
				'options' => [
					'slide' => 'اسلاید',
					'fade'  => 'محو شدن',
				],

				'afold' => 'shop_single_product_images_layout:default',

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "اندازه تصویر محصول<br /><small>{$note_str} ابعاد تصویر پیش فرض ووکامرس تا زمانی که اندازه تصویر مختلفی را انتخاب می کنید اعمال شود.</small>",
				'id'      => 'shop_single_auto_rotate_image',
				'std'     => "",
				'plc'     => 'مقدار پیشفرض: 5',
				'postfix' => 's',
				'type'    => 'text',
				'numeric' => true,

				'afold' => 'shop_single_product_images_layout:default',

				'tab_id' => 'shop-settings-single',
			];

			$of_options[] = [
				'desc'    => "سبک رتبه بندی<br /><small>{$note_str} انتخاب سبک رتبه بندی برای نمایش محصولات.</small>",
				'id'      => 'shop_single_rating_style',
				'std'     => 'circles',
				'type'    => 'select',
				'options' => [
					'stars'      => 'ستاره',
					'circles'    => 'دایره',
					'rectangles' => 'مستطیل'
				],

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "ستون های محصولات مرتبط/پرفروش<br><small>{$note_str} تعداد ستون ها را فقط برای محصولات مرتبط و پرفروش تنظیم کنید.</small>",
				'id'      => 'shop_related_products_columns',
				'std'     => 4,
				'type'    => 'select',
				'options' => range( 2, 6 ),

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'desc'    => "تعداد محصولات مرتبط<br><small>{$note_str} تعداد محصولات مرتبط که در صفحه محصول تک نشان داده شده است.</small>",
				'id'      => 'shop_related_products_per_page',
				'std'     => 4,
				'type'    => 'select',
				'options' => range( 12, 0 ),

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'name' => 'Product Attributes Visibility',
				'desc' => "Product SKU<br><small>{$note_str} Show or hide this product attribute.</small>",
				'id'   => 'shop_single_product_sku_visibility',
				'std'  => 1,
				'on'   => 'Show',
				'off'  => 'Hide',
				'type' => 'switch',

				'tab_id' => 'shop-settings-single',
			];

			$of_options[] = [
				'desc' => "Product Categoriess<br><small>{$note_str} Show or hide this product attribute.</small>",
				'id'   => 'shop_single_product_categories_visibility',
				'std'  => 1,
				'on'   => 'Show',
				'off'  => 'Hide',
				'type' => 'switch',

				'tab_id' => 'shop-settings-single',
			];

			$of_options[] = [
				'desc' => "Product Tags<br><small>{$note_str} Show or hide this product attribute.</small>",
				'id'   => 'shop_single_product_tags_visibility',
				'std'  => 1,
				'on'   => 'Show',
				'off'  => 'Hide',
				'type' => 'switch',

				'tab_id' => 'shop-settings-single',
			];

			$of_options[] = [
				'name'    => 'سایدبار',
				'desc'    => "تنظیم موقعیت سایدبار در مطلب تک یا پنهان کردن آن",
				'id'      => 'shop_single_sidebar_position',
				'std'     => 'hide',
				'type'    => 'select',
				'options' => $show_sidebar_options,

				'afolds' => true,

				'tab_id' => 'shop-settings-single',
			];

			$of_options[] = [
				'desc'  => 'Show sidebar before products on mobile viewport',
				'id'    => 'shop_single_sidebar_before_products_mobile',
				'std'   => 0,
				'type'  => 'checkbox',
				'afold' => 'shop_single_sidebar_position:left,right',

				'tab_id' => 'shop-settings-single'
			];


			$of_options[] = [
				'name' => 'گالری تصاویر محصول',
				'desc' => "بزرگنمایی تصویر<br><small class=\"note\">{$note_str} با hover روی تصویر محصول (ها) تصویر بزرگ میشود، همچنین در دستگاه های تلفن همراه پشتیبانی می شود.</small>",
				'id'   => 'shop_single_product_image_zoom',
				'std'  => 1,
				'type' => 'switch',

				'tab_id' => 'shop-settings-single',
			];


			$of_options[] = [
				'desc' => "گالری لایت باکس<br><small class=\"note\">{$note_str} هر تصویر محصول دارای یک آیکون + است برای مشاهده تمام تصاویر محصول در لایت باکس.</span>",
				'id'   => 'shop_single_product_image_lightbox',
				'std'  => 1,
				'type' => 'switch',

				'tab_id' => 'shop-settings-single',
			];


			$of_options[] = [
				'name'  => 'Custom image size',
				'desc'  => "Custom image size<br><small class=\"note\">{$note_str} Enabling this option will affect only <strong>main product images</strong>. <a href=\"" . admin_url( 'admin.php?page=kalium&tab=faq#faq-regenerate-thumbnails' ) . "\" target='_blank'>Thumbnails regeneration</a> is required.</small>",
				'id'    => 'shop_single_product_custom_image_size',
				'std'   => 0,
				'type'  => 'switch',
				'folds' => true,
				'on'    => 'Enable',
				'off'   => 'Disable',

				'tab_id' => 'shop-settings-single',
			];


			$of_options[] = [
				'desc'    => 'Image width',
				'id'      => 'shop_single_product_custom_image_size_width',
				'std'     => '',
				'plc'     => '820',
				'postfix' => 'px',
				'type'    => 'text',
				'numeric' => true,

				'fold' => 'shop_single_product_custom_image_size',

				'tab_id' => 'shop-settings-single'
			];


			$of_options[] = [
				'desc'    => 'Image height',
				'id'      => 'shop_single_product_custom_image_size_height',
				'std'     => '',
				'plc'     => '990',
				'postfix' => 'px',
				'type'    => 'text',
				'numeric' => true,

				'fold' => 'shop_single_product_custom_image_size',

				'tab_id' => 'shop-settings-single'
			];

			$of_options[] = [
				'name'  => 'اشتراک گذاری محصول',
				'desc'  => 'فعال یا غیرفعال کردن اشتراک گذاری محصولات در شبکه های اجتماعی',
				'id'    => 'shop_single_share_product',
				'std'   => 1,
				'type'  => 'switch',
				'folds' => 1,

				'on'  => 'اجازه به اشتراک گذاشتن',
				'off' => 'خیر',

				'tab_id' => 'shop-settings-sharing'
			];

			$share_product_networks = [
				'visible' => [
					'placebo' => 'placebo',
					'fb'      => 'Facebook',
					'tw'      => 'Twitter',
					'pi'      => 'Pinterest',
					'em'      => 'Email',
				],

				'hidden' => [
					'placebo' => 'placebo',
					'lin'     => 'LinkedIn',
					'tlr'     => 'Tumblr',
					'vk'      => 'VKontakte',
					'wa'      => 'WhatsApp',
				],
			];

			$of_options[] = [
				'name'    => 'اشتراک گذاری در:',
				'desc'    => "اشتراک گذاری محصولات در شبکه های اجتماعی<br><small>{$note_str} شبکه های اجتماعی که کاربران میتوانند محصولات فروشگاه شما را در آن به اشتراک بگذارند انتخاب کنید</small>",
				'id'      => 'shop_share_product_networks',
				'std'     => $share_product_networks,
				'type'    => 'sorter',
				'options' => [
					'rows-1' => '1 row',
					'rows-2' => '2 rows',
				],
				'fold'    => 'shop_single_share_product',

				'tab_id' => 'shop-settings-sharing'
			];

			$of_options[] = [
				'name' => 'Share links options',
				'desc' => 'Rounded social networks icons',
				'id'   => 'shop_share_product_rounded_icons',
				'std'  => 0,
				'type' => 'checkbox',
				'fold' => 'shop_single_share_product',

				'tab_id' => 'shop-settings-sharing'
			];

			$of_options[] = [
				'name'  => 'سبد خرید کوچک (مینی کارت)',
				'desc'  => 'نمایش آیکون سبد خرید در فهرست',
				'id'    => 'shop_cart_icon_menu',
				'std'   => 0,
				'type'  => 'checkbox',
				'folds' => 0,

				'tab_id' => 'shop-settings-other'
			];

			$of_options[] = [
				'desc' => 'شاخص شمارش موارد',
				'id'   => 'shop_cart_icon_menu_count',
				'std'  => 1,
				'type' => 'checkbox',
				//'fold' => 'shop_cart_icon_menu',

				'tab_id' => 'shop-settings-other'
			];

			$of_options[] = [
				'desc' => 'پنهان کردن آیکون سبد خرید زمانی که خالی است',
				'id'   => 'shop_cart_icon_menu_hide_empty',
				'std'  => 0,
				'type' => 'checkbox',
//				'fold' => 'shop_cart_icon_menu',

				'tab_id' => 'shop-settings-other'
			];

			$of_options[] = [
				'desc'    => "پنجره کوچک (پاپ آپ) محتویات سبد خرید<br><small>{$note_str} پنجره کوچک سبد خرید شامل موارد فعلی در سبد خرید، تسویه حساب و آدرس سبد خرید است.</small>",
				'id'      => 'shop_cart_contents',
				'std'     => 'show-on-click',
				'type'    => 'select',
				'options' => [
					'hide'          => 'پنجره کوچک محتویات کوچک سبد خرید را نمایش نده',
					'show-on-click' => 'نمایش محتویات سبد خرید هنگام کلیک',
					'show-on-hover' => 'نمایش محتویات سبد خرید هنگام hover',
				],
//				'fold'    => 'shop_cart_icon_menu',

				'tab_id' => 'shop-settings-other'
			];

			$of_options[] = [
				'desc'    => "آیکون سبد خرید <br /><small>آیکون سبد خریدی که می خواهید در فهرست نمایش داده شود را انتخاب کنید</small>",
				'id'      => 'shop_cart_icon',
				'std'     => 'ecommerce-cart-content',
				'options' => [
					'ecommerce-cart-content' => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-1.png' ),
					'ecommerce-bag'          => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-2.png' ),
					'ecommerce-basket'       => kalium()->assets_url( 'admin/images/theme-options/cart-menu-icon-3.png' ),
				],
				'type'    => 'images',
//				'fold'    => 'shop_cart_icon_menu',

				'tab_id' => 'shop-settings-other'
			];

			$of_options[] = [
				'name'  => 'Add to Cart in Search Results',
				'desc'  => 'Show add to cart link for products in search results',
				'id'    => 'shop_search_add_to_cart',
				'std'   => 1,
				'type'  => 'checkbox',
				'folds' => 1,

				'tab_id' => 'shop-settings-other'
			];

		}
		// END OF SHOP SETTINGS


		// OTHER SETTINGS
		$of_options[] = [
			'name' => 'Other Settings',
			'type' => 'heading',
			'icon' => 'icon-other-settings'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'other-settings-tabs',
			'tabs' => [
				'other-settings-misc'                      => 'متفرقه',
				'other-settings-custom-js'                 => 'جاوا اسکریپت سفارشی',
				'other-settings-search'                    => 'تنظیمات جستجو',
				'other-settings-video-audio-settings'      => 'تنظیمات صوتی و تصویری',
				'other-settings-image-loading-placeholder' => 'تصویر در حال بارگذاری'
			]
		];

		$of_options[] = [
			'name' => 'فایل استایل قالب (style.css)',
			'desc' => 'Disable enqueue of style.css of the theme',
			'id'   => 'do_not_enqueue_style_css',
			'std'  => 0,
			'type' => 'checkbox',

			'tab_id' => 'other-settings-misc',
		];

		$of_options[] = [
			'name'  => 'رفتن به بالا',
			'desc'  => "نمایش دکمه &quot;رفتن به بالا&quot; هنگامی که کاربران به پایین صفحه میروند",
			'id'    => 'footer_go_to_top',
			'std'   => 0,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'desc' => "تنظیم شماره یا درصد پیکسل های پنجره کاربر هنگامی که اسکرول میکند و لینک &quot;رفتن به بالا&quot; نمایش داده میشود<br><small>{$note_str} اگر مقدار را روی <strong>footer</strong> تنظیم کنید، فقط وقتی کاربر پاورقی صفحه را ببیند لینک نمایش داده میشود.</small>",
			'id'   => 'footer_go_to_top_activate',
			'std'  => 'footer',
			'plc'  => "",
			'type' => 'text',
			'fold' => 'footer_go_to_top',

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'desc'    => 'نوع جعبه برای دکمه "رفتن به بالا"',
			'id'      => 'footer_go_to_top_type',
			'std'     => 'circle',
			'type'    => 'select',
			'options' => [
				'square' => 'مربع',
				'circle' => 'دایره',
			],
			'fold'    => 'footer_go_to_top',

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'desc'    => 'موقعیت لینک',
			'id'      => 'footer_go_to_top_position',
			'std'     => 'bottom-right',
			'type'    => 'select',
			'options' => [
				'bottom-right'  => 'پایین راست',
				'bottom-left'   => 'پایین چپ',
				'bottom-center' => 'پایین وسط',
				'top-right'     => 'بالا راست',
				'top-left'      => 'بالا چپ',
				'top-center'    => 'بالا وسط',
			],
			'fold'    => 'footer_go_to_top',

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'name'    => 'پوسته سایدبار',
			'desc'    => 'سبکی برای ابزارک های سایت انتخاب کنید<br><small>' . $note_str . ' پوسته سایدبار برای ابزارک های پاورقی یا فهرست بالا اعمال نمیشود</small>',
			'id'      => 'sidebar_skin',
			'std'     => 'plain',
			'type'    => 'select',
			'options' => [
				'plain'           => 'معمولی',
				'bordered'        => 'حشایه دار',
				'background-fill' => 'پس زمینه بزرگ'

			],

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'name' => 'کلید API نقشه گوگل',
			'desc' => 'نقشه های گوگل نیاز به یک کلید API منحصر به فرد برای هر سایت دارد، کسب اطلاعات بیشتر در مورد ایجاد <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank"> API Google Key </a>',
			'id'   => 'google_maps_api',
			'std'  => '',
			'plc'  => '',
			'type' => 'text',

			'tab_id' => 'other-settings-misc'
		];

		$of_options[] = [
			'name' => 'جاوا اسکریپت سربرگ',
			'desc' => "کد جاوا اسکریپت خود را وارد کنید. کد وارد شده در تگ &lt;head&gt; قرار میگیرد.<br /><small>{$note_str} پیشنهاد میشود کد جاوا اسکریپت سفارشی خود را به پاورقی اضافه کنید مگر اینکه لازم باشد آن را در سربرگ قرار دهید. <a href=\"https://developer.yahoo.com/performance/rules.html#js_bottom=\" target=\"_blank\">اطلاعات بیشتر</a></small>",
			'id'   => 'user_custom_js_head',
			'std'  => "",
			'type' => 'textarea',
			'plc'  => "// Example\nvar a = 1;\nvar b = 2;\n\nfunction fx( c ) {\n\treturn Math.pow( a + b, c );\n}",

			'tab_id' => 'other-settings-custom-js',
		];

		$of_options[] = [
			'name' => 'جاوا اسکریپت پاورقی',
			'desc' => "کد جاوا اسکریپت خود را وارد کنید. کد وارد شده در پاورقی قرار میگیرد.<br /><small><span class=\"note\">مثال:</span> کد ردیابی آنالیز گوگل میتواند اینجا قرار بگیرد.</small>",
			'id'   => 'user_custom_js',
			'std'  => "",
			'type' => 'textarea',
			'plc'  => "",

			'tab_id' => 'other-settings-custom-js',
		];

		$of_options[] = [
			'name' => 'تصاویر بندانگشتی برای نتایج',
			'desc' => "نمایش تصویر شاخص در کنار نتایج جستجو",
			'id'   => 'search_thumbnails',
			'std'  => 1,
			'on'   => 'نمایان',
			'off'  => 'پنهان',
			'type' => 'switch',

			'tab_id' => 'other-settings-search'
		];

		$post_types_obj = get_post_types( [
			'_builtin'            => false,
			'publicly_queryable'  => true,
			'exclude_from_search' => false
		], 'objects' );

		$post_types = [];

		$post_types['post'] = 'مطالب';
		$post_types['page'] = 'صفحات';

		foreach ( $post_types_obj as $pt => $obj ) {
			$post_types[ $pt ] = $obj->labels->name;
		}

		$of_options[] = [
			'name'    => 'حذف انواع مطالب',
			'desc'    => 'انواع پست را برای حذف از نتایج جستجو انتخاب کنید',
			'id'      => 'exclude_search_post_types',
			'std'     => [],
			'type'    => 'multicheck',
			'options' => $post_types,

			'tab_id' => 'other-settings-search'
		];

		$of_options[] = [
			'name'    => "پخش کننده صوتی و تصویری",
			'desc'    => "پوسته پیشفرض پخش کننده صوتی و تصویری را برای استفاده انتخاب کنید<br><small>{$note_str} این گزینه جایگزین پخش کننده پیش فرض وردپرس برای تعبیه های صوتی و تصویری است.</small>",
			'id'      => 'videojs_player_skin',
			'std'     => 'minimal',
			'options' => [
				'standard' => 'پوسته استاندارد',
				'minimal'  => 'پوسته مینیمال',
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings'
		];

		$of_options[] = [
			'desc'    => "پیش بارگذاری ویدیوهای قرار داده شده<br><small>{$note_str} برای کسب اطلاعات بیشتر درباره پیش بارگذاری ویدوها <a href=\"http://www.stevesouders.com/blog/2013/04/12/html5-video-preload/\" target=\"_blank\">اینجا کلیک کنید</a>.</small>",
			'id'      => 'videojs_player_preload',
			'std'     => 'auto',
			'options' => [
				'auto'     => 'خودکار',
				'none'     => 'هیچکدام',
				'metadata' => 'فقط پیش بارگذاری متا دیتا',
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings'
		];

		$of_options[] = [
			'desc'    => "پخش خودکار ویدیوها<br><small>{$note_str} فعال کردن این گزینه تمام ویدیوهایی را که پست میکنید، خودکار پخش میکند.</small>",
			'id'      => 'videojs_player_autoplay',
			'std'     => 'no',
			'options' => [
				'no'          => 'غیرفعال',
				'yes'         => 'فعال',
				'on-viewport' => 'پخش خودکار در نمایشگر'
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings',
		];

		$of_options[] = [
			'desc'    => "حلقه ویدوها<br><small>{$note_str} ویدیوها بعد از پایان یافتن دوباره اجرا می شوند (حلقه بینهایت).</small>",
			'id'      => 'videojs_player_loop',
			'std'     => 'no',
			'options' => [
				'no'  => 'غیرفعال کردن',
				'yes' => 'فعال کردن',
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings',
		];

		$of_options[] = [
			'desc'    => "Share video<br><small>{$note_str} Enable/disable video sharing to social networks. Not applied for native YouTube player.</small>",
			'id'      => 'videojs_share',
			'std'     => 'no',
			'options' => [
				'yes' => 'Enable',
				'no'  => 'Disable',
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings',
		];

		$of_options[] = [
			'desc'    => "YouTube player<br><small>{$note_str} Select YouTube player to use.</small>",
			'id'      => 'youtube_player',
			'std'     => 'videojs',
			'options' => [
				'videojs' => 'VideoJS YouTube Player',
				'native'  => 'Native YouTube Player',
			],
			'type'    => 'select',

			'tab_id' => 'other-settings-video-audio-settings',
		];

		$of_options[] = [
			'name'    => 'نوع تصویر درحال بارگذاری',
			'desc'    => "",
			'id'      => 'image_loading_placeholder_type',
			'std'     => 'static-color',
			'options' => [
				'static-color' => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-color.png' ),
				'preselected'  => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-preloaders.png' ),
				'custom'       => kalium()->assets_url( 'admin/images/theme-options/image-placeholder-custom.png' ),
			],
			'descrs'  => [
				'static-color' => 'رنگ استاتیک',
				'preselected'  => 'بارگذارنده های انتخاب شده',
				'custom'       => 'بارگذارنده سفارشی',
			],
			'type'    => 'images',

			'afolds' => true,

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'name' => 'رنگ پس زمینه نگهدارنده',
			'desc' => 'رنگ محل نگهدارنده',
			'id'   => 'image_loading_placeholder_bg',
			'std'  => '#eeeeee',
			'type' => 'color',

			'afold' => '',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		$of_options[] = [
			'desc' => 'استفاده از گرادینت',
			'id'   => 'image_loading_placeholder_use_gradient',
			'std'  => 0,
			'type' => 'switch',
			'on'   => 'بله',
			'off'  => 'خیر',

			'folds' => true,

			'afold' => '',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		$of_options[] = [
			'desc' => 'غالب رنگ تصویر<br><small>توجه: فعال کردن این گزینه باعث نادیده گرفته شدن گرادینت و رنگ پس زمینه میشود.</small>',
			'id'   => 'image_loading_placeholder_dominant_color',
			'std'  => 0,
			'type' => 'switch',
			'on'   => 'بله',
			'off'  => 'خیر',

			'folds' => true,

			'afold' => '',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		$of_options[] = [
			'name'    => 'رنگ گرادینت',
			'desc'    => 'نوع گرادینت',
			'id'      => 'image_loading_placeholder_gradient_type',
			'std'     => 'fade',
			'options' => [
				'linear' => 'خطی',
				'radial' => 'شعاعی',
			],
			'type'    => 'select',

			'fold' => 'image_loading_placeholder_use_gradient',

			'afold' => '',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		$of_options[] = [
			'desc' => 'رنگ گرادینت',
			'id'   => 'image_loading_placeholder_gradient_bg',
			'std'  => '#8d8d8d',
			'type' => 'color',

			'fold' => 'image_loading_placeholder_use_gradient',

			'afold' => '',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		if ( is_admin() && 'admin.php' == $pagenow ) {
			$loaders_html            = '';
			$loading_spinners        = Kalium_Image_Loading_Spinner::get_spinners();
			$loading_spinners_values = [];

			$current_spinner = kalium_get_theme_option( 'image_loading_placeholder_preselected_loader' );

			foreach ( $loading_spinners as $spinner_id => $spinner ) {
				$loading_spinners_values[ $spinner_id ] = $spinner['name'];
			}

			if ( ! $current_spinner ) {
				$spinner_keys    = array_keys( $loading_spinners_values );
				$current_spinner = reset( $spinner_keys );
			}

			if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
				foreach ( $loading_spinners as $spinner_id => $spinner_name ) {
					$spinner = Kalium_Image_Loading_Spinner::get_spinner_by_id( $spinner_id, [
						'holder' => 'div',
					] );

					if ( $current_spinner == $spinner_id ) {
						$spinner = str_replace( '"loader"', '"loader current"', $spinner );
					}

					$loaders_html .= $spinner;
				}
			}

			$loaders_html = '<div class="loaders clearfix">' . $loaders_html . '</div>';
		} else {
			$current_spinner         = $loaders_html = '';
			$loading_spinners_values = [];
		}

		$loaders_position = [
	        'top-left'       => 'بالا چپ',
	        'top-center'     => 'بالا وسط',
	        'top-right'      => 'بالا راست',
	        'center-left'    => 'وسط چپ',
	        'center'       => 'وسط وسط',
	        'center-right'   => 'وسط راست',
	        'bottom-left'    => 'پایین چپ',
	        'bottom-center'  => 'پایین وسط',
	        'bottom-right'   => 'پایین راست',
		];

		$of_options[] = [
			'name'    => 'بارگذارهای انتخاب شده',
			'desc'    => 'فهرست بارگذارنده های زیر را مشاهده کنید و تصویر پیش فرض بارگذاری را انتخاب کنید.',
			'id'      => 'image_loading_placeholder_preselected_loader',
			'std'     => $current_spinner,
			'type'    => 'select',
			'options' => $loading_spinners_values,

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'موقعیت بارگذار/چرخنده',
			'id'      => 'image_loading_placeholder_preselected_loader_position',
			'std'     => 'center',
			'type'    => 'select',
			'options' => $loaders_position,

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'اندازه بارگذار (در مقیاس درصد)<br><small>' . $note_str . ' اندازه واقعی بارگذار انتخاب شده به عنوان 100٪ از اندازه آن نشان داده شده است.</small>',
			'id'      => 'image_loading_placeholder_preselected_size',
			'std'     => '',
			'plc'     => '100',
			'postfix' => '%',
			'type'    => 'text',
			'numeric' => true,

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'فاصله بارگذار<br><small>' . $note_str . ' بسته به اندازه بارگذار، این گزینه به شما کمک می کند که بارگذار را در داخل تصویر بندانگشتی قرار دهید.</small>',
			'id'      => 'image_loading_placeholder_preselected_spacing',
			'std'     => '',
			'plc'     => '20',
			'postfix' => 'px',
			'type'    => 'text',
			'numeric' => true,

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc' => 'رنگ اسپینر (چرخنده)<br><small>' . $note_str . ' این گزینه رنگ اسپینرهای متحرک را تغییر خواهد داد.</small>',
			'id'   => 'image_loading_placeholder_preselected_loader_color',
			'std'  => '#ffffff',
			'type' => 'color',

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder',
		];

		$of_options[] = [
			'name' => 'بارگذارهای انتخاب شده',
			'desc' => '',
			'id'   => 'image_loading_placeholder_preselected',
			'std'  => "<h3 style=\"margin: 0 0 10px;\">لیست بارگذارهای انتخاب شده</h3>
					در اینجا لیستی از بارگذار/اسپینرهای از پیش تعیین شده میباشد که شما می توانید برای  بارگذار استفاده کنید:" . $loaders_html,
			'icon' => true,
			'type' => 'info',

			'afold' => 'image_loading_placeholder_type:preselected',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'name'  => 'پیش بارگذار سفارشی',
			'desc'  => 'تصویر بارگذار<br><small>' . $note_str . ' لودینگ اسپینر متحرک خود را انتخاب کنید، فرمت GIF پشتیبانی می شود.</small>',
			'id'    => 'image_loading_placeholder_custom_image',
			'std'   => '',
			'type'  => 'media',
			'mod'   => 'min',
			'afold' => 'image_loading_placeholder_type:custom',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'عرض تصویر بارگذار را تنظیم کنید<br><small>' . $note_str . ' اگر خالی باشد، اندازه تصویر واقعی نمایش داده خواهد شد.</small>',
			'id'      => 'image_loading_placeholder_custom_image_width',
			'plc'     => 'سایز واقعی',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'afold'   => 'image_loading_placeholder_type:custom',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'جایگاه بارگذار/چرخنده (اسپینر)',
			'id'      => 'image_loading_placeholder_custom_loader_position',
			'std'     => 'center',
			'type'    => 'select',
			'options' => $loaders_position,

			'afold' => 'image_loading_placeholder_type:custom',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];

		$of_options[] = [
			'desc'    => 'فاصله بارگذار<br><small>' . $note_str . ' بسته به اندازه بارگذار، این گزینه به شما کمک می کند که بارگذار را در داخل تصویر بندانگشتی قرار دهید.</small>',
			'id'      => 'image_loading_placeholder_custom_spacing',
			'std'     => '',
			'plc'     => '20',
			'postfix' => 'px',
			'type'    => 'text',
			'numeric' => true,

			'afold' => 'image_loading_placeholder_type:custom',

			'tab_id' => 'other-settings-image-loading-placeholder'
		];
		// END OF OTHER SETTINGS


		$fonts_list = [
			'ABeeZee'                  => 'ABeeZee',
			'Abel'                     => 'Abel',
			'Abril Fatface'            => 'Abril Fatface',
			'Aclonica'                 => 'Aclonica',
			'Acme'                     => 'Acme',
			'Actor'                    => 'Actor',
			'Adamina'                  => 'Adamina',
			'Advent Pro'               => 'Advent Pro',
			'Aguafina Script'          => 'Aguafina Script',
			'Akronim'                  => 'Akronim',
			'Aladin'                   => 'Aladin',
			'Aldrich'                  => 'Aldrich',
			'Alef'                     => 'Alef',
			'Alegreya'                 => 'Alegreya',
			'Alegreya SC'              => 'Alegreya SC',
			'Alegreya Sans'            => 'Alegreya Sans',
			'Alegreya Sans SC'         => 'Alegreya Sans SC',
			'Alex Brush'               => 'Alex Brush',
			'Alfa Slab One'            => 'Alfa Slab One',
			'Alice'                    => 'Alice',
			'Alike'                    => 'Alike',
			'Alike Angular'            => 'Alike Angular',
			'Allan'                    => 'Allan',
			'Allerta'                  => 'Allerta',
			'Allerta Stencil'          => 'Allerta Stencil',
			'Allura'                   => 'Allura',
			'Almendra'                 => 'Almendra',
			'Almendra Display'         => 'Almendra Display',
			'Almendra SC'              => 'Almendra SC',
			'Amarante'                 => 'Amarante',
			'Amaranth'                 => 'Amaranth',
			'Amatic SC'                => 'Amatic SC',
			'Amatica SC'               => 'Amatica SC',
			'Amethysta'                => 'Amethysta',
			'Amiko'                    => 'Amiko',
			'Amiri'                    => 'Amiri',
			'Amita'                    => 'Amita',
			'Anaheim'                  => 'Anaheim',
			'Andada'                   => 'Andada',
			'Andika'                   => 'Andika',
			'Angkor'                   => 'Angkor',
			'Annie Use Your Telescope' => 'Annie Use Your Telescope',
			'Anonymous Pro'            => 'Anonymous Pro',
			'Antic'                    => 'Antic',
			'Antic Didone'             => 'Antic Didone',
			'Antic Slab'               => 'Antic Slab',
			'Anton'                    => 'Anton',
			'Arapey'                   => 'Arapey',
			'Arbutus'                  => 'Arbutus',
			'Arbutus Slab'             => 'Arbutus Slab',
			'Architects Daughter'      => 'Architects Daughter',
			'Archivo Black'            => 'Archivo Black',
			'Archivo Narrow'           => 'Archivo Narrow',
			'Aref Ruqaa'               => 'Aref Ruqaa',
			'Arima Madurai'            => 'Arima Madurai',
			'Arimo'                    => 'Arimo',
			'Arizonia'                 => 'Arizonia',
			'Armata'                   => 'Armata',
			'Artifika'                 => 'Artifika',
			'Arvo'                     => 'Arvo',
			'Arya'                     => 'Arya',
			'Asap'                     => 'Asap',
			'Asar'                     => 'Asar',
			'Asset'                    => 'Asset',
			'Assistant'                => 'Assistant',
			'Astloch'                  => 'Astloch',
			'Asul'                     => 'Asul',
			'Athiti'                   => 'Athiti',
			'Atma'                     => 'Atma',
			'Atomic Age'               => 'Atomic Age',
			'Aubrey'                   => 'Aubrey',
			'Audiowide'                => 'Audiowide',
			'Autour One'               => 'Autour One',
			'Average'                  => 'Average',
			'Average Sans'             => 'Average Sans',
			'Averia Gruesa Libre'      => 'Averia Gruesa Libre',
			'Averia Libre'             => 'Averia Libre',
			'Averia Sans Libre'        => 'Averia Sans Libre',
			'Averia Serif Libre'       => 'Averia Serif Libre',
			'Bad Script'               => 'Bad Script',
			'Baloo'                    => 'Baloo',
			'Baloo Bhai'               => 'Baloo Bhai',
			'Baloo Bhaina'             => 'Baloo Bhaina',
			'Baloo Chettan'            => 'Baloo Chettan',
			'Baloo Da'                 => 'Baloo Da',
			'Baloo Paaji'              => 'Baloo Paaji',
			'Baloo Tamma'              => 'Baloo Tamma',
			'Baloo Thambi'             => 'Baloo Thambi',
			'Balthazar'                => 'Balthazar',
			'Bangers'                  => 'Bangers',
			'Basic'                    => 'Basic',
			'Battambang'               => 'Battambang',
			'Baumans'                  => 'Baumans',
			'Bayon'                    => 'Bayon',
			'Belgrano'                 => 'Belgrano',
			'Belleza'                  => 'Belleza',
			'BenchNine'                => 'BenchNine',
			'Bentham'                  => 'Bentham',
			'Berkshire Swash'          => 'Berkshire Swash',
			'Bevan'                    => 'Bevan',
			'Bigelow Rules'            => 'Bigelow Rules',
			'Bigshot One'              => 'Bigshot One',
			'Bilbo'                    => 'Bilbo',
			'Bilbo Swash Caps'         => 'Bilbo Swash Caps',
			'BioRhyme'                 => 'BioRhyme',
			'BioRhyme Expanded'        => 'BioRhyme Expanded',
			'Biryani'                  => 'Biryani',
			'Bitter'                   => 'Bitter',
			'Black Ops One'            => 'Black Ops One',
			'Bokor'                    => 'Bokor',
			'Bonbon'                   => 'Bonbon',
			'Boogaloo'                 => 'Boogaloo',
			'Bowlby One'               => 'Bowlby One',
			'Bowlby One SC'            => 'Bowlby One SC',
			'Brawler'                  => 'Brawler',
			'Bree Serif'               => 'Bree Serif',
			'Bubblegum Sans'           => 'Bubblegum Sans',
			'Bubbler One'              => 'Bubbler One',
			'Buda'                     => 'Buda',
			'Buenard'                  => 'Buenard',
			'Bungee'                   => 'Bungee',
			'Bungee Hairline'          => 'Bungee Hairline',
			'Bungee Inline'            => 'Bungee Inline',
			'Bungee Outline'           => 'Bungee Outline',
			'Bungee Shade'             => 'Bungee Shade',
			'Butcherman'               => 'Butcherman',
			'Butterfly Kids'           => 'Butterfly Kids',
			'Cabin'                    => 'Cabin',
			'Cabin Condensed'          => 'Cabin Condensed',
			'Cabin Sketch'             => 'Cabin Sketch',
			'Caesar Dressing'          => 'Caesar Dressing',
			'Cagliostro'               => 'Cagliostro',
			'Cairo'                    => 'Cairo',
			'Calligraffitti'           => 'Calligraffitti',
			'Cambay'                   => 'Cambay',
			'Cambo'                    => 'Cambo',
			'Candal'                   => 'Candal',
			'Cantarell'                => 'Cantarell',
			'Cantata One'              => 'Cantata One',
			'Cantora One'              => 'Cantora One',
			'Capriola'                 => 'Capriola',
			'Cardo'                    => 'Cardo',
			'Carme'                    => 'Carme',
			'Carrois Gothic'           => 'Carrois Gothic',
			'Carrois Gothic SC'        => 'Carrois Gothic SC',
			'Carter One'               => 'Carter One',
			'Catamaran'                => 'Catamaran',
			'Caudex'                   => 'Caudex',
			'Caveat'                   => 'Caveat',
			'Caveat Brush'             => 'Caveat Brush',
			'Cedarville Cursive'       => 'Cedarville Cursive',
			'Ceviche One'              => 'Ceviche One',
			'Changa'                   => 'Changa',
			'Changa One'               => 'Changa One',
			'Chango'                   => 'Chango',
			'Chathura'                 => 'Chathura',
			'Chau Philomene One'       => 'Chau Philomene One',
			'Chela One'                => 'Chela One',
			'Chelsea Market'           => 'Chelsea Market',
			'Chenla'                   => 'Chenla',
			'Cherry Cream Soda'        => 'Cherry Cream Soda',
			'Cherry Swash'             => 'Cherry Swash',
			'Chewy'                    => 'Chewy',
			'Chicle'                   => 'Chicle',
			'Chivo'                    => 'Chivo',
			'Chonburi'                 => 'Chonburi',
			'Cinzel'                   => 'Cinzel',
			'Cinzel Decorative'        => 'Cinzel Decorative',
			'Clicker Script'           => 'Clicker Script',
			'Coda'                     => 'Coda',
			'Coda Caption'             => 'Coda Caption',
			'Codystar'                 => 'Codystar',
			'Coiny'                    => 'Coiny',
			'Combo'                    => 'Combo',
			'Comfortaa'                => 'Comfortaa',
			'Coming Soon'              => 'Coming Soon',
			'Concert One'              => 'Concert One',
			'Condiment'                => 'Condiment',
			'Content'                  => 'Content',
			'Contrail One'             => 'Contrail One',
			'Convergence'              => 'Convergence',
			'Cookie'                   => 'Cookie',
			'Copse'                    => 'Copse',
			'Corben'                   => 'Corben',
			'Cormorant'                => 'Cormorant',
			'Cormorant Garamond'       => 'Cormorant Garamond',
			'Cormorant Infant'         => 'Cormorant Infant',
			'Cormorant SC'             => 'Cormorant SC',
			'Cormorant Unicase'        => 'Cormorant Unicase',
			'Cormorant Upright'        => 'Cormorant Upright',
			'Courgette'                => 'Courgette',
			'Cousine'                  => 'Cousine',
			'Coustard'                 => 'Coustard',
			'Covered By Your Grace'    => 'Covered By Your Grace',
			'Crafty Girls'             => 'Crafty Girls',
			'Creepster'                => 'Creepster',
			'Crete Round'              => 'Crete Round',
			'Crimson Text'             => 'Crimson Text',
			'Croissant One'            => 'Croissant One',
			'Crushed'                  => 'Crushed',
			'Cuprum'                   => 'Cuprum',
			'Cutive'                   => 'Cutive',
			'Cutive Mono'              => 'Cutive Mono',
			'Damion'                   => 'Damion',
			'Dancing Script'           => 'Dancing Script',
			'Dangrek'                  => 'Dangrek',
			'David Libre'              => 'David Libre',
			'Dawning of a New Day'     => 'Dawning of a New Day',
			'Days One'                 => 'Days One',
			'Dekko'                    => 'Dekko',
			'Delius'                   => 'Delius',
			'Delius Swash Caps'        => 'Delius Swash Caps',
			'Delius Unicase'           => 'Delius Unicase',
			'Della Respira'            => 'Della Respira',
			'Denk One'                 => 'Denk One',
			'Devonshire'               => 'Devonshire',
			'Dhurjati'                 => 'Dhurjati',
			'Didact Gothic'            => 'Didact Gothic',
			'Diplomata'                => 'Diplomata',
			'Diplomata SC'             => 'Diplomata SC',
			'Domine'                   => 'Domine',
			'Donegal One'              => 'Donegal One',
			'Doppio One'               => 'Doppio One',
			'Dorsa'                    => 'Dorsa',
			'Dosis'                    => 'Dosis',
			'Dr Sugiyama'              => 'Dr Sugiyama',
			'Droid Sans'               => 'Droid Sans',
			'Droid Sans Mono'          => 'Droid Sans Mono',
			'Droid Serif'              => 'Droid Serif',
			'Duru Sans'                => 'Duru Sans',
			'Dynalight'                => 'Dynalight',
			'EB Garamond'              => 'EB Garamond',
			'Eagle Lake'               => 'Eagle Lake',
			'Eater'                    => 'Eater',
			'Economica'                => 'Economica',
			'Eczar'                    => 'Eczar',
			'Ek Mukta'                 => 'Ek Mukta',
			'El Messiri'               => 'El Messiri',
			'Electrolize'              => 'Electrolize',
			'Elsie'                    => 'Elsie',
			'Elsie Swash Caps'         => 'Elsie Swash Caps',
			'Emblema One'              => 'Emblema One',
			'Emilys Candy'             => 'Emilys Candy',
			'Engagement'               => 'Engagement',
			'Englebert'                => 'Englebert',
			'Enriqueta'                => 'Enriqueta',
			'Erica One'                => 'Erica One',
			'Esteban'                  => 'Esteban',
			'Euphoria Script'          => 'Euphoria Script',
			'Ewert'                    => 'Ewert',
			'Exo'                      => 'Exo',
			'Exo 2'                    => 'Exo 2',
			'Expletus Sans'            => 'Expletus Sans',
			'Fanwood Text'             => 'Fanwood Text',
			'Farsan'                   => 'Farsan',
			'Fascinate'                => 'Fascinate',
			'Fascinate Inline'         => 'Fascinate Inline',
			'Faster One'               => 'Faster One',
			'Fasthand'                 => 'Fasthand',
			'Fauna One'                => 'Fauna One',
			'Federant'                 => 'Federant',
			'Federo'                   => 'Federo',
			'Felipa'                   => 'Felipa',
			'Fenix'                    => 'Fenix',
			'Finger Paint'             => 'Finger Paint',
			'Fira Mono'                => 'Fira Mono',
			'Fira Sans'                => 'Fira Sans',
			'Fjalla One'               => 'Fjalla One',
			'Fjord One'                => 'Fjord One',
			'Flamenco'                 => 'Flamenco',
			'Flavors'                  => 'Flavors',
			'Fondamento'               => 'Fondamento',
			'Fontdiner Swanky'         => 'Fontdiner Swanky',
			'Forum'                    => 'Forum',
			'Francois One'             => 'Francois One',
			'Frank Ruhl Libre'         => 'Frank Ruhl Libre',
			'Freckle Face'             => 'Freckle Face',
			'Fredericka the Great'     => 'Fredericka the Great',
			'Fredoka One'              => 'Fredoka One',
			'Freehand'                 => 'Freehand',
			'Fresca'                   => 'Fresca',
			'Frijole'                  => 'Frijole',
			'Fruktur'                  => 'Fruktur',
			'Fugaz One'                => 'Fugaz One',
			'GFS Didot'                => 'GFS Didot',
			'GFS Neohellenic'          => 'GFS Neohellenic',
			'Gabriela'                 => 'Gabriela',
			'Gafata'                   => 'Gafata',
			'Galada'                   => 'Galada',
			'Galdeano'                 => 'Galdeano',
			'Galindo'                  => 'Galindo',
			'Gentium Basic'            => 'Gentium Basic',
			'Gentium Book Basic'       => 'Gentium Book Basic',
			'Geo'                      => 'Geo',
			'Geostar'                  => 'Geostar',
			'Geostar Fill'             => 'Geostar Fill',
			'Germania One'             => 'Germania One',
			'Gidugu'                   => 'Gidugu',
			'Gilda Display'            => 'Gilda Display',
			'Give You Glory'           => 'Give You Glory',
			'Glass Antiqua'            => 'Glass Antiqua',
			'Glegoo'                   => 'Glegoo',
			'Gloria Hallelujah'        => 'Gloria Hallelujah',
			'Goblin One'               => 'Goblin One',
			'Gochi Hand'               => 'Gochi Hand',
			'Gorditas'                 => 'Gorditas',
			'Goudy Bookletter 1911'    => 'Goudy Bookletter 1911',
			'Graduate'                 => 'Graduate',
			'Grand Hotel'              => 'Grand Hotel',
			'Gravitas One'             => 'Gravitas One',
			'Great Vibes'              => 'Great Vibes',
			'Griffy'                   => 'Griffy',
			'Gruppo'                   => 'Gruppo',
			'Gudea'                    => 'Gudea',
			'Gurajada'                 => 'Gurajada',
			'Habibi'                   => 'Habibi',
			'Halant'                   => 'Halant',
			'Hammersmith One'          => 'Hammersmith One',
			'Hanalei'                  => 'Hanalei',
			'Hanalei Fill'             => 'Hanalei Fill',
			'Handlee'                  => 'Handlee',
			'Hanuman'                  => 'Hanuman',
			'Happy Monkey'             => 'Happy Monkey',
			'Harmattan'                => 'Harmattan',
			'Headland One'             => 'Headland One',
			'Heebo'                    => 'Heebo',
			'Henny Penny'              => 'Henny Penny',
			'Herr Von Muellerhoff'     => 'Herr Von Muellerhoff',
			'Hind'                     => 'Hind',
			'Hind Guntur'              => 'Hind Guntur',
			'Hind Madurai'             => 'Hind Madurai',
			'Hind Siliguri'            => 'Hind Siliguri',
			'Hind Vadodara'            => 'Hind Vadodara',
			'Holtwood One SC'          => 'Holtwood One SC',
			'Homemade Apple'           => 'Homemade Apple',
			'Homenaje'                 => 'Homenaje',
			'IM Fell DW Pica'          => 'IM Fell DW Pica',
			'IM Fell DW Pica SC'       => 'IM Fell DW Pica SC',
			'IM Fell Double Pica'      => 'IM Fell Double Pica',
			'IM Fell Double Pica SC'   => 'IM Fell Double Pica SC',
			'IM Fell English'          => 'IM Fell English',
			'IM Fell English SC'       => 'IM Fell English SC',
			'IM Fell French Canon'     => 'IM Fell French Canon',
			'IM Fell French Canon SC'  => 'IM Fell French Canon SC',
			'IM Fell Great Primer'     => 'IM Fell Great Primer',
			'IM Fell Great Primer SC'  => 'IM Fell Great Primer SC',
			'Iceberg'                  => 'Iceberg',
			'Iceland'                  => 'Iceland',
			'Imprima'                  => 'Imprima',
			'Inconsolata'              => 'Inconsolata',
			'Inder'                    => 'Inder',
			'Indie Flower'             => 'Indie Flower',
			'Inika'                    => 'Inika',
			'Inknut Antiqua'           => 'Inknut Antiqua',
			'Irish Grover'             => 'Irish Grover',
			'Istok Web'                => 'Istok Web',
			'Italiana'                 => 'Italiana',
			'Italianno'                => 'Italianno',
			'Itim'                     => 'Itim',
			'Jacques Francois'         => 'Jacques Francois',
			'Jacques Francois Shadow'  => 'Jacques Francois Shadow',
			'Jaldi'                    => 'Jaldi',
			'Jim Nightshade'           => 'Jim Nightshade',
			'Jockey One'               => 'Jockey One',
			'Jolly Lodger'             => 'Jolly Lodger',
			'Jomhuria'                 => 'Jomhuria',
			'Josefin Sans'             => 'Josefin Sans',
			'Josefin Slab'             => 'Josefin Slab',
			'Joti One'                 => 'Joti One',
			'Judson'                   => 'Judson',
			'Julee'                    => 'Julee',
			'Julius Sans One'          => 'Julius Sans One',
			'Junge'                    => 'Junge',
			'Jura'                     => 'Jura',
			'Just Another Hand'        => 'Just Another Hand',
			'Just Me Again Down Here'  => 'Just Me Again Down Here',
			'Kadwa'                    => 'Kadwa',
			'Kalam'                    => 'Kalam',
			'Kameron'                  => 'Kameron',
			'Kanit'                    => 'Kanit',
			'Kantumruy'                => 'Kantumruy',
			'Karla'                    => 'Karla',
			'Karma'                    => 'Karma',
			'Katibeh'                  => 'Katibeh',
			'Kaushan Script'           => 'Kaushan Script',
			'Kavivanar'                => 'Kavivanar',
			'Kavoon'                   => 'Kavoon',
			'Kdam Thmor'               => 'Kdam Thmor',
			'Keania One'               => 'Keania One',
			'Kelly Slab'               => 'Kelly Slab',
			'Kenia'                    => 'Kenia',
			'Khand'                    => 'Khand',
			'Khmer'                    => 'Khmer',
			'Khula'                    => 'Khula',
			'Kite One'                 => 'Kite One',
			'Knewave'                  => 'Knewave',
			'Kotta One'                => 'Kotta One',
			'Koulen'                   => 'Koulen',
			'Kranky'                   => 'Kranky',
			'Kreon'                    => 'Kreon',
			'Kristi'                   => 'Kristi',
			'Krona One'                => 'Krona One',
			'Kumar One'                => 'Kumar One',
			'Kumar One Outline'        => 'Kumar One Outline',
			'Kurale'                   => 'Kurale',
			'La Belle Aurore'          => 'La Belle Aurore',
			'Laila'                    => 'Laila',
			'Lakki Reddy'              => 'Lakki Reddy',
			'Lalezar'                  => 'Lalezar',
			'Lancelot'                 => 'Lancelot',
			'Lateef'                   => 'Lateef',
			'Lato'                     => 'Lato',
			'League Script'            => 'League Script',
			'Leckerli One'             => 'Leckerli One',
			'Ledger'                   => 'Ledger',
			'Lekton'                   => 'Lekton',
			'Lemon'                    => 'Lemon',
			'Lemonada'                 => 'Lemonada',
			'Libre Baskerville'        => 'Libre Baskerville',
			'Libre Franklin'           => 'Libre Franklin',
			'Life Savers'              => 'Life Savers',
			'Lilita One'               => 'Lilita One',
			'Lily Script One'          => 'Lily Script One',
			'Limelight'                => 'Limelight',
			'Linden Hill'              => 'Linden Hill',
			'Lobster'                  => 'Lobster',
			'Lobster Two'              => 'Lobster Two',
			'Londrina Outline'         => 'Londrina Outline',
			'Londrina Shadow'          => 'Londrina Shadow',
			'Londrina Sketch'          => 'Londrina Sketch',
			'Londrina Solid'           => 'Londrina Solid',
			'Lora'                     => 'Lora',
			'Love Ya Like A Sister'    => 'Love Ya Like A Sister',
			'Loved by the King'        => 'Loved by the King',
			'Lovers Quarrel'           => 'Lovers Quarrel',
			'Luckiest Guy'             => 'Luckiest Guy',
			'Lusitana'                 => 'Lusitana',
			'Lustria'                  => 'Lustria',
			'Macondo'                  => 'Macondo',
			'Macondo Swash Caps'       => 'Macondo Swash Caps',
			'Mada'                     => 'Mada',
			'Magra'                    => 'Magra',
			'Maiden Orange'            => 'Maiden Orange',
			'Maitree'                  => 'Maitree',
			'Mako'                     => 'Mako',
			'Mallanna'                 => 'Mallanna',
			'Mandali'                  => 'Mandali',
			'Marcellus'                => 'Marcellus',
			'Marcellus SC'             => 'Marcellus SC',
			'Marck Script'             => 'Marck Script',
			'Margarine'                => 'Margarine',
			'Marko One'                => 'Marko One',
			'Marmelad'                 => 'Marmelad',
			'Martel'                   => 'Martel',
			'Martel Sans'              => 'Martel Sans',
			'Marvel'                   => 'Marvel',
			'Mate'                     => 'Mate',
			'Mate SC'                  => 'Mate SC',
			'Maven Pro'                => 'Maven Pro',
			'McLaren'                  => 'McLaren',
			'Meddon'                   => 'Meddon',
			'MedievalSharp'            => 'MedievalSharp',
			'Medula One'               => 'Medula One',
			'Meera Inimai'             => 'Meera Inimai',
			'Megrim'                   => 'Megrim',
			'Meie Script'              => 'Meie Script',
			'Merienda'                 => 'Merienda',
			'Merienda One'             => 'Merienda One',
			'Merriweather'             => 'Merriweather',
			'Merriweather Sans'        => 'Merriweather Sans',
			'Metal'                    => 'Metal',
			'Metal Mania'              => 'Metal Mania',
			'Metamorphous'             => 'Metamorphous',
			'Metrophobic'              => 'Metrophobic',
			'Michroma'                 => 'Michroma',
			'Milonga'                  => 'Milonga',
			'Miltonian'                => 'Miltonian',
			'Miltonian Tattoo'         => 'Miltonian Tattoo',
			'Miniver'                  => 'Miniver',
			'Miriam Libre'             => 'Miriam Libre',
			'Mirza'                    => 'Mirza',
			'Miss Fajardose'           => 'Miss Fajardose',
			'Mitr'                     => 'Mitr',
			'Modak'                    => 'Modak',
			'Modern Antiqua'           => 'Modern Antiqua',
			'Mogra'                    => 'Mogra',
			'Molengo'                  => 'Molengo',
			'Molle'                    => 'Molle',
			'Monda'                    => 'Monda',
			'Monofett'                 => 'Monofett',
			'Monoton'                  => 'Monoton',
			'Monsieur La Doulaise'     => 'Monsieur La Doulaise',
			'Montaga'                  => 'Montaga',
			'Montez'                   => 'Montez',
			'Montserrat'               => 'Montserrat',
			'Montserrat Alternates'    => 'Montserrat Alternates',
			'Montserrat Subrayada'     => 'Montserrat Subrayada',
			'Moul'                     => 'Moul',
			'Moulpali'                 => 'Moulpali',
			'Mountains of Christmas'   => 'Mountains of Christmas',
			'Mouse Memoirs'            => 'Mouse Memoirs',
			'Mr Bedfort'               => 'Mr Bedfort',
			'Mr Dafoe'                 => 'Mr Dafoe',
			'Mr De Haviland'           => 'Mr De Haviland',
			'Mrs Saint Delafield'      => 'Mrs Saint Delafield',
			'Mrs Sheppards'            => 'Mrs Sheppards',
			'Mukta Vaani'              => 'Mukta Vaani',
			'Muli'                     => 'Muli',
			'Mystery Quest'            => 'Mystery Quest',
			'NTR'                      => 'NTR',
			'Neucha'                   => 'Neucha',
			'Neuton'                   => 'Neuton',
			'New Rocker'               => 'New Rocker',
			'News Cycle'               => 'News Cycle',
			'Niconne'                  => 'Niconne',
			'Nixie One'                => 'Nixie One',
			'Nobile'                   => 'Nobile',
			'Nokora'                   => 'Nokora',
			'Norican'                  => 'Norican',
			'Nosifer'                  => 'Nosifer',
			'Nothing You Could Do'     => 'Nothing You Could Do',
			'Noticia Text'             => 'Noticia Text',
			'Noto Sans'                => 'Noto Sans',
			'Noto Serif'               => 'Noto Serif',
			'Nova Cut'                 => 'Nova Cut',
			'Nova Flat'                => 'Nova Flat',
			'Nova Mono'                => 'Nova Mono',
			'Nova Oval'                => 'Nova Oval',
			'Nova Round'               => 'Nova Round',
			'Nova Script'              => 'Nova Script',
			'Nova Slim'                => 'Nova Slim',
			'Nova Square'              => 'Nova Square',
			'Numans'                   => 'Numans',
			'Nunito'                   => 'Nunito',
			'Odor Mean Chey'           => 'Odor Mean Chey',
			'Offside'                  => 'Offside',
			'Old Standard TT'          => 'Old Standard TT',
			'Oldenburg'                => 'Oldenburg',
			'Oleo Script'              => 'Oleo Script',
			'Oleo Script Swash Caps'   => 'Oleo Script Swash Caps',
			'Open Sans'                => 'Open Sans',
			'Open Sans Condensed'      => 'Open Sans Condensed',
			'Oranienbaum'              => 'Oranienbaum',
			'Orbitron'                 => 'Orbitron',
			'Oregano'                  => 'Oregano',
			'Orienta'                  => 'Orienta',
			'Original Surfer'          => 'Original Surfer',
			'Oswald'                   => 'Oswald',
			'Over the Rainbow'         => 'Over the Rainbow',
			'Overlock'                 => 'Overlock',
			'Overlock SC'              => 'Overlock SC',
			'Ovo'                      => 'Ovo',
			'Oxygen'                   => 'Oxygen',
			'Oxygen Mono'              => 'Oxygen Mono',
			'PT Mono'                  => 'PT Mono',
			'PT Sans'                  => 'PT Sans',
			'PT Sans Caption'          => 'PT Sans Caption',
			'PT Sans Narrow'           => 'PT Sans Narrow',
			'PT Serif'                 => 'PT Serif',
			'PT Serif Caption'         => 'PT Serif Caption',
			'Pacifico'                 => 'Pacifico',
			'Palanquin'                => 'Palanquin',
			'Palanquin Dark'           => 'Palanquin Dark',
			'Paprika'                  => 'Paprika',
			'Parisienne'               => 'Parisienne',
			'Passero One'              => 'Passero One',
			'Passion One'              => 'Passion One',
			'Pathway Gothic One'       => 'Pathway Gothic One',
			'Patrick Hand'             => 'Patrick Hand',
			'Patrick Hand SC'          => 'Patrick Hand SC',
			'Pattaya'                  => 'Pattaya',
			'Patua One'                => 'Patua One',
			'Pavanam'                  => 'Pavanam',
			'Paytone One'              => 'Paytone One',
			'Peddana'                  => 'Peddana',
			'Peralta'                  => 'Peralta',
			'Permanent Marker'         => 'Permanent Marker',
			'Petit Formal Script'      => 'Petit Formal Script',
			'Petrona'                  => 'Petrona',
			'Philosopher'              => 'Philosopher',
			'Piedra'                   => 'Piedra',
			'Pinyon Script'            => 'Pinyon Script',
			'Pirata One'               => 'Pirata One',
			'Plaster'                  => 'Plaster',
			'Play'                     => 'Play',
			'Playball'                 => 'Playball',
			'Playfair Display'         => 'Playfair Display',
			'Playfair Display SC'      => 'Playfair Display SC',
			'Podkova'                  => 'Podkova',
			'Poiret One'               => 'Poiret One',
			'Poller One'               => 'Poller One',
			'Poly'                     => 'Poly',
			'Pompiere'                 => 'Pompiere',
			'Pontano Sans'             => 'Pontano Sans',
			'Poppins'                  => 'Poppins',
			'Port Lligat Sans'         => 'Port Lligat Sans',
			'Port Lligat Slab'         => 'Port Lligat Slab',
			'Pragati Narrow'           => 'Pragati Narrow',
			'Prata'                    => 'Prata',
			'Preahvihear'              => 'Preahvihear',
			'Press Start 2P'           => 'Press Start 2P',
			'Pridi'                    => 'Pridi',
			'Princess Sofia'           => 'Princess Sofia',
			'Prociono'                 => 'Prociono',
			'Prompt'                   => 'Prompt',
			'Prosto One'               => 'Prosto One',
			'Proza Libre'              => 'Proza Libre',
			'Puritan'                  => 'Puritan',
			'Purple Purse'             => 'Purple Purse',
			'Quando'                   => 'Quando',
			'Quantico'                 => 'Quantico',
			'Quattrocento'             => 'Quattrocento',
			'Quattrocento Sans'        => 'Quattrocento Sans',
			'Questrial'                => 'Questrial',
			'Quicksand'                => 'Quicksand',
			'Quintessential'           => 'Quintessential',
			'Qwigley'                  => 'Qwigley',
			'Racing Sans One'          => 'Racing Sans One',
			'Radley'                   => 'Radley',
			'Rajdhani'                 => 'Rajdhani',
			'Rakkas'                   => 'Rakkas',
			'Raleway'                  => 'Raleway',
			'Raleway Dots'             => 'Raleway Dots',
			'Ramabhadra'               => 'Ramabhadra',
			'Ramaraja'                 => 'Ramaraja',
			'Rambla'                   => 'Rambla',
			'Rammetto One'             => 'Rammetto One',
			'Ranchers'                 => 'Ranchers',
			'Rancho'                   => 'Rancho',
			'Ranga'                    => 'Ranga',
			'Rasa'                     => 'Rasa',
			'Rationale'                => 'Rationale',
			'Ravi Prakash'             => 'Ravi Prakash',
			'Redressed'                => 'Redressed',
			'Reem Kufi'                => 'Reem Kufi',
			'Reenie Beanie'            => 'Reenie Beanie',
			'Revalia'                  => 'Revalia',
			'Rhodium Libre'            => 'Rhodium Libre',
			'Ribeye'                   => 'Ribeye',
			'Ribeye Marrow'            => 'Ribeye Marrow',
			'Righteous'                => 'Righteous',
			'Risque'                   => 'Risque',
			'Roboto'                   => 'Roboto',
			'Roboto Condensed'         => 'Roboto Condensed',
			'Roboto Mono'              => 'Roboto Mono',
			'Roboto Slab'              => 'Roboto Slab',
			'Rochester'                => 'Rochester',
			'Rock Salt'                => 'Rock Salt',
			'Rokkitt'                  => 'Rokkitt',
			'Romanesco'                => 'Romanesco',
			'Ropa Sans'                => 'Ropa Sans',
			'Rosario'                  => 'Rosario',
			'Rosarivo'                 => 'Rosarivo',
			'Rouge Script'             => 'Rouge Script',
			'Rozha One'                => 'Rozha One',
			'Rubik'                    => 'Rubik',
			'Rubik Mono One'           => 'Rubik Mono One',
			'Rubik One'                => 'Rubik One',
			'Ruda'                     => 'Ruda',
			'Rufina'                   => 'Rufina',
			'Ruge Boogie'              => 'Ruge Boogie',
			'Ruluko'                   => 'Ruluko',
			'Rum Raisin'               => 'Rum Raisin',
			'Ruslan Display'           => 'Ruslan Display',
			'Russo One'                => 'Russo One',
			'Ruthie'                   => 'Ruthie',
			'Rye'                      => 'Rye',
			'Sacramento'               => 'Sacramento',
			'Sahitya'                  => 'Sahitya',
			'Sail'                     => 'Sail',
			'Salsa'                    => 'Salsa',
			'Sanchez'                  => 'Sanchez',
			'Sancreek'                 => 'Sancreek',
			'Sansita One'              => 'Sansita One',
			'Sarala'                   => 'Sarala',
			'Sarina'                   => 'Sarina',
			'Sarpanch'                 => 'Sarpanch',
			'Satisfy'                  => 'Satisfy',
			'Scada'                    => 'Scada',
			'Scheherazade'             => 'Scheherazade',
			'Schoolbell'               => 'Schoolbell',
			'Scope One'                => 'Scope One',
			'Seaweed Script'           => 'Seaweed Script',
			'Secular One'              => 'Secular One',
			'Sevillana'                => 'Sevillana',
			'Seymour One'              => 'Seymour One',
			'Shadows Into Light'       => 'Shadows Into Light',
			'Shadows Into Light Two'   => 'Shadows Into Light Two',
			'Shanti'                   => 'Shanti',
			'Share'                    => 'Share',
			'Share Tech'               => 'Share Tech',
			'Share Tech Mono'          => 'Share Tech Mono',
			'Shojumaru'                => 'Shojumaru',
			'Short Stack'              => 'Short Stack',
			'Shrikhand'                => 'Shrikhand',
			'Siemreap'                 => 'Siemreap',
			'Sigmar One'               => 'Sigmar One',
			'Signika'                  => 'Signika',
			'Signika Negative'         => 'Signika Negative',
			'Simonetta'                => 'Simonetta',
			'Sintony'                  => 'Sintony',
			'Sirin Stencil'            => 'Sirin Stencil',
			'Six Caps'                 => 'Six Caps',
			'Skranji'                  => 'Skranji',
			'Slabo 13px'               => 'Slabo 13px',
			'Slabo 27px'               => 'Slabo 27px',
			'Slackey'                  => 'Slackey',
			'Smokum'                   => 'Smokum',
			'Smythe'                   => 'Smythe',
			'Sniglet'                  => 'Sniglet',
			'Snippet'                  => 'Snippet',
			'Snowburst One'            => 'Snowburst One',
			'Sofadi One'               => 'Sofadi One',
			'Sofia'                    => 'Sofia',
			'Sonsie One'               => 'Sonsie One',
			'Sorts Mill Goudy'         => 'Sorts Mill Goudy',
			'Source Code Pro'          => 'Source Code Pro',
			'Source Sans Pro'          => 'Source Sans Pro',
			'Source Serif Pro'         => 'Source Serif Pro',
			'Space Mono'               => 'Space Mono',
			'Special Elite'            => 'Special Elite',
			'Spicy Rice'               => 'Spicy Rice',
			'Spinnaker'                => 'Spinnaker',
			'Spirax'                   => 'Spirax',
			'Squada One'               => 'Squada One',
			'Sree Krushnadevaraya'     => 'Sree Krushnadevaraya',
			'Sriracha'                 => 'Sriracha',
			'Stalemate'                => 'Stalemate',
			'Stalinist One'            => 'Stalinist One',
			'Stardos Stencil'          => 'Stardos Stencil',
			'Stint Ultra Condensed'    => 'Stint Ultra Condensed',
			'Stint Ultra Expanded'     => 'Stint Ultra Expanded',
			'Stoke'                    => 'Stoke',
			'Strait'                   => 'Strait',
			'Sue Ellen Francisco'      => 'Sue Ellen Francisco',
			'Suez One'                 => 'Suez One',
			'Sumana'                   => 'Sumana',
			'Sunshiney'                => 'Sunshiney',
			'Supermercado One'         => 'Supermercado One',
			'Sura'                     => 'Sura',
			'Suranna'                  => 'Suranna',
			'Suravaram'                => 'Suravaram',
			'Suwannaphum'              => 'Suwannaphum',
			'Swanky and Moo Moo'       => 'Swanky and Moo Moo',
			'Syncopate'                => 'Syncopate',
			'Tangerine'                => 'Tangerine',
			'Taprom'                   => 'Taprom',
			'Tauri'                    => 'Tauri',
			'Taviraj'                  => 'Taviraj',
			'Teko'                     => 'Teko',
			'Telex'                    => 'Telex',
			'Tenali Ramakrishna'       => 'Tenali Ramakrishna',
			'Tenor Sans'               => 'Tenor Sans',
			'Text Me One'              => 'Text Me One',
			'The Girl Next Door'       => 'The Girl Next Door',
			'Tienne'                   => 'Tienne',
			'Tillana'                  => 'Tillana',
			'Timmana'                  => 'Timmana',
			'Tinos'                    => 'Tinos',
			'Titan One'                => 'Titan One',
			'Titillium Web'            => 'Titillium Web',
			'Trade Winds'              => 'Trade Winds',
			'Trirong'                  => 'Trirong',
			'Trocchi'                  => 'Trocchi',
			'Trochut'                  => 'Trochut',
			'Trykker'                  => 'Trykker',
			'Tulpen One'               => 'Tulpen One',
			'Ubuntu'                   => 'Ubuntu',
			'Ubuntu Condensed'         => 'Ubuntu Condensed',
			'Ubuntu Mono'              => 'Ubuntu Mono',
			'Ultra'                    => 'Ultra',
			'Uncial Antiqua'           => 'Uncial Antiqua',
			'Underdog'                 => 'Underdog',
			'Unica One'                => 'Unica One',
			'UnifrakturCook'           => 'UnifrakturCook',
			'UnifrakturMaguntia'       => 'UnifrakturMaguntia',
			'Unkempt'                  => 'Unkempt',
			'Unlock'                   => 'Unlock',
			'Unna'                     => 'Unna',
			'VT323'                    => 'VT323',
			'Vampiro One'              => 'Vampiro One',
			'Varela'                   => 'Varela',
			'Varela Round'             => 'Varela Round',
			'Vast Shadow'              => 'Vast Shadow',
			'Vesper Libre'             => 'Vesper Libre',
			'Vibur'                    => 'Vibur',
			'Vidaloka'                 => 'Vidaloka',
			'Viga'                     => 'Viga',
			'Voces'                    => 'Voces',
			'Volkhov'                  => 'Volkhov',
			'Vollkorn'                 => 'Vollkorn',
			'Voltaire'                 => 'Voltaire',
			'Waiting for the Sunrise'  => 'Waiting for the Sunrise',
			'Wallpoet'                 => 'Wallpoet',
			'Walter Turncoat'          => 'Walter Turncoat',
			'Warnes'                   => 'Warnes',
			'Wellfleet'                => 'Wellfleet',
			'Wendy One'                => 'Wendy One',
			'Wire One'                 => 'Wire One',
			'Work Sans'                => 'Work Sans',
			'Yanone Kaffeesatz'        => 'Yanone Kaffeesatz',
			'Yantramanav'              => 'Yantramanav',
			'Yatra One'                => 'Yatra One',
			'Yellowtail'               => 'Yellowtail',
			'Yeseva One'               => 'Yeseva One',
			'Yesteryear'               => 'Yesteryear',
			'Yrsa'                     => 'Yrsa',
			'Zeyada'                   => 'Zeyada',
		];

		$font_preview = [
			'text' => "<span class=\"nums\">1234567890</span><span class=\"uppers\">ABCDEFGHIKLMNOPQRSTVXYZ</span><span class=\"lowers\">abcdefghiklmnopqrstvxyz</span>",
			'size' => '25px'
		];

		$font_primary_list = array_merge( [ 'none' => 'Use default' ], $fonts_list );
		$font_heading_list = array_merge( [ 'none' => 'Use default' ], $fonts_list );

		$font_weights = [
			''     => 'Use Default',
			300,
			400,
			500,
			600,
			700,
			'bold' => 'Bold'
		];

		$text_transforms = [
			''           => 'Use Default',
			'none'       => 'None',
			'uppercase'  => 'Upper Case',
			'lowercase'  => 'Lower Case',
			'capitalize' => 'Capitalize',
		];


		$of_options[] = [
			'name' => 'Typography',
			'type' => 'heading',
			'icon' => 'icon-typography'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'typography-settings-tabs',
			'tabs' => []
		];

		$of_options[] = [
			'name' => 'هشدار تایپوگرافی',
			'desc' => "",
			'id'   => 'typography_warning',
			'std'  => "<h3 style=\"margin: 0 0 10px;\">تایپوگرافی انتقال داده شده است به <strong>آزمایشگاه &gt; تایپوگرافی</strong></h3>
						<a href='admin.php?page=typolab'>برای ورود به بخش TypoLab کلیک کنید &raquo;</a>",
			'icon' => true,
			'type' => 'info',
		];

		$of_options[] = [
			'name' => 'Theme Styling',
			'type' => 'heading',
			'icon' => 'icon-theme-styling'
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'styling-settings-tabs',
			'tabs' => [
				'styling-settings-skin'    => 'پوسته سفارشی',
				'styling-settings-borders' => 'حاشیه های قالب'
			]
		];

		$of_options[] = [
			'name'  => 'پوسته ساز سفارشی',
			'desc'  => 'پوسته سفارشی خود را برای این قالب بسازید',
			'id'    => 'use_custom_skin',
			'std'   => 0,
			'folds' => 1,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',

			'tab_id' => 'styling-settings-skin'
		];

		if ( 'admin.php' == $pagenow && 'laborator_options' === kalium()->request->query( 'page' ) ) {
			$custom_skin_path          = kalium_get_custom_skin_file_path( true );
			$custom_skin_path_relative = wp_basename( WP_CONTENT_DIR ) . DIRECTORY_SEPARATOR . kalium_get_custom_skin_file_path();

			if ( false === file_exists( $custom_skin_path ) ) {
				@touch( $custom_skin_path );
			}

			$custom_skin_file_exists = true === file_exists( $custom_skin_path );
			$custom_skin_writable    = is_writable( $custom_skin_path );

			if ( ! $custom_skin_file_exists ) {
				$of_options[] = [
					'name' => 'Custom Skin Builder',
					'desc' => "",
					'id'   => 'custom_skin_builder_info',
					'std'  => "<h3 style=\"margin: 0 0 10px;\">Warning</h3>
					
					Custom skin file couldn't be generated, make sure the directory is writable!
					<code>File path: <strong title='$custom_skin_path'>$custom_skin_path_relative</strong></code>	
					",
					'icon' => true,
					'type' => 'info',

					'fold' => 'use_custom_skin',

					'tab_id' => 'skin-settings-skin'
				];
			} else if ( ! $custom_skin_writable ) {
				$of_options[] = [
					'name' => 'Custom Skin Builder',
					'desc' => "",
					'id'   => 'custom_skin_builder_info',
					'std'  => "<h3 style=\"margin: 0 0 10px;\">Warning</h3>
					
					<code>File path:  <strong title='$custom_skin_path'>$custom_skin_path_relative</strong></code>
					Custom skin file exists but is not writable, therefore generated skin will not be reflected on your site!<br>
					Try setting file permissions to <strong>766</strong> to the file above and refresh this page.
					<a href='https://codex.wordpress.org/Changing_File_Permissions' target='_blank'>Learn more</a>	
					",
					'icon' => true,
					'type' => 'info',

					'fold' => 'use_custom_skin',

					'tab_id' => 'skin-settings-skin'
				];
			}
		}

		$of_options[] = [
			'name' => 'رنگ های پوسته',
			'desc' => 'رنگ پس زمینه',
			'id'   => 'custom_skin_bg_color',
			'std'  => '#FFF',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'desc' => 'رنگ لینک',
			'id'   => 'custom_skin_link_color',
			'std'  => '#F6364D',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'desc' => 'رنگ عناوین',
			'id'   => 'custom_skin_headings_color',
			'std'  => '#F6364D',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'desc' => 'رنگ پاراگراف',
			'id'   => 'custom_skin_paragraph_color',
			'std'  => '#777777',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'desc' => 'رنگ پس زمینه پاورقی',
			'id'   => 'custom_skin_footer_bg_color',
			'std'  => '#FAFAFA',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'desc' => 'رنگ حاشیه ها',
			'id'   => 'custom_skin_borders_color',
			'std'  => '#EEEEEE',
			'type' => 'color',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];

		$of_options[] = [
			'name' => 'CSS سفارشی',
			'desc' => "",
			'id'   => 'skin_palettes_list',
			'std'  => "
						<h3 style=\"margin: 0 0 10px;\">انتخاب ما از پالت های از پیش تعیین شده پوسته</h3>".
					  '
						<a href="#" class=\'skin-palette\'>
							<span style="background-color: #FFF;"></span>
							<span style="background-color: #F6364D;"></span>
							<span style="background-color: #F6364D;"></span>
							<span style="background-color: #777;"></span>
							<span style="background-color: #FAFAFA;"></span>
							<span style="background-color: #EEE;"></span>
							
							<em>صورتی</em>
						</a>
						
						<a href="#" class=\'skin-palette\'>
							<span style="background-color: #f2f0ec;"></span>
							<span style="background-color: #e09a0e;"></span>
							<span style="background-color: #242321;"></span>
							<span style="background-color: #242321;"></span>
							<span style="background-color: #ece9e4;"></span>
							<span style="background-color: #FFF;"></span>
							
							<em>طلایی</em>
						</a>
						
						<a href="#" class=\'skin-palette\'>
							<span style="background-color: #FFF;"></span>
							<span style="background-color: #a58f60;"></span>
							<span style="background-color: #222;"></span>
							<span style="background-color: #555;"></span>
							<span style="background-color: #EAEAEA;"></span>
							<span style="background-color: #EEE;"></span>
							
							<em>کرمی</em>
						</a>
						
						<a href="#" class=\'skin-palette\'>
							<span style="background-color: #333333;"></span>
							<span style="background-color: #FBC441;"></span>
							<span style="background-color: #FFF;"></span>
							<span style="background-color: #CCC;"></span>
							<span style="background-color: #222;"></span>
							<span style="background-color: #333;"></span>
							
							<em>پوسته تیره</em>
						</a>
						'
			,
			'icon' => true,
			'type' => 'info',
			'fold' => 'use_custom_skin',

			'tab_id' => 'styling-settings-skin',
		];


		// BORDERS
		/*
$of_options[] = array( 	'name' 		=> 'Borders',
						'type' 		=> 'heading',
						'icon'		=> 'fa fa-square-o'
				);
*/

		$of_options[] = [
			'name'  => 'حاشیه های قالب',
			'desc'  => 'نمایش یا پنهان کردن حاشیه های قالب',
			'id'    => 'theme_borders',
			'std'   => 0,
			'folds' => 1,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',

			'tab_id' => 'styling-settings-borders'
		];

		$of_options[] = [
			'name'    => 'تنظیمات حاشیه',
			'desc'    => 'نمایش حاشیه ها با انیمیشن',
			'id'      => 'theme_borders_animation',
			'std'     => 'fade',
			'options' => [
				'none'  => 'بدون انیمیشن',
				'fade'  => 'محو شدن به داخل',
				'slide' => 'اسلاید شدن به داخل',
			],
			'type'    => 'select',
			'fold'    => 'theme_borders',

			'tab_id' => 'styling-settings-borders',

			'afolds' => 1
		];

		$of_options[] = [
			'desc'    => 'مدت زمان انیمیشن به ثانیه <em>(اگر انیمیشن فعال باشد)</em>',
			'id'      => 'theme_borders_animation_duration',
			'std'     => '1',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 's',
			'fold'    => 'theme_borders',

			'afold' => 'theme_borders_animation:fade,slide',

			'tab_id' => 'styling-settings-borders',
		];

		$of_options[] = [
			'desc'    => 'مدت زمان تأخیر انیمیشن حاشیه ها <em>(اگر انیمیشن فعال باشد)</em>',
			'id'      => 'theme_borders_animation_delay',
			'std'     => '0.2',
			'type'    => 'text',
			'numeric' => true,
			'fold'    => 'theme_borders',

			'afold' => 'theme_borders_animation:fade,slide',

			'tab_id' => 'styling-settings-borders',
		];

		$of_options[] = [
			'desc'    => 'ضخامت حاشیه',
			'id'      => 'theme_borders_thickness',
			'std'     => '',
			'plc'     => 'اگر تنظیم نشده باشد، از پیش فرض استفاده می شود: 22',
			'type'    => 'text',
			'postfix' => 'px',
			'numeric' => true,
			'fold'    => 'theme_borders',

			'tab_id' => 'styling-settings-borders',
		];

		$of_options[] = [
			'desc' => 'تنظیم رنگ حاشیه ها',
			'id'   => 'theme_borders_color',
			'std'  => '#f3f3ef',
			'type' => 'color',
			'fold' => 'theme_borders',

			'tab_id' => 'styling-settings-borders',
		];
		// END OF BORDERS


		$of_options[] = [
			'name' => 'Social Networks',
			'type' => 'heading',
			'icon' => 'icon-social-networks'
		];

		$social_networks_ordering = [
			'visible' => [
				'placebo' => 'placebo',
				'fb'      => 'Facebook',
				'tw'      => 'Twitter',
				'ig'      => 'Instagram',
				'vm'      => 'Vimeo',
				'be'      => 'Behance',
				'fs'      => 'Foursquare',
				'custom'  => 'Custom Link',
			],

			'hidden' => [
				'placebo' => 'placebo',
				'lin'     => 'LinkedIn',
				'yt'      => 'YouTube',
				'drb'     => 'Dribbble',
				'pi'      => 'Pinterest',
				'vk'      => 'VKontakte',
				'da'      => 'DeviantArt',
				'fl'      => 'Flickr',
				'tu'      => 'Tumblr',
				'sk'      => 'Skype',
				'gh'      => 'GitHub',
				'sc'      => 'SoundCloud',
				'hz'      => 'Houzz',
				'px'      => '500px',
				'xi'      => 'Xing',
				'sp'      => 'Spotify',
				'sn'      => 'Snapchat',
				'em'      => 'Email',
				'yp'      => 'Yelp',
				'ta'      => 'TripAdvisor',
				'tc'      => 'Twitch',
				'wa'      => 'WhatsApp',
			],
		];

		$of_options[] = [
			'name' => 'مرتب سازی شبکه های اجتماعی',
			'desc' => "نظم ظاهر شبکه های اجتماعی در پایین صفحه را تنظیم کنید. برای استفاده از لیست لینکهای شبکه اجتماعی، این کد کوتاه را کپی کنید:<br> " . $lab_social_networks_shortcode,
			'id'   => 'social_order',
			'std'  => $social_networks_ordering,
			'type' => 'sorter'
		];

		$of_options[] = [
			'name'    => 'هدف لینک',
			'desc'    => 'باز کردن پیوندهای اجتماعی در پنجره جدید یا پنجره فعلی',
			'id'      => 'social_networks_target_attr',
			'std'     => '_blank',
			'type'    => 'select',
			'options' => [
				'_self'  => 'همان پنجره',
				'_blank' => 'پنجره جدید',
			]
		];

		$of_options[] = [
			'name' => 'لینک های شبکه های اجتماعی',
			'desc' => 'Facebook',
			'id'   => 'social_network_link_fb',
			'std'  => "",
			'plc'  => "https://facebook.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Twitter',
			'id'   => 'social_network_link_tw',
			'std'  => "",
			'plc'  => "https://twitter.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'LinkedIn',
			'id'   => 'social_network_link_lin',
			'std'  => "",
			'plc'  => "https://linkedin.com/in/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'YouTube',
			'id'   => 'social_network_link_yt',
			'std'  => "",
			'plc'  => "https://youtube.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Vimeo',
			'id'   => 'social_network_link_vm',
			'std'  => "",
			'plc'  => "https://vimeo.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Dribbble',
			'id'   => 'social_network_link_drb',
			'std'  => "",
			'plc'  => "https://dribbble.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Instagram',
			'id'   => 'social_network_link_ig',
			'std'  => "",
			'plc'  => "https://instagram.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Pinterest',
			'id'   => 'social_network_link_pi',
			'std'  => "",
			'plc'  => "https://pinterest.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'VKontakte',
			'id'   => 'social_network_link_vk',
			'std'  => "",
			'plc'  => "https://vk.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'DeviantArt',
			'id'   => 'social_network_link_da',
			'std'  => "",
			'plc'  => "https://username.deviantart.com",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Tumblr',
			'id'   => 'social_network_link_tu',
			'std'  => "",
			'plc'  => "https://username.tumblr.com",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Behance',
			'id'   => 'social_network_link_be',
			'std'  => "",
			'plc'  => "https://www.behance.net/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Flickr',
			'id'   => 'social_network_link_fl',
			'std'  => "",
			'plc'  => "https://www.flickr.com/photos/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Foursquare',
			'id'   => 'social_network_link_fs',
			'std'  => "",
			'plc'  => "https://foursquare.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Skype',
			'id'   => 'social_network_link_sk',
			'std'  => "",
			'plc'  => 'skype:username',
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'GitHub',
			'id'   => 'social_network_link_gh',
			'std'  => "",
			'plc'  => "https://github.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'SoundCloud',
			'id'   => 'social_network_link_sc',
			'std'  => "",
			'plc'  => "https://soundcloud.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Houzz',
			'id'   => 'social_network_link_hz',
			'std'  => "",
			'plc'  => "https://www.houzz.com/user/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => '500px',
			'id'   => 'social_network_link_px',
			'std'  => "",
			'plc'  => "https://500px.com/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Xing',
			'id'   => 'social_network_link_xi',
			'std'  => "",
			'plc'  => "https://www.xing.com/profile/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Spotify',
			'id'   => 'social_network_link_sp',
			'std'  => "",
			'plc'  => "https://open.spotify.com/user/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Snapchat',
			'id'   => 'social_network_link_sn',
			'std'  => "",
			'plc'  => "https://www.snapchat.com/add/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Yelp',
			'id'   => 'social_network_link_yp',
			'std'  => "",
			'plc'  => "https://www.yelp.com/biz/alias",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Trip Advisor',
			'id'   => 'social_network_link_ta',
			'std'  => "",
			'plc'  => "https://www.tripadvisor.com/",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'Twitch',
			'id'   => 'social_network_link_tc',
			'std'  => "",
			'plc'  => "https://www.twitch.tv/username",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "",
			'desc' => 'WhatsApp',
			'id'   => 'social_network_link_wa',
			'std'  => "",
			'plc'  => "https://api.whatsapp.com/send?phone=123456789&text=Hello",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => "ایمیل",
			'desc' => 'ایمیل تماس باما',
			'id'   => 'social_network_link_em',
			'std'  => "",
			'plc'  => "john.doe@email.com",
			'type' => 'text'
		];

		$of_options[] = [
			'desc' => 'عنوان پیشفرض',
			'id'   => 'social_network_link_em_subject',
			'std'  => "سلام! retsnompw",
			'plc'  => "",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => 'لینک سفارشی',
			'desc' => 'عنوان لینک',
			'id'   => 'social_network_custom_link_title',
			'std'  => "",
			'plc'  => 'لینک سفارشی من',
			'type' => 'text'
		];

		$of_options[] = [
			'desc' => 'لینک',
			'id'   => 'social_network_custom_link_link',
			'std'  => "",
			'plc'  => "https://www.mywebsite.com/",
			'type' => 'text'
		];

		$of_options[] = [
			'desc' => 'آیکون (اختیاری)<br><small>توجه: اگر می خواهید آیکون سفارشی را تنظیم کنید، نام مستعار آیکون را از کالکشن آیکون <a href="http://fontawesome.io/icons/" target="_blank">Font Awesome</a> انتخاب کنید.</small>','Icon (optional)<br><small>Note: If you want to set custom icon, enter icon alias from <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">Font Awesome</a> icon collection.</small>',
			'id'   => 'social_network_custom_link_icon',
			'std'  => "",
			'plc'  => "مثال: bookmark",
			'type' => 'text'
		];

		$of_options[] = [
			'name' => 'Coming Soon Mode',
			'type' => 'heading',
			'icon' => 'icon-coming-soon-mode',
		];

		$of_options[] = [
			'type' => 'tabs',
			'id'   => 'coming-soon-settings-tabs',
			'tabs' => [
				'coming-soon-settings-main'        => 'تنظیمات عمومی',
				'coming-soon-settings-countdown'   => 'تایمر شمارنده',
				'coming-soon-settings-custom-bg'   => 'پس زمینه سفارشی',
				'coming-soon-settings-custom-logo' => 'لوگوی سفارشی',
			]
		];

		$of_options[] = [
			'name' => 'هشدار به زودی',
			'desc' => "",
			'id'   => 'custom_coming_soon_warning',
			'std'  => "<h3 style=\"margin: 0 0 10px;\">هشدار</h3>
					برای مشاهده تنظیمات در این زبانه را باید <strong>حالت بزودی</strong> را در زبانه <strong>تنظیمات عمومی</strong> فعال کنید.",
			'icon' => true,
			'type' => 'info',

			'afold' => 'coming_soon_mode:notChecked',

			'tab_id' => 'coming-soon-settings-countdown'
		];

		$last = end( $of_options );

		$last['tab_id'] = 'coming-soon-settings-custom-bg';
		$of_options[]   = $last;

		$last['tab_id'] = 'coming-soon-settings-custom-logo';
		$of_options[]   = $last;

		$of_options[] = [
			'name'   => 'حالت به زودی',
			'desc'   => "حالت به زودی صفحه و تایمر شمارنده را فعال کنید.<br /><small>توجه داشته باشید که به عنوان مدیر شما صفحه به زودی را نمی بینید مگر اینکه <a href=\"" . home_url( '?view-coming-soon=true' ) . "\" target=\"_blank\">اینجا کلیک کنید</a>.</small>",
			'id'     => 'coming_soon_mode',
			'std'    => 0,
			'on'     => 'فعال',
			'off'    => 'غیرفعال',
			'type'   => 'switch',
			'afolds' => 1,

			'tab_id' => 'coming-soon-settings-main'
		];

		$of_options[] = [
			'name'  => 'عنوان و توضیحات',
			'desc'  => 'عنوان صفحه را برای نشان دادن در این صفحه تنظیم کنید (برای استفاده از شعار سایت خالی بگذارید)',
			'id'    => 'coming_soon_mode_title',
			'std'   => "",
			'type'  => 'text',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-main'
		];

		$of_options[] = [
			'desc'  => 'متنی که به بازدیدکنندگان شما توضیح میدهد چرا این سایت در دست تعمیر است',
			'id'    => 'coming_soon_mode_description',
			'std'   => "ما در حال حاضر در حال کار روی قالب جدید هستنیم ،
تیم ما بشدت در حال کار است و به زودی برمیگردیم",
			'type'  => 'textarea',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-main'
		];

		$of_options[] = [
			'name'  => 'شبکه های اجتماعی',
			'desc'  => 'نمایان یا پنهان کردن شبکه های اجتماعی در پاورقی این صفحه',
			'id'    => 'coming_soon_mode_social_networks',
			'std'   => 0,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-main'
		];

		$of_options[] = [
			'name'  => 'تایمر شمارش معکوس',
			'desc'  => 'نمایان یا پنهان کردن تایمر شمارش معکوس',
			'id'    => 'coming_soon_mode_countdown',
			'std'   => 0,
			'on'    => 'نمایان',
			'off'   => 'پنهان',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-countdown'
		];

		$of_options[] = [
			'name'  => 'تاریخ انتشار',
			'desc' 		=> 'تاریخی را که سایت آنلاین میشود وارد کنید (فرمت YYYY-MM-DD HH: MM: SS)',
			'id'    => 'coming_soon_mode_date',
			'std'   => date( 'Y-m-d', strtotime( "+3 months" ) ) . ' 18:00:00',
			'plc'   => "",
			'type'  => 'text',
			'fold'  => 'coming_soon_mode_countdown',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-countdown'
		];

		$of_options[] = [
			'name'  => 'پس زمینه سفارشی',
			'desc'  => 'شامل تصویر پس زمینه سفارشی برای این صفحه',
			'id'    => 'coming_soon_mode_custom_bg',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-bg'
		];

		$of_options[] = [
			'name'  => 'آپلود تصویر پس زمینه',
			'desc'  => "تصویر پس زمینه سفارشی خود را آپلود/انتخاب کنید",
			'id'    => 'coming_soon_mode_custom_bg_id',
			'std'   => "",
			'type'  => 'media',
			'mod'   => 'min',
			'fold'  => 'coming_soon_mode_custom_bg',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-bg'
		];

		$of_options[] = [
			'desc'    => 'تنظیمات ظرفیت پس زمینه',
			'id'      => 'coming_soon_mode_custom_bg_size',
			'std'     => 'cover',
			'type'    => 'select',
			'options' => [
				'cover'   => 'کاور',
				'contain' => 'شامل',
			],
			'fold'    => 'coming_soon_mode_custom_bg',
			'afold'   => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-bg'
		];

		$of_options[] = [
			'desc'  => 'رنگ پس زمینه (اختیاری)',
			'id'    => 'coming_soon_mode_custom_bg_color',
			'std'   => '',
			'type'  => 'color',
			'fold'  => 'coming_soon_mode_custom_bg',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-bg'
		];

		$of_options[] = [
			'desc'  => 'رنگ متن (اختیاری)',
			'id'    => 'coming_soon_mode_custom_txt_color',
			'std'   => '',
			'type'  => 'color',
			'fold'  => 'coming_soon_mode_custom_bg',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-bg'
		];

		$of_options[] = [
			'name'  => 'لوگوی سفارشی',
			'desc'  => 'استفاده از لوگوی سفارشی',
			'id'    => 'coming_soon_mode_use_uploaded_logo',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-logo'
		];

		$of_options[] = [
			'name'  => 'آپلود لوگو',
			'desc'  => "تصویر لوگوی سفارشی خود را از گالری انتخاب کنید اگر میخواهید از آن به جای لوگوی پیشفرض آپلود شده در بخش <strong>لوگو و برندینگ</strong> استفاده کنید",
			'id'    => 'coming_soon_mode_custom_logo_image',
			'std'   => "",
			'type'  => 'media',
			'mod'   => 'min',
			'fold'  => 'coming_soon_mode_use_uploaded_logo',
			'afold' => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-logo'
		];

		$of_options[] = [
			'desc'    => 'حداکثر عرض برای لوگو آپلود شده را تنظیم کنید',
			'id'      => 'coming_soon_mode_custom_logo_max_width',
			'std'     => "",
			'plc'     => 'عرض لوگو',
			'type'    => 'text',
			'numeric' => true,
			'postfix' => 'px',
			'fold'    => 'coming_soon_mode_use_uploaded_logo',
			'afold'   => 'coming_soon_mode:checked',

			'tab_id' => 'coming-soon-settings-custom-logo'
		];

		$of_options[] = [
			'name' => 'Maintenance Mode',
			'type' => 'heading',
			'icon' => 'icon-maintenance-mode',
		];

		$of_options[] = [
			'name'  => 'حالت تعمیر',
			'desc'  => "حالت تعمیر را فعال یا غیرفعال کنید. توجه داشته باشید که اگر حالت به زودی فعال باشد، این صفحه نمایش داده نمیشود.<br /><sتوجه داشته باشید که به عنوان مدیر شما صفحه به زودی را نمی بینید مگر اینکه <a href=\"" . home_url( '?view-maintenance=true' ) . "\" target=\"_blank\">اینجا کلیک کنید</a>.</small>",
			'id'    => 'maintenance_mode',
			'std'   => 0,
			'on'    => 'فعال',
			'off'   => 'غیرفعال',
			'type'  => 'switch',
			'folds' => 1
		];

		$of_options[] = [
			'name' => 'عنوان و توضیحات',
			'desc' => 'عنوان صفحه را برای نشان دادن در این صفحه تنظیم کنید (برای استفاده از شعار سایت خالی بگذارید)',
			'id'   => 'maintenance_mode_title',
			'std'  => "",
			'type' => 'text',
			'fold' => 'maintenance_mode'
		];

		$of_options[] = [
			'desc' => 'متنی که به بازدیدکنندگان شما توضیح میدهد چرا این سایت در دست تعمیر است',
			'id'   => 'maintenance_mode_description',
			'std'  => "ما در حال حاضر در حال کار روی قالب جدید هستنیم ،
تیم ما بشدت در حال کار است و به زودی برمیگردیم",
			'type' => 'textarea',
			'fold' => 'maintenance_mode'
		];

		$of_options[] = [
			'name'  => 'پس زمینه سفارشی',
			'desc'  => 'شامل تصویر پس زمینه سفارشی برای این صفحه',
			'id'    => 'maintenance_mode_custom_bg',
			'std'   => 0,
			'on'    => 'بله',
			'off'   => 'خیر',
			'type'  => 'switch',
			'folds' => 1,
			'fold'  => 'maintenance_mode'
		];

		$of_options[] = [
			'name' => 'آپلود تصویر پس زمینه',
			'desc' => "تصویر پس زمینه سفارشی خود را آپلود/انتخاب کنید",
			'id'   => 'maintenance_mode_custom_bg_id',
			'std'  => "",
			'type' => 'media',
			'mod'  => 'min',
			'fold' => 'maintenance_mode_custom_bg'
		];

		$of_options[] = [
			'desc'    => 'تنظیمات ظرفیت پس زمینه',
			'id'      => 'maintenance_mode_custom_bg_size',
			'std'     => 'cover',
			'type'    => 'select',
			'options' => [
				'cover'   => 'کاور',
				'contain' => 'شامل',
			],
			'fold'    => 'maintenance_mode_custom_bg'
		];

		$of_options[] = [
			'desc' => 'رنگ پس زمینه (اختیاری)',
			'id'   => 'maintenance_mode_custom_bg_color',
			'std'  => '',
			'type' => 'color',
			'fold' => 'maintenance_mode_custom_bg'
		];

		$of_options[] = [
			'desc' => 'رنگ نوشته (اختیاری)',
			'id'   => 'maintenance_mode_custom_txt_color',
			'std'  => '',
			'type' => 'color',
			'fold' => 'maintenance_mode_custom_bg'
		];


		// Backup Options
		$of_options[] = [
			'name' => 'Backup Options',
			'type' => 'heading',
			'icon' => 'icon-backup-options'
		];

		$of_options[] = [
			'name' => 'تنظیمات پشتیبان گیری و بازگردانی',
			'id'   => 'of_backup',
			'std'  => "",
			'type' => 'backup',
			'desc' => 'شما می توانید از دو دکمه زیر برای پشتیبان گیری از تنظیمات فعلی خود استفاده کنید و سپس پس از مدتی آن را بازگردانید. این مفید است اگر شما می خواهید روی تنظیمات آزمایش کنید، اما می خواهید تنظیمات قدیمی را نگه دارید در صورتی که دوباره به آن ها نیاز داشتید',
		];

		$of_options[] = [
			'name' => 'انتقال داده های تنظیمات قالب',
			'id'   => 'of_transfer',
			'std'  => "",
			'type' => 'transfer',
			'desc' => 'شما می توانید داده های تنظیمات ذخیره شده را بین نصب های مختلف را با کپی متن داخل کادر انتقال دهید. برای درون ریزی داده ها از نصب دیگر، داده ها را در جعبه متن با یکی از نصب های دیگر جایگزین کنید و روی «درون ریزی تنظیمات» کلیک کنید',
		];

		$of_options[] = [
			'name'     => 'Documentation',
			'type'     => 'heading',
			'icon'     => 'icon-documentation',
			'redirect' => Kalium_About::get_tab_link( 'help' ),
		];

		$of_options[] = [
			'name' => 'مستندات قالب',
			'desc' => "",
			'id'   => 'theme_documentation',
			'std'  => "<h3 style=\"margin: 0 0 10px;\">مستندات قالب</h3>
						<a href=\"" . Kalium_About::get_tab_link( 'help' ) . "\">برای دسترسی به مستندات قالب کلیک کنید &raquo;</a>",
			'icon' => true,
			'type' => 'info'
		];

		$of_options[] = [
			'name' => 'Changelog',
			'type' => 'heading',
			'icon' => 'icon-changelog',
		];
	}
}

add_action( 'init', 'of_options' );
