<?php
/**
 * Kalium WordPress Theme //WPMonster.co
 *
 * Help page.
 *
 * @var array   $help_links
 * @var int     $support_remaining
 * @var boolean $support_nearly_expiring
 * @var boolean $is_theme_registered
 * @var string  $support_left
 * @var string  $support_status
 * @var string  $support_status_class
 * @var string  $support_badge_class
 * @var string  $validate_license_link
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="row">
    <div class="col col-7 col-lg-12">
        <div class="about-kalium__heading no-top-margin">
            <h2>راهنما</h2>
            <p>بخش راهنمایی که علاقه دارید در آن زمینه بیشتر بدانید انتخاب کنید. هر بخش شامل مقاله هایی میباشند که ممکن است بدون باز کردن تیکت پشتیبانی به سؤال شما پاسخ دهند.</p>
        </div>

        <ul class="about-kalium__help-links row">

			<?php if ( ! empty( $help_links ) ) : foreach ( $help_links as $help_link ) : ?>
                <li class="col col-3 col-sm-6">
                    <a href="<?php echo esc_url( $help_link['link'] ); ?>" target="_blank" rel="noreferrer noopener" class="about-kalium__help-links-entry">
                        <img src="<?php echo esc_url( kalium()->assets_url( "admin/images/help/{$help_link['icon']}.svg" ) ); ?>" width="45" height="45" alt="<?php echo sanitize_title( $help_link['title'] ); ?>">
                        <span><?php echo esc_html( $help_link['title'] ); ?></span>
                    </a>
                </li>
			<?php endforeach; endif; ?>

        </ul>
    </div>
    <div class="col col-5 col-lg-12">

        <div class="about-kalium__support-info">

			<?php if ( ! $is_theme_registered ) : ?>
                <div class="about-kalium__support-info about-kalium__support-info--not-registered">
                    <h4 class="no-margin">Theme not registered</h4>
                    <p class="about-kalium__support-info-status">To view your support status you must register the
                        theme.</p>
                    <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'theme-registration' ) ); ?>" class="button button-primary">Register
                        theme</a>
                </div>
			<?php endif; ?>

            <h3>پشتیبانی هیولای وردپرس</h3>

            <p>از زمانی که شما محصول را خریداری مینمایید تا 6 ماه بصورت رایگان پشتیبانی دریافت خواهید کرد، پس از اتمام این دوره زمانی شما میتوانید مجددا پشتیبانی خود را تمدید نمایید.</p>

           

            <h4>موارد شامل پشتیبانی</h4>
            <ul>
                <li>
                    <i class="dashicons dashicons-yes"></i>
                  سوالات و یا مشکلات مرتبط با قالب
                </li>
                <li>
                    <i class="dashicons dashicons-yes"></i>
                   رفع باگ های موجود در چهارچوب بومی سازی قالب
                </li>
                <li>
                    <i class="dashicons dashicons-yes"></i>
                    ارائه آپدیت های جدید محصول
                </li>
            </ul>

            <h4>مواردی که شامل پشتیبانی نمیشوند:</h4>
            <ul>
                <li>
                    <i class="dashicons dashicons-no-alt"></i>
                    سفارشی سازی قالب یا سایت
                </li>
                <li>
                    <i class="dashicons dashicons-no-alt"></i>
                   درخواست هایی که مشمول کدنویسی میشوند
                </li>
                <li>
                    <i class="dashicons dashicons-no-alt"></i>
                   پشتیبانی از افزونه های اضافی نصب شده
                </li>
                <li>
                    <i class="dashicons dashicons-no-alt"></i>
                آموزش وردپرس و یا افزونه هایش
                </li>
            </ul>
        </div>


	
    </div>
</div>