<?php

/**
 * Adds the woocommerce settings tab
 * @author jacek
 */
class ctSizeGuideSettings {

	/**
	 * Inits object
	 */

	public function __construct() {
		add_filter( 'woocommerce_settings_tabs_array', array( $this, 'addSettingsTab' ), 90 );
		add_action( 'woocommerce_settings_tabs_size_guide_tab', array( $this, 'settingsTab' ) );
        add_action( 'woocommerce_settings_tabs_size_guide_tab2', array( $this, 'settingsTab2' ) );
		add_action( 'woocommerce_update_options_size_guide_tab', array( $this, 'updateSettings' ) );
	}

	/**
	 * Adds tab
	 *
	 * @param $settings_tabs
	 *
	 * @return mixed
	 */

	public function addSettingsTab( $settings_tabs ) {
		$settings_tabs['size_guide_tab'] = __( 'Size guide', 'ct-sgp' );
        $settings_tabs['size_guide_tab2'] = __( 'Size guide - overview', 'ct-sgp' );

		return $settings_tabs;
	}

	/**
	 * Adds fields
	 */

	function settingsTab() {
		woocommerce_admin_fields( $this->getSettings() );
	}


    function settingsTab2() {
        echo '<h1>' . __( 'Size guide - overview', 'ct-sgp' ) . '</h1>';
        echo '<div class="ct-info-box"><p>' . __( 'This table shows product assignments as stored in the database. If assignments conflict, the plugin uses internal logic to display a single size guide on the frontend.', 'ct-sgp' ) . '</p></div>';

        $size_guides = $this->listAllSizeGuides();

        ob_start();
        ?>
        <div class="wrap">
            <table class="wp-list-table widefat fixed striped">
                <thead>
                <tr>
                    <th scope="col" class="manage-column column-title"><?php echo __( 'Size Guide', 'ct-sgp' ); ?></th>
                    <th scope="col" class="manage-column column-title"><?php echo __( 'Assigned Products and Methods', 'ct-sgp' ); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php if (!empty($size_guides)) : ?>
                    <?php foreach ($size_guides as $guide) : ?>
                        <tr>
                            <td>
                                <a href="<?php echo get_edit_post_link($guide['size_guide_id']); ?>" target="_blank">
                                    <?php echo esc_html($guide['size_guide_title']); ?>
                                </a>
                            </td>
                            <td>
                                <?php if (!empty($guide['assigned_products'])) : ?>
                                    <ul class="ct-list">
                                        <?php foreach ($guide['assigned_products'] as $product_id => $product_data) : ?>
                                            <li>
                                                <a href="<?php echo get_edit_post_link($product_id); ?>" target="_blank">
                                                    <?php echo esc_html($product_data['product_title']); ?>
                                                </a>
                                                <?php foreach ($product_data['assignment_methods'] as $method) : ?>
                                                    <span class="assignment-method pill"><?php echo esc_html($method); ?></span>
                                                <?php endforeach; ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php else : ?>
                                    <em><?php echo __( 'No products assigned', 'ct-sgp' ); ?></em>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="2"><?php echo __( 'No size guides found.', 'ct-sgp' ); ?></td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <style>
            .ct-info-box {
                background-color: #eaf7ff;
                border-left: 4px solid #007cba;
                padding: 12px;
                margin-bottom: 20px;
                border-radius: 3px;
            }

            .ct-info-box p {
                margin: 0;
                color: #007cba;
                font-size: 14px;
            }
            .ct-list {
                list-style: none;
                padding: 0;
                margin: 0;
            }
            .ct-list a,
            .ct-list span {
                display: inline-block;
                padding: 4px 0;
                margin-right: 5px;
                font-size: 12px;
                line-height: 1;
            }

            .ct-list li {
                margin-bottom: 8px;
                white-space: nowrap;
            }

            .assignment-method.pill {
                background-color: #007cba;
                color: #fff;
                border-radius: 12px;
                padding: 4px 8px;
            }
            .assignment-method.pill:hover {
                background-color: #005a8d;
            }
        </style>
        <?php
        echo ob_get_clean();
    }



	function getSettings() {

		$sg_id = [];
		$args = array(
			'post_type'   => 'ct_size_guide',
			'numberposts' => -1,
			'orderby'     => 'title',
			'order'       => "ASC"
		);

		$sg_list = get_posts( $args );

		if( !empty($sg_list) ) {
			foreach($sg_list as $list) {
				$sg_id[] = $list->post_title;
			}
		}

		$settings = array(
			'section_title' => array(
				'name' => __( 'Size guide settings', 'ct-sgp' ),
				'type' => 'title',
				'id'   => 'wc_size_guide_tab_section_title'
			),
			array(
				'name'    => __( 'Style', 'ct-sgp' ),
				'desc'    => __( 'Chose the style of popup window (checkout previews in the plugin <a href="http://createit.support/documentation/size-guide/#doc-7007" target="_blank">documentation</a>).', 'ct-sgp' ),
				'id'      => 'wc_size_guide_style',
				'type'    => 'select',
				'class'   => 'chosen_select',
				'css'     => 'min-width:300px;',
				'std'     => CT_SIZEGUIDE_ASSETS . 'css/ct.sizeguide.style1.css',
				'default' => CT_SIZEGUIDE_ASSETS . 'css/ct.sizeguide.style1.css',
				'options' => apply_filters( 'ct_sizeguide_styles', array(
					CT_SIZEGUIDE_ASSETS . 'css/ct.sizeguide.style1.css' => __( 'Minimalistic', 'ct-sgp' ),
					CT_SIZEGUIDE_ASSETS . 'css/ct.sizeguide.style2.css' => __( 'Classic', 'ct-sgp' ),
					CT_SIZEGUIDE_ASSETS . 'css/ct.sizeguide.style3.css' => __( 'Modern', 'ct-sgp' )
				) ),
			),
			/* The commented code below is for applying the strict mode. It is temporarily disabled */
			// array(
			// 	'name'    => __( 'Default SizeGuide', 'ct-sgp' ),
			// 	'desc'    => __( 'Chose default SizeGuide. Make sure to associate it with a category and tags.', 'ct-sgp' ),
			// 	'id'      => 'wc_size_guide_default',
			// 	'type'    => 'select',
			// 	'class'   => 'chosen_select default_sizeguide',
			// 	'css'     => 'min-width:300px;',
			// 	'options' => $sg_id,
			// ),
			// array(
			// 	'name'    => __( 'Disable associate category/tag', 'ct-sgp' ),
			// 	'desc'    => __( 'SizeGuide update includes proper association with categories and tags.', 'ct-sgp' ),
			// 	'id'      => 'wc_size_guide_update',
			// 	'type'    => 'checkbox',
			// 	'css'     => 'min-width:300px;',
			// 	'default' => 'yes'
			// ),
			array(
				'name'    => __( 'Open guide with:', 'ct-sgp' ),
				'desc'    => __( 'Chose whether to display a simple link or a button to open the size guide.', 'ct-sgp' ),
				'id'      => 'wc_size_guide_button_style',
				'type'    => 'select',
				'class'   => 'chosen_select',
				'css'     => 'min-width:300px;',
				'std'     => 'ct-trigger-button',
				'default' => 'ct-trigger-button',
				'options' => array(
					'ct-trigger-link'   => __( 'Link', 'ct-sgp' ),
					'ct-trigger-button' => __( 'Button', 'ct-sgp' ),
				),
			),
			array(
				'name'    => __( 'Hide Size Guide', 'ct-sgp' ),
				'desc'    => __( 'Check this field to hide size guide when the product is out of stock', 'ct-sgp' ),
				'id'      => 'wc_size_guide_hide',
				'type'    => 'checkbox',
				//'class' => 'chosen_select', // #429: Custom theme button issue
				'css'     => 'min-width:300px;',
				'std'     => 'no',
				'default' => 'no'
			),
			array(
				'name'    => __( 'Button/link position:', 'ct-sgp' ),
				'desc'    => __( 'For manual embed, [ct_size_guide] shortcode can be placed anywhere you want. More info can be found <a href="http://createit.support/documentation/size-guide/#doc-7007" target="_blank">here</a>.', 'ct-sgp' ),
				'id'      => 'wc_size_guide_button_position',
				'type'    => 'select',
				'class'   => 'chosen_select',
				'css'     => 'min-width:300px;',
				'std'     => 'ct-position-summary',
				'default' => 'ct-position-summary',
				'options' => array(
					'ct-position-price'       => __( 'Under Price', 'ct-sgp' ),
					'ct-position-summary'     => __( 'Above the product summary tabs', 'ct-sgp' ),
					'ct-position-add-to-cart' => __( 'After Add To Cart button', 'ct-sgp' ),
					'ct-position-info'        => __( 'After Product Info', 'ct-sgp' ),
					'ct-position-tab'         => __( 'Make it a tab', 'ct-sgp' ),
					'ct-position-shortcode'   => __( 'Embed manually (shortcode)', 'ct-sgp' ),
				),
			),
			array(
				'name'        => __( 'Button/link hook priority', 'ct-sgp' ),
				'desc'        => __( 'Priority of the action that outputs the button/link. Using this you can adjust the position - check the <a href="http://createit.support/documentation/size-guide/#button-priority">documentation</a> for more information.', 'ct-sgp' ),
				'id'          => 'wc_size_guide_button_priority',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 60,
				'std'         => 60,
				'placeholder' => 60,
			),
			array(
				'name'    => __( 'Tab Multiple Table', 'ct-sgp' ),
				'desc'    => __( 'Check this field to show multiple size guide table as tabs', 'ct-sgp' ),
				'id'      => 'wc_size_guide_tab_multiple_table',
				'type'    => 'checkbox',
				'css'     => 'min-width:300px;',
				'std'     => 'no',
				'default' => 'no'
			),
			array(
				'name'    => __( 'Button/link label', 'ct-sgp' ),
				'id'      => 'wc_size_guide_button_label',
				'type'    => 'text',
				'default' => 'Size Guide',
				'std'     => 'Size Guide',
				//'placeholder' => 'Size Guide'
			),
			array(
				'name'    => __( 'Button/link align', 'ct-sgp' ),
				'id'      => 'wc_size_guide_button_align',
				'type'    => 'select',
				'class'   => 'chosen_select',
				'css'     => 'min-width:300px;',
				'std'     => 'ct-align-left',
				'default' => 'ct-align-left',
				'options' => array(
					'left'  => __( 'Left', 'ct-sgp' ),
					'right' => __( 'Right', 'ct-sgp' ),
				),
			),
			array(
				'name'    => __( 'Button/link clearing', 'ct-sgp' ),
				'desc'    => __( 'Allow floating elements on the sides of the link/button?', 'ct-sgp' ),
				'id'      => 'wc_size_guide_button_clear',
				'type'    => 'checkbox',
				'class'   => 'chosen_select',
				'css'     => 'min-width:300px;',
				'std'     => 'no',
				'default' => 'no'
			),
            array(
                'name'    => __( 'Button class', 'ct-sgp' ),
                'desc'    => __( 'Add a custom class to the button. If You want to use default class, type: button_sg', 'ct-sgp' ),
                'id'      => 'wc_size_guide_button_class',
                'type'    => 'text',
                'default' => 'button_sg',
                'std'     => 'button_sg',
                //'placeholder' => 'button_sg'
            ),
            array(
                'name'    => __( 'Button icon', 'ct-sgp' ),
                'desc'    => __( 'Icon to accompany text in button, type: icon_sg', 'ct-sgp' ),
                'id'      => 'wc_size_guide_button_icon',
                'type'    => 'text',
            ),
			array(
				'name'        => __( 'Margin left', 'ct-sgp' ),
				'desc'        => __( 'Enter the left margin of the link/button', 'ct-sgp' ),
				'id'          => 'wc_size_guide_button_margin_left',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Margin top', 'ct-sgp' ),
				'desc'        => __( 'Enter the top margin of the link/button', 'ct-sgp' ),
				'id'          => 'wc_size_guide_button_margin_top',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Margin right', 'ct-sgp' ),
				'desc'        => __( 'Enter the right margin of the link/button', 'ct-sgp' ),
				'id'          => 'wc_size_guide_button_margin_right',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Margin bottom', 'ct-sgp' ),
				'desc'        => __( 'Enter the bottom margin of the link/button', 'ct-sgp' ),
				'id'          => 'wc_size_guide_button_margin_bottom',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'    => __( 'Popup overlay color', 'ct-sgp' ),
				'desc'    => __( 'Click to pick the color of the popup background overlay', 'ct-sgp' ),
				'id'      => 'wc_size_guide_overlay_color',
				'css'     => 'max-width:70px;',
				'type'    => 'color',
				'default' => '000000',
			),
			array(
				'name'        => __( 'Padding left', 'ct-sgp' ),
				'desc'        => __( 'Enter the left padding of the content in the popup window', 'ct-sgp' ),
				'id'          => 'wc_size_guide_modal_padding_left',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Padding top', 'ct-sgp' ),
				'desc'        => __( 'Enter the top padding of the content in the popup window', 'ct-sgp' ),
				'id'          => 'wc_size_guide_modal_padding_top',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Padding right', 'ct-sgp' ),
				'desc'        => __( 'Enter the right padding of the content in the popup window', 'ct-sgp' ),
				'id'          => 'wc_size_guide_modal_padding_right',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),
			array(
				'name'        => __( 'Padding bottom', 'ct-sgp' ),
				'desc'        => __( 'Enter the bottom padding of the content in the popup window', 'ct-sgp' ),
				'id'          => 'wc_size_guide_modal_padding_bottom',
				'css'         => 'max-width:60px;',
				'type'        => 'number',
				'default'     => 0,
				'placeholder' => 0,
			),

			array(
				'name'    => __( 'Table hover', 'ct-sgp' ),
				'desc'    => __( 'Do you want to use hover effect on tables?', 'ct-sgp' ),
				'id'      => 'wc_size_guide_hovers_on_tables',
				'type'    => 'checkbox',
				'default' => true,
			),

			array(
				'name' => __( 'Background for hovers line', 'ct-sgp' ),
				'desc' => __( 'Set background color for hover lines', 'ct-sgp' ),
				'id'   => 'wc_size_guide_lines_hover_color',
				'css'     => 'max-width:70px;',
				'type' => 'color',
				'default' => '#999999',
			),

			array(
				'name' => __( 'Background for active cell on hover', 'ct-sgp' ),
				'desc' => __( 'Set background color for hover lines', 'ct-sgp' ),
				'id'   => 'wc_size_guide_active_hover_color',
				'css'     => 'max-width:70px;',
				'type' => 'color',
				'default' => '#2C72AD',
			),

			array(
				'name'    => __( 'Responsible tables', 'ct-sgp' ),
				'desc'    => __( 'This option disables responsive view of tables', 'ct-sgp' ),
				'id'      => 'wc_size_guide_display_mobile_table',
				'css'     => 'max-width:200px',
				'type'    => 'select',
				'options' => array(
					'ct-size-guide--Responsive'    => __( 'Responsive', 'ct-sgp' ),
					'ct-size-guide--NonResponsive' => __( 'Non responsive', 'ct-sgp' ),
				),
			),



			'section_end'   => array(
				'type' => 'sectionend',
				'id'   => 'wc_size_guide_tab_section_end'
			)
		);

		return apply_filters( 'wc_size_guide_tab_settings', $settings );
	}

	function wcSizeGuidePopupOverlayColorGlobal() {
		$settings                     = $this->getSettings();
		$wcSizeGuidePopupOverlayColor = get_option( $settings[13]['id'] ) != null ? get_option( $settings[13]['id'] ) : '#000000';

		return $wcSizeGuidePopupOverlayColor;
	}

	function updateSettings() {
		woocommerce_update_options( $this->getSettings() );
	}

    /**
     * @return array
     * Similar logic like in: hasSizeGuide()
     */
    public function listAllSizeGuides() {
        $args = array(
            'post_type'   => 'ct_size_guide',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC'
        );

        $size_guides = get_posts($args);
        $results = array();

        foreach ($size_guides as $guide) {
            $guide_id = $guide->ID;
            $assigned_products = array();

            // Check for products assigned directly via post meta
            $products_assigned_directly = get_posts(array(
                'post_type' => 'product',
                'meta_query' => array(
                    array(
                        'key' => '_ct_selectsizeguide',
                        'value' => $guide_id,
                        'compare' => '='
                    )
                ),
                'numberposts' => -1
            ));

            foreach ($products_assigned_directly as $product) {
                $product_id = $product->ID;
                if (!isset($assigned_products[$product_id])) {
                    $assigned_products[$product_id] = array(
                        'product_title' => $product->post_title,
                        'assignment_methods' => array()
                    );
                }
                $assigned_products[$product_id]['assignment_methods'][] = 'Manual';
            }

            // Check for products assigned via categories or tags
            $products = get_posts(array(
                'post_type' => 'product',
                'numberposts' => -1,
                'fields' => 'ids'
            ));

            foreach ($products as $product_id) {
                $productCategoryTerms = wp_get_post_terms($product_id, 'product_cat');
                $productTagTerms = wp_get_post_terms($product_id, 'product_tag');

                // Detect assignments via Category
                foreach ($productCategoryTerms as $term) {
                    $termId = $term->term_id;
                    do {
                        $display = new ctSizeGuideDisplay();
                        $hasChildTerm = $display->getChildTermId($termId, $productCategoryTerms);
                        if ($hasChildTerm) {
                            $termId = $hasChildTerm;
                        }
                    } while ($hasChildTerm);

                    $sg_post_id_candidates = get_term_meta($termId, '_ct_assignsizeguide', false);

                    if (in_array($guide_id, $sg_post_id_candidates)) {
                        if (!isset($assigned_products[$product_id])) {
                            $assigned_products[$product_id] = array(
                                'product_title' => get_the_title($product_id),
                                'assignment_methods' => array()
                            );
                        }
                        $assigned_products[$product_id]['assignment_methods'][] = 'Category';
                    }
                }

                // Detect assignments via Tag
                foreach ($productTagTerms as $term) {
                    $termId = $term->term_id;
                    do {
                        $display = new ctSizeGuideDisplay();
                        $hasChildTerm = $display->getChildTermId($termId, $productTagTerms);
                        if ($hasChildTerm) {
                            $termId = $hasChildTerm;
                        }
                    } while ($hasChildTerm);

                    $sg_post_id_candidates = get_term_meta($termId, '_ct_assignsizeguide', false);

                    if (in_array($guide_id, $sg_post_id_candidates)) {
                        if (!isset($assigned_products[$product_id])) {
                            $assigned_products[$product_id] = array(
                                'product_title' => get_the_title($product_id),
                                'assignment_methods' => array()
                            );
                        }
                        $assigned_products[$product_id]['assignment_methods'][] = 'Tag';
                    }
                }

                // Check for products assigned via shortcode in post content
                $post_content = get_post_field('post_content', $product_id);
                if (has_shortcode($post_content, 'ct_size_guide')) {
                    preg_match_all('/\[ct_size_guide[^\]]*postid\s*=\s*(\d+)/', $post_content, $matches);
                    if (!empty($matches[1]) && in_array($guide_id, $matches[1])) {
                        if (!isset($assigned_products[$product_id])) {
                            $assigned_products[$product_id] = array(
                                'product_title' => get_the_title($product_id),
                                'assignment_methods' => array()
                            );
                        }
                        $assigned_products[$product_id]['assignment_methods'][] = 'Shortcode';
                    }
                }
            }

            $results[] = array(
                'size_guide_id' => $guide_id,
                'size_guide_title' => get_the_title($guide_id),
                'assigned_products' => $assigned_products
            );
        }

        return $results;
    }


}

new ctSizeGuideSettings;
