<?php


function fu_admin_page() {
	add_theme_page( __('فونت آپلودر', 'fontuploader'), __('فونت آپلودر', 'fontuploader'), 'manage_options', 'font-uploader', 'fu_render_admin');
}
add_action('admin_menu', 'fu_admin_page');

function fu_render_admin() {

    $options = fu_setup_options();
    $i=0;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>' . __('تنظیمات ذخیره شد.', 'fontuploader') . '</strong></p></div>';
	?>
	<div class="wrap">
		
		<h2>مدیریت فونت‌های فارسی</h2>
		<p>فونت‌های بارگذاری شده در منوهای زیر نمایش داده می‌شوند</p>
		<form method="post" enctype="multipart/form-data" action="themes.php?page=font-uploader">
			<p><input type="file" name="font"></p>
			<input type="hidden" name="fu_action" value="upload"/>
			<?php echo wp_nonce_field('font-upload-nonce', 'font-upload-nonce'); ?>
			<div class="description"><em><?php _e('انواع فایل‌هایی که پشتیبانی می‌شود: ', 'fontuploader'); ?><strong>.ttf</strong>, <strong>.otf</strong>, <strong>.eot</strong></em></div>
			<?php echo submit_button(__('آپلود فایل فونت', 'fontuploader'), 'secondary' ); ?>
		</form>


	    <form method="post">
	    	<table class="form-table">
			<?php 
	        foreach ($options as $value):
	            switch ( $value['type'] ):
	                case "open":  break;
					case "close": ?>
	    					</td>
						</tr>
						<?php
						break;
	                case "title": ?>
						<p><?php _e('فونت‌های بارگذاری شده را روی المان‌های زیر اعمال نمایید:', 'fontuploader'); ?></p>
						<?php
						break;
					case 'text': ?>
						<tr class="form-field">
							<th scope="row" valign="top">
		    					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
							</th>
							<td class="fu_input fu_text">
		    					<input name="<?php echo $value['id']; ?>" class="<?php echo $value['class']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != ""){ echo htmlentities(stripslashes(get_option( $value['id']))); } else { echo htmlentities($value['std']); } ?>" />
		    					<p class="description"><?php echo $value['desc']; ?></p>
							</td>
						</tr>
						<?php
	                    break;
	                case 'textarea': ?>
						<tr class="form-field">
							<th scope="row" valign="top">
		    					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
							</th>
							<td class="fu_input fu_text">
		    					<textarea name="<?php echo $value['id']; ?>" class="<?php echo $value['class']; ?>" rows="10" id="<?php echo $value['id']; ?>"><?php if ( get_option( $value['id'] ) != ""){ echo htmlentities(stripslashes(get_option( $value['id']))); } else { echo htmlentities($value['std']); } ?></textarea>
		    					<p class="description"><?php echo $value['desc']; ?></p>
							</td>
						</tr>
						<?php
	                    break;
	                case 'select':
						?>
						<tr class="form-field">
							<th scope="row" valign="top">
		    					<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
							</th>
							<td class="fu_input fu_select">
							    <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" class="<?php echo $value['class']; ?>">
							    <?php foreach ($value['options'] as $option) { ?>
							        <option <?php if (get_option( $value['id'] ) == $option){ echo 'selected="selected"'; } ?>><?php echo htmlentities($option); ?></option>
							    <?php } ?>
							    </select>
							    <span class="description"><?php echo $value['desc']; ?></span>
							</td>
						</tr>
						<?php
	                    break;
	                case "section":
	                    $i++; ?>
						<tr class="form-field">
						    <th scope="row" valign="top">
						    	<h3><?php echo $value['name']; ?></h3>
						   	</th>
						    <td class="fu_options">
	                        <?php 
	                    break;
	            endswitch;
	        endforeach;
			?>
			</table>
	        <input type="hidden" name="action" value="save" />
	        <?php echo submit_button(__('ذخیره تغییرات', 'fontuploader') ); ?>
	    </form>
	</div>
	<?php
}

function fu_setup_options() {
	
	$sn = 'fu';
	$fonts = fu_load_fonts();
	$font_sizes = fu_get_font_sizes();
	$options = array(

	    array( "name" => __('فونت آپلودر', 'fontuploader'),
	        "type" => "title"),
	   
	    array( "name" => __('فونت‌ها', 'fontuploader'),
	        "type" => "section"),

	    array( "type" => "open"),

		 array( 
		 	"name" => __('سرتیترها', 'fontuploader'),
			"desc" => __('تنظیم فونت برای المان‌های سرتیتر، مانند H1, H2', 'fontuploader'),
			"id" => $sn."_header_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),

		array( 
		 	"name" => __('لیست‌ها', 'fontuploader'),
			"desc" => __('تنظیم فونت برای آیتم‌های لیست', 'fontuploader'),
			"id" => $sn."_lists_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),

		array( 
		 	"name" => __('بدنه‌ی اصلی', 'fontuploader'),
			"desc" => __('تنظیم فونت برای متون اصلی بدنه‌ی وب‌سایت', 'fontuploader'),
			"id" => $sn."_body_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),
		   
	    array( "type" => "close"),
	    
	    array( 
	    	"name" => __('المان‌های سفارشی', 'fontuploader'),
	        "type" => "section"
	    ),
	    array( "type" => "open"), 
	    
		array( 
		 	"name" => __('فونت المان یک', 'fontuploader'),
			"id" => $sn."_custom_one_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		), 
		array( 
		 	"name" => __('المان', 'fontuploader'),
			"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
			"id" => $sn."_custom_one",
			"class" => "regular-text",
			"type" => "text"
		),    
		array( 
		 	"name" => __('فونت المان دو', 'fontuploader'),
			"id" => $sn."_custom_two_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),
		array( 
			"name" => __('المان', 'fontuploader'),
			"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
			"id" => $sn."_custom_two",
			"class" => "regular-text",
			"type" => "text"
		),    
		array( 
		 	"name" => __('فونت المان سه', 'fontuploader'),
			"id" => $sn."_custom_three_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),
		array( 
			"name" => __('المان', 'fontuploader'),
			"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
			"id" => $sn."_custom_three",
			"class" => "regular-text",
			"type" => "text"
		),    
		array( 
		 	"name" => __('فونت المان چهار', 'fontuploader'),
			"id" => $sn."_custom_four_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		), 
		array( 
		 	"name" => __('المان', 'fontuploader'),
			"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
			"id" => $sn."_custom_four",
			"class" => "regular-text",
			"type" => "text"
		),    
		array( 
			"name" => __('فونت المان پنج', 'fontuploader'),
			"id" => $sn."_custom_five_font",
			"class" => "fu_font_list",
			"type" => "select",
			"options" => $fonts
		),
		array( 
			"name" => __('المان', 'fontuploader'),
			"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
			"id" => $sn."_custom_five",
			"class" => "regular-text",
			"type" => "text"
		),    
			   
	    array( "type" => "close"),
    
    array( "name" => __('فونت‌های اینترنت اکسپلورر', 'fontuploader'),
        "type" => "section"),
    array( "type" => "open"), 

	 array( "name" => __('سرتیترهای اینترنت اکسپلورر', 'fontuploader'),
		"desc" => __('تنظیم فونت برای المان‌های سرتیتر، مانند H1, H2. در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"id" => $sn."_ie_header_font",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $fonts),
	 array( "name" => __('لیست‌های اینترنت اکسپلورر', 'fontuploader'),
		"desc" => __('تنظیم فونت برای آیتم‌های لیست. در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"id" => $sn."_ie_lists_font",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $fonts),
	 array( "name" => __('بدنه‌ی اصلی اینترنت اکسپلورر', 'fontuploader'),
		"desc" => __('تنظیم فونت برای متون اصلی بدنه‌ی وبسایت اینترنت اکسپلورر. در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"id" => $sn."_ie_body_font",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $fonts),

    array( "type" => "close"),

    array( "name" => __('المان‌های سفارشی IE', 'fontuploader'),
        "type" => "section"),
    array( "type" => "open"), 
    
	array( "name" => __('المان', 'fontuploader'),
		"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
		"id" => $sn."_ie_custom_one",
		"type" => "text"),    
	array( "name" => __('فونت المان', 'fontuploader'),
		"id" => $sn."_ie_custom_one_font",
		"class" => "fu_font_list",
		"type" => "select",
		"desc" => __('در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"options" => $fonts), 

	array( "name" => __('المان', 'fontuploader'),
		"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
		"id" => $sn."_ie_custom_two",
		"type" => "text"),    
	array( "name" => __('فونت المان', 'fontuploader'),
		"id" => $sn."_ie_custom_two_font",
		"class" => "fu_font_list",
		"type" => "select",
		"desc" => __('در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"options" => $fonts), 
		
	array( "name" => __('المان', 'fontuploader'),
		"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
		"id" => $sn."_ie_custom_three",
		"type" => "text"),    
	array( "name" => __('فونت المان', 'fontuploader'),
		"id" => $sn."_ie_custom_three_font",
		"class" => "fu_font_list",
		"type" => "select",
		"desc" => __('در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"options" => $fonts), 
		
	array( "name" => __('المان', 'fontuploader'),
		"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
		"id" => $sn."_ie_custom_four",
		"type" => "text"),    
	array( "name" => __('فونت المان', 'fontuploader'),
		"id" => $sn."_ie_custom_four_font",
		"class" => "fu_font_list",
		"type" => "select",
		"desc" => __('در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"options" => $fonts), 
		
	array( "name" => __('المان', 'fontuploader'),
		"desc" => __('شناسه یا سلکتور کلاس را برای المانی که می‌خواهید <em>فونت‌گذاری</em> نمایید انتخاب کنید. مانند <em>#navigation</em> یا <em>.element p</em>', 'fontuploader'),
		"id" => $sn."_ie_custom_five",
		"type" => "text"),    
	array( "name" => __('فونت المان', 'fontuploader'),
		"id" => $sn."_ie_custom_five_font",
		"class" => "fu_font_list",
		"type" => "select",
		"desc" => __('در این‌جا می‌بایست یک فایل <strong>.eot</strong> قرار گیرد.', 'fontuploader'),
		"options" => $fonts),

	array( "type" => "close"),

    array( "name" => __('سایز فونت‌ها', 'fontuploader'),
        "type" => "section"),
    array( "type" => "open"),

	array( "name" => __('سایز سرتیتر', 'fontuploader'),
		"desc" => __('تنظیم سایز فونت برای المان‌های سرتیتر، مانند H1, H2', 'fontuploader'),
		"id" => $sn."_header_font_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
	array( "name" => __('سایز لیست', 'fontuploader'),
		"desc" => __('تنظیم سایز فونت برای آیتم‌های لیست', 'fontuploader'),
		"id" => $sn."_lists_font_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
	array( "name" => __('سایز بدنه‌ی اصلی', 'fontuploader'),
		"desc" => __('تنظیم سایز فونت برای متون اصلی بدنه‌ی وب‌سایت', 'fontuploader'),
		"id" => $sn."_body_font_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
		
	array( "name" => __('سایز سفارشی فونت‌ها', 'fontuploader'),
        "type" => "section"),
    array( "type" => "open"),

	array( "name" => __('المان سفارشی یک', 'fontuploader'),
		"desc" => __('شناسه‌ی المانی که قصد دارید سایز آن را کنترل نمایید وارد کنید. مانند: <span style="font-style:normal;"">.navigation li</span>', 'fontuploader'),
		"id" => $sn."_custom_one_size_element",
		"type" => "text"),		
	array( "name" => __('سایز فونت المان', 'fontuploader'),
		"desc" => __('سایز فونت را برای المان سفارشی که در بالا تعریف شده است انتخاب نمایید.', 'fontuploader'),
		"id" => $sn."_custom_one_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
		
	array( "name" => __('المان سفارشی دو', 'fontuploader'),
		"desc" => __('شناسه‌ی المانی که قصد دارید سایز آن را کنترل نمایید وارد کنید. مانند: <span style="font-style:normal;"">.navigation li</span>', 'fontuploader'),
		"id" => $sn."_custom_two_size_element",
		"type" => "text"),		
	array( "name" => __('سایز فونت المان', 'fontuploader'),
		"desc" => __('سایز فونت را برای المان سفارشی که در بالا تعریف شده است انتخاب نمایید.', 'fontuploader'),
		"id" => $sn."_custom_two_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
		
	array( "name" => __('المان سفارشی سه', 'fontuploader'),
		"desc" => __('شناسه‌ی المانی که قصد دارید سایز آن را کنترل نمایید وارد کنید. مانند: <span style="font-style:normal;"">.navigation li</span>', 'fontuploader'),
		"id" => $sn."_custom_three_size_element",
		"type" => "text"),		
	array( "name" => __('سایز فونت المان', 'fontuploader'),
		"desc" => __('سایز فونت را برای المان سفارشی که در بالا تعریف شده است انتخاب نمایید.', 'fontuploader'),
		"id" => $sn."_custom_three_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),

	array( "name" => __('المان سفارشی چهار', 'fontuploader'),
		"desc" => __('شناسه‌ی المانی که قصد دارید سایز آن را کنترل نمایید وارد کنید. مانند: <span style="font-style:normal;"">.navigation li</span>', 'fontuploader'),
		"id" => $sn."_custom_four_size_element",
		"type" => "text"),		
	array( "name" => __('سایز فونت المان', 'fontuploader'),
		"desc" => __('سایز فونت را برای المان سفارشی که در بالا تعریف شده است انتخاب نمایید.', 'fontuploader'),
		"id" => $sn."_custom_four_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
		
	array( "name" => __('المان سفارشی پنج', 'fontuploader'),
		"desc" => __('شناسه‌ی المانی که قصد دارید سایز آن را کنترل نمایید وارد کنید. مانند: <span style="font-style:normal;"">.navigation li</span>', 'fontuploader'),
		"id" => $sn."_custom_five_size_element",
		"type" => "text"),		
	array( "name" => __('سایز فونت المان', 'fontuploader'),
		"desc" => __('سایز فونت را برای المان سفارشی که در بالا تعریف شده است انتخاب نمایید.', 'fontuploader'),
		"id" => $sn."_custom_five_size",
		"class" => "fu_font_list",
		"type" => "select",
		"options" => $font_sizes),
		
		
    array( "type" => "close"),	


	);

	return $options;
}

function fu_save_options() {

	global $pagenow;

    $options = fu_setup_options();

    if ( isset( $_GET['page'] ) && $_GET['page'] == 'font-uploader'  && $pagenow == 'themes.php') {

        if ( 'save' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                update_option( $value['id'], $_REQUEST[ $value['id'] ] );
            }

            foreach ($options as $value) {

                if( isset( $_REQUEST[ $value['id'] ] ) ) {

                    update_option( $value['id'], $_REQUEST[ $value['id'] ]  );

                } else {

                    delete_option( $value['id'] );

                }

            }
        }
    }
}
add_action('admin_init', 'fu_save_options');
