<?php
/**
 * Kalium WordPress Theme
 *
 * Other/uncategorized functions.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Null function.
 *
 * @return void
 */
function kalium_null_function() {
}

/**
 * Conditional return value.
 *
 * @param bool $condition
 * @param mixed $if
 * @param mixed $else
 *
 * @return mixed
 */
function kalium_conditional( $condition, $if, $else = null ) {
	return $condition ? $if : $else;
}

/**
 * Enqueue GSAP library.
 *
 * @return void
 */
function kalium_enqueue_gsap_library() {
	kalium_enqueue( 'gsap' );
}

/**
 * Enqueue Isotope & Packery library.
 *
 * @return void
 */
function kalium_enqueue_isotope_and_packery_library() {
	kalium_enqueue( 'isotope' );

	// Workaround for WPBakery
	if ( wp_script_is( 'isotope', 'registered' ) ) {
		wp_dequeue_script( 'isotope' );
		wp_deregister_script( 'isotope' );
	}
}

/**
 * Enqueue media library.
 *
 * @return void
 */
function kalium_enqueue_media_library() {
	kalium()->media->enqueue_media_library();
}

/**
 * Enqueue flickity carousel library.
 *
 * @return void
 */
function kalium_enqueue_flickity_library() {
	kalium_enqueue( 'flickity' );
}

/**
 * Enqueue flickity fade library.
 *
 * @return void
 */
function kalium_enqueue_flickity_fade_library() {
	kalium_enqueue( 'flickity-fade' );
}

/**
 * Enqueue Slick Gallery.
 *
 * @return void
 */
function kalium_enqueue_slick_slider_library() {
	kalium_enqueue( 'slick' );
}

/**
 * Enqueue Lightbox Gallery.
 *
 * @return void
 */
function kalium_enqueue_lightbox_library() {
	kalium_enqueue( 'light-gallery' );
}

/**
 * Enqueue ScrollMagic library.
 *
 * @return void
 */
function kalium_enqueue_scrollmagic_library() {
	kalium_enqueue( 'scrollmagic' );

	if ( defined( 'KALIUM_DEBUG' ) ) {
		kalium_enqueue( 'scrollmagic-debug-js' );
	}
}

/**
 * Enqueue Kalium Sticky Header.
 *
 * @return void
 */
function kalium_enqueue_sticky_header() {
	kalium_enqueue( 'sticky-header-js' );
}

/**
 * Is holiday season (13 dec – 05 jan).
 *
 * @return bool
 */
function kalium_is_holiday_season() {
	$current_year = (int) date( 'Y' );
	$date_start   = sprintf( '%d-12-13', $current_year );
	$date_end     = sprintf( '%d-01-04', $current_year + 1 );

	return strtotime( $date_start ) <= time() && strtotime( $date_end ) >= time();
}

/**
 * Register dynamic translatable string for WPML.
 *
 * @param string $name
 * @param string $value
 *
 * @return void
 */
function kalium_wpml_register_single_string( $name, $value ) {
	do_action( 'wpml_register_single_string', 'kalium', $name, $value );
}

/**
 * WPML dynamic translatable string.
 *
 * @param string $original_value
 * @param string $name
 *
 * @return string
 */
function kalium_wpml_translate_single_string( $original_value, $name ) {
	return apply_filters( 'wpml_translate_single_string', $original_value, 'kalium', $name );
}
