<?php
/**
 * Kalium WordPress Theme //WPMonster.co
 *
 * About Kalium.
 *
 * @var bool   $welcome
 * @var string $version
 * @var bool   $is_theme_registered
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="about-kalium__heading">
    <h2>ممنون از انتخاب کالیوم</h2>
    <p>کالیوم به طور مداوم با ویژگی های جدید ، رفع اشکال و سایر تنظیمات گسترش می یابد تا تجربه بهتر و انعطاف پذیرتری برای همه فراهم کند.</p>
</div>

<?php if ( $welcome ) : $list_count = 1; ?>
    <div class="about-kalium__welcome">

        <div class="about-kalium__welcome-heading">
            <h3>ممنون برای انتخاب کالیوم!</h3>
            <p>در اینجا اولین مراحل برای راه اندازی قالب ذکر شده است:</p>
        </div>

        <ul class="about-kalium__welcome-steps">
			<?php if ( ! $is_theme_registered ) : ?>
                <li>
                    <span class="step-number"><?php echo esc_html( $list_count ++ ); ?></span>
                    <p>ثبت قالب در قسمت
                        <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'theme-registration' ) ); ?>" target="_blank">فعال سازی</a>
                        </p>
                </li>
			<?php endif; ?>
            <li>
                <span class="step-number"><?php echo esc_html( $list_count ++ ); ?></span>
                <p>نصب و فعالسازی افزونه های الزامی در قسمت
                    <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'plugins' ) ); ?>" target="_blank">افزونه ها</a></p>
            </li>
            <li>
                <span class="step-number"><?php echo esc_html( $list_count ++ ); ?></span>
                <p>نصب یک دموی آماده و انگلیسی از قسمت <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'demos' ) ); ?>">دموها</a> (اختیاری)</p>
            </li>
            <li>
                <span class="step-number"><?php echo esc_html( $list_count ++ ); ?></span>
                <p>پیکربندی
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=laborator_options' ) ); ?>" target="_blank">تنظیمات قالب</a> بر اساس نیازهای شما</p>
            </li>
            <li>
                <span class="step-number"><?php echo esc_html( $list_count ++ ); ?></span>
                <p>جهت کسب اطلاعات بیشتر به قسمت <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'help' ) ); ?>" target="_blank" rel="noopener">راهنما</a> سر بزنید</p>
            </li>
        </ul>

        <div class="about-kalium__welcome-getting-started-figure">
            <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/getting-started.svg' ) ); ?>" width="300" height="289" alt="getting-started"/>
        </div>
    </div>
<?php endif; ?>

<ul class="about-kalium__features-list">

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-welcome.svg' ) ); ?>" width="48" height="48" alt="welcome-to-kalium"/>
            </div>
            <h3 class="about-kalium__features-list-item-title">
                به کالیوم خوش آمدید
            </h3>
            <p class="about-kalium__features-list-item-description">سپاس از اینکه کسب و کار خود را با محصولات هیولای وردپرس راه اندازی میکنید، امیدواریم لذت ببرید!
                </p>
        </div>
    </li>

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-new.svg' ) ); ?>" width="48" height="48" alt="whats-new"/>
            </div>

            <h3 class="about-kalium__features-list-item-title">
               چه چیزهایی جدید است در نسخه <?php echo esc_html( $version ); ?>
            </h3>

            <p class="about-kalium__features-list-item-description">کالیوم به طور مداوم با ویژگی های جدید ، رفع اشکال و سایر تنظیمات گسترش می یابد تا تجربه بهتر و انعطاف پذیرتری برای همه فراهم کند.</p>

            <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'whats-new' ) ); ?>#changelog" class="about-kalium__features-list-item-link button button-primary">مشاهده لیست تغییرات</a>
        </div>
    </li>

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-documentation.svg' ) ); ?>" width="48" height="48" alt="documentation"/>
            </div>

            <h3 class="about-kalium__features-list-item-title">
                مستندات
            </h3>

            <p class="about-kalium__features-list-item-description">پایگاه دانش کالیوم اطلاعات دقیقی در رابطه با نحوه پیکربندی و نصب قالب به شما میدهد.</p>

            <a href="https://documentation.laborator.co/" target="_blank" rel="noreferrer noopener" class="about-kalium__features-list-item-link button button-primary">خواندن مستندات</a>
        </div>
    </li>

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-subscribe.svg' ) ); ?>" width="48" height="48" alt="subscribe"/>
            </div>

            <h3 class="about-kalium__features-list-item-title">
                خبرنامه
            </h3>

            <p class="about-kalium__features-list-item-description">در خبرنامه لابراتور مشترک شوید و از آخرین اخبار کالیوم مطلع شوید.</p>

            <form action="https://laborator.us19.list-manage.com/subscribe/post?u=d14e54b0150aa63b1d1363b66&amp;id=6863811c9e" method="post" class="about-kalium__features-list-item-subscribe" target="_blank">
                <div style="position: absolute; left: -5000px;" aria-hidden="true">
                    <input type="text" name="b_d14e54b0150aa63b1d1363b66_6863811c9e" tabindex="-1" value=""></div>
                <input type="email" class="regular-text" placeholder="آدرس ایمیل شما" name="EMAIL" class="required email"/>
                <button type="submit" class="button button-primary" name="subscribe">اشتراک</button>
            </form>
        </div>
    </li>

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-faq.svg' ) ); ?>" width="48" height="48" alt="faq"/>
            </div>

            <h3 class="about-kalium__features-list-item-title">
                سوالات متداول
            </h3>

            <p class="about-kalium__features-list-item-description">سوالات متداول و پر بحث ترین موضوعاتی که توسط مشتریان قالب از ما پرسیده می شود.</p>

            <a href="<?php echo esc_url( Kalium_About::get_tab_link( 'faq' ) ); ?>" class="about-kalium__features-list-item-link button button-primary">خواندن سوالات</a>
        </div>
    </li>

    <li>
        <div class="about-kalium__features-list-item">
            <div class="about-kalium__features-list-item-icon">
                <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/icon-help.svg' ) ); ?>" width="48" height="48" alt="need-help"/>
            </div>
            <h3 class="about-kalium__features-list-item-title">
                به کمک نیاز دارید؟
            </h3>
            <p class="about-kalium__features-list-item-description">اگر شما در رابطه با کالیوم سوال و یا مشکلی داشتید همیشه میتوانید با پشتیبانی هیولای وردپرس در ارتباط باشید و برای ما تیکت بفرستید.</p>

            <a href="https://www.rtl-theme.com/kalium-multiporpose-wordpress-theme/?tab=support" target="_blank" rel="noreferrer noopener" class="about-kalium__features-list-item-link button button-primary">ارتباط با پشتیبانی</a>
        </div>
    </li>

</ul>
